/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import com.jimrolf.complex.Complex;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class SquareRoot
extends PostfixMathCommand {
    public SquareRoot() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.sqrt(param));
    }

    public Object sqrt(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).sqrt();
        }
        if (param instanceof Number) {
            double value = ((Number)param).doubleValue();
            if (value < 0.0) {
                return new Complex(value).sqrt();
            }
            return new Double(Math.sqrt(value));
        }
        throw new ParseException("Invalid parameter type");
    }
}

