/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import com.jimrolf.complex.Complex;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Exp
extends PostfixMathCommand {
    public Exp() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.exp(param));
    }

    public Object exp(Object param) throws ParseException {
        if (param instanceof Complex) {
            Complex z = (Complex)param;
            double x = z.re();
            double y = z.im();
            double mod = Math.exp(x);
            return new Complex(mod * Math.cos(y), mod * Math.sin(y));
        }
        if (param instanceof Number) {
            return new Double(Math.exp(((Number)param).doubleValue()));
        }
        throw new ParseException("Invalid parameter type");
    }
}

