/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import com.jimrolf.complex.Complex;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ArcCosineH
extends PostfixMathCommand {
    public ArcCosineH() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.acosh(param));
    }

    public Object acosh(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).acosh();
        }
        if (param instanceof Number) {
            double val = ((Number)param).doubleValue();
            if (val >= 1.0) {
                double res = Math.log(val + Math.sqrt(val * val - 1.0));
                return new Double(res);
            }
            Complex temp = new Complex(((Number)param).doubleValue(), 0.0);
            return temp.acosh();
        }
        throw new ParseException("Invalid parameter type");
    }
}

