/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import com.jimrolf.complex.Complex;
import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Hashtable;
import org.lsmp.djep.xjep.ErrorCatchingVisitor;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.List;

public class PrintVisitor
extends ErrorCatchingVisitor {
    public static final int FULL_BRACKET = 1;
    public static final int COMPLEX_I = 2;
    private int maxLen = -1;
    protected StringBuffer sb;
    protected int mode = 0;
    private Hashtable specialRules = new Hashtable();
    private FieldPosition fp = new FieldPosition(1);
    protected NumberFormat format;

    public void print(Node node, PrintStream out) {
        this.sb = new StringBuffer();
        this.acceptCatchingErrors(node, null);
        if (this.maxLen != -1) {
            while (true) {
                if (this.sb.length() < this.maxLen) {
                    out.print(this.sb);
                    return;
                }
                int pos = this.maxLen - 2;
                for (int i = this.maxLen - 2; i >= 0; --i) {
                    char c = this.sb.charAt(i);
                    if (c != '+' && c != '-' && c != '*' && c != '/') continue;
                    pos = i;
                    break;
                }
                out.println(this.sb.substring(0, pos + 1));
                this.sb.delete(0, pos + 1);
            }
        }
        out.print(this.sb);
    }

    public void print(Node node) {
        this.print(node, System.out);
    }

    public void println(Node node, PrintStream out) {
        this.print(node, out);
        out.println("");
    }

    public void println(Node node) {
        this.println(node, System.out);
    }

    public String toString(Node node) {
        this.sb = new StringBuffer();
        this.acceptCatchingErrors(node, null);
        return this.sb.toString();
    }

    public void append(String s) {
        this.sb.append(s);
    }

    public void addSpecialRule(Operator op, PrintRulesI rules) {
        this.specialRules.put(op, rules);
    }

    private void printNoBrackets(Node node) throws ParseException {
        node.jjtAccept(this, null);
    }

    private void printBrackets(Node node) throws ParseException {
        this.sb.append("(");
        this.printNoBrackets(node);
        this.sb.append(")");
    }

    private Object visitUnary(ASTFunNode node, Object data) throws ParseException {
        Node rhs = node.jjtGetChild(0);
        this.sb.append(node.getOperator().getSymbol());
        if (rhs instanceof ASTFunNode && ((ASTFunNode)rhs).isOperator()) {
            this.printBrackets(rhs);
        } else {
            this.printNoBrackets(rhs);
        }
        return data;
    }

    private boolean testLeft(XOperator top, Node lhs) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (lhs instanceof ASTFunNode && ((ASTFunNode)lhs).isOperator()) {
            XOperator lhsop = (XOperator)((ASTFunNode)lhs).getOperator();
            if (top == lhsop) {
                if (top.getBinding() == 4 && top.isAssociative()) {
                    return false;
                }
                return !top.useBindingForPrint();
            }
            if (top.getPrecedence() == lhsop.getPrecedence()) {
                if (lhsop.getBinding() == 4 && lhsop.isAssociative()) {
                    return false;
                }
                return !lhsop.useBindingForPrint();
            }
            return top.getPrecedence() <= lhsop.getPrecedence();
        }
        return false;
    }

    private boolean testMid(XOperator top, Node rhs) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (rhs instanceof ASTFunNode && ((ASTFunNode)rhs).isOperator()) {
            XOperator rhsop = (XOperator)((ASTFunNode)rhs).getOperator();
            if (top == rhsop) {
                return false;
            }
            if (top.getPrecedence() == rhsop.getPrecedence()) {
                return false;
            }
            return top.getPrecedence() <= rhsop.getPrecedence();
        }
        return false;
    }

    private boolean testRight(XOperator top, Node rhs) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (rhs instanceof ASTFunNode && ((ASTFunNode)rhs).isOperator()) {
            XOperator rhsop = (XOperator)((ASTFunNode)rhs).getOperator();
            if (top == rhsop) {
                return top.getBinding() != 8 && !top.isAssociative();
            }
            if (top.getPrecedence() == rhsop.getPrecedence()) {
                return top.getBinding() != 4 || !top.isAssociative();
            }
            return top.getPrecedence() <= rhsop.getPrecedence();
        }
        return false;
    }

    private Object visitNaryBinary(ASTFunNode node, XOperator op) throws ParseException {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node arg;
            if (i > 0) {
                this.sb.append(op.getSymbol());
            }
            if (this.testMid(op, arg = node.jjtGetChild(i))) {
                this.printBrackets(arg);
                continue;
            }
            this.printNoBrackets(arg);
        }
        return null;
    }

    public Object visit(ASTFunNode node, Object data) throws ParseException {
        if (!node.isOperator()) {
            return this.visitFun(node);
        }
        if (node instanceof PrintRulesI) {
            ((PrintRulesI)((Object)node)).append(node, this);
            return null;
        }
        if (node.getOperator() == null) {
            throw new ParseException("Null operator in print for " + node);
        }
        if (this.specialRules.containsKey(node.getOperator())) {
            ((PrintRulesI)this.specialRules.get(node.getOperator())).append(node, this);
            return null;
        }
        if (node.getPFMC() instanceof List) {
            this.append("[");
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    this.append(",");
                }
                node.jjtGetChild(i).jjtAccept(this, null);
            }
            this.append("]");
            return null;
        }
        if (((XOperator)node.getOperator()).isUnary()) {
            return this.visitUnary(node, data);
        }
        if (((XOperator)node.getOperator()).isBinary()) {
            XOperator top = (XOperator)node.getOperator();
            if (node.jjtGetNumChildren() != 2) {
                return this.visitNaryBinary(node, top);
            }
            Node lhs = node.jjtGetChild(0);
            Node rhs = node.jjtGetChild(1);
            if (this.testLeft(top, lhs)) {
                this.printBrackets(lhs);
            } else {
                this.printNoBrackets(lhs);
            }
            this.sb.append(node.getOperator().getSymbol());
            if (this.testRight(top, rhs)) {
                this.printBrackets(rhs);
            } else {
                this.printNoBrackets(rhs);
            }
        }
        return null;
    }

    private Object visitFun(ASTFunNode node) throws ParseException {
        this.sb.append(node.getName() + "(");
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (i > 0) {
                this.sb.append(",");
            }
            node.jjtGetChild(i).jjtAccept(this, null);
        }
        this.sb.append(")");
        return null;
    }

    public Object visit(ASTVarNode node, Object data) throws ParseException {
        this.sb.append(node.getName());
        return data;
    }

    public Object visit(ASTConstant node, Object data) {
        Object val = node.getValue();
        this.formatValue(val, this.sb);
        return data;
    }

    public void formatValue(Object val, StringBuffer sb1) {
        if (this.format != null) {
            if (val instanceof Number) {
                this.format.format(val, sb1, this.fp);
            } else if (val instanceof Complex) {
                if ((this.mode | 2) == 2) {
                    sb1.append(((Complex)val).toString(this.format, true));
                } else {
                    sb1.append(((Complex)val).toString(this.format));
                }
            } else {
                sb1.append(val);
            }
        } else {
            sb1.append(val);
        }
    }

    public String formatValue(Object val) {
        StringBuffer sb2 = new StringBuffer();
        this.formatValue(val, sb2);
        return sb2.toString();
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getMode(int testmode) {
        return (this.mode | testmode) == testmode;
    }

    public void setMode(int mode, boolean flag) {
        this.mode = flag ? (this.mode |= mode) : (this.mode ^= mode);
    }

    public void setNumberFormat(NumberFormat format) {
        this.format = format;
    }

    public void setMaxLen(int i) {
        this.maxLen = i;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public static interface PrintRulesI {
        public void append(Node var1, PrintVisitor var2) throws ParseException;
    }
}

