/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.startool;

import com.jimrolf.complex.Complex;
import com.jimrolf.datagrapher2d.DataGrapher2D;
import com.jimrolf.domainchoicebox.ComplexDomainChoiceBox;
import com.jimrolf.functionfield.DoubleField;
import com.jimrolf.functionfield.IntField;
import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.numberlabel.NumberLabel;
import com.jimrolf.plotstuff2d.PlotStuff;
import com.jimrolf.plotstuff2d.PlotStuff2D;
import com.jimrolf.plotstuff2d.PolarGrid;
import com.jimrolf.slider.Slider;
import com.jimrolf.zoompanel.ZoomPanel325x80;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class StarTool
extends JApplet {
    private String imageType = "png";
    private JFileChooser fileChooser = new JFileChooser();
    private int numInteriorCircles = 9;
    private int defaultNumInteriorCircles = 9;
    private int numRays = 24;
    private int defaultNumRays = 23;
    private double radiusMax = 0.999;
    private int currentN = 3;
    private double currentP = 0.5;
    private double currentR = 0.3;
    private double currentRMax = 2.0;
    private double eps;
    private double cursorX;
    private double cursorY;
    private int arcSize;
    private boolean componentIsFocused;
    private boolean dragging;
    private Complex zVal;
    private Complex zRange;
    private Color backgroundColor;
    private Color evenColor;
    private Color oddColor;
    private Color rootColor;
    private JTextComponent focusField;
    private double[] domainDomainRange;
    private double[] rangeDomainRange;
    private double[] arcBegin;
    private double[] arcEnd;
    private int numArcs;
    private int numVertices;
    private int currentVertex;
    private int maxNumArcsVertices;
    private int numArcDataPoints;
    private PlotStuff2D[] arc;
    private double[][] arcDataX;
    private double[][] arcDataY;
    private PlotStuff[] domainAllData;
    private PlotStuff[] rangeAllData;
    private int[] domainOrderTraces;
    private PlotStuff2D[] vertexPoints;
    private double[][] vertexDataX;
    private double[][] vertexDataY;
    private double[][] arcEnds;
    private PlotStuff2D roots;
    private double[] rootsDataX;
    private double[] rootsDataY;
    private Complex constantC;
    private double machEps;
    private double piInverse;
    private Complex funcNumerator;
    private Complex funcDenom;
    private Complex sumEven;
    private Complex sumOdd;
    private Complex one;
    private Complex starVertexEven;
    private Complex starVertexOdd;
    private Complex exponent;
    private double thetaEven;
    private double thetaOdd;
    private double deltaThetaEven;
    private double deltaThetaOdd;
    private double startThetaEven;
    private double startThetaOdd;
    private Grapher2D currentGrapher;
    private double[] currentDomainRange;
    private double lastX;
    private double lastY;
    private boolean isDraggingGrid;
    private double centerX;
    private double centerY;
    private double tempCenterX;
    private double tempCenterY;
    private IntField currentNField;
    private JLabel currentNLabel;
    private JButton currentNMinusButtonm;
    private JButton currentNPlusButton;
    private DoubleField currentPField;
    private JLabel currentPLabel;
    private Slider currentPSlider;
    private DoubleField currentRField;
    private JLabel currentRLabel;
    private DoubleField currentRMaxField;
    private Slider currentRSlider;
    private JLabel currentRZeroLabel;
    private JButton defaultButton;
    private JButton defaultDomainButton;
    private JPanel dividerPanel1;
    private JPanel dividerPanel2;
    private JPanel dividerPanel3;
    private JPanel dividerPanel4;
    private JRadioButton domainBoxedAxesButton;
    private ButtonGroup domainButtonGroup;
    private JRadioButton domainCrossedAxesButton;
    private JLabel domainCursorLabel;
    private NumberLabel domainCursorLocateLabel;
    private JButton domainDefaultViewButton;
    private ComplexDomainChoiceBox domainDomainChoiceBox;
    private DataGrapher2D domainGrapher;
    private PolarGrid domainPGrid;
    private DoubleField domainXMaxField;
    private DoubleField domainXMinField;
    private DoubleField domainYMaxField;
    private DoubleField domainYMinField;
    private JMenu export;
    private JMenuItem exportApplet;
    private JMenuItem exportDomainGraph;
    private JMenuItem exportRangeGraph;
    private JMenu exportSettings;
    private JRadioButtonMenuItem gifMenuItem;
    private JPanel grapherDomainPanel;
    private JPanel grapherRangePanel;
    private JRadioButtonMenuItem jpgMenuItem;
    private JMenuBar menuBar;
    private IntField numInteriorCirclesField;
    private JLabel numInteriorCirclesLabel;
    private IntField numRaysField;
    private JLabel numRaysLabel;
    private JLabel omegaLabel;
    private JLabel pOneLabel;
    private JLabel pZeroLabel;
    private JRadioButtonMenuItem pngMenuItem;
    private JRadioButton rangeBoxedAxesButton;
    private ButtonGroup rangeButtonGroup;
    private JRadioButton rangeCrossedAxesButton;
    private JLabel rangeCursorLabel;
    private NumberLabel rangeCursorLocateLabel;
    private JButton rangeDefaultViewButton;
    private ComplexDomainChoiceBox rangeDomainChoiceBox;
    private DataGrapher2D rangeGrapher;
    private PolarGrid rangePGrid;
    private DoubleField rangeXMaxField;
    private DoubleField rangeXMinField;
    private DoubleField rangeYMaxField;
    private DoubleField rangeYMinField;
    private JCheckBox showRootsBox;
    private JCheckBox sketchBox;
    private PlotStuff2D sketchData;
    private JPanel starInfoPanel;
    private JPanel starToolPanel;
    private JButton updateButton;
    private JLabel zoomErrorMessageLabel;
    private JPanel zoomErrorMessagePanel;
    private ZoomPanel325x80 zoomPanel;

    public StarTool() {
        new MachineEpsilon();
        this.eps = MachineEpsilon.getEpsilon();
        this.cursorX = 0.0;
        this.cursorY = 0.0;
        this.arcSize = 2;
        this.componentIsFocused = false;
        this.dragging = false;
        this.zVal = new Complex();
        this.zRange = new Complex();
        this.backgroundColor = new Color(235, 235, 235);
        this.evenColor = Color.BLUE;
        this.oddColor = new Color(153, 204, 255);
        this.rootColor = Color.BLACK;
        this.focusField = null;
        this.domainDomainRange = new double[]{-1.0, 1.0, -1.0, 1.0};
        this.rangeDomainRange = new double[]{-1.0, 1.0, -1.0, 1.0};
        this.arcBegin = null;
        this.arcEnd = null;
        this.numArcs = 0;
        this.numVertices = 0;
        this.currentVertex = 0;
        this.maxNumArcsVertices = 36;
        this.numArcDataPoints = 30;
        this.arc = null;
        this.arcDataX = null;
        this.arcDataY = null;
        this.domainAllData = null;
        this.rangeAllData = null;
        this.domainOrderTraces = null;
        this.vertexPoints = null;
        this.vertexDataX = null;
        this.vertexDataY = null;
        this.arcEnds = null;
        this.roots = null;
        this.rootsDataX = null;
        this.rootsDataY = null;
        this.constantC = new Complex();
        this.machEps = MachineEpsilon.getEpsilon();
        this.piInverse = 0.3183098861837907;
        this.funcNumerator = new Complex();
        this.funcDenom = new Complex();
        this.sumEven = new Complex();
        this.sumOdd = new Complex();
        this.one = new Complex(1.0, 0.0);
        this.starVertexEven = new Complex();
        this.starVertexOdd = new Complex();
        this.exponent = new Complex();
        this.thetaEven = 0.0;
        this.thetaOdd = 0.0;
        this.deltaThetaEven = 0.0;
        this.deltaThetaOdd = 0.0;
        this.startThetaEven = 0.0;
        this.startThetaOdd = 0.0;
        this.currentGrapher = null;
        this.currentDomainRange = null;
        this.lastX = 0.0;
        this.lastY = 0.0;
        this.isDraggingGrid = false;
        this.centerX = 0.0;
        this.centerY = 0.0;
        this.tempCenterX = 0.0;
        this.tempCenterY = 0.0;
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            UIManager.put("swing.boldMetal", Boolean.FALSE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    StarTool.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initStuff();
    }

    private void initComponents() {
        this.sketchData = new PlotStuff2D();
        this.domainPGrid = new PolarGrid();
        this.rangePGrid = new PolarGrid();
        this.domainButtonGroup = new ButtonGroup();
        this.rangeButtonGroup = new ButtonGroup();
        this.starToolPanel = new JPanel();
        this.grapherDomainPanel = new JPanel();
        this.domainYMaxField = new DoubleField();
        this.domainYMinField = new DoubleField();
        this.domainXMinField = new DoubleField();
        this.domainXMaxField = new DoubleField();
        this.domainDomainChoiceBox = new ComplexDomainChoiceBox();
        this.domainCursorLabel = new JLabel();
        this.domainCursorLocateLabel = new NumberLabel();
        this.domainCrossedAxesButton = new JRadioButton();
        this.domainBoxedAxesButton = new JRadioButton();
        this.domainGrapher = new DataGrapher2D();
        this.domainDefaultViewButton = new JButton();
        this.grapherRangePanel = new JPanel();
        this.rangeGrapher = new DataGrapher2D();
        this.defaultDomainButton = new JButton();
        this.rangeYMaxField = new DoubleField();
        this.rangeYMinField = new DoubleField();
        this.rangeXMinField = new DoubleField();
        this.rangeXMaxField = new DoubleField();
        this.rangeDomainChoiceBox = new ComplexDomainChoiceBox();
        this.rangeCursorLabel = new JLabel();
        this.rangeCursorLocateLabel = new NumberLabel();
        this.rangeCrossedAxesButton = new JRadioButton();
        this.rangeBoxedAxesButton = new JRadioButton();
        this.rangeDefaultViewButton = new JButton();
        this.zoomErrorMessagePanel = new JPanel();
        this.zoomErrorMessageLabel = new JLabel();
        this.zoomPanel = new ZoomPanel325x80();
        this.starInfoPanel = new JPanel();
        this.updateButton = new JButton();
        this.defaultButton = new JButton();
        this.currentNMinusButtonm = new JButton();
        this.currentNPlusButton = new JButton();
        this.currentPLabel = new JLabel();
        this.currentRLabel = new JLabel();
        this.currentNLabel = new JLabel();
        this.currentNField = new IntField();
        this.currentPField = new DoubleField();
        this.currentRField = new DoubleField();
        this.currentPSlider = new Slider();
        this.pZeroLabel = new JLabel();
        this.pOneLabel = new JLabel();
        this.currentRSlider = new Slider();
        this.currentRZeroLabel = new JLabel();
        this.currentRMaxField = new DoubleField();
        this.dividerPanel1 = new JPanel();
        this.dividerPanel2 = new JPanel();
        this.dividerPanel3 = new JPanel();
        this.sketchBox = new JCheckBox();
        this.showRootsBox = new JCheckBox();
        this.numInteriorCirclesLabel = new JLabel();
        this.numInteriorCirclesField = new IntField();
        this.numRaysLabel = new JLabel();
        this.numRaysField = new IntField();
        this.dividerPanel4 = new JPanel();
        this.omegaLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.export = new JMenu();
        this.exportDomainGraph = new JMenuItem();
        this.exportRangeGraph = new JMenuItem();
        this.exportApplet = new JMenuItem();
        this.exportSettings = new JMenu();
        this.pngMenuItem = new JRadioButtonMenuItem();
        this.gifMenuItem = new JRadioButtonMenuItem();
        this.jpgMenuItem = new JRadioButtonMenuItem();
        this.sketchData.setPlotColor(Color.blue);
        this.domainPGrid.setCircleColor(new Color(204, 0, 0));
        this.domainPGrid.setNumCirclePoints(150);
        this.domainPGrid.setNumCircles(10);
        this.domainPGrid.setNumRayPoints(50);
        this.domainPGrid.setNumRays(16);
        this.domainPGrid.setRadiusMax(1.0);
        this.domainPGrid.setRayColor(new Color(0, 102, 51));
        this.rangePGrid.setCircleColor(new Color(204, 0, 0));
        this.rangePGrid.setNumCirclePoints(150);
        this.rangePGrid.setNumCircles(10);
        this.rangePGrid.setNumRayPoints(50);
        this.rangePGrid.setNumRays(16);
        this.rangePGrid.setRadiusMax(1.0);
        this.rangePGrid.setRayColor(new Color(0, 102, 51));
        this.getContentPane().setLayout(null);
        this.starToolPanel.setBackground(SystemColor.controlLtHighlight);
        this.starToolPanel.setBorder(BorderFactory.createEtchedBorder());
        this.starToolPanel.setLayout(null);
        this.grapherDomainPanel.setBackground(new Color(204, 204, 204));
        this.grapherDomainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.grapherDomainPanel.setLayout(null);
        this.domainYMaxField.setText("1");
        this.domainYMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.domainYMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.domainYMaxFieldFocusGained(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainYMaxField);
        this.domainYMaxField.setBounds(2, 19, 40, 15);
        this.domainYMinField.setText("-1");
        this.domainYMinField.setFont(new Font("LucidaSans", 0, 10));
        this.domainYMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.domainYMinFieldFocusGained(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainYMinField);
        this.domainYMinField.setBounds(2, 320, 40, 15);
        this.domainXMinField.setText("-1");
        this.domainXMinField.setFont(new Font("LucidaSans", 0, 10));
        this.domainXMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.domainXMinFieldFocusGained(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainXMinField);
        this.domainXMinField.setBounds(45, 335, 40, 15);
        this.domainXMaxField.setText("1");
        this.domainXMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.domainXMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.domainXMaxFieldFocusGained(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainXMaxField);
        this.domainXMaxField.setBounds(305, 335, 40, 15);
        this.domainDomainChoiceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.domainDomainChoiceBoxActionPerformed(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainDomainChoiceBox);
        this.domainDomainChoiceBox.setBounds(45, 19, 205, 15);
        this.domainCursorLabel.setBackground(new Color(255, 255, 255));
        this.domainCursorLabel.setFont(new Font("LucidaSans", 1, 10));
        this.domainCursorLabel.setText("Cursor:");
        this.grapherDomainPanel.add(this.domainCursorLabel);
        this.domainCursorLabel.setBounds(100, 335, 38, 15);
        this.domainCursorLocateLabel.setText("invisible");
        this.grapherDomainPanel.add(this.domainCursorLocateLabel);
        this.domainCursorLocateLabel.setBounds(140, 335, 160, 15);
        this.domainCrossedAxesButton.setBackground(Color.white);
        this.domainButtonGroup.add(this.domainCrossedAxesButton);
        this.domainCrossedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.domainCrossedAxesButton.setSelected(true);
        this.domainCrossedAxesButton.setText("Crossed");
        this.domainCrossedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.domainCrossedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.domainCrossedAxesButton.setOpaque(false);
        this.domainCrossedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.domainCrossedAxesButtonActionPerformed(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainCrossedAxesButton);
        this.domainCrossedAxesButton.setBounds(210, 3, 56, 15);
        this.domainBoxedAxesButton.setBackground(Color.white);
        this.domainButtonGroup.add(this.domainBoxedAxesButton);
        this.domainBoxedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.domainBoxedAxesButton.setText("Boxed axes");
        this.domainBoxedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.domainBoxedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.domainBoxedAxesButton.setOpaque(false);
        this.domainBoxedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.domainBoxedAxesButtonActionPerformed(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainBoxedAxesButton);
        this.domainBoxedAxesButton.setBounds(270, 3, 82, 15);
        this.domainGrapher.setXAxisTitle("Re");
        this.domainGrapher.setXMax(1.0);
        this.domainGrapher.setXMin(-1.0);
        this.domainGrapher.setYAxisTitle("Im");
        this.domainGrapher.setYMax(1.0);
        this.domainGrapher.setYMin(-1.0);
        this.domainGrapher.setAntiAliasing(true);
        this.domainGrapher.setNumTraces(1);
        this.domainGrapher.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.domainGrapherMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                StarTool.this.domainGrapherMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                StarTool.this.domainGrapherMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                StarTool.this.domainGrapherMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                StarTool.this.domainGrapherMouseReleased(evt);
            }
        });
        this.domainGrapher.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                StarTool.this.domainGrapherMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                StarTool.this.domainGrapherMouseMoved(evt);
            }
        });
        this.domainGrapher.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                StarTool.this.domainGrapherMouseWheelMoved(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainGrapher);
        this.domainGrapher.setBounds(45, 35, 300, 300);
        this.domainDefaultViewButton.setFont(new Font("Dialog", 1, 10));
        this.domainDefaultViewButton.setText("Default View");
        this.domainDefaultViewButton.setMargin(new Insets(2, 2, 2, 2));
        this.domainDefaultViewButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.domainDefaultViewButtonMouseClicked(evt);
            }
        });
        this.grapherDomainPanel.add(this.domainDefaultViewButton);
        this.domainDefaultViewButton.setBounds(253, 19, 91, 15);
        this.starToolPanel.add(this.grapherDomainPanel);
        this.grapherDomainPanel.setBounds(0, 0, 350, 355);
        this.grapherRangePanel.setBackground(new Color(204, 204, 204));
        this.grapherRangePanel.setBorder(BorderFactory.createEtchedBorder());
        this.grapherRangePanel.setLayout(null);
        this.rangeGrapher.setBorder(BorderFactory.createEtchedBorder());
        this.rangeGrapher.setXAxisTitle("Re");
        this.rangeGrapher.setXMax(1.0);
        this.rangeGrapher.setXMin(-1.0);
        this.rangeGrapher.setYAxisTitle("Im");
        this.rangeGrapher.setYMax(1.0);
        this.rangeGrapher.setYMin(-1.0);
        this.rangeGrapher.setNumTraces(1);
        this.rangeGrapher.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.rangeGrapherMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                StarTool.this.rangeGrapherMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                StarTool.this.rangeGrapherMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                StarTool.this.rangeGrapherMousePressed(evt);
            }
        });
        this.rangeGrapher.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                StarTool.this.rangeGrapherMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                StarTool.this.rangeGrapherMouseMoved(evt);
            }
        });
        this.rangeGrapher.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                StarTool.this.rangeGrapherMouseWheelMoved(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeGrapher);
        this.rangeGrapher.setBounds(45, 35, 300, 300);
        this.defaultDomainButton.setFont(new Font("LucidaSans", 1, 10));
        this.defaultDomainButton.setText("Regraph with Re: [-1,1]  Im: [-1,1]");
        this.defaultDomainButton.setMargin(new Insets(2, 2, 2, 2));
        this.defaultDomainButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.defaultDomainButtonMouseClicked(evt);
            }
        });
        this.grapherRangePanel.add(this.defaultDomainButton);
        this.defaultDomainButton.setBounds(2, 422, 407, 16);
        this.rangeYMaxField.setText("1");
        this.rangeYMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeYMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.rangeYMaxFieldFocusGained(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeYMaxField);
        this.rangeYMaxField.setBounds(2, 19, 40, 15);
        this.rangeYMinField.setText("-1");
        this.rangeYMinField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeYMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.rangeYMinFieldFocusGained(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeYMinField);
        this.rangeYMinField.setBounds(2, 320, 40, 15);
        this.rangeXMinField.setText("-1");
        this.rangeXMinField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeXMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.rangeXMinFieldFocusGained(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeXMinField);
        this.rangeXMinField.setBounds(45, 335, 40, 15);
        this.rangeXMaxField.setText("1");
        this.rangeXMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeXMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StarTool.this.rangeXMaxFieldFocusGained(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeXMaxField);
        this.rangeXMaxField.setBounds(305, 335, 40, 15);
        this.rangeDomainChoiceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.rangeDomainChoiceBoxActionPerformed(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeDomainChoiceBox);
        this.rangeDomainChoiceBox.setBounds(45, 19, 205, 15);
        this.rangeCursorLabel.setBackground(new Color(255, 255, 255));
        this.rangeCursorLabel.setFont(new Font("LucidaSans", 1, 10));
        this.rangeCursorLabel.setText("Cursor:");
        this.grapherRangePanel.add(this.rangeCursorLabel);
        this.rangeCursorLabel.setBounds(100, 335, 38, 15);
        this.rangeCursorLocateLabel.setText("invisible");
        this.grapherRangePanel.add(this.rangeCursorLocateLabel);
        this.rangeCursorLocateLabel.setBounds(140, 335, 160, 15);
        this.rangeCrossedAxesButton.setBackground(Color.white);
        this.rangeButtonGroup.add(this.rangeCrossedAxesButton);
        this.rangeCrossedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.rangeCrossedAxesButton.setSelected(true);
        this.rangeCrossedAxesButton.setText("Crossed");
        this.rangeCrossedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rangeCrossedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.rangeCrossedAxesButton.setOpaque(false);
        this.rangeCrossedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.rangeCrossedAxesButtonActionPerformed(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeCrossedAxesButton);
        this.rangeCrossedAxesButton.setBounds(210, 3, 56, 15);
        this.rangeBoxedAxesButton.setBackground(Color.white);
        this.rangeButtonGroup.add(this.rangeBoxedAxesButton);
        this.rangeBoxedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.rangeBoxedAxesButton.setText("Boxed axes");
        this.rangeBoxedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rangeBoxedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.rangeBoxedAxesButton.setOpaque(false);
        this.rangeBoxedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.rangeBoxedAxesButtonActionPerformed(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeBoxedAxesButton);
        this.rangeBoxedAxesButton.setBounds(270, 3, 82, 15);
        this.rangeDefaultViewButton.setFont(new Font("Dialog", 1, 10));
        this.rangeDefaultViewButton.setText("Default View");
        this.rangeDefaultViewButton.setMargin(new Insets(2, 2, 2, 2));
        this.rangeDefaultViewButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.rangeDefaultViewButtonMouseClicked(evt);
            }
        });
        this.grapherRangePanel.add(this.rangeDefaultViewButton);
        this.rangeDefaultViewButton.setBounds(253, 19, 91, 15);
        this.starToolPanel.add(this.grapherRangePanel);
        this.grapherRangePanel.setBounds(675, 0, 350, 355);
        this.zoomErrorMessagePanel.setBackground(new Color(204, 204, 204));
        this.zoomErrorMessagePanel.setLayout(null);
        this.zoomErrorMessageLabel.setFont(new Font("LucidaSans", 1, 12));
        this.zoomErrorMessageLabel.setHorizontalAlignment(0);
        this.zoomErrorMessageLabel.setText("Zoom capabilities not available when sketching");
        this.zoomErrorMessagePanel.add(this.zoomErrorMessageLabel);
        this.zoomErrorMessageLabel.setBounds(0, 28, 325, 20);
        this.zoomPanel.setBackground(new Color(204, 204, 204));
        this.zoomPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StarTool.this.zoomPanelPropertyChange(evt);
            }
        });
        this.zoomErrorMessagePanel.add(this.zoomPanel);
        this.zoomPanel.setBounds(0, 0, 325, 80);
        this.starToolPanel.add(this.zoomErrorMessagePanel);
        this.zoomErrorMessagePanel.setBounds(350, 275, 325, 80);
        this.starInfoPanel.setBackground(new Color(204, 204, 204));
        this.starInfoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.starInfoPanel.setFont(new Font("LucidaSans", 0, 10));
        this.starInfoPanel.setLayout(null);
        this.updateButton.setFont(new Font("LucidaSans", 1, 10));
        this.updateButton.setText("Update");
        this.updateButton.setMargin(new Insets(2, 2, 2, 2));
        this.updateButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.updateButtonMouseClicked(evt);
            }
        });
        this.starInfoPanel.add(this.updateButton);
        this.updateButton.setBounds(50, 243, 87, 16);
        this.defaultButton.setFont(new Font("LucidaSans", 1, 10));
        this.defaultButton.setText("Reset Defaults");
        this.defaultButton.setMargin(new Insets(2, 2, 2, 2));
        this.defaultButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.defaultButtonMouseClicked(evt);
            }
        });
        this.starInfoPanel.add(this.defaultButton);
        this.defaultButton.setBounds(187, 243, 87, 16);
        this.currentNMinusButtonm.setFont(new Font("LucidaSans", 1, 10));
        this.currentNMinusButtonm.setText("-");
        this.currentNMinusButtonm.setHorizontalTextPosition(0);
        this.currentNMinusButtonm.setMargin(new Insets(2, 2, 2, 2));
        this.currentNMinusButtonm.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.currentNMinusButtonmMouseClicked(evt);
            }
        });
        this.starInfoPanel.add(this.currentNMinusButtonm);
        this.currentNMinusButtonm.setBounds(190, 10, 21, 16);
        this.currentNPlusButton.setFont(new Font("LucidaSans", 1, 10));
        this.currentNPlusButton.setText("+ ");
        this.currentNPlusButton.setHorizontalTextPosition(0);
        this.currentNPlusButton.setMargin(new Insets(2, 2, 2, 2));
        this.currentNPlusButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StarTool.this.currentNPlusButtonMouseClicked(evt);
            }
        });
        this.starInfoPanel.add(this.currentNPlusButton);
        this.currentNPlusButton.setBounds(210, 10, 21, 16);
        this.currentPLabel.setFont(new Font("LucidaSans", 1, 10));
        this.currentPLabel.setHorizontalAlignment(4);
        this.currentPLabel.setText("p=");
        this.starInfoPanel.add(this.currentPLabel);
        this.currentPLabel.setBounds(105, 65, 15, 16);
        this.currentRLabel.setFont(new Font("LucidaSans", 1, 10));
        this.currentRLabel.setHorizontalAlignment(4);
        this.currentRLabel.setText("r=");
        this.starInfoPanel.add(this.currentRLabel);
        this.currentRLabel.setBounds(105, 120, 15, 16);
        this.currentNLabel.setFont(new Font("LucidaSans", 1, 10));
        this.currentNLabel.setHorizontalAlignment(4);
        this.currentNLabel.setText("n=");
        this.starInfoPanel.add(this.currentNLabel);
        this.currentNLabel.setBounds(105, 10, 15, 16);
        this.currentNField.setHorizontalAlignment(0);
        this.currentNField.setText("3");
        this.currentNField.setFont(new Font("LucidaSans", 0, 10));
        this.starInfoPanel.add(this.currentNField);
        this.currentNField.setBounds(120, 10, 70, 16);
        this.currentPField.setHorizontalAlignment(0);
        this.currentPField.setText("0.5");
        this.currentPField.setFont(new Font("LucidaSans", 0, 10));
        this.starInfoPanel.add(this.currentPField);
        this.currentPField.setBounds(120, 65, 70, 16);
        this.currentRField.setHorizontalAlignment(0);
        this.currentRField.setText("0.3");
        this.currentRField.setFont(new Font("LucidaSans", 0, 10));
        this.starInfoPanel.add(this.currentRField);
        this.currentRField.setBounds(120, 120, 70, 16);
        this.currentPSlider.setOpaque(false);
        this.currentPSlider.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                StarTool.this.currentPSliderMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                StarTool.this.currentPSliderMouseExited(evt);
            }
        });
        this.currentPSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                StarTool.this.currentPSliderMouseDragged(evt);
            }
        });
        this.currentPSlider.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                StarTool.this.currentPSliderKeyPressed(evt);
            }
        });
        this.starInfoPanel.add(this.currentPSlider);
        this.currentPSlider.setBounds(30, 45, 250, 16);
        this.pZeroLabel.setFont(new Font("LucidaSans", 0, 10));
        this.pZeroLabel.setText("0.0");
        this.starInfoPanel.add(this.pZeroLabel);
        this.pZeroLabel.setBounds(10, 45, 15, 16);
        this.pOneLabel.setFont(new Font("LucidaSans", 0, 10));
        this.pOneLabel.setText("1.0");
        this.starInfoPanel.add(this.pOneLabel);
        this.pOneLabel.setBounds(281, 45, 40, 16);
        this.currentRSlider.setDoubleMax(2.0);
        this.currentRSlider.setDoubleVal(0.3);
        this.currentRSlider.setOpaque(false);
        this.currentRSlider.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                StarTool.this.currentRSliderMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                StarTool.this.currentRSliderMouseExited(evt);
            }
        });
        this.currentRSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                StarTool.this.currentRSliderMouseDragged(evt);
            }
        });
        this.currentRSlider.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                StarTool.this.currentRSliderKeyPressed(evt);
            }
        });
        this.starInfoPanel.add(this.currentRSlider);
        this.currentRSlider.setBounds(30, 100, 250, 16);
        this.currentRZeroLabel.setFont(new Font("LucidaSans", 0, 10));
        this.currentRZeroLabel.setText("0.0");
        this.starInfoPanel.add(this.currentRZeroLabel);
        this.currentRZeroLabel.setBounds(10, 100, 15, 16);
        this.currentRMaxField.setText("2.0");
        this.currentRMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.starInfoPanel.add(this.currentRMaxField);
        this.currentRMaxField.setBounds(281, 100, 40, 16);
        this.dividerPanel1.setBackground(new Color(153, 153, 153));
        this.dividerPanel1.setLayout(null);
        this.starInfoPanel.add(this.dividerPanel1);
        this.dividerPanel1.setBounds(10, 35, 305, 3);
        this.dividerPanel2.setBackground(new Color(153, 153, 153));
        this.dividerPanel2.setLayout(null);
        this.starInfoPanel.add(this.dividerPanel2);
        this.dividerPanel2.setBounds(10, 90, 305, 3);
        this.dividerPanel3.setBackground(new Color(153, 153, 153));
        this.dividerPanel3.setLayout(null);
        this.starInfoPanel.add(this.dividerPanel3);
        this.dividerPanel3.setBounds(10, 150, 305, 3);
        this.sketchBox.setBackground(Color.white);
        this.sketchBox.setFont(new Font("LucidaSans", 0, 10));
        this.sketchBox.setText("Sketch");
        this.sketchBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sketchBox.setMargin(new Insets(0, 0, 0, 0));
        this.sketchBox.setOpaque(false);
        this.sketchBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                StarTool.this.sketchBoxItemStateChanged(evt);
            }
        });
        this.starInfoPanel.add(this.sketchBox);
        this.sketchBox.setBounds(5, 190, 49, 16);
        this.showRootsBox.setBackground(new Color(255, 255, 255));
        this.showRootsBox.setFont(new Font("LucidaSans", 0, 10));
        this.showRootsBox.setText("Show roots of");
        this.showRootsBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showRootsBox.setMargin(new Insets(0, 0, 0, 0));
        this.showRootsBox.setOpaque(false);
        this.showRootsBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                StarTool.this.showRootsBoxItemStateChanged(evt);
            }
        });
        this.starInfoPanel.add(this.showRootsBox);
        this.showRootsBox.setBounds(5, 165, 84, 16);
        this.numInteriorCirclesLabel.setFont(new Font("LucidaSans", 0, 11));
        this.numInteriorCirclesLabel.setHorizontalAlignment(4);
        this.numInteriorCirclesLabel.setText("Interior circles:");
        this.starInfoPanel.add(this.numInteriorCirclesLabel);
        this.numInteriorCirclesLabel.setBounds(198, 165, 82, 16);
        this.numInteriorCirclesField.setText("9");
        this.starInfoPanel.add(this.numInteriorCirclesField);
        this.numInteriorCirclesField.setBounds(281, 165, 40, 16);
        this.numRaysLabel.setFont(new Font("LucidaSans", 0, 11));
        this.numRaysLabel.setHorizontalAlignment(4);
        this.numRaysLabel.setText("Rays:");
        this.starInfoPanel.add(this.numRaysLabel);
        this.numRaysLabel.setBounds(198, 190, 82, 16);
        this.numRaysField.setText("23");
        this.starInfoPanel.add(this.numRaysField);
        this.numRaysField.setBounds(281, 190, 40, 16);
        this.dividerPanel4.setBackground(new Color(153, 153, 153));
        this.dividerPanel4.setLayout(null);
        this.starInfoPanel.add(this.dividerPanel4);
        this.dividerPanel4.setBounds(10, 225, 305, 3);
        this.omegaLabel.setFont(new Font("Lucida Sans", 1, 10));
        this.omegaLabel.setIcon(new ImageIcon("/home/jimrolf/java/StarTool0.3/src/com/jimrolf/startool/image022.gif"));
        this.starInfoPanel.add(this.omegaLabel);
        this.omegaLabel.setBounds(90, 166, 30, 16);
        this.starToolPanel.add(this.starInfoPanel);
        this.starInfoPanel.setBounds(350, 0, 325, 275);
        this.getContentPane().add(this.starToolPanel);
        this.starToolPanel.setBounds(0, 0, 1025, 355);
        this.menuBar.setFont(new Font("Lucida Sans", 1, 12));
        this.export.setText("Export");
        this.export.setFont(new Font("Lucida Sans", 1, 12));
        this.exportDomainGraph.setFont(new Font("Lucida Sans", 0, 10));
        this.exportDomainGraph.setText("Export graph of domain");
        this.exportDomainGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.exportDomainGraphActionPerformed(evt);
            }
        });
        this.export.add(this.exportDomainGraph);
        this.exportRangeGraph.setFont(new Font("Lucida Sans", 0, 10));
        this.exportRangeGraph.setText("Export graph of range");
        this.exportRangeGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.exportRangeGraphActionPerformed(evt);
            }
        });
        this.export.add(this.exportRangeGraph);
        this.exportApplet.setFont(new Font("Lucida Sans", 0, 10));
        this.exportApplet.setText("Export screen shot of applet");
        this.exportApplet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.exportAppletActionPerformed(evt);
            }
        });
        this.export.add(this.exportApplet);
        this.menuBar.add(this.export);
        this.exportSettings.setText("Export settings");
        this.exportSettings.setFont(new Font("Lucida Sans", 1, 12));
        this.pngMenuItem.setFont(new Font("Lucida Sans", 0, 10));
        this.pngMenuItem.setSelected(true);
        this.pngMenuItem.setText("Export as .png");
        this.pngMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.pngMenuItemActionPerformed(evt);
            }
        });
        this.exportSettings.add(this.pngMenuItem);
        this.gifMenuItem.setFont(new Font("Lucida Sans", 0, 10));
        this.gifMenuItem.setLabel("Export as .gif");
        this.gifMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.gifMenuItemActionPerformed(evt);
            }
        });
        this.exportSettings.add(this.gifMenuItem);
        this.jpgMenuItem.setFont(new Font("Lucida Sans", 0, 10));
        this.jpgMenuItem.setText("Export as .jpg");
        this.jpgMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StarTool.this.jpgMenuItemActionPerformed(evt);
            }
        });
        this.exportSettings.add(this.jpgMenuItem);
        this.menuBar.add(this.exportSettings);
        this.setJMenuBar(this.menuBar);
    }

    private void domainDefaultViewButtonMouseClicked(MouseEvent evt) {
        this.domainDomainChoiceBox.putDomainRangeVals();
        this.domainGrapher.plotData();
    }

    private void sketchBoxItemStateChanged(ItemEvent evt) {
        if (this.sketchBox.isSelected()) {
            this.zoomPanel.setVisible(false);
            this.zoomErrorMessageLabel.setVisible(true);
        } else {
            this.zoomPanel.setVisible(true);
            this.zoomErrorMessageLabel.setVisible(false);
        }
    }

    private void rangeDefaultViewButtonMouseClicked(MouseEvent evt) {
        this.rangeDomainChoiceBox.putDomainRangeVals();
        this.rangeGrapher.plotData();
    }

    private void zoomPanelPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("zoomSliderHasMoved")) {
            this.currentGrapher.plotData();
        } else {
            this.focusField = this.zoomPanel.getFocusField();
        }
    }

    private void showRootsBoxItemStateChanged(ItemEvent evt) {
        if (this.showRootsBox.isSelected()) {
            this.computeRoots();
            this.roots.setNumPoints(this.currentN + 1);
            this.domainOrderTraces[2 * this.currentN + 1] = this.maxNumArcsVertices + 1;
            this.domainGrapher.setNumTraces(2 * this.currentN + 2);
        } else {
            this.domainGrapher.setNumTraces(2 * this.currentN + 1);
            for (int i = 0; i <= this.maxNumArcsVertices / 2 - 1; ++i) {
                this.domainOrderTraces[2 * i + 1] = 2 * i + 1;
                this.domainOrderTraces[2 * i + 2] = 2 * i + 2;
            }
        }
        this.domainGrapher.plotData();
    }

    private void currentRSliderKeyPressed(KeyEvent evt) {
        this.currentR = this.currentRSlider.getDoubleVal(evt);
        this.currentRField.setDoubleText(this.currentR);
        this.createVertexData();
        this.transformData();
        if (this.showRootsBox.isSelected()) {
            this.computeRoots();
            this.domainGrapher.plotData();
        }
        this.rangeGrapher.plotData();
    }

    private void domainGrapherMousePressed(MouseEvent evt) {
        this.clearLabels();
        if (this.sketchBox.isSelected()) {
            this.cursorX = this.domainGrapher.getXVal(evt.getX());
            this.cursorY = this.domainGrapher.getYVal(evt.getY());
            this.domainGrapher.setLastX(this.cursorX);
            this.domainGrapher.setLastY(this.cursorY);
            this.zVal.setRe(this.cursorX);
            this.zVal.setIm(this.cursorY);
            this.zRange = this.func(this.zVal);
            this.rangeGrapher.setLastX(this.zRange.re());
            this.rangeGrapher.setLastY(this.zRange.im());
        } else {
            this.domainGrapher.mousePressed(evt);
        }
    }

    private void domainGrapherMouseDragged(MouseEvent evt) {
        if (this.sketchBox.isSelected()) {
            this.cursorX = this.domainGrapher.getXVal(evt.getX());
            this.cursorY = this.domainGrapher.getYVal(evt.getY());
            this.domainCursorLocateLabel.setCursorLocation(this.cursorX, this.cursorY);
            this.zVal.setRe(this.cursorX);
            this.zVal.setIm(this.cursorY);
            this.zRange = this.func(this.zVal);
            this.domainGrapher.sketchData(this.cursorX, this.cursorY);
            this.rangeGrapher.sketchData(this.zRange.re(), this.zRange.im());
        } else {
            this.domainGrapher.mouseDragged(evt);
            this.domainGrapher.plotData();
        }
    }

    private void domainGrapherMouseMoved(MouseEvent evt) {
        this.domainCursorLocateLabel.setCursorLocation(this.domainGrapher.getXVal(evt.getX()), this.domainGrapher.getYVal(evt.getY()));
    }

    private void domainGrapherMouseExited(MouseEvent evt) {
        this.componentIsFocused = false;
        this.domainCursorLocateLabel.setVisible(false);
    }

    private void domainGrapherMouseEntered(MouseEvent evt) {
        this.zoomPanel.register(this.domainGrapher);
        this.currentGrapher = this.domainGrapher;
        this.currentDomainRange = this.domainDomainRange;
        this.componentIsFocused = this.domainGrapher.requestFocusInWindow();
        this.domainCursorLocateLabel.setCursorLocation(this.domainGrapher.getXVal(evt.getX()), this.domainGrapher.getYVal(evt.getY()));
        this.domainCursorLocateLabel.setVisible(true);
    }

    private void currentRSliderMouseDragged(MouseEvent evt) {
        this.currentR = this.currentRSlider.getDoubleVal(evt);
        this.currentRField.setDoubleText(this.currentR);
        this.createVertexData();
        this.transformData();
        if (this.showRootsBox.isSelected()) {
            this.computeRoots();
            this.domainGrapher.plotData();
        }
        this.rangeGrapher.plotData();
    }

    private void currentRSliderMouseExited(MouseEvent evt) {
        this.componentIsFocused = false;
    }

    private void currentRSliderMouseEntered(MouseEvent evt) {
        this.componentIsFocused = this.currentRSlider.requestFocusInWindow();
    }

    private void currentPSliderKeyPressed(KeyEvent evt) {
        this.currentP = this.currentPSlider.getDoubleVal(evt);
        this.currentPField.setDoubleText(this.currentP);
        this.createArcData();
        this.transformData();
        if (this.showRootsBox.isSelected()) {
            this.computeRoots();
        }
        this.domainGrapher.plotData();
        this.rangeGrapher.plotData();
    }

    private void currentPSliderMouseDragged(MouseEvent evt) {
        this.currentP = this.currentPSlider.getDoubleVal(evt);
        this.currentPField.setDoubleText(this.currentP);
        this.createArcData();
        this.transformData();
        if (this.showRootsBox.isSelected()) {
            this.computeRoots();
        }
        this.domainGrapher.plotData();
        this.rangeGrapher.plotData();
    }

    private void currentPSliderMouseExited(MouseEvent evt) {
        this.componentIsFocused = false;
    }

    private void currentPSliderMouseEntered(MouseEvent evt) {
        this.componentIsFocused = this.currentPSlider.requestFocusInWindow();
    }

    private void currentNPlusButtonMouseClicked(MouseEvent evt) {
        if (!this.currentNField.hasError()) {
            this.currentN = this.currentNField.getIntVal();
            if (this.currentN < this.maxNumArcsVertices / 2) {
                ++this.currentN;
                this.currentNField.setText("" + this.currentN);
                this.numRays = 8 * this.currentN - 1;
                this.numRaysField.setText("" + this.numRays);
                this.domainPGrid.setNumRays(this.numRays);
                this.rangePGrid.setNumRays(this.numRays);
                this.domainPGrid.createData();
                this.rangePGrid.createData();
                this.createArcData();
                this.createVertexData();
                this.transformData();
                if (this.showRootsBox.isSelected()) {
                    this.roots.setNumPoints(this.currentN + 1);
                    for (int i = 0; i <= this.currentN - 1; ++i) {
                        this.domainOrderTraces[2 * i + 1] = 2 * i + 1;
                        this.domainOrderTraces[2 * i + 2] = 2 * i + 2;
                    }
                    this.domainOrderTraces[2 * this.currentN + 1] = this.maxNumArcsVertices + 1;
                    this.roots.setNumPoints(this.currentN + 1);
                    this.computeRoots();
                    this.domainGrapher.setNumTraces(2 * this.currentN + 2);
                } else {
                    this.domainGrapher.setNumTraces(2 * this.currentN + 1);
                }
                this.rangeGrapher.setNumTraces(2 * this.currentN + 1);
                this.domainGrapher.plotData();
                this.rangeGrapher.plotData();
            }
        }
    }

    private void currentNMinusButtonmMouseClicked(MouseEvent evt) {
        if (!this.currentNField.hasError()) {
            this.currentN = this.currentNField.getIntVal();
            if (this.currentN > 2) {
                --this.currentN;
                this.currentNField.setText("" + this.currentN);
                this.currentNField.setText("" + this.currentN);
                this.numRays = 8 * this.currentN - 1;
                this.numRaysField.setText("" + this.numRays);
                this.domainPGrid.setNumRays(this.numRays);
                this.rangePGrid.setNumRays(this.numRays);
                this.domainPGrid.createData();
                this.rangePGrid.createData();
                this.createArcData();
                this.createVertexData();
                this.transformData();
                if (this.showRootsBox.isSelected()) {
                    this.roots.setNumPoints(this.currentN + 1);
                    for (int i = 0; i <= this.currentN - 1; ++i) {
                        this.domainOrderTraces[2 * i + 1] = 2 * i + 1;
                        this.domainOrderTraces[2 * i + 2] = 2 * i + 2;
                    }
                    this.domainOrderTraces[2 * this.currentN + 1] = this.maxNumArcsVertices + 1;
                    this.roots.setNumPoints(this.currentN + 1);
                    this.computeRoots();
                    this.domainGrapher.setNumTraces(2 * this.currentN + 2);
                } else {
                    this.domainGrapher.setNumTraces(2 * this.currentN + 1);
                }
                this.rangeGrapher.setNumTraces(2 * this.currentN + 1);
                this.domainGrapher.plotData();
                this.rangeGrapher.plotData();
            }
        }
    }

    private void rangeGrapherMouseWheelMoved(MouseWheelEvent evt) {
        this.zoomPanel.zoomByMouseWheel(evt);
        this.rangeGrapher.plotData();
    }

    private void defaultDomainButtonMouseClicked(MouseEvent evt) {
        this.rangeDomainChoiceBox.putDomainRangeVals();
        this.rangeGrapher.plotData();
    }

    private void rangeGrapherMouseClicked(MouseEvent evt) {
        this.clearLabels();
        this.grapherMouseClicked(evt);
    }

    private void domainBoxedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.domainCrossedAxesButton.isSelected()) {
            this.domainGrapher.setAxesStyle(1);
        } else {
            this.domainGrapher.setAxesStyle(2);
        }
        this.domainGrapher.plotData();
    }

    private void domainCrossedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.domainCrossedAxesButton.isSelected()) {
            this.domainGrapher.setAxesStyle(1);
        } else {
            this.domainGrapher.setAxesStyle(2);
        }
        this.domainGrapher.plotData();
    }

    private void rangeBoxedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.rangeCrossedAxesButton.isSelected()) {
            this.rangeGrapher.setAxesStyle(1);
        } else {
            this.rangeGrapher.setAxesStyle(2);
        }
        this.rangeGrapher.plotData();
    }

    private void rangeCrossedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.rangeCrossedAxesButton.isSelected()) {
            this.rangeGrapher.setAxesStyle(1);
        } else {
            this.rangeGrapher.setAxesStyle(2);
        }
        this.rangeGrapher.plotData();
    }

    private void rangeDomainChoiceBoxActionPerformed(ActionEvent evt) {
        this.rangeDomainChoiceBox.itemClicked();
        this.rangeGrapher.plotData();
    }

    private void domainDomainChoiceBoxActionPerformed(ActionEvent evt) {
        this.domainDomainChoiceBox.itemClicked();
        this.domainGrapher.plotData();
    }

    private void defaultButtonMouseClicked(MouseEvent evt) {
        this.clearLabels();
        this.sketchBox.setSelected(false);
        this.showRootsBox.setSelected(false);
        this.currentN = 3;
        this.currentNField.setText("" + this.currentN);
        this.currentRMax = 2.0;
        this.currentRField.setDoubleText(this.currentRMax);
        this.currentRSlider.setDoubleMax(this.currentRMax);
        this.currentR = 0.3;
        this.currentRField.setDoubleText(this.currentR);
        this.currentRSlider.setDoubleVal(this.currentR);
        this.currentP = 0.5;
        this.currentPField.setDoubleText(this.currentP);
        this.currentPSlider.setDoubleVal(this.currentP);
        this.domainDomainChoiceBox.putDomainRangeVals();
        this.rangeDomainChoiceBox.putDomainRangeVals();
        this.numInteriorCirclesField.setText("" + this.defaultNumInteriorCircles);
        this.numInteriorCircles = this.defaultNumInteriorCircles;
        this.numRaysField.setText("" + this.defaultNumRays);
        this.numRays = this.defaultNumRays;
        this.domainPGrid.setNumCircles(this.defaultNumInteriorCircles + 1);
        this.domainPGrid.setNumRays(this.defaultNumRays);
        this.rangePGrid.setNumCircles(this.defaultNumInteriorCircles + 1);
        this.rangePGrid.setNumRays(this.defaultNumRays);
        this.domainPGrid.createData();
        this.rangePGrid.createData();
        this.createArcData();
        this.createVertexData();
        this.transformData();
        this.domainGrapher.setNumTraces(2 * this.currentN + 1);
        this.rangeGrapher.setNumTraces(2 * this.currentN + 1);
        this.domainGrapher.plotData();
        this.rangeGrapher.plotData();
    }

    private void updateButtonMouseClicked(MouseEvent evt) {
        boolean noProblems = true;
        this.clearLabels();
        if (this.isXYInputsGood() && this.isInputInfoGood() && noProblems) {
            this.domainPGrid.createData();
            this.rangePGrid.createData();
            this.createArcData();
            this.createVertexData();
            this.transformData();
            if (this.showRootsBox.isSelected()) {
                this.roots.setNumPoints(this.currentN + 1);
                for (int i = 0; i <= this.currentN - 1; ++i) {
                    this.domainOrderTraces[2 * i + 1] = 2 * i + 1;
                    this.domainOrderTraces[2 * i + 2] = 2 * i + 2;
                }
                this.domainOrderTraces[2 * this.currentN + 1] = this.maxNumArcsVertices + 1;
                this.roots.setNumPoints(this.currentN + 1);
                this.computeRoots();
                this.domainGrapher.setNumTraces(2 * this.currentN + 2);
            } else {
                this.domainGrapher.setNumTraces(2 * this.currentN + 1);
            }
            this.rangeGrapher.setNumTraces(2 * this.currentN + 1);
            this.domainGrapher.plotData();
            this.rangeGrapher.plotData();
        }
    }

    private void rangeXMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeXMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeYMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeYMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainXMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainXMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainYMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainYMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeGrapherMouseExited(MouseEvent evt) {
        this.componentIsFocused = false;
        this.rangeCursorLocateLabel.setVisible(false);
    }

    private void rangeGrapherMouseEntered(MouseEvent evt) {
        this.componentIsFocused = this.rangeGrapher.requestFocusInWindow();
        this.zoomPanel.register(this.rangeGrapher);
        this.currentGrapher = this.rangeGrapher;
        this.currentDomainRange = this.rangeDomainRange;
        this.rangeCursorLocateLabel.setCursorLocation(this.rangeGrapher.getXVal(evt.getX()), this.rangeGrapher.getYVal(evt.getY()));
        this.rangeCursorLocateLabel.setVisible(true);
    }

    private void rangeGrapherMouseMoved(MouseEvent evt) {
        this.rangeCursorLocateLabel.setCursorLocation(this.rangeGrapher.getXVal(evt.getX()), this.rangeGrapher.getYVal(evt.getY()));
    }

    private void rangeGrapherMouseDragged(MouseEvent evt) {
        this.rangeGrapher.mouseDragged(evt);
        this.rangeGrapher.plotData();
    }

    private void rangeGrapherMousePressed(MouseEvent evt) {
        this.rangeGrapher.mousePressed(evt);
    }

    private void domainGrapherMouseReleased(MouseEvent evt) {
    }

    private void domainGrapherMouseWheelMoved(MouseWheelEvent evt) {
        this.zoomPanel.zoomByMouseWheel(evt);
        this.domainGrapher.plotData();
    }

    private void domainGrapherMouseClicked(MouseEvent evt) {
        this.clearLabels();
        this.grapherMouseClicked(evt);
    }

    private void exportDomainGraphActionPerformed(ActionEvent evt) {
        this.exportActionEvent(evt);
    }

    private void exportRangeGraphActionPerformed(ActionEvent evt) {
        this.exportActionEvent(evt);
    }

    private void exportAppletActionPerformed(ActionEvent evt) {
        this.exportActionEvent(evt);
    }

    private void pngMenuItemActionPerformed(ActionEvent evt) {
        this.imageType = "png";
    }

    private void gifMenuItemActionPerformed(ActionEvent evt) {
        this.imageType = "gif";
    }

    private void jpgMenuItemActionPerformed(ActionEvent evt) {
        this.imageType = "jpg";
    }

    private boolean isXYInputsGood() {
        boolean noProblems = true;
        if (this.domainXMinField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[0] = this.domainXMinField.getDoubleVal();
            this.domainGrapher.setXMin(this.domainDomainRange[0]);
        }
        if (this.domainXMaxField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[1] = this.domainXMaxField.getDoubleVal();
            this.domainGrapher.setXMax(this.domainDomainRange[1]);
        }
        if (this.domainYMinField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[2] = this.domainYMinField.getDoubleVal();
            this.domainGrapher.setYMin(this.domainDomainRange[2]);
        }
        if (this.domainYMaxField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[3] = this.domainYMaxField.getDoubleVal();
            this.domainGrapher.setYMax(this.domainDomainRange[3]);
        }
        if (this.rangeXMinField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[0] = this.rangeXMinField.getDoubleVal();
            this.rangeGrapher.setXMin(this.rangeDomainRange[0]);
        }
        if (this.rangeXMaxField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[1] = this.rangeXMaxField.getDoubleVal();
            this.rangeGrapher.setXMax(this.rangeDomainRange[1]);
        }
        if (this.rangeYMinField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[2] = this.rangeYMinField.getDoubleVal();
            this.rangeGrapher.setYMin(this.rangeDomainRange[2]);
        }
        if (this.rangeYMaxField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[3] = this.rangeYMaxField.getDoubleVal();
            this.rangeGrapher.setYMax(this.rangeDomainRange[3]);
        }
        return noProblems;
    }

    private void transformData() {
        int j;
        int i;
        for (i = 0; i <= this.domainPGrid.getNumCircles() - 1; ++i) {
            for (j = 0; j <= this.domainPGrid.getNumCirclePoints() - 1; ++j) {
                this.zVal.setRe(this.domainPGrid.getCircles(i).getDataX(j));
                this.zVal.setIm(this.domainPGrid.getCircles(i).getDataY(j));
                this.zRange = this.func(this.zVal);
                this.rangePGrid.getCircles(i).setDataX(j, this.zRange.re());
                this.rangePGrid.getCircles(i).setDataY(j, this.zRange.im());
            }
        }
        for (i = 0; i <= this.domainPGrid.getNumTotalRays() - 1; ++i) {
            for (j = 0; j <= this.domainPGrid.getNumRayPoints() - 1; ++j) {
                this.zVal.setRe(this.domainPGrid.getRays(i).getDataX(j));
                this.zVal.setIm(this.domainPGrid.getRays(i).getDataY(j));
                this.zRange = this.func(this.zVal);
                this.rangePGrid.getRays(i).setDataX(j, this.zRange.re());
                this.rangePGrid.getRays(i).setDataY(j, this.zRange.im());
            }
        }
    }

    private void clearLabels() {
        this.zoomPanel.clearLabels();
        this.domainXMinField.setBackground(this.backgroundColor);
        this.domainXMaxField.setBackground(this.backgroundColor);
        this.domainYMinField.setBackground(this.backgroundColor);
        this.domainYMaxField.setBackground(this.backgroundColor);
        this.rangeXMinField.setBackground(this.backgroundColor);
        this.rangeXMaxField.setBackground(this.backgroundColor);
        this.rangeYMinField.setBackground(this.backgroundColor);
        this.rangeYMaxField.setBackground(this.backgroundColor);
        this.numRaysField.setBackground(this.backgroundColor);
        this.numInteriorCirclesField.setBackground(this.backgroundColor);
        this.currentPField.setBackground(this.backgroundColor);
        this.currentRField.setBackground(this.backgroundColor);
        this.currentRMaxField.setBackground(this.backgroundColor);
        this.currentNField.setBackground(this.backgroundColor);
    }

    private boolean isInputInfoGood() {
        boolean noProblems = true;
        if (this.numRaysField.hasError()) {
            noProblems = false;
        } else {
            this.numRays = this.numRaysField.getIntVal();
            this.domainPGrid.setNumRays(this.numRays);
            this.rangePGrid.setNumRays(this.numRays);
        }
        if (this.numInteriorCirclesField.hasError()) {
            noProblems = false;
        } else {
            this.numInteriorCircles = this.numInteriorCirclesField.getIntVal();
            this.domainPGrid.setNumCircles(this.numInteriorCircles + 1);
            this.rangePGrid.setNumCircles(this.numInteriorCircles + 1);
        }
        if (!this.currentPField.hasError()) {
            this.currentP = this.currentPField.getDoubleVal();
            this.currentPSlider.setDoubleVal(this.currentP);
        }
        if (!this.currentNField.hasError()) {
            this.currentN = this.currentNField.getIntVal();
        }
        if (!this.currentRField.hasError()) {
            this.currentR = this.currentRField.getDoubleVal();
            this.currentRSlider.setDoubleVal(this.currentR);
        }
        if (!this.currentRMaxField.hasError()) {
            this.currentRMax = this.currentRMaxField.getDoubleVal();
            this.currentRSlider.setDoubleMax(this.currentRMax);
            this.currentRSlider.setDoubleVal(this.currentRSlider.getDoubleVal());
        }
        return noProblems;
    }

    private Complex func(Complex z) {
        Complex sum = new Complex();
        this.sumEven.setRe(0.0);
        this.sumEven.setIm(0.0);
        this.sumOdd.setRe(0.0);
        this.sumOdd.setIm(0.0);
        for (int i = 0; i <= this.currentN - 1; ++i) {
            this.starVertexEven.setRe(this.vertexDataX[2 * i][0]);
            this.starVertexEven.setIm(this.vertexDataY[2 * i][0]);
            this.starVertexOdd.setRe(this.vertexDataX[2 * i + 1][0]);
            this.starVertexOdd.setIm(this.vertexDataY[2 * i + 1][0]);
            this.exponent.setRe(Math.cos(this.arcEnds[2 * i][1]));
            this.exponent.setIm(Math.sin(-this.arcEnds[2 * i][1]));
            this.funcNumerator = this.one.sub(z.mul(this.exponent));
            this.exponent.setRe(Math.cos(this.arcEnds[2 * i][0]));
            this.exponent.setIm(Math.sin(-this.arcEnds[2 * i][0]));
            this.funcDenom = this.one.sub(z.mul(this.exponent));
            this.sumEven = this.sumEven.add(this.starVertexEven.mul((this.arcEnds[2 * i][1] - this.arcEnds[2 * i][0]) / 2.0 + this.funcNumerator.div(this.funcDenom).arg()));
            this.exponent.setRe(Math.cos(this.arcEnds[2 * i + 1][1]));
            this.exponent.setIm(Math.sin(-this.arcEnds[2 * i + 1][1]));
            this.funcNumerator = this.one.sub(z.mul(this.exponent));
            this.exponent.setRe(Math.cos(this.arcEnds[2 * i + 1][0]));
            this.exponent.setIm(Math.sin(-this.arcEnds[2 * i + 1][0]));
            this.funcDenom = this.one.sub(z.mul(this.exponent));
            this.sumOdd = this.sumOdd.add(this.starVertexOdd.mul((this.arcEnds[2 * i + 1][1] - this.arcEnds[2 * i + 1][0]) / 2.0 + this.funcNumerator.div(this.funcDenom).arg()));
        }
        sum = this.sumEven.mul(this.piInverse).add(this.sumOdd.mul(this.piInverse));
        return sum;
    }

    private void initStuff() {
        this.fileChooser.setFont(new Font("Lucida Sans", 0, 10));
        this.domainDomainChoiceBox.registerObjects(this.domainGrapher, this.domainDomainRange, this.domainXMinField, this.domainXMaxField, this.domainYMinField, this.domainYMaxField);
        this.rangeDomainChoiceBox.registerObjects(this.rangeGrapher, this.rangeDomainRange, this.rangeXMinField, this.rangeXMaxField, this.rangeYMinField, this.rangeYMaxField);
        this.domainGrapher.registerObjects(this.domainDomainRange, this.domainXMinField, this.domainXMaxField, this.domainYMinField, this.domainYMaxField);
        this.rangeGrapher.registerObjects(this.rangeDomainRange, this.rangeXMinField, this.rangeXMaxField, this.rangeYMinField, this.rangeYMaxField);
        this.currentGrapher = this.domainGrapher;
        this.currentDomainRange = this.domainDomainRange;
        this.zoomPanel.register(this.domainGrapher);
        this.domainAllData = new PlotStuff[2 + this.maxNumArcsVertices];
        this.domainOrderTraces = new int[2 + this.maxNumArcsVertices];
        this.rangeAllData = new PlotStuff[1 + this.maxNumArcsVertices];
        this.arc = new PlotStuff2D[this.maxNumArcsVertices];
        this.arcDataX = new double[this.maxNumArcsVertices][this.numArcDataPoints];
        this.arcDataY = new double[this.maxNumArcsVertices][this.numArcDataPoints];
        this.vertexPoints = new PlotStuff2D[this.maxNumArcsVertices];
        this.vertexDataX = new double[this.maxNumArcsVertices][1];
        this.vertexDataY = new double[this.maxNumArcsVertices][1];
        this.domainAllData[0] = this.domainPGrid;
        this.rangeAllData[0] = this.rangePGrid;
        this.domainOrderTraces[0] = 0;
        this.rootsDataX = new double[this.maxNumArcsVertices / 2 + 1];
        this.rootsDataY = new double[this.maxNumArcsVertices / 2 + 2];
        this.roots = new PlotStuff2D();
        this.roots.setPlotStyle(1);
        this.roots.setNumPoints(this.currentN + 1);
        this.roots.setPlotSize(3);
        this.roots.setPlotColor(this.rootColor);
        this.roots.setDataX(this.rootsDataX);
        this.roots.setDataY(this.rootsDataY);
        this.arcEnds = new double[this.maxNumArcsVertices][2];
        for (int i = 0; i <= this.maxNumArcsVertices / 2 - 1; ++i) {
            this.arc[2 * i] = new PlotStuff2D();
            this.arc[2 * i].setPlotStyle(0);
            this.arc[2 * i].setNumPoints(this.numArcDataPoints);
            this.arc[2 * i].setPlotSize(this.arcSize);
            this.arc[2 * i].setPlotColor(this.evenColor);
            this.arc[2 * i].setDataX(this.arcDataX[2 * i]);
            this.arc[2 * i].setDataY(this.arcDataY[2 * i]);
            this.domainAllData[2 * i + 1] = this.arc[2 * i];
            this.domainOrderTraces[2 * i + 1] = 2 * i + 1;
            this.arc[2 * i + 1] = new PlotStuff2D();
            this.arc[2 * i + 1].setPlotStyle(0);
            this.arc[2 * i + 1].setNumPoints(this.numArcDataPoints);
            this.arc[2 * i + 1].setPlotSize(this.arcSize);
            this.arc[2 * i + 1].setPlotColor(this.oddColor);
            this.arc[2 * i + 1].setDataX(this.arcDataX[2 * i + 1]);
            this.arc[2 * i + 1].setDataY(this.arcDataY[2 * i + 1]);
            this.domainAllData[2 * i + 2] = this.arc[2 * i + 1];
            this.domainOrderTraces[2 * i + 2] = 2 * i + 2;
            this.vertexPoints[2 * i] = new PlotStuff2D();
            this.vertexPoints[2 * i].setPlotStyle(1);
            this.vertexPoints[2 * i].setNumPoints(1);
            this.vertexPoints[2 * i].setPlotSize(3);
            this.vertexPoints[2 * i].setPlotColor(this.evenColor);
            this.vertexPoints[2 * i].setDataX(this.vertexDataX[2 * i]);
            this.vertexPoints[2 * i].setDataY(this.vertexDataY[2 * i]);
            this.rangeAllData[2 * i + 1] = this.vertexPoints[2 * i];
            this.vertexPoints[2 * i + 1] = new PlotStuff2D();
            this.vertexPoints[2 * i + 1].setPlotStyle(1);
            this.vertexPoints[2 * i + 1].setNumPoints(1);
            this.vertexPoints[2 * i + 1].setPlotSize(3);
            this.vertexPoints[2 * i + 1].setPlotColor(this.oddColor);
            this.vertexPoints[2 * i + 1].setDataX(this.vertexDataX[2 * i + 1]);
            this.vertexPoints[2 * i + 1].setDataY(this.vertexDataY[2 * i + 1]);
            this.rangeAllData[2 * i + 2] = this.vertexPoints[2 * i + 1];
        }
        this.domainAllData[this.maxNumArcsVertices + 1] = this.roots;
        this.createArcData();
        this.createVertexData();
        this.domainPGrid.setNumRays(this.defaultNumRays);
        this.rangePGrid.setNumRays(this.defaultNumRays);
        this.domainPGrid.setNumCircles(this.defaultNumInteriorCircles + 1);
        this.rangePGrid.setNumCircles(this.defaultNumInteriorCircles + 1);
        this.domainPGrid.createData();
        this.rangePGrid.createData();
        this.transformData();
        this.domainGrapher.registerObjects(this.domainDomainRange, this.domainXMinField, this.domainXMaxField, this.domainYMinField, this.domainYMaxField);
        this.rangeGrapher.registerObjects(this.domainDomainRange, this.rangeXMinField, this.rangeXMaxField, this.rangeYMinField, this.rangeYMaxField);
        this.domainGrapher.setNumTraces(2 * this.currentN + 1);
        this.rangeGrapher.setNumTraces(2 * this.currentN + 1);
        this.domainGrapher.plotData(this.domainOrderTraces, this.domainAllData);
        this.rangeGrapher.plotData(this.rangeAllData);
        this.domainGrapher.setSketchTrace(this.sketchData);
        this.rangeGrapher.setSketchTrace(this.sketchData);
        this.rangeCursorLocateLabel.setVisible(false);
        this.domainCursorLocateLabel.setVisible(false);
        this.zoomErrorMessageLabel.setVisible(false);
    }

    private void createVertexData() {
        for (int i = 0; i <= this.currentN - 1; ++i) {
            this.thetaEven = (double)(2 * i) * Math.PI / (double)this.currentN;
            this.thetaOdd = ((double)(2 * i) + 1.0) * Math.PI / (double)this.currentN;
            this.vertexDataX[2 * i][0] = this.currentR * Math.cos(this.thetaEven);
            this.vertexDataY[2 * i][0] = this.currentR * Math.sin(this.thetaEven);
            this.vertexDataX[2 * i + 1][0] = this.radiusMax * Math.cos(this.thetaOdd);
            this.vertexDataY[2 * i + 1][0] = this.radiusMax * Math.sin(this.thetaOdd);
        }
    }

    private void createArcData() {
        this.thetaEven = Math.PI * 2 * this.currentP / (double)this.currentN;
        this.thetaOdd = Math.PI * 2 * (1.0 - this.currentP) / (double)this.currentN;
        this.deltaThetaEven = this.thetaEven / (double)(this.numArcDataPoints - 1);
        this.deltaThetaOdd = this.thetaOdd / (double)(this.numArcDataPoints - 1);
        for (int i = 0; i <= this.currentN - 1; ++i) {
            this.startThetaEven = ((double)(2 * i) - 1.0) / 2.0 * this.thetaEven + (double)i * this.thetaOdd;
            this.startThetaOdd = ((double)(2 * i) + 1.0) / 2.0 * this.thetaEven + (double)i * this.thetaOdd;
            this.arcEnds[2 * i][0] = this.startThetaEven;
            this.arcEnds[2 * i][1] = this.startThetaEven + (double)(this.numArcDataPoints - 1) * this.deltaThetaEven;
            this.arcEnds[2 * i + 1][0] = this.startThetaOdd;
            this.arcEnds[2 * i + 1][1] = this.startThetaOdd + (double)(this.numArcDataPoints - 1) * this.deltaThetaOdd;
            for (int j = 0; j <= this.numArcDataPoints - 1; ++j) {
                this.arcDataX[2 * i][j] = this.radiusMax * Math.cos(this.startThetaEven + (double)j * this.deltaThetaEven);
                this.arcDataY[2 * i][j] = this.radiusMax * Math.sin(this.startThetaEven + (double)j * this.deltaThetaEven);
                this.arcDataX[2 * i + 1][j] = this.radiusMax * Math.cos(this.startThetaOdd + (double)j * this.deltaThetaOdd);
                this.arcDataY[2 * i + 1][j] = this.radiusMax * Math.sin(this.startThetaOdd + (double)j * this.deltaThetaOdd);
            }
        }
    }

    private void computeRoots() {
        double r = 0.0;
        double theta = 0.0;
        double twoPiOverN = Math.PI * 2 / (double)this.currentN;
        this.constantC.setRe((Math.sin((double)(this.currentN - 1) * (1.0 - this.currentP) * Math.PI / (double)this.currentN) - this.currentR * Math.sin((double)(this.currentN - 1) * this.currentP * Math.PI / (double)this.currentN)) / (Math.sin((1.0 - this.currentP) * Math.PI / (double)this.currentN) + this.currentR * Math.sin(this.currentP * Math.PI / (double)this.currentN)));
        this.constantC.setIm(0.0);
        theta = this.constantC.arg() / (double)this.currentN;
        r = Math.pow(this.constantC.abs(), 1.0 / (double)this.currentN);
        for (int i = 0; i <= this.currentN - 1; ++i) {
            this.rootsDataX[i] = r * Math.cos(theta + (double)i * twoPiOverN);
            this.rootsDataY[i] = r * Math.sin(theta + (double)i * twoPiOverN);
        }
        this.rootsDataX[this.currentN] = 0.0;
        this.rootsDataY[this.currentN] = 0.0;
    }

    private void grapherMouseClicked(MouseEvent evt) {
        this.zoomPanel.zoomByClicking(evt);
        this.currentGrapher.plotData();
    }

    private void exportSettingsItemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.pngMenuItem) {
            this.imageType = "png";
        } else if (evt.getSource() == this.gifMenuItem) {
            this.imageType = "gif";
        } else if (evt.getSource() == this.jpgMenuItem) {
            this.imageType = "jpg";
        }
    }

    private void exportActionEvent(ActionEvent evt) {
        JPanel component = null;
        if (evt.getSource() == this.exportDomainGraph) {
            component = this.domainGrapher;
        } else if (evt.getSource() == this.exportRangeGraph) {
            component = this.rangeGrapher;
        } else if (evt.getSource() == this.exportApplet) {
            component = this.starToolPanel;
        }
        int result = this.fileChooser.showSaveDialog(this);
        if (result != 1 && result == 0) {
            int response;
            File fFile = new File(this.fileChooser.getSelectedFile().getPath() + "." + this.imageType);
            if (!fFile.exists() || (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                // empty if block
            }
            StarTool.exportToFile(this.fileChooser.getSelectedFile().getPath(), component, this.imageType);
        }
    }

    private static void exportToFile(String fileName, JComponent component, String ext) {
        File file = new File(fileName + "." + ext);
        BufferedImage bi = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        component.print(g2);
        try {
            ImageIO.write((RenderedImage)bi, ext, file);
        }
        catch (IOException e) {
            System.out.println("Write error for " + file.getPath() + ": " + e.getMessage());
        }
    }
}

