/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.plotstuff2d;

import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.plotstuff2d.PlotStuff;
import java.awt.Color;

public class RectGrid
extends PlotStuff {
    private double deltaVert = 0.0;
    private double deltaHoriz = 0.0;
    private boolean needToCreateHorizData = true;
    private boolean needToCreateVertData = true;
    private double xVal = 0.0;
    private double yVal = 0.0;
    private double[][] vertHatchesDataX = null;
    private double[][] vertHatchesDataY = null;
    private double[][] horizHatchesDataX = null;
    private double[][] horizHatchesDataY = null;
    private double[] leftSideDataX = null;
    private double[] leftSideDataY = null;
    private double[] rightSideDataX = null;
    private double[] rightSideDataY = null;
    private double[] topSideDataX = null;
    private double[] topSideDataY = null;
    private double[] bottomSideDataX = null;
    private double[] bottomSideDataY = null;
    private MachineEpsilon myEpsilon = null;
    private double epsilon = 0.0;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private int numVertPoints = 2;
    private int numHorizPoints = 2;
    private PlotStuff[] vertHatches;
    private PlotStuff[] horizHatches;
    private PlotStuff topSide;
    private PlotStuff bottomSide;
    private PlotStuff leftSide;
    private PlotStuff rightSide;
    private int numVertHatches = 3;
    private int numHorizHatches = 3;
    private double width = 6.0;
    private double height = 6.0;
    private Color vertColor = new Color(0, 102, 0);
    private Color horizColor = Color.RED;

    public RectGrid() {
        this.myEpsilon = new MachineEpsilon();
        RectGrid rectGrid = this;
        this.epsilon = rectGrid.myEpsilon.getEpsilon();
        this.plotSize = 1;
        this.plotStyle = 11;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public int getNumVertPoints() {
        return this.numVertPoints;
    }

    public void setNumVertPoints(int numVertPoints) {
        this.numVertPoints = numVertPoints;
        this.needToCreateVertData = true;
    }

    public int getNumHorizPoints() {
        return this.numHorizPoints;
    }

    public void setNumHorizPoints(int numHorizPoints) {
        this.numHorizPoints = numHorizPoints;
        this.needToCreateHorizData = true;
    }

    public void createData() {
        int j;
        int i;
        double xVal = 0.0;
        double xVal2 = 0.0;
        double yVal = 0.0;
        double yVal2 = 0.0;
        if (this.needToCreateHorizData) {
            this.topSide = new PlotStuff();
            this.topSideDataX = new double[this.numHorizPoints];
            this.topSideDataY = new double[this.numHorizPoints];
            this.topSide.setDataX(this.topSideDataX);
            this.topSide.setDataY(this.topSideDataY);
            this.topSide.setPlotColor(this.plotColor);
            this.bottomSide = new PlotStuff();
            this.bottomSideDataX = new double[this.numHorizPoints];
            this.bottomSideDataY = new double[this.numHorizPoints];
            this.bottomSide.setDataX(this.bottomSideDataX);
            this.bottomSide.setDataY(this.bottomSideDataY);
            this.bottomSide.setPlotColor(this.plotColor);
            this.horizHatchesDataX = new double[this.numHorizHatches][this.numHorizPoints];
            this.horizHatchesDataY = new double[this.numHorizHatches][this.numHorizPoints];
            this.horizHatches = new PlotStuff[this.numHorizHatches];
            for (i = 0; i <= this.numHorizHatches - 1; ++i) {
                this.horizHatches[i] = new PlotStuff();
                this.horizHatches[i].setDataX(this.horizHatchesDataX[i]);
                this.horizHatches[i].setDataY(this.horizHatchesDataY[i]);
                this.horizHatches[i].setPlotColor(this.plotColor);
                this.horizHatches[i].setPlotStyle(this.plotStyle);
            }
            this.needToCreateHorizData = false;
        }
        if (this.needToCreateVertData) {
            this.leftSide = new PlotStuff();
            this.leftSideDataX = new double[this.numVertPoints];
            this.leftSideDataY = new double[this.numVertPoints];
            this.leftSide.setDataX(this.leftSideDataX);
            this.leftSide.setDataY(this.leftSideDataY);
            this.leftSide.setPlotColor(this.plotColor);
            this.rightSide = new PlotStuff();
            this.rightSideDataX = new double[this.numVertPoints];
            this.rightSideDataY = new double[this.numVertPoints];
            this.rightSide.setDataX(this.rightSideDataX);
            this.rightSide.setDataY(this.rightSideDataY);
            this.rightSide.setPlotColor(this.plotColor);
            this.vertHatchesDataX = new double[this.numVertHatches][this.numVertPoints];
            this.vertHatchesDataY = new double[this.numVertHatches][this.numVertPoints];
            this.vertHatches = new PlotStuff[this.numVertHatches];
            for (i = 0; i <= this.numVertHatches - 1; ++i) {
                this.vertHatches[i] = new PlotStuff();
                this.vertHatches[i].setDataX(this.vertHatchesDataX[i]);
                this.vertHatches[i].setDataY(this.vertHatchesDataY[i]);
                this.vertHatches[i].setPlotColor(this.plotColor);
                this.vertHatches[i].setPlotStyle(this.plotStyle);
            }
            this.needToCreateVertData = false;
        }
        this.deltaVert = this.height / (double)(this.numHorizHatches + 1);
        this.deltaHoriz = this.width / (double)(this.numHorizPoints - 1);
        for (i = 0; i <= this.numHorizHatches - 1; ++i) {
            yVal = this.centerY - this.height / 2.0 + (double)(i + 1) * this.deltaVert;
            this.horizHatchesDataX[i][0] = xVal = this.centerX - this.width / 2.0;
            this.horizHatchesDataY[i][0] = yVal;
            this.horizHatchesDataX[i][this.numHorizPoints - 1] = xVal = this.centerX + this.width / 2.0;
            this.horizHatchesDataY[i][this.numHorizPoints - 1] = yVal;
            for (j = 1; j <= this.numHorizPoints - 2; ++j) {
                this.horizHatchesDataX[i][j] = xVal = this.centerX - this.width / 2.0 + (double)(j + 1) * this.deltaHoriz;
                this.horizHatchesDataY[i][j] = yVal;
            }
        }
        this.deltaHoriz = this.width / (double)(this.numVertHatches + 1);
        this.deltaVert = this.height / (double)(this.numVertPoints - 1);
        for (i = 0; i <= this.numVertHatches - 1; ++i) {
            xVal = this.centerX - this.width / 2.0 + (double)(i + 1) * this.deltaHoriz;
            yVal = this.centerY - this.height / 2.0;
            this.vertHatchesDataX[i][0] = xVal;
            this.vertHatchesDataY[i][0] = yVal;
            yVal = this.centerY + this.height / 2.0;
            this.vertHatchesDataX[i][this.numVertPoints - 1] = xVal;
            this.vertHatchesDataY[i][this.numVertPoints - 1] = yVal;
            for (j = 1; j <= this.numVertPoints - 2; ++j) {
                yVal = this.centerY - this.height / 2.0 + (double)(j + 1) * this.deltaVert;
                this.vertHatchesDataX[i][j] = xVal;
                this.vertHatchesDataY[i][j] = yVal;
            }
        }
        yVal = this.centerY - this.height / 2.0;
        yVal2 = this.centerY + this.height / 2.0;
        this.deltaHoriz = this.width / (double)(this.numHorizPoints - 1);
        this.bottomSideDataX[0] = xVal = this.centerX - this.width / 2.0;
        this.bottomSideDataY[0] = yVal;
        this.topSideDataX[0] = xVal;
        this.topSideDataY[0] = yVal2;
        this.bottomSideDataX[this.numHorizPoints - 1] = xVal = this.centerX + this.width / 2.0;
        this.bottomSideDataY[this.numHorizPoints - 1] = yVal;
        this.topSideDataX[this.numHorizPoints - 1] = xVal;
        this.topSideDataY[this.numHorizPoints - 1] = yVal2;
        for (i = 1; i <= this.numHorizPoints - 2; ++i) {
            this.bottomSideDataX[i] = xVal = this.centerX - this.width / 2.0 + (double)i * this.deltaHoriz;
            this.bottomSideDataY[i] = yVal;
            this.topSideDataX[i] = xVal;
            this.topSideDataY[i] = yVal2;
        }
        xVal = this.centerX - this.width / 2.0;
        xVal2 = this.centerX + this.width / 2.0;
        this.deltaVert = this.height / (double)(this.numVertPoints - 1);
        yVal = this.centerY - this.height / 2.0;
        this.leftSideDataX[0] = xVal;
        this.leftSideDataY[0] = yVal;
        this.rightSideDataX[0] = xVal2;
        this.rightSideDataY[0] = yVal;
        yVal = this.centerY + this.height / 2.0;
        this.leftSideDataX[this.numVertPoints - 1] = xVal;
        this.leftSideDataY[this.numVertPoints - 1] = yVal;
        this.rightSideDataX[this.numVertPoints - 1] = xVal2;
        this.rightSideDataY[this.numVertPoints - 1] = yVal;
        for (i = 1; i <= this.numVertPoints - 2; ++i) {
            yVal = this.centerY - this.height / 2.0 + (double)i * this.deltaVert;
            this.leftSideDataX[i] = xVal;
            this.leftSideDataY[i] = yVal;
            this.rightSideDataX[i] = xVal2;
            this.rightSideDataY[i] = yVal;
        }
    }

    public PlotStuff getVertHatches(int index) {
        return this.vertHatches[index];
    }

    public PlotStuff[] getVertHatches() {
        return this.vertHatches;
    }

    public void setVertHatches(int index, PlotStuff vertHatches) {
        this.vertHatches[index] = vertHatches;
    }

    public void setVertHatches(PlotStuff[] vertHatches) {
        this.vertHatches = vertHatches;
    }

    public PlotStuff getHorizHatches(int index) {
        return this.horizHatches[index];
    }

    public PlotStuff[] getHorizHatches() {
        return this.horizHatches;
    }

    public void setHorizHatches(int index, PlotStuff horizHatches) {
        this.horizHatches[index] = horizHatches;
    }

    public void setHorizHatches(PlotStuff[] horizHatches) {
        this.horizHatches = horizHatches;
    }

    public PlotStuff getTopSide() {
        return this.topSide;
    }

    public void setTopSide(PlotStuff topSide) {
        this.topSide = topSide;
    }

    public PlotStuff getBottomSide() {
        return this.bottomSide;
    }

    public void setBottomSide(PlotStuff bottomSide) {
        this.bottomSide = bottomSide;
    }

    public PlotStuff getLeftSide() {
        return this.leftSide;
    }

    public void setLeftSide(PlotStuff leftSide) {
        this.leftSide = leftSide;
    }

    public PlotStuff getRightSide() {
        return this.rightSide;
    }

    public void setRightSide(PlotStuff rightSide) {
        this.rightSide = rightSide;
    }

    public int getNumVertHatches() {
        return this.numVertHatches;
    }

    public void setNumVertHatches(int numVertHatches) {
        this.numVertHatches = numVertHatches;
        this.needToCreateVertData = true;
    }

    public int getNumHorizHatches() {
        return this.numHorizHatches;
    }

    public void setNumHorizHatches(int numHorizHatches) {
        this.numHorizHatches = numHorizHatches;
        this.needToCreateHorizData = true;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Color getVertColor() {
        return this.vertColor;
    }

    public void setVertColor(Color vertColor) {
        this.vertColor = vertColor;
    }

    public Color getHorizColor() {
        return this.horizColor;
    }

    public void setHorizColor(Color horizColor) {
        this.horizColor = horizColor;
    }
}

