/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.plotstuff2d;

import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.plotstuff2d.PlotStuff;
import java.awt.Color;

public class PolarGrid
extends PlotStuff {
    private boolean needCircleBoundaries = false;
    private double theta = 0.0;
    private double deltaTheta = 0.0;
    private double deltaRadius = 0.0;
    private double deltaThetaRay = 0.0;
    private double deltaRadiusTheta = 0.0;
    private boolean needToCreateRayData = true;
    private boolean needToCreateCircleData = true;
    private double radius = 0.0;
    private double[][] raysDataX = null;
    private double[][] raysDataY = null;
    private double[][] circlesDataX = null;
    private double[][] circlesDataY = null;
    private MachineEpsilon myEpsilon = null;
    private double epsilon = 0.0;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double thetaMin;
    private double thetaMax = Math.PI * 2;
    private int numRays = 6;
    private int numCircles = 3;
    private int numCirclePoints = 100;
    private int numRayPoints = 2;
    private double radiusMax = 3.0;
    private int numTotalRays = 3;
    private PlotStuff[] rays;
    private PlotStuff[] circles;
    private Color rayColor = new Color(0, 102, 0);
    private Color circleColor = Color.RED;

    public PolarGrid() {
        this.myEpsilon = new MachineEpsilon();
        PolarGrid polarGrid = this;
        this.epsilon = polarGrid.myEpsilon.getEpsilon();
        this.plotSize = 1;
        this.plotStyle = 10;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public double getThetaMin() {
        this.thetaMin = 0.0;
        return 0.0;
    }

    public void setThetaMin(double thetaMin) {
        this.thetaMin = thetaMin;
        this.needToCreateCircleData = true;
        this.needToCreateRayData = true;
    }

    public double getThetaMax() {
        return this.thetaMax;
    }

    public void setThetaMax(double thetaMax) {
        this.thetaMax = thetaMax;
        this.needToCreateCircleData = true;
        this.needToCreateRayData = true;
    }

    public int getNumRays() {
        return this.numRays;
    }

    public void setNumRays(int numRays) {
        this.numRays = numRays;
        this.needToCreateRayData = true;
    }

    public int getNumCircles() {
        return this.numCircles;
    }

    public void setNumCircles(int numCircles) {
        this.numCircles = numCircles;
        this.needToCreateCircleData = true;
    }

    public int getNumCirclePoints() {
        return this.numCirclePoints;
    }

    public void setNumCirclePoints(int numCirclePoints) {
        this.numCirclePoints = numCirclePoints;
        this.needToCreateCircleData = true;
    }

    public int getNumRayPoints() {
        return this.numRayPoints;
    }

    public void setNumRayPoints(int numRayPoints) {
        this.numRayPoints = numRayPoints;
        this.needToCreateRayData = true;
    }

    public double getRadiusMax() {
        return this.radiusMax;
    }

    public void setRadiusMax(double radiusMax) {
        this.radiusMax = radiusMax;
        this.needToCreateCircleData = true;
        this.needToCreateRayData = true;
    }

    public void createData() {
        int j;
        int i;
        this.numTotalRays = Math.abs(this.thetaMax - this.thetaMin - Math.PI * 2) <= 2.0 * this.epsilon ? this.numRays : this.numRays + 2;
        if (this.needToCreateRayData) {
            this.raysDataX = new double[this.numTotalRays][this.numRayPoints];
            this.raysDataY = new double[this.numTotalRays][this.numRayPoints];
            this.rays = new PlotStuff[this.numTotalRays];
            for (i = 0; i <= this.numTotalRays - 1; ++i) {
                this.rays[i] = new PlotStuff();
                this.rays[i].setDataX(this.raysDataX[i]);
                this.rays[i].setDataY(this.raysDataY[i]);
                this.rays[i].setPlotColor(this.rayColor);
                this.rays[i].setPlotStyle(this.plotStyle);
            }
            this.needToCreateRayData = false;
            this.deltaRadius = this.radiusMax / (double)(this.numRayPoints - 1);
        }
        if (this.needToCreateCircleData) {
            this.circles = new PlotStuff[this.numCircles];
            this.circlesDataX = new double[this.numCircles][this.numCirclePoints];
            this.circlesDataY = new double[this.numCircles][this.numCirclePoints];
            for (i = 0; i <= this.numCircles - 1; ++i) {
                this.circles[i] = new PlotStuff();
                this.circles[i].setDataX(this.circlesDataX[i]);
                this.circles[i].setDataY(this.circlesDataY[i]);
                this.circles[i].setPlotColor(this.circleColor);
                this.circles[i].setPlotStyle(this.plotStyle);
            }
            this.needToCreateCircleData = false;
            this.deltaTheta = (this.thetaMax - this.thetaMin) / (double)this.numCirclePoints;
        }
        this.deltaThetaRay = this.numTotalRays == this.numRays ? (this.thetaMax - this.thetaMin) / (double)this.numTotalRays : (this.thetaMax - this.thetaMin) / (double)(this.numTotalRays - 1);
        this.deltaRadiusTheta = this.radiusMax / (double)this.numCircles;
        for (i = 0; i <= this.numTotalRays - 1; ++i) {
            this.theta = this.thetaMin + (double)i * this.deltaThetaRay;
            this.raysDataX[i][0] = this.centerX;
            this.raysDataY[i][0] = this.centerY;
            for (j = 1; j <= this.numRayPoints - 2; ++j) {
                this.radius = (double)j * this.deltaRadius;
                this.raysDataX[i][j] = this.centerX + this.radius * Math.cos(this.theta);
                this.raysDataY[i][j] = this.centerY + this.radius * Math.sin(this.theta);
            }
            this.raysDataX[i][this.numRayPoints - 1] = this.centerX + this.radiusMax * Math.cos(this.theta);
            this.raysDataY[i][this.numRayPoints - 1] = this.centerY + this.radiusMax * Math.sin(this.theta);
        }
        for (i = 0; i <= this.numCircles - 1; ++i) {
            this.radius = (double)(i + 1) * this.deltaRadiusTheta;
            this.circlesDataX[i][0] = this.centerX + this.radius * Math.cos(this.thetaMin);
            this.circlesDataY[i][0] = this.centerY + this.radius * Math.sin(this.thetaMin);
            for (j = 1; j <= this.numCirclePoints - 2; ++j) {
                this.theta = this.thetaMin + (double)j * this.deltaTheta;
                this.circlesDataX[i][j] = this.centerX + this.radius * Math.cos(this.theta);
                this.circlesDataY[i][j] = this.centerY + this.radius * Math.sin(this.theta);
            }
            this.circlesDataX[i][this.numCirclePoints - 1] = this.centerX + this.radius * Math.cos(this.thetaMax);
            this.circlesDataY[i][this.numCirclePoints - 1] = this.centerY + this.radius * Math.sin(this.thetaMax);
        }
    }

    public int getNumTotalRays() {
        return this.numTotalRays;
    }

    public PlotStuff getRays(int index) {
        return this.rays[index];
    }

    public PlotStuff[] getRays() {
        return this.rays;
    }

    public void setRays(int index, PlotStuff rays) {
        this.rays[index] = rays;
    }

    public void setRays(PlotStuff[] rays) {
        this.rays = rays;
    }

    public PlotStuff getCircles(int index) {
        return this.circles[index];
    }

    public PlotStuff[] getCircles() {
        return this.circles;
    }

    public void setCircles(int index, PlotStuff circles) {
        this.circles[index] = circles;
    }

    public void setCircles(PlotStuff[] circles) {
        this.circles = circles;
    }

    public void setCirclesDataX(int numCircle, int numPoint, double dataVal) {
        this.circles[numCircle].setDataX(numPoint, dataVal);
    }

    public void setCirclesDataY(int numCircle, int numPoint, double dataVal) {
        this.circles[numCircle].setDataY(numPoint, dataVal);
    }

    public void setRaysDataX(int numRay, int numPoint, double dataVal) {
        this.circles[numRay].setDataX(numPoint, dataVal);
    }

    public void setRaysDataY(int numRay, int numPoint, double dataVal) {
        this.circles[numRay].setDataY(numPoint, dataVal);
    }

    public Color getRayColor() {
        return this.rayColor;
    }

    public void setRayColor(Color rayColor) {
        this.rayColor = rayColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }
}

