/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.numberlabel;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JLabel;

public class NumberLabel
extends JLabel {
    protected DecimalFormat outNumber = null;
    protected int minimumIntegerDigits = 1;
    protected int maximumFractionDigits = 8;
    protected int minimumFractionDigits = 1;
    protected String preText = "";
    protected String postText = "";
    private StringBuffer stringBuffer = new StringBuffer();
    private int dimension = 2;

    public NumberLabel() {
        this.outNumber = new DecimalFormat();
        this.setBackground(new Color(235, 235, 235));
        this.setFont(new Font("Lucida Sans", 0, 11));
        super.setText("0.0");
        this.outNumber.setMinimumIntegerDigits(this.minimumIntegerDigits);
        this.outNumber.setMinimumFractionDigits(this.minimumFractionDigits);
        this.outNumber.setMaximumFractionDigits(this.maximumFractionDigits);
    }

    public void setMinimumIntegerDigits(int minimumIntegerDigits) {
        this.minimumIntegerDigits = minimumIntegerDigits;
        this.outNumber.setMinimumIntegerDigits(minimumIntegerDigits);
    }

    public void setMinimumFractionDigits(int minimumFractionDigits) {
        this.minimumFractionDigits = minimumFractionDigits;
        this.outNumber.setMinimumFractionDigits(minimumFractionDigits);
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
        this.outNumber.setMaximumFractionDigits(maximumFractionDigits);
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setDoubleText(double x) {
        super.setText(this.preText + this.outNumber.format(x) + this.postText);
    }

    public void setIntText(int intVal) {
        super.setText(this.preText + intVal + this.postText);
    }

    public void setCursorLocation(double x, double y) {
        this.setText(this.preText + "(" + this.outNumber.format(x) + "," + this.outNumber.format(y) + ")" + this.postText);
    }

    public void setCursorLocation(String x, String y) {
        this.setText(this.preText + "(" + x + "," + y + ")" + this.postText);
    }

    public void setCursorLocation(double[] coordinates) {
        this.stringBuffer.setLength(0);
        this.stringBuffer.append(this.preText + "(");
        for (int i = 0; i <= this.dimension - 2; ++i) {
            this.stringBuffer.append(this.outNumber.format(coordinates[i]) + ",");
        }
        this.stringBuffer.append(this.outNumber.format(coordinates[this.dimension - 1]) + ")" + this.postText);
        this.setText(this.stringBuffer.toString());
    }

    public void setClosedInterval(double x, double y) {
        this.setText(this.preText + "[" + this.outNumber.format(x) + "," + this.outNumber.format(y) + "]" + this.postText);
    }

    public void setClosedInterval(String x, String y) {
        this.setText(this.preText + "[" + x + "," + y + "]" + this.postText);
    }

    public void setPreText(String preText) {
        this.preText = preText;
    }

    public void setPostText(String postText) {
        this.postText = postText;
    }

    public String getPreText() {
        return this.preText;
    }

    public String getPostText() {
        return this.postText;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }
}

