/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.grapher2d;

import com.jimrolf.convert.Convert;
import com.jimrolf.functionfield.DoubleField;
import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.numberlabel.NumberLabel;
import com.jimrolf.plotstuff2d.PlotStuff;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class Grapher2D
extends JPanel {
    protected int xx1;
    protected int xy1;
    protected int xx2;
    protected int xy2;
    protected int vx1;
    protected int vx2;
    protected int vy1;
    protected int vy2;
    protected int hx1;
    protected int hx2;
    protected int hy1;
    protected int hy2;
    protected int ticLength = 2;
    protected int originX = 0;
    protected int originY = 0;
    protected int oldOriginX = 0;
    protected int oldOriginY = 0;
    private double currentX = 0.0;
    private double currentY = 0.0;
    protected int mousePressedXPixel = 0;
    protected int mousePressedYPixel = 0;
    protected int axesIntersectXPix = 0;
    protected int axesIntersectYPix;
    protected int xAxisLength = 0;
    protected int yAxisLength = 0;
    protected double xAxisLengthDouble = 0.0;
    protected double yAxisLengthDouble = 0.0;
    protected double xTicGap = 0.0;
    protected double yTicGap = 0.0;
    private JLabel xAxisTitleLabel = new JLabel();
    private JLabel yAxisTitleLabel = new JLabel();
    protected boolean draggingToZoom = false;
    private double slope = 0.0;
    protected BufferedImage bufferedImage = null;
    protected WritableRaster raster = null;
    protected Graphics2D gBI = null;
    protected boolean needToRedrawAxes = false;
    protected boolean grapherHasBeenResized = false;
    protected Raster axesRaster = null;
    protected int alpha = 255;
    protected int red = 0;
    protected int blue = 0;
    public static final int X_DIRECTION = 0;
    public static final int Y_DIRECTION = 1;
    public static final int BOTH_DIRECTIONS = 2;
    protected double eps = MachineEpsilon.getEpsilon();
    protected Component zoomPanel = null;
    public static final int NONE = 0;
    public static final int CROSSED_AXES = 1;
    public static final int BOXED_AXES = 2;
    public static final int GRID = 3;
    public static final int GRID_AND_CROSSED_AXES = 4;
    public static final int GRID_AND_BOXED_AXES = 5;
    public static final int GRID_AND_CROSSED_AND_BOXED_AXES = 6;
    public static final int RIGHT = 10;
    public static final int RIGHT_ABOVE = 11;
    public static final int RIGHT_BELOW = 12;
    public static final int LEFT = 13;
    public static final int LEFT_ABOVE = 14;
    public static final int LEFT_BELOW = 15;
    public static final int TOP = 20;
    public static final int TOP_RIGHT = 21;
    public static final int TOP_LEFT = 22;
    public static final int BOTTOM = 23;
    public static final int BOTTOM_RIGHT = 24;
    public static final int BOTTOM_LEFT = 25;
    public static final int ABOVE = 30;
    public static final int BELOW = 31;
    public static final int INSIDE = 32;
    public static final int OUTSIDE = 33;
    protected int green = 0;
    protected int lineWidth = 0;
    protected double xMin = -3.0;
    protected double xMax = 3.0;
    protected double yMin = -3.0;
    protected double yMax = 3.0;
    protected int numTraces = 0;
    protected String graphTitle;
    protected String xAxisTitle = "x";
    protected String yAxisTitle = "y";
    protected int graphTitleLocation;
    protected int xAxisTitleLocation = 12;
    protected int yAxisTitleLocation = 21;
    protected boolean usingHalfIntegerTics = false;
    protected boolean usingIntegerTics = true;
    protected int numXTics;
    protected int numYTics;
    protected int axesStyle = 1;
    protected Color xAxisTitleColor = new Color(204, 204, 204);
    protected Color yAxisTitleColor = new Color(204, 204, 204);
    protected Font xAxisTitleFont = new Font("Lucida Sans", 0, 10);
    protected Font yAxisTitleFont = new Font("Lucida Sans", 0, 10);
    protected Font xTicLabelsFont = new Font("Lucida Sans", 0, 8);
    protected Font yTicLabelsFont = new Font("Lucida Sans", 0, 8);
    protected Color xTicLabelsColor = Color.BLACK;
    protected Color yTicLabelsColor = Color.BLACK;
    protected int xTicLabelsLocation = 0;
    protected int yTicLabelsLocation = 0;
    protected int topPad = 12;
    protected int bottomPad = 12;
    protected int leftPad = 12;
    protected int rightPad = 12;
    protected PlotStuff trace;
    protected PlotStuff[] traces;
    protected PlotStuff sketchTrace;
    private double lastX;
    private double lastY;
    protected int[] orderTraces;
    protected boolean usingOrderTraces = false;
    protected Color axesColor = new Color(204, 204, 204);
    protected boolean antiAliasing = false;
    protected boolean usingDragZoom = false;
    protected Color zoomRectangleColor = Color.BLACK;
    protected boolean usingBackgroundImage = false;
    protected int[] pixelColors = null;
    private int zoomRectX;
    private int zoomRectY;
    private int zoomRectHeight;
    private int zoomRectWidth;
    private int minZoomPixels = 2;
    protected NumberLabel numberLabel = null;
    protected double[] domainRange = null;
    protected NumberLabel yMaxLabel = null;
    protected NumberLabel yMinLabel = null;
    protected NumberLabel xMaxLabel = null;
    protected NumberLabel xMinLabel = null;
    protected DoubleField xMinField = null;
    protected DoubleField xMaxField = null;
    protected DoubleField yMinField = null;
    protected DoubleField yMaxField = null;
    private double zoomMagnitude = 1.0;
    private double zoomCenterX = 0.0;
    private double zoomCenterY = 0.0;
    protected Color gridColor = new Color(204, 204, 204);

    public Component getZoomPanel() {
        return this.zoomPanel;
    }

    public void setZoomPanel(Component zoomPanel) {
        this.zoomPanel = zoomPanel;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Grapher2D() {
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(100, 100));
        this.setSize(100, 100);
        this.setLayout(null);
        this.xAxisTitleLabel.setText(this.xAxisTitle);
        this.xAxisTitleLabel.setFont(this.xAxisTitleFont);
        this.yAxisTitleLabel.setText(this.yAxisTitle);
        this.yAxisTitleLabel.setFont(this.yAxisTitleFont);
        this.getNewBufferedImage();
        this.locateAxes();
        this.drawAxesAndLabels();
        this.needToRedrawAxes = false;
        this.grapherHasBeenResized = false;
    }

    public void init() {
        if (this.grapherHasBeenResized) {
            this.getNewBufferedImage();
            this.locateAxes();
            this.drawAxesAndLabels();
            this.grapherHasBeenResized = false;
        }
        if (this.needToRedrawAxes) {
            this.raster.setDataElements(0, 0, this.getSize().width, this.getSize().height, this.pixelColors);
            this.locateAxes();
            this.drawAxesAndLabels();
            this.needToRedrawAxes = false;
        }
    }

    protected void drawBoxedAxes() {
        block26: {
            int i;
            block25: {
                int i2;
                int temp = 0;
                if (this.lineWidth >= 1) {
                    this.gBI.fillRect(this.hx1 - this.lineWidth, this.vy1 - this.lineWidth, 2 * this.lineWidth, this.yAxisLength + 2 * this.lineWidth);
                    this.gBI.fillRect(this.hx2 - this.lineWidth, this.vy1 - this.lineWidth, 2 * this.lineWidth, this.yAxisLength + 2 * this.lineWidth);
                    this.gBI.fillRect(this.hx1, this.vy2 - this.lineWidth, this.xAxisLength, 2 * this.lineWidth);
                    this.gBI.fillRect(this.hx1, this.vy1 - this.lineWidth, this.xAxisLength, 2 * this.lineWidth);
                } else {
                    this.gBI.drawLine(this.hx1, this.vy1, this.hx1, this.vy2);
                    this.gBI.drawLine(this.hx2, this.vy1, this.hx2, this.vy2);
                    this.gBI.drawLine(this.hx1, this.vy2, this.hx2, this.vy2);
                    this.gBI.drawLine(this.hx1, this.vy1, this.hx2, this.vy1);
                }
                if (!this.usingIntegerTics) break block25;
                if (this.lineWidth >= 1) {
                    for (i2 = Convert.toRoundedInt(this.yMin); i2 <= Convert.toRoundedInt(this.yMax); ++i2) {
                        this.gBI.fillRect(this.hx1 - this.lineWidth, this.getYPixel(Convert.toDouble(i2)) - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                        this.gBI.fillRect(this.hx2 - this.lineWidth - 2 * this.ticLength, this.getYPixel(Convert.toDouble(i2)) - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                    }
                } else {
                    for (i2 = Convert.toRoundedInt(this.yMin); i2 <= Convert.toRoundedInt(this.yMax); ++i2) {
                        temp = this.getYPixel(Convert.toDouble(i2));
                        this.gBI.drawLine(this.hx1, temp, this.hx1 + 2 * this.ticLength, temp);
                        this.gBI.drawLine(this.hx2, temp, this.hx2 - 2 * this.ticLength, temp);
                    }
                }
                if (this.lineWidth >= 1) {
                    for (i2 = Convert.toRoundedInt(this.xMin); i2 <= Convert.toRoundedInt(this.xMax); ++i2) {
                        this.gBI.fillRect(this.getXPixel(i2) - this.lineWidth, this.vy1 - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                        this.gBI.fillRect(this.getXPixel(i2) - this.lineWidth, this.vy2 - 2 * this.ticLength - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                    }
                } else {
                    for (i2 = Convert.toRoundedInt(this.xMin); i2 <= Convert.toRoundedInt(this.xMax); ++i2) {
                        temp = this.getXPixel(i2);
                        this.gBI.drawLine(temp, this.vy1, temp, this.vy1 + 2 * this.ticLength);
                        this.gBI.drawLine(temp, this.vy2, temp, this.vy2 - 2 * this.ticLength);
                    }
                }
                break block26;
            }
            if (this.numYTics == 1) {
                if (this.lineWidth >= 1) {
                    this.gBI.fillRect(this.hx1 - this.lineWidth, this.axesIntersectYPix - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                    this.gBI.fillRect(this.hx2 - this.lineWidth - 2 * this.ticLength, this.axesIntersectYPix - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                } else {
                    this.gBI.drawLine(this.hx1, this.axesIntersectYPix, this.hx1 + 2 * this.ticLength, this.axesIntersectYPix);
                    this.gBI.drawLine(this.hx2 - 2 * this.ticLength, this.axesIntersectYPix, this.hx2, this.axesIntersectYPix);
                }
            }
            if (this.numYTics > 1) {
                if (this.lineWidth >= 1) {
                    for (i = 0; i <= this.numYTics - 1; ++i) {
                        this.gBI.fillRect(this.hx1 - this.lineWidth, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap) - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                        this.gBI.fillRect(this.hx2 - this.lineWidth - 2 * this.ticLength, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap) - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                    }
                } else {
                    for (i = 0; i <= this.numYTics - 1; ++i) {
                        this.gBI.drawLine(this.hx1, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap), this.hx1 + 2 * this.ticLength, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap));
                        this.gBI.drawLine(this.hx2 - 2 * this.ticLength, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap), this.hx2, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap));
                    }
                }
            }
            if (this.numXTics == 1) {
                if (this.lineWidth >= 1) {
                    this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth, this.vy1 - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                    this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth, this.vy2 - 2 * this.ticLength - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                } else {
                    this.gBI.drawLine(this.axesIntersectXPix, this.vy1, this.axesIntersectXPix, this.vy1 + 2 * this.ticLength);
                    this.gBI.drawLine(this.axesIntersectXPix, this.vy2, this.axesIntersectXPix, this.vy2 - 2 * this.ticLength);
                }
            }
            if (this.numXTics <= 1) break block26;
            if (this.lineWidth >= 1) {
                for (i = 0; i <= this.numXTics - 1; ++i) {
                    this.gBI.fillRect(this.hx1 - this.lineWidth + Convert.toRoundedInt((double)i * this.xTicGap), this.vy1 - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                    this.gBI.fillRect(this.hx1 - this.lineWidth + Convert.toRoundedInt((double)i * this.xTicGap), this.vy2 - 2 * this.ticLength - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                }
            } else {
                for (i = 0; i <= this.numXTics - 1; ++i) {
                    this.gBI.drawLine(this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.vy1, this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.vy1 + 2 * this.ticLength);
                    this.gBI.drawLine(this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.vy2, this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.vy2 - 2 * this.ticLength);
                }
            }
        }
    }

    protected void drawCrossedAxes() {
        block44: {
            int i;
            block45: {
                block43: {
                    int temp = 0;
                    boolean start = false;
                    boolean end = false;
                    double ticXMin = 0.0;
                    double ticXMax = 0.0;
                    double ticYMin = 0.0;
                    double ticYMax = 0.0;
                    if (this.lineWidth >= 1) {
                        this.gBI.fillRect(this.vx1 - this.lineWidth, this.vy1, 2 * this.lineWidth, this.yAxisLength);
                    } else {
                        this.gBI.drawLine(this.vx1, this.vy1, this.vx2, this.vy2);
                    }
                    if (this.usingHalfIntegerTics) {
                        ticYMin = (double)Convert.toRoundedInt(2.0 * this.yMin) / 2.0;
                        if (ticYMin < this.xMin && Math.abs(ticYMin - this.yMin) > this.eps) {
                            ticYMin += 0.5;
                        }
                        if ((ticYMax = (double)Convert.toRoundedInt(2.0 * this.yMax) / 2.0) > this.yMax && Math.abs(ticYMax - this.yMax) > this.eps) {
                            ticYMax -= 0.5;
                        }
                        if (this.lineWidth >= 1) {
                            for (i = 0; i <= Convert.toRoundedInt(2.0 * (ticYMax - ticYMin)); ++i) {
                                this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth - this.ticLength, this.getYPixel(ticYMin + (double)i * 0.5) - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                            }
                        } else {
                            for (i = 0; i <= 2 * Convert.toRoundedInt(2.0 * (ticYMax - ticYMin)); ++i) {
                                temp = this.getYPixel(ticYMin + (double)i * 0.5);
                                this.gBI.drawLine(this.axesIntersectXPix - this.ticLength, temp, this.axesIntersectXPix + this.ticLength, temp);
                            }
                        }
                    } else if (this.usingIntegerTics) {
                        if (this.lineWidth >= 1) {
                            for (i = Convert.toRoundedInt(this.yMin); i <= Convert.toRoundedInt(this.yMax); ++i) {
                                this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth - this.ticLength, this.getYPixel(Convert.toDouble(i)) - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                            }
                        } else {
                            for (i = Convert.toRoundedInt(this.yMin); i <= Convert.toRoundedInt(this.yMax); ++i) {
                                this.gBI.drawLine(this.axesIntersectXPix - this.ticLength, this.getYPixel(Convert.toDouble(i)), this.axesIntersectXPix + this.ticLength, this.getYPixel(Convert.toDouble(i)));
                            }
                        }
                    } else {
                        if (this.numYTics == 1) {
                            if (this.lineWidth >= 1) {
                                this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth - this.ticLength, this.axesIntersectYPix - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                            } else {
                                this.gBI.drawLine(this.axesIntersectXPix - this.ticLength, this.axesIntersectYPix, this.axesIntersectXPix + this.ticLength, this.axesIntersectYPix);
                            }
                        }
                        if (this.numYTics > 1) {
                            if (this.lineWidth >= 1) {
                                for (i = 0; i <= this.numYTics - 1; ++i) {
                                    this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth - this.ticLength, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap) - this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength, 2 * this.lineWidth);
                                }
                            } else {
                                for (i = 0; i <= this.numYTics - 1; ++i) {
                                    this.gBI.drawLine(this.axesIntersectXPix - this.ticLength, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap), this.axesIntersectXPix + this.ticLength, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap));
                                }
                            }
                        }
                    }
                    if (this.lineWidth >= 1) {
                        this.gBI.fillRect(this.hx1, this.hy1 - this.lineWidth, this.xAxisLength, 2 * this.lineWidth);
                    } else {
                        this.gBI.drawLine(this.hx1, this.hy1, this.hx2, this.hy2);
                    }
                    if (!this.usingHalfIntegerTics) break block43;
                    ticXMin = (double)Convert.toRoundedInt(2.0 * this.xMin) / 2.0;
                    if (ticXMin < this.xMin && Math.abs(ticXMin - this.xMin) > this.eps) {
                        ticXMin += 0.5;
                    }
                    if ((ticXMax = (double)Convert.toRoundedInt(2.0 * this.xMax) / 2.0) > this.xMax && Math.abs(ticXMax - this.xMax) > this.eps) {
                        ticXMax -= 0.5;
                    }
                    if (this.lineWidth >= 1) {
                        for (i = 0; i <= Convert.toRoundedInt(2.0 * (ticXMax - ticXMin)); ++i) {
                            this.gBI.fillRect(this.getXPixel(ticXMin + (double)i * 0.5) - this.lineWidth, this.axesIntersectYPix - this.ticLength - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                        }
                    } else {
                        for (i = 0; i <= Convert.toRoundedInt(2.0 * (ticXMax - ticXMin)); ++i) {
                            temp = this.getXPixel(ticXMin + (double)i * 0.5);
                            this.gBI.drawLine(temp, this.axesIntersectYPix - this.ticLength, temp, this.axesIntersectYPix + this.ticLength);
                        }
                    }
                    break block44;
                }
                if (!this.usingIntegerTics) break block45;
                if (this.lineWidth >= 1) {
                    for (i = Convert.toRoundedInt(this.xMin); i <= Convert.toRoundedInt(this.xMax); ++i) {
                        this.gBI.fillRect(this.getXPixel(i) - this.lineWidth, this.axesIntersectYPix - this.ticLength - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                    }
                } else {
                    for (i = Convert.toRoundedInt(this.xMin); i <= Convert.toRoundedInt(this.xMax); ++i) {
                        this.gBI.drawLine(this.getXPixel(i), this.axesIntersectYPix - this.ticLength, this.getXPixel(i), this.axesIntersectYPix + this.ticLength);
                    }
                }
                break block44;
            }
            if (this.numXTics == 1) {
                if (this.lineWidth >= 1) {
                    this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth, this.axesIntersectYPix - this.ticLength - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                } else {
                    this.gBI.drawLine(this.axesIntersectXPix, this.axesIntersectYPix - this.ticLength, this.axesIntersectXPix, this.axesIntersectYPix + this.ticLength);
                }
            }
            if (this.numXTics <= 1) break block44;
            if (this.lineWidth >= 1) {
                for (i = 0; i <= this.numXTics - 1; ++i) {
                    this.gBI.fillRect(this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap) - this.lineWidth, this.axesIntersectYPix - this.ticLength - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth + 2 * this.ticLength);
                }
            } else {
                for (i = 0; i <= this.numXTics - 1; ++i) {
                    this.gBI.drawLine(this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.axesIntersectYPix - this.ticLength, this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.axesIntersectYPix + this.ticLength);
                }
            }
        }
    }

    protected void drawGrid() {
        block34: {
            int i;
            block35: {
                int i2;
                int temp;
                block33: {
                    temp = 0;
                    int start = 0;
                    int end = 0;
                    double ticXMin = 0.0;
                    double ticXMax = 0.0;
                    double ticYMin = 0.0;
                    double ticYMax = 0.0;
                    if (!this.usingHalfIntegerTics) break block33;
                    ticXMin = (double)Convert.toRoundedInt(2.0 * this.xMin) / 2.0;
                    if (ticXMin < this.xMin && Math.abs(ticXMin - this.xMin) > this.eps) {
                        ticXMin += 0.5;
                    }
                    if ((ticXMax = (double)Convert.toRoundedInt(2.0 * this.xMax) / 2.0) > this.xMax && Math.abs(ticXMax - this.xMax) > this.eps) {
                        ticXMax -= 0.5;
                    }
                    if ((ticYMin = (double)Convert.toRoundedInt(2.0 * this.yMin) / 2.0) < this.xMin && Math.abs(ticYMin - this.yMin) > this.eps) {
                        ticYMin += 0.5;
                    }
                    if ((ticYMax = (double)Convert.toRoundedInt(2.0 * this.yMax) / 2.0) > this.yMax && Math.abs(ticYMax - this.yMax) > this.eps) {
                        ticYMax -= 0.5;
                    }
                    if (this.lineWidth >= 1) {
                        int i3;
                        start = this.getYPixel(ticYMin);
                        end = this.getYPixel(ticYMax);
                        for (i3 = 0; i3 <= Convert.toRoundedInt(2.0 * (ticXMax - ticXMin)); ++i3) {
                            temp = this.getXPixel(ticXMin + (double)i3 * 0.5);
                            this.gBI.fillRect(temp - this.lineWidth, end - this.lineWidth, 2 * this.lineWidth, start - end + 2 * this.lineWidth);
                        }
                        start = this.getXPixel(ticXMin);
                        end = this.getXPixel(ticXMax);
                        for (i3 = 0; i3 <= Convert.toRoundedInt(2.0 * (ticYMax - ticYMin)); ++i3) {
                            temp = this.getYPixel(ticYMin + (double)i3 * 0.5);
                            this.gBI.fillRect(start - this.lineWidth, temp - this.lineWidth, end - start + 2 * this.lineWidth, 2 * this.lineWidth);
                        }
                    } else {
                        int i4;
                        start = this.getYPixel(ticYMin);
                        end = this.getYPixel(ticYMax);
                        for (i4 = 0; i4 <= Convert.toRoundedInt(2.0 * (ticXMax - ticXMin)); ++i4) {
                            temp = this.getXPixel(ticXMin + (double)i4 * 0.5);
                            this.gBI.drawLine(temp, start, temp, end);
                        }
                        start = this.getXPixel(ticXMin);
                        end = this.getXPixel(ticXMax);
                        for (i4 = 0; i4 <= 2 * Convert.toRoundedInt(2.0 * (ticYMax - ticYMin)); ++i4) {
                            temp = this.getYPixel(ticYMin + (double)i4 * 0.5);
                            this.gBI.drawLine(start, temp, end, temp);
                        }
                    }
                    break block34;
                }
                if (!this.usingIntegerTics) break block35;
                if (this.lineWidth >= 1) {
                    for (i2 = Convert.toRoundedInt(this.yMin); i2 <= Convert.toRoundedInt(this.yMax); ++i2) {
                        this.gBI.fillRect(this.hx1 - this.lineWidth, this.getYPixel(Convert.toDouble(i2)) - this.lineWidth, this.xAxisLength + 2 * this.lineWidth, 2 * this.lineWidth);
                    }
                } else {
                    for (i2 = Convert.toRoundedInt(this.yMin); i2 <= Convert.toRoundedInt(this.yMax); ++i2) {
                        temp = this.getYPixel(Convert.toDouble(i2));
                        this.gBI.drawLine(this.hx1, temp, this.hx2, temp);
                    }
                }
                if (this.lineWidth >= 1) {
                    for (i2 = Convert.toRoundedInt(this.xMin); i2 <= Convert.toRoundedInt(this.xMax); ++i2) {
                        this.gBI.fillRect(this.getXPixel(i2) - this.lineWidth, this.vy1 - this.lineWidth, 2 * this.lineWidth, this.yAxisLength);
                    }
                } else {
                    for (i2 = Convert.toRoundedInt(this.xMin); i2 <= Convert.toRoundedInt(this.xMax); ++i2) {
                        temp = this.getXPixel(i2);
                        this.gBI.drawLine(temp, this.vy1, temp, this.vy2);
                    }
                }
                break block34;
            }
            if (this.numYTics == 1) {
                if (this.lineWidth >= 1) {
                    this.gBI.fillRect(this.hx1 - this.lineWidth, this.axesIntersectYPix - this.lineWidth, this.xAxisLength + 2 * this.lineWidth, 2 * this.lineWidth);
                } else {
                    this.gBI.drawLine(this.hx1, this.axesIntersectYPix, this.hx2, this.axesIntersectYPix);
                }
            }
            if (this.numYTics > 1) {
                if (this.lineWidth >= 1) {
                    for (i = 0; i <= this.numYTics - 1; ++i) {
                        this.gBI.fillRect(this.hx1 - this.lineWidth, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap) - this.lineWidth, this.xAxisLength + 2 * this.lineWidth, 2 * this.lineWidth);
                    }
                } else {
                    for (i = 0; i <= this.numYTics - 1; ++i) {
                        this.gBI.drawLine(this.hx1, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap), this.hx2, this.vy1 + Convert.toRoundedInt((double)i * this.yTicGap));
                    }
                }
            }
            if (this.numXTics == 1) {
                if (this.lineWidth >= 1) {
                    this.gBI.fillRect(this.axesIntersectXPix - this.lineWidth, this.vy1 - this.lineWidth, 2 * this.lineWidth, this.yAxisLength + 2 * this.lineWidth);
                } else {
                    this.gBI.drawLine(this.axesIntersectXPix, this.vy1, this.axesIntersectXPix, this.vy2);
                }
            }
            if (this.numXTics <= 1) break block34;
            if (this.lineWidth >= 1) {
                for (i = 0; i <= this.numXTics - 1; ++i) {
                    this.gBI.fillRect(this.hx1 - this.lineWidth + Convert.toRoundedInt((double)i * this.xTicGap), this.vy1 - this.lineWidth, 2 * this.lineWidth, this.yAxisLength + 2 * this.lineWidth);
                }
            } else {
                for (i = 0; i <= this.numXTics - 1; ++i) {
                    this.gBI.drawLine(this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.vy1, this.hx1 + Convert.toRoundedInt((double)i * this.xTicGap), this.vy2);
                }
            }
        }
    }

    public void reColorBackground() {
        block9: {
            int color;
            block8: {
                int height = this.getSize().height;
                int width = this.getSize().width;
                color = 0;
                this.red = this.getBackground().getRed();
                this.green = this.getBackground().getGreen();
                this.blue = this.getBackground().getBlue();
                color = this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
                if (!this.usingBackgroundImage) break block8;
                if (this.topPad > 0 || this.bottomPad > 0) {
                    for (int i = 0; i < width; ++i) {
                        int j;
                        for (j = 0; j < this.topPad; ++j) {
                            this.pixelColors[i + j * width] = color;
                        }
                        for (j = height - this.topPad; j < height; ++j) {
                            this.pixelColors[i + j * width] = color;
                        }
                    }
                }
                if (this.leftPad <= 0 && this.rightPad <= 0) break block9;
                for (int j = this.topPad; j < height - this.bottomPad; ++j) {
                    int i;
                    for (i = 0; i < this.leftPad; ++i) {
                        this.pixelColors[i + j * width] = color;
                    }
                    for (i = width - this.rightPad; i < width; ++i) {
                        this.pixelColors[i + j * width] = color;
                    }
                }
                break block9;
            }
            for (int i = 0; i <= this.getWidth() * this.getHeight() - 1; ++i) {
                this.pixelColors[i] = color;
            }
        }
    }

    private void getNewBufferedImage() {
        this.bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.gBI = (Graphics2D)this.bufferedImage.getGraphics();
        this.raster = this.bufferedImage.getRaster();
        this.pixelColors = new int[this.getWidth() * this.getHeight()];
        if (this.usingBackgroundImage) {
            this.createBackgroundImage();
        } else {
            this.reColorBackground();
        }
        this.raster.setDataElements(0, 0, this.getSize().width, this.getSize().height, this.pixelColors);
    }

    protected abstract void plotData(PlotStuff var1, Graphics2D var2);

    protected abstract void createBackgroundImage();

    public void sketchData(double cursorX, double cursorY) {
        Graphics g = this.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(new BasicStroke(this.sketchTrace.getPlotSize()));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.sketchTrace.getPlotColor());
        g2d.drawLine(this.getXPixel(this.lastX), this.getYPixel(this.lastY), this.getXPixel(cursorX), this.getYPixel(cursorY));
        this.lastX = cursorX;
        this.lastY = cursorY;
        g.dispose();
    }

    public void mousePressed(MouseEvent evt) {
        if (this.usingDragZoom) {
            this.oldOriginX = evt.getX();
            this.oldOriginY = evt.getY();
            this.slope = Convert.toDouble(this.yAxisLength) / Convert.toDouble(this.xAxisLength);
        } else {
            this.mousePressedXPixel = evt.getX();
            this.mousePressedYPixel = evt.getY();
            this.oldOriginX = this.originX;
            this.oldOriginY = this.originY;
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.usingDragZoom) {
            this.draggingToZoom = true;
            this.findCornersofZoomRect(evt);
        } else {
            this.setOriginX(this.oldOriginX + (evt.getX() - this.mousePressedXPixel));
            this.setOriginY(this.oldOriginY + (evt.getY() - this.mousePressedYPixel));
            this.updateRegisteredObjects();
            this.locateAxes();
            if (this.numberLabel != null) {
                this.numberLabel.setCursorLocation(this.getXVal(evt.getX()), this.getYVal(evt.getY()));
            }
        }
    }

    protected void findCornersofZoomRect(MouseEvent evt) {
        if (evt.getY() > Convert.toRoundedInt(this.slope * (double)(evt.getX() - this.oldOriginX)) + this.oldOriginY) {
            if (evt.getY() > Convert.toRoundedInt(-this.slope * (double)(evt.getX() - this.oldOriginX)) + this.oldOriginY) {
                this.zoomRectY = 2 * this.oldOriginY - evt.getY();
                this.zoomRectX = Convert.toRoundedInt((double)(this.zoomRectY - this.oldOriginY) / this.slope) + this.oldOriginX;
            } else {
                this.zoomRectX = evt.getX();
                this.zoomRectY = Convert.toRoundedInt(this.slope * (double)(this.zoomRectX - this.oldOriginX)) + this.oldOriginY;
            }
        } else if (evt.getY() > Convert.toRoundedInt(-this.slope * (double)(evt.getX() - this.oldOriginX)) + this.oldOriginY) {
            this.zoomRectX = 2 * this.oldOriginX - evt.getX();
            this.zoomRectY = Convert.toRoundedInt(this.slope * (double)(this.zoomRectX - this.oldOriginX)) + this.oldOriginY;
        } else {
            this.zoomRectY = evt.getY();
            this.zoomRectX = Convert.toRoundedInt((double)(this.zoomRectY - this.oldOriginY) / this.slope) + this.oldOriginX;
        }
        this.zoomRectHeight = 2 * (this.oldOriginY - this.zoomRectY);
        this.zoomRectWidth = 2 * (this.oldOriginX - this.zoomRectX);
    }

    public void mouseEntered(MouseEvent evt) {
        if (this.numberLabel != null) {
            this.numberLabel.setCursorLocation(this.getXVal(evt.getX()), this.getYVal(evt.getY()));
        }
    }

    public void mouseExited(MouseEvent evt) {
        if (this.numberLabel != null) {
            this.numberLabel.setText("");
        }
    }

    public void mouseMoved(MouseEvent evt) {
        if (this.numberLabel != null) {
            this.numberLabel.setCursorLocation(this.getXVal(evt.getX()), this.getYVal(evt.getY()));
        }
    }

    public boolean mouseReleased(MouseEvent evt) {
        boolean didZoom = true;
        double tempXMin = 0.0;
        double tempXMax = 0.0;
        double tempYMin = 0.0;
        double tempYMax = 0.0;
        if (this.draggingToZoom) {
            this.findCornersofZoomRect(evt);
            if (this.zoomRectWidth > this.minZoomPixels) {
                tempXMin = this.getXVal(this.zoomRectX);
                tempXMax = this.getXVal(this.zoomRectX + this.zoomRectWidth);
                tempYMax = this.getYVal(this.zoomRectY);
                tempYMin = this.getYVal(this.zoomRectY + this.zoomRectHeight);
                this.xMin = tempXMin;
                this.xMax = tempXMax;
                this.yMin = tempYMin;
                this.yMax = tempYMax;
                this.updateRegisteredObjects();
                this.locateAxes();
            } else {
                didZoom = false;
            }
            this.draggingToZoom = false;
        }
        return didZoom;
    }

    public void plotData() {
        if (this.grapherHasBeenResized) {
            this.getNewBufferedImage();
            this.locateAxes();
            this.drawAxesAndLabels();
            this.grapherHasBeenResized = false;
        }
        if (this.needToRedrawAxes) {
            this.raster.setDataElements(0, 0, this.getSize().width, this.getSize().height, this.pixelColors);
            this.locateAxes();
            this.drawAxesAndLabels();
            this.needToRedrawAxes = false;
        }
        this.raster.setDataElements(0, 0, this.getSize().width, this.getSize().height, this.pixelColors);
        if (this.antiAliasing) {
            this.gBI.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawAxesAndLabels();
        if (this.numTraces == 1 && this.trace != null) {
            this.gBI.setColor(this.trace.getPlotColor());
            this.plotData(this.trace, this.gBI);
        } else if (this.traces != null) {
            if (this.usingOrderTraces) {
                for (int i = 0; i <= this.numTraces - 1; ++i) {
                    this.gBI.setColor(this.traces[this.orderTraces[i]].getPlotColor());
                    this.plotData(this.traces[this.orderTraces[i]], this.gBI);
                }
            } else {
                for (int i = 0; i <= this.numTraces - 1; ++i) {
                    this.gBI.setColor(this.traces[i].getPlotColor());
                    this.plotData(this.traces[i], this.gBI);
                }
            }
        }
        if (this.draggingToZoom) {
            this.gBI.setColor(this.zoomRectangleColor);
            this.gBI.drawRect(this.zoomRectX, this.zoomRectY, this.zoomRectWidth, this.zoomRectHeight);
        }
        this.repaint();
    }

    public void plotData(int[] orderTraces, PlotStuff[] allData) {
        this.orderTraces = orderTraces;
        this.traces = allData;
        this.usingOrderTraces = true;
        this.plotData();
    }

    public void plotData(PlotStuff[] traces) {
        this.usingOrderTraces = false;
        this.traces = traces;
        this.plotData();
    }

    public void plotData(PlotStuff trace) {
        this.usingOrderTraces = false;
        this.trace = trace;
        this.numTraces = 1;
        this.plotData();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.grapherHasBeenResized = true;
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.grapherHasBeenResized = true;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.grapherHasBeenResized = true;
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.grapherHasBeenResized = true;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.bufferedImage, 0, 0, this);
    }

    public void drawAxes() {
        this.gBI.setColor(this.axesColor);
        this.gBI.setStroke(new BasicStroke(0.0f, 0, 2));
        switch (this.getAxesStyle()) {
            case 0: {
                break;
            }
            case 1: {
                this.drawCrossedAxes();
                break;
            }
            case 2: {
                this.drawBoxedAxes();
                break;
            }
            case 3: {
                this.gBI.setColor(this.gridColor);
                this.drawGrid();
                break;
            }
            case 4: {
                this.gBI.setColor(this.gridColor);
                this.drawGrid();
                this.gBI.setColor(this.axesColor);
                this.drawCrossedAxes();
                break;
            }
            case 5: {
                this.gBI.setColor(this.gridColor);
                this.drawGrid();
                this.gBI.setColor(this.axesColor);
                this.drawBoxedAxes();
                break;
            }
            case 6: {
                this.gBI.setColor(this.gridColor);
                this.drawGrid();
                this.gBI.setColor(this.axesColor);
                this.drawBoxedAxes();
                this.drawCrossedAxes();
            }
        }
    }

    public void drawAxesAndLabels() {
        this.drawAxes();
        if (this.getAxesStyle() != 0) {
            this.drawLabels();
        }
    }

    public void drawLabels() {
        block0 : switch (this.getAxesStyle()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.gBI.setColor(this.xAxisTitleColor);
                this.gBI.setFont(this.xAxisTitleFont);
                switch (this.getXAxisTitleLocation()) {
                    case 0: {
                        break;
                    }
                    case 10: {
                        this.gBI.drawString(this.xAxisTitle, this.getWidth() - this.xAxisTitleLabel.getPreferredSize().width - 3, this.axesIntersectYPix + this.xAxisTitleFont.getSize() / 2 - 1);
                        break;
                    }
                    case 11: {
                        this.gBI.drawString(this.xAxisTitle, this.getWidth() - this.xAxisTitleLabel.getPreferredSize().width - 3, this.axesIntersectYPix - this.ticLength);
                        break;
                    }
                    case 12: {
                        this.gBI.drawString(this.xAxisTitle, this.getWidth() - this.xAxisTitleLabel.getPreferredSize().width - 3, this.axesIntersectYPix + this.xAxisTitleFont.getSize() + this.ticLength);
                        break;
                    }
                    case 13: {
                        this.gBI.drawString(this.xAxisTitle, 2, this.axesIntersectYPix + this.xAxisTitleFont.getSize() / 2 - 1);
                        break;
                    }
                    case 14: {
                        this.gBI.drawString(this.xAxisTitle, 2, this.axesIntersectYPix - this.ticLength);
                        break;
                    }
                    case 15: {
                        this.gBI.drawString(this.xAxisTitle, 2, this.axesIntersectYPix + this.xAxisTitleFont.getSize() + this.ticLength);
                    }
                }
                this.gBI.setColor(this.yAxisTitleColor);
                this.gBI.setFont(this.yAxisTitleFont);
                switch (this.getYAxisTitleLocation()) {
                    case 0: {
                        break block0;
                    }
                    case 20: {
                        this.gBI.drawString(this.yAxisTitle, this.axesIntersectXPix - this.yAxisTitleLabel.getPreferredSize().width / 2 + 1, this.yAxisTitleFont.getSize());
                        break block0;
                    }
                    case 21: {
                        this.gBI.drawString(this.yAxisTitle, this.axesIntersectXPix + this.ticLength + 1, this.yAxisTitleFont.getSize());
                        break block0;
                    }
                    case 22: {
                        this.gBI.drawString(this.yAxisTitle, this.axesIntersectXPix - Convert.toRoundedInt(this.yAxisTitleLabel.getPreferredSize().getWidth()) - this.ticLength + 1, this.yAxisTitleFont.getSize());
                        break block0;
                    }
                    case 23: {
                        this.gBI.drawString(this.yAxisTitle, this.axesIntersectXPix - Convert.toRoundedInt(this.yAxisTitleLabel.getPreferredSize().getWidth() / 2.0) + 1, this.getHeight() - 3);
                        break block0;
                    }
                    case 24: {
                        this.gBI.drawString(this.yAxisTitle, this.axesIntersectXPix + this.ticLength + 1, this.getHeight() - 3);
                        break block0;
                    }
                    case 25: {
                        this.gBI.drawString(this.yAxisTitle, this.axesIntersectXPix - Convert.toRoundedInt(this.yAxisTitleLabel.getPreferredSize().getWidth()) - this.ticLength + 1, this.getHeight() - 3);
                    }
                }
            }
        }
    }

    public int getAxesStyle() {
        return this.axesStyle;
    }

    public int getBottomPad() {
        return this.bottomPad;
    }

    public String getGraphTitle() {
        return this.graphTitle;
    }

    public int getGraphTitleLocation() {
        return this.graphTitleLocation;
    }

    public int getLeftPad() {
        return this.leftPad;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getNumTraces() {
        return this.numTraces;
    }

    public int getNumXTics() {
        return this.numXTics;
    }

    public int getNumYTics() {
        return this.numYTics;
    }

    public int getRightPad() {
        return this.rightPad;
    }

    public int getTopPad() {
        return this.topPad;
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public Color getXAxisTitleColor() {
        return this.xAxisTitleColor;
    }

    public Font getXAxisTitleFont() {
        return this.xAxisTitleFont;
    }

    public int getXAxisTitleLocation() {
        return this.xAxisTitleLocation;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public int getXPixel(double x) {
        return Convert.toRoundedInt((double)this.originX + x / (this.xMax - this.xMin) * (double)this.xAxisLength);
    }

    public Color getXTicLabelsColor() {
        return this.xTicLabelsColor;
    }

    public Font getXTicLabelsFont() {
        return this.xTicLabelsFont;
    }

    public int getXTicLabelsLocation() {
        return this.xTicLabelsLocation;
    }

    public double getXVal(int xPixel) {
        return (double)(xPixel - this.leftPad) / this.xAxisLengthDouble * (this.xMax - this.xMin) + this.xMin;
    }

    public String getYAxisTitle() {
        return this.yAxisTitle;
    }

    public Color getYAxisTitleColor() {
        return this.yAxisTitleColor;
    }

    public Font getYAxisTitleFont() {
        return this.yAxisTitleFont;
    }

    public int getYAxisTitleLocation() {
        return this.yAxisTitleLocation;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public int getYPixel(double y) {
        return Convert.toRoundedInt((double)this.originY - y / (this.yMax - this.yMin) * (double)this.yAxisLength);
    }

    public Color getYTicLabelsColor() {
        return this.yTicLabelsColor;
    }

    public Font getYTicLabelsFont() {
        return this.yTicLabelsFont;
    }

    public int getYTicLabelsLocation() {
        return this.yTicLabelsLocation;
    }

    public double getYVal(int yPixel) {
        return this.yMax - (double)(yPixel - this.topPad) / this.yAxisLengthDouble * (this.yMax - this.yMin);
    }

    public boolean isUsingIntegerTics() {
        return this.usingIntegerTics;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getXAxisLength() {
        return this.xAxisLength;
    }

    public int getYAxisLength() {
        return this.yAxisLength;
    }

    public void setOriginX(int originX) {
        double oldXMin = this.xMin;
        this.originX = originX;
        this.xMin = (this.xMax - this.xMin) * (double)(this.leftPad - originX) / (double)this.xAxisLength;
        this.xMax += this.xMin - oldXMin;
    }

    public void setOriginY(int originY) {
        double oldYMax = this.yMax;
        this.originY = originY;
        this.yMax = (this.yMax - this.yMin) * (double)(originY - this.topPad) / (double)this.yAxisLength;
        this.yMin += this.yMax - oldYMax;
    }

    protected void locateAxes() {
        this.xAxisLength = this.getSize().width - this.leftPad - this.rightPad;
        this.xAxisLengthDouble = this.xAxisLength;
        this.yAxisLength = this.getSize().height - this.topPad - this.bottomPad;
        this.yAxisLengthDouble = this.yAxisLength;
        this.originX = Math.abs((this.xMax + this.xMin) / 2.0) < this.eps && this.xAxisLength % 2 == 1 ? this.leftPad - Convert.toRoundedInt((double)this.xAxisLength * this.xMin / (this.xMax - this.xMin)) - 1 : this.leftPad - Convert.toRoundedInt((double)this.xAxisLength * this.xMin / (this.xMax - this.xMin));
        this.originY = Math.abs((this.yMax + this.yMin) / 2.0) < this.eps && this.yAxisLength % 2 == 1 ? this.topPad + Convert.toRoundedInt((double)this.yAxisLength * this.yMax / (this.yMax - this.yMin)) - 1 : this.topPad + Convert.toRoundedInt((double)this.yAxisLength * this.yMax / (this.yMax - this.yMin));
        if (this.xMin < 0.0 && this.xMax > 0.0) {
            this.axesIntersectXPix = this.originX;
        } else if (this.xMin >= 0.0) {
            this.axesIntersectXPix = this.leftPad;
        } else if (this.xMax <= 0.0) {
            this.axesIntersectXPix = this.leftPad + this.xAxisLength;
        }
        if (this.yMin < 0.0 && this.yMax > 0.0) {
            this.axesIntersectYPix = this.originY;
        } else if (this.yMax <= 0.0) {
            this.axesIntersectYPix = this.topPad;
        } else if (this.yMin >= 0.0) {
            this.axesIntersectYPix = this.topPad + this.yAxisLength;
        }
        if (this.numXTics < 0) {
            this.numXTics = 0;
            this.xTicGap = 0.0;
        } else {
            this.xTicGap = this.numXTics == 1 ? (double)this.xAxisLength / 2.0 : (double)this.xAxisLength / (double)(this.numXTics - 1);
        }
        if (this.numYTics < 0) {
            this.numYTics = 0;
            this.yTicGap = 0.0;
        } else {
            this.yTicGap = this.numYTics == 1 ? (double)this.yAxisLength / 2.0 : (double)this.yAxisLength / (double)(this.numYTics - 1);
        }
        this.vy1 = this.topPad;
        this.vy2 = this.topPad + this.yAxisLength;
        this.vx1 = this.axesIntersectXPix;
        this.vx2 = this.axesIntersectXPix;
        this.hx1 = this.leftPad;
        this.hx2 = this.leftPad + this.xAxisLength;
        this.hy1 = this.axesIntersectYPix;
        this.hy2 = this.axesIntersectYPix;
    }

    public void setAxesStyle(int axesStyle) {
        this.axesStyle = axesStyle;
    }

    public void setBottomPad(int bottomPad) {
        this.bottomPad = bottomPad;
        this.needToRedrawAxes = true;
    }

    public void setGraphTitle(String graphTitle) {
        this.graphTitle = graphTitle;
    }

    public void setGraphTitleLocation(int graphTitleLocation) {
        this.graphTitleLocation = graphTitleLocation;
    }

    public void setRightPad(int rightPad) {
        this.rightPad = rightPad;
        this.needToRedrawAxes = true;
    }

    public void setLeftPad(int leftPad) {
        this.leftPad = leftPad;
        this.needToRedrawAxes = true;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setNumTraces(int numTraces) {
        this.numTraces = numTraces;
    }

    public void setNumXTics(int numXTics) {
        this.numXTics = numXTics;
        this.locateAxes();
    }

    public void setNumYTics(int numYTics) {
        this.numYTics = numYTics;
        this.locateAxes();
    }

    public void setTopPad(int topPad) {
        this.topPad = topPad;
        this.needToRedrawAxes = true;
    }

    public void setUsingIntegerTics(boolean usingIntegerTics) {
        this.usingIntegerTics = usingIntegerTics;
        if (usingIntegerTics) {
            this.usingHalfIntegerTics = false;
        }
        this.needToRedrawAxes = true;
    }

    public boolean isUsingHalfIntegerTics() {
        return this.usingHalfIntegerTics;
    }

    public void setUsingHalfIntegerTics(boolean usingHalfIntegerTics) {
        this.usingHalfIntegerTics = usingHalfIntegerTics;
        if (usingHalfIntegerTics) {
            this.usingIntegerTics = false;
        }
        this.needToRedrawAxes = true;
    }

    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
        this.xAxisTitleLabel.setText(xAxisTitle);
    }

    public void setXAxisTitleColor(Color xAxisTitleColor) {
        this.xAxisTitleColor = xAxisTitleColor;
    }

    public void setXAxisTitleFont(Font xAxisTitleFont) {
        this.xAxisTitleFont = xAxisTitleFont;
        this.xAxisTitleLabel.setFont(xAxisTitleFont);
    }

    public void setXAxisTitleLocation(int xAxisTitleLocation) {
        this.xAxisTitleLocation = xAxisTitleLocation;
    }

    public void setXMax(double xMax) {
        this.xMax = xMax;
        this.locateAxes();
    }

    public void setXMin(double xMin) {
        this.xMin = xMin;
        this.locateAxes();
    }

    public void setXTicLabelsColor(Color xTicLabelsColor) {
        this.xTicLabelsColor = xTicLabelsColor;
    }

    public void setXTicLabelsFont(Font xTicLabelsFont) {
        this.xTicLabelsFont = xTicLabelsFont;
    }

    public void setXTicLabelsLocation(int xTicLabelsLocation) {
        this.xTicLabelsLocation = xTicLabelsLocation;
    }

    public void setYAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
        this.yAxisTitleLabel.setText(yAxisTitle);
    }

    public void setYAxisTitleColor(Color yAxisTitleColor) {
        this.yAxisTitleColor = yAxisTitleColor;
    }

    public void setYAxisTitleFont(Font yAxisTitleFont) {
        this.yAxisTitleFont = yAxisTitleFont;
        this.yAxisTitleLabel.setFont(yAxisTitleFont);
    }

    public void setYAxisTitleLocation(int yAxisTitleLocation) {
        this.yAxisTitleLocation = yAxisTitleLocation;
    }

    public void setYMax(double yMax) {
        this.yMax = yMax;
        this.locateAxes();
    }

    public void setYMin(double yMin) {
        this.yMin = yMin;
        this.locateAxes();
    }

    public void setYTicLabelsColor(Color yTicLabelsColor) {
        this.yTicLabelsColor = yTicLabelsColor;
    }

    public void setYTicLabelsFont(Font yTicLabelsFont) {
        this.yTicLabelsFont = yTicLabelsFont;
    }

    public void setYTicLabelsLocation(int yTicLabelsLocation) {
        this.yTicLabelsLocation = yTicLabelsLocation;
    }

    public PlotStuff getTrace() {
        return this.trace;
    }

    public void setTrace(PlotStuff trace) {
        this.trace = trace;
    }

    public PlotStuff getTraces(int index) {
        return this.traces[index];
    }

    public PlotStuff[] getTraces() {
        return this.traces;
    }

    public void setTraces(int index, PlotStuff traces) {
        this.traces[index] = traces;
    }

    public void setTraces(PlotStuff[] traces) {
        this.traces = traces;
    }

    public PlotStuff getSketchTrace() {
        return this.sketchTrace;
    }

    public void setSketchTrace(PlotStuff sketchTrace) {
        this.sketchTrace = sketchTrace;
    }

    public double getLastX() {
        return this.lastX;
    }

    public void setLastX(double lastX) {
        this.lastX = lastX;
    }

    public double getLastY() {
        return this.lastY;
    }

    public void setLastY(double lastY) {
        this.lastY = lastY;
    }

    public int getOrderTraces(int index) {
        return this.orderTraces[index];
    }

    public int[] getOrderTraces() {
        return this.orderTraces;
    }

    public void setOrderTraces(int index, int orderTraces) {
        this.orderTraces[index] = orderTraces;
    }

    public void setOrderTraces(int[] orderTraces) {
        this.orderTraces = orderTraces;
    }

    public boolean isUsingOrderTraces() {
        return this.usingOrderTraces;
    }

    public void setUsingOrderTraces(boolean usingOrderTraces) {
        this.usingOrderTraces = usingOrderTraces;
    }

    public Color getAxesColor() {
        return this.axesColor;
    }

    public void setAxesColor(Color axesColor) {
        this.axesColor = axesColor;
    }

    public void setTicLength(int ticLength) {
        this.ticLength = ticLength;
    }

    public int getTicLength() {
        return this.ticLength;
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
        if (antiAliasing) {
            this.gBI.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.gBI.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public boolean isUsingDragZoom() {
        return this.usingDragZoom;
    }

    public void setUsingDragZoom(boolean usingDragZoom) {
        this.usingDragZoom = usingDragZoom;
    }

    public Color getZoomRectangleColor() {
        return this.zoomRectangleColor;
    }

    public void setZoomRectangleColor(Color zoomRectangleColor) {
        this.zoomRectangleColor = zoomRectangleColor;
    }

    public boolean isUsingBackgroundImage() {
        return this.usingBackgroundImage;
    }

    public void setUsingBackgroundImage(boolean usingBackgroundImage) {
        this.usingBackgroundImage = usingBackgroundImage;
    }

    public int getPixelColors(int index) {
        return this.pixelColors[index];
    }

    public int[] getPixelColors() {
        return this.pixelColors;
    }

    public void setPixelColors(int index, int pixelColors) {
        this.pixelColors[index] = pixelColors;
    }

    public void setPixelColors(int[] pixelColors) {
        this.pixelColors = pixelColors;
    }

    public int getZoomRectX() {
        return this.zoomRectX;
    }

    public void setZoomRectX(int zoomRectX) {
        this.zoomRectX = zoomRectX;
    }

    public int getZoomRectY() {
        return this.zoomRectY;
    }

    public void setZoomRectY(int zoomRectY) {
        this.zoomRectY = zoomRectY;
    }

    public int getZoomRectHeight() {
        return this.zoomRectHeight;
    }

    public void setZoomRectHeight(int zoomRectHeight) {
        this.zoomRectHeight = zoomRectHeight;
    }

    public int getZoomRectWidth() {
        return this.zoomRectWidth;
    }

    public void setZoomRectWidth(int zoomRectWidth) {
        this.zoomRectWidth = zoomRectWidth;
    }

    public int getMinZoomPixels() {
        return this.minZoomPixels;
    }

    public void setMinZoomPixels(int minZoomPixels) {
        this.minZoomPixels = minZoomPixels;
    }

    public NumberLabel getNumberLabel() {
        return this.numberLabel;
    }

    public void setNumberLabel(NumberLabel numberLabel) {
        this.numberLabel = numberLabel;
    }

    public double[] getDomainRange() {
        return this.domainRange;
    }

    public void setDomainRange(double[] domainRange) {
        this.domainRange = domainRange;
        this.xMin = domainRange[0];
        this.xMax = domainRange[1];
        this.yMin = domainRange[2];
        this.yMax = domainRange[3];
        this.locateAxes();
    }

    public NumberLabel getYMaxLabel() {
        return this.yMaxLabel;
    }

    public void setYMaxLabel(NumberLabel yMaxLabel) {
        this.yMaxLabel = yMaxLabel;
    }

    public NumberLabel getYMinLabel() {
        return this.yMinLabel;
    }

    public void setYMinLabel(NumberLabel yMinLabel) {
        this.yMinLabel = yMinLabel;
    }

    public NumberLabel getXMaxLabel() {
        return this.xMaxLabel;
    }

    public void setXMaxLabel(NumberLabel xMaxLabel) {
        this.xMaxLabel = xMaxLabel;
    }

    public NumberLabel getXMinLabel() {
        return this.xMinLabel;
    }

    public void setXMinLabel(NumberLabel xMinLabel) {
        this.xMinLabel = xMinLabel;
    }

    public DoubleField getXMinField() {
        return this.xMinField;
    }

    public void setXMinField(DoubleField xMinField) {
        this.xMinField = xMinField;
    }

    public DoubleField getXMaxField() {
        return this.xMaxField;
    }

    public void setXMaxField(DoubleField xMaxField) {
        this.xMaxField = xMaxField;
    }

    public DoubleField getYMinField() {
        return this.yMinField;
    }

    public void setYMinField(DoubleField yMinField) {
        this.yMinField = yMinField;
    }

    public DoubleField getYMaxField() {
        return this.yMaxField;
    }

    public void setYMaxField(DoubleField yMaxField) {
        this.yMaxField = yMaxField;
    }

    public void registerObjects(double[] domainRange, DoubleField xMinField, DoubleField xMaxField, DoubleField yMinField, DoubleField yMaxField) {
        this.setDomainRange(domainRange);
        this.xMinField = xMinField;
        this.xMaxField = xMaxField;
        this.yMinField = yMinField;
        this.yMaxField = yMaxField;
    }

    public void updateRegisteredObjects() {
        if (this.domainRange != null) {
            this.domainRange[0] = this.xMin;
            this.domainRange[1] = this.xMax;
            this.domainRange[2] = this.yMin;
            this.domainRange[3] = this.yMax;
        }
        if (this.xMinField != null) {
            this.xMinField.setDoubleText(this.xMin);
            this.xMinField.setDoubleVal(this.xMin);
        }
        if (this.xMinLabel != null) {
            this.xMinLabel.setDoubleText(this.xMin);
        }
        if (this.xMaxField != null) {
            this.xMaxField.setDoubleText(this.xMax);
            this.xMaxField.setDoubleVal(this.xMax);
        }
        if (this.xMaxLabel != null) {
            this.xMaxLabel.setDoubleText(this.xMax);
        }
        if (this.yMinField != null) {
            this.yMinField.setDoubleText(this.yMin);
            this.yMinField.setDoubleVal(this.yMin);
        }
        if (this.yMinLabel != null) {
            this.yMinLabel.setDoubleText(this.yMin);
        }
        if (this.yMaxField != null) {
            this.yMaxField.setDoubleText(this.yMax);
            this.yMaxField.setDoubleVal(this.yMax);
        }
        if (this.yMaxLabel != null) {
            this.yMaxLabel.setDoubleText(this.yMax);
        }
    }

    public void zoomIn(int direction) {
        double xWidth = this.xMax - this.xMin;
        double yHeight = this.yMax - this.yMin;
        if (direction == 0 || direction == 2) {
            this.xMin = this.zoomCenterX - (this.zoomCenterX - this.xMin) / Math.pow(2.0, this.zoomMagnitude);
            this.xMax = this.zoomCenterX - (this.zoomCenterX - this.xMax) / Math.pow(2.0, this.zoomMagnitude);
        }
        if (direction == 1 || direction == 2) {
            this.yMin = this.zoomCenterY - (this.zoomCenterY - this.yMin) / Math.pow(2.0, this.zoomMagnitude);
            this.yMax = this.zoomCenterY - (this.zoomCenterY - this.yMax) / Math.pow(2.0, this.zoomMagnitude);
        }
        this.locateAxes();
        this.updateRegisteredObjects();
    }

    public void zoomOut(int direction) {
        double xWidth = this.xMax - this.xMin;
        double yHeight = this.yMax - this.yMin;
        if (direction == 0 || direction == 2) {
            this.xMin = this.zoomCenterX - (this.zoomCenterX - this.xMin) * Math.pow(2.0, this.zoomMagnitude);
            this.xMax = this.zoomCenterX - (this.zoomCenterX - this.xMax) * Math.pow(2.0, this.zoomMagnitude);
        }
        if (direction == 1 || direction == 2) {
            this.yMin = this.zoomCenterY - (this.zoomCenterY - this.yMin) * Math.pow(2.0, this.zoomMagnitude);
            this.yMax = this.zoomCenterY - (this.zoomCenterY - this.yMax) * Math.pow(2.0, this.zoomMagnitude);
        }
        this.locateAxes();
        this.updateRegisteredObjects();
    }

    public double getZoomMagnitude() {
        return this.zoomMagnitude;
    }

    public void setZoomMagnitude(double zoomMagnitude) {
        this.zoomMagnitude = zoomMagnitude;
    }

    public double getZoomCenterX() {
        return this.zoomCenterX;
    }

    public void setZoomCenterX(double zoomCenterX) {
        this.zoomCenterX = zoomCenterX;
    }

    public double getZoomCenterY() {
        return this.zoomCenterY;
    }

    public void setZoomCenterY(double zoomCenterY) {
        this.zoomCenterY = zoomCenterY;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }
}

