/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.functionparser;

import com.jimrolf.complex.Complex;
import org.lsmp.djep.djep.DJep;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Factorial;

public class FunctionParser {
    private boolean implicitMultiplication = true;
    private DJep funcParser = null;
    private DJep derivParser = null;
    private String funcInput = null;
    private String variable = null;
    private String[] variables = null;
    private boolean multiDimensional = false;
    private boolean useAllVariables = false;
    private double variableValue = 0.0;
    private String derivInput = null;
    private boolean funcHasError = false;
    private boolean derivHasError = false;
    private String funcErrorInfo = null;
    private String derivErrorInfo = null;
    private String constantName = null;
    private double constantValue = 0.0;
    private int whichDeriv = 0;
    private boolean complex;

    public FunctionParser() {
        this.funcParser = new DJep();
        this.funcParser.addStandardFunctions();
        this.funcParser.addStandardConstants();
        this.funcParser.setAllowUndeclared(true);
        this.funcParser.setAllowAssignment(true);
        this.funcParser.setImplicitMul(true);
        this.funcParser.addStandardDiffRules();
        this.funcParser.addFunction("fact", new Factorial());
        this.derivParser = new DJep();
        this.derivParser.addStandardFunctions();
        this.derivParser.addStandardConstants();
        this.derivParser.setAllowUndeclared(true);
        this.derivParser.setAllowAssignment(true);
        this.derivParser.setImplicitMul(true);
        this.derivParser.addStandardDiffRules();
        this.derivParser.addFunction("fact", new Factorial());
        this.variable = "x";
    }

    public FunctionParser(String funcInput, String variable) {
        this.funcInput = funcInput;
        this.variable = variable;
        this.funcParser = new DJep();
        this.funcParser.addStandardFunctions();
        this.funcParser.addStandardConstants();
        this.funcParser.setAllowUndeclared(true);
        this.funcParser.setAllowAssignment(true);
        this.funcParser.setImplicitMul(true);
        this.funcParser.addStandardDiffRules();
        this.funcParser.addFunction("fact", new Factorial());
        this.derivParser = new DJep();
        this.derivParser.addStandardFunctions();
        this.derivParser.addStandardConstants();
        this.derivParser.setAllowUndeclared(true);
        this.derivParser.setAllowAssignment(true);
        this.derivParser.setImplicitMul(true);
        this.derivParser.addStandardDiffRules();
        this.derivParser.addFunction("fact", new Factorial());
        this.parseExpression(funcInput);
    }

    public FunctionParser(String funcInput, String[] variables) {
        this.funcInput = funcInput;
        this.variables = variables;
        this.multiDimensional = true;
        this.funcParser = new DJep();
        this.funcParser.addStandardFunctions();
        this.funcParser.addStandardConstants();
        this.funcParser.setAllowUndeclared(true);
        this.funcParser.setAllowAssignment(true);
        this.funcParser.setImplicitMul(true);
        this.funcParser.addStandardDiffRules();
        this.funcParser.addFunction("fact", new Factorial());
        this.derivParser = new DJep();
        this.derivParser.addStandardFunctions();
        this.derivParser.addStandardConstants();
        this.derivParser.setAllowUndeclared(true);
        this.derivParser.setAllowAssignment(true);
        this.derivParser.setImplicitMul(true);
        this.derivParser.addStandardDiffRules();
        this.derivParser.addFunction("fact", new Factorial());
        this.parseExpression(funcInput);
    }

    public void simplifyFunc() {
        try {
            this.funcInput = this.funcParser.toString(this.funcParser.simplify(this.funcParser.parse(this.funcInput)));
        }
        catch (ParseException e) {
            this.funcHasError = true;
        }
        this.funcParser.addVariable(this.variable, 0.0);
        this.funcParser.parseExpression(this.funcInput);
    }

    public void parseExpression() {
        this.derivInput = this.funcInput;
        this.funcHasError = false;
        this.funcErrorInfo = null;
        this.derivHasError = false;
        this.derivErrorInfo = null;
        if (this.useAllVariables) {
            this.funcParser.addVariable(this.variable, 0.0);
            this.derivParser.addVariable(this.variable, 0.0);
            for (int i = 0; i <= this.variables.length - 1; ++i) {
                this.funcParser.addVariable(this.variables[i], 0.0);
                this.derivParser.addVariable(this.variables[i], 0.0);
            }
        } else if (this.multiDimensional) {
            for (int i = 0; i <= this.variables.length - 1; ++i) {
                this.funcParser.addVariable(this.variables[i], 0.0);
                this.derivParser.addVariable(this.variables[i], 0.0);
            }
        } else {
            this.funcParser.addVariable(this.variable, 0.0);
            this.derivParser.addVariable(this.variable, 0.0);
        }
        this.funcParser.parseExpression(this.funcInput);
        if (this.funcParser.getErrorInfo() != null) {
            this.funcHasError = true;
            this.funcErrorInfo = this.funcParser.getErrorInfo();
        }
        this.derivParser.parseExpression(this.derivInput);
        if (this.derivParser.getErrorInfo() != null) {
            this.derivHasError = true;
            this.derivErrorInfo = this.derivParser.getErrorInfo();
        }
    }

    public void parseExpression(String funcInput) {
        this.funcInput = funcInput;
        this.derivInput = funcInput;
        this.funcHasError = false;
        this.funcErrorInfo = null;
        this.derivHasError = false;
        this.derivErrorInfo = null;
        if (this.useAllVariables) {
            this.funcParser.addVariable(this.variable, 0.0);
            this.derivParser.addVariable(this.variable, 0.0);
            for (int i = 0; i <= this.variables.length - 1; ++i) {
                this.funcParser.addVariable(this.variables[i], 0.0);
                this.derivParser.addVariable(this.variables[i], 0.0);
            }
        } else if (this.multiDimensional) {
            for (int i = 0; i <= this.variables.length - 1; ++i) {
                this.funcParser.addVariable(this.variables[i], 0.0);
                this.derivParser.addVariable(this.variables[i], 0.0);
            }
        } else {
            this.funcParser.addVariable(this.variable, 0.0);
            this.derivParser.addVariable(this.variable, 0.0);
        }
        this.funcParser.parseExpression(funcInput);
        if (this.funcParser.getErrorInfo() != null) {
            this.funcHasError = true;
            this.funcErrorInfo = this.funcParser.getErrorInfo();
        }
        this.derivParser.parseExpression(this.derivInput);
        if (this.derivParser.getErrorInfo() != null) {
            this.derivHasError = true;
            this.derivErrorInfo = this.derivParser.getErrorInfo();
        }
    }

    public double evalFunc(double x) {
        this.funcParser.addVariable(this.variable, x);
        return this.funcParser.getValue();
    }

    public double evalFunc(double x, double y) {
        this.funcParser.addVariable(this.variables[0], x);
        this.funcParser.addVariable(this.variables[1], y);
        return this.funcParser.getValue();
    }

    public Complex evalFunc(Complex z) {
        this.funcParser.addVariable(this.variable, z);
        return this.funcParser.getComplexValue();
    }

    public double evalFunc(int x) {
        this.funcParser.addVariable(this.variable, x);
        return this.funcParser.getValue();
    }

    public double evalFunc(double[] variableVals) {
        for (int i = 0; i <= variableVals.length - 1; ++i) {
            this.funcParser.addVariable(this.variables[i], variableVals[i]);
        }
        return this.funcParser.getValue();
    }

    public double evalFunc(double t, double[] variableVals) {
        this.funcParser.addVariable(this.variable, t);
        for (int i = 0; i <= variableVals.length - 1; ++i) {
            this.funcParser.addVariable(this.variables[i], variableVals[i]);
        }
        return this.funcParser.getValue();
    }

    public void setImplicitMultiplication(boolean value) {
        this.funcParser.setImplicitMul(value);
        this.implicitMultiplication = value;
    }

    public boolean getImplicitMultiplication() {
        return this.implicitMultiplication;
    }

    public void setVariable(String variable) {
        this.variable = variable;
        this.multiDimensional = false;
        this.funcParser.addVariable(variable, 0.0);
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariables(String[] variables) {
        this.variables = variables;
        this.multiDimensional = true;
        for (int i = 0; i <= variables.length - 1; ++i) {
            this.funcParser.addVariable(variables[i], 0.0);
        }
    }

    public void setVariables(String variable, String[] variables) {
        this.variable = variable;
        this.variables = variables;
        this.multiDimensional = false;
        this.useAllVariables = true;
        this.funcParser.addVariable(variable, 0.0);
        for (int i = 0; i <= variables.length - 1; ++i) {
            this.funcParser.addVariable(variables[i], 0.0);
        }
    }

    public void removeVariable(String variable) {
        this.funcParser.removeVariable(variable);
    }

    public void removeVariables(String[] variables) {
        for (int i = 0; i <= variables.length - 1; ++i) {
            this.funcParser.removeVariable(variables[i]);
        }
    }

    public void removeVariables(String variable, String[] variables) {
        this.funcParser.removeVariable(variable);
        for (int i = 0; i <= variables.length - 1; ++i) {
            this.funcParser.removeVariable(variables[i]);
        }
    }

    public String[] getVariables() {
        return this.variables;
    }

    public void setVariableValue(double variableValue) {
        this.variableValue = variableValue;
    }

    public double getVariableValue() {
        return this.variableValue;
    }

    public boolean funcHasError() {
        return this.funcParser.hasError();
    }

    public String getFuncErrorInfo() {
        return this.funcParser.getErrorInfo();
    }

    public boolean derivHasError() {
        return this.derivHasError;
    }

    public String getDerivErrorInfo() {
        return this.derivParser.getErrorInfo();
    }

    public int getWhichDeriv() {
        return this.whichDeriv;
    }

    public void computeDeriv() {
        try {
            this.derivInput = this.funcParser.toString(this.funcParser.simplify(this.funcParser.differentiate(this.funcParser.parse(this.derivInput), this.variable)));
        }
        catch (ParseException e) {
            this.derivHasError = true;
        }
        this.derivParser.addVariable(this.variable, 0.0);
        this.derivParser.parseExpression(this.derivInput);
        ++this.whichDeriv;
    }

    public String getDeriv() {
        return this.derivInput;
    }

    public double evalDeriv(double x) {
        this.derivParser.addVariable(this.variable, x);
        return this.derivParser.getValue();
    }

    public Complex evalDeriv(Complex z) {
        this.derivParser.addVariable(this.variable, z);
        return this.derivParser.getComplexValue();
    }

    public double evalDeriv(int x) {
        this.derivParser.addVariable(this.variable, x);
        return this.derivParser.getValue();
    }

    public boolean funcHasVariable(String testVariable) {
        boolean val = false;
        this.funcParser.removeVariable(testVariable);
        this.funcParser.parseExpression(this.funcInput);
        if (this.funcParser.getVar(testVariable) != null) {
            val = true;
            this.funcParser.addVariable(testVariable, 0.0);
        }
        return val;
    }

    public void setUseAllVariables(boolean useAllVariables) {
        this.useAllVariables = useAllVariables;
    }

    public boolean getUseAllVariables() {
        return this.useAllVariables;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public void setComplex(boolean complex) {
        this.complex = complex;
        if (complex) {
            this.funcParser.addComplex();
            this.derivParser.addComplex();
        }
    }

    public void setFuncInput(String funcInput) {
        this.funcInput = funcInput;
    }

    public String getFuncInput() {
        return this.funcInput;
    }

    public void setDerivInput(String derivInput) {
        this.derivInput = derivInput;
    }

    public String getDerivInput() {
        return this.derivInput;
    }

    public void removeConstant(String constantName) {
        this.funcParser.removeVariable(constantName);
        this.constantName = null;
    }

    public void setConstant(String constantName, double constantValue) {
        this.constantName = constantName;
        this.constantValue = constantValue;
        this.funcParser.addConstant(constantName, constantValue);
    }
}

