/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ToBase
extends PostfixMathCommand {
    int globalBase = -1;
    String prefix = "";

    public ToBase() {
        this.numberOfParameters = -1;
    }

    public ToBase(int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        this.globalBase = base;
        this.numberOfParameters = -1;
    }

    public ToBase(int base, String prefix) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        this.globalBase = base;
        this.numberOfParameters = -1;
        this.prefix = prefix;
    }

    public boolean checkNumberOfParameters(int n) {
        if (this.globalBase == -1) {
            return n == 2 || n == 3;
        }
        return n == 1 || n == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(Stack s) throws ParseException {
        int narg = this.curNumberOfParameters;
        int digits = 0;
        int base = 0;
        if (!this.checkNumberOfParameters(narg)) {
            throw new ParseException("toBase: can only have 1,2 or 3 arguments");
        }
        if (narg == 3 || this.globalBase != -1 && narg == 2) {
            try {
                digits = ((Number)s.pop()).intValue();
            }
            catch (ClassCastException e) {
                throw new ParseException("toBase: last argument should be an integer");
            }
        }
        if (this.globalBase == -1) {
            Object rhs = s.pop();
            if (!(rhs instanceof Number)) throw new ParseException("toBase: second argument should be an integer");
            base = ((Number)rhs).intValue();
        } else {
            base = this.globalBase;
        }
        if (base < 2 || base > 36) {
            throw new ParseException("base must be between 2 and 2");
        }
        Object lhs = s.pop();
        String res = null;
        if (lhs instanceof Integer || lhs instanceof Short || lhs instanceof Long) {
            res = this.toBase(((Number)lhs).longValue(), base);
        } else {
            if (!(lhs instanceof Float) && !(lhs instanceof Double) && !(lhs instanceof Number)) throw new ParseException("toBase: Cannot convert object of type " + lhs.getClass().getName());
            res = this.toBase(((Number)lhs).doubleValue(), base, digits);
        }
        s.push(res);
    }

    public String toBase(long num, int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        if (num < 0L) {
            return '-' + this.prefix + Long.toString(num, base);
        }
        return this.prefix + Long.toString(num, base);
    }

    public String toBase(double val, int base, int digits) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        StringBuffer sb = new StringBuffer();
        if (val < 0.0) {
            val = -val;
            sb.append('-');
        }
        sb.append(this.prefix);
        long round = Math.round(val *= Math.pow(base, digits));
        String s = Long.toString(round, base);
        if (s.length() <= digits) {
            sb.append("0.");
            for (int i = 0; i < digits - s.length(); ++i) {
                sb.append('0');
            }
            sb.append(s);
        } else if (digits > 0) {
            sb.append(s);
            sb.insert(sb.length() - digits, '.');
        } else {
            sb.append(s);
        }
        return sb.toString();
    }
}

