/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep.function;

import java.util.Stack;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommand;

public abstract class SumType
extends PostfixMathCommand
implements CallbackEvaluationI {
    protected String name;

    public SumType(String funName) {
        this.numberOfParameters = -1;
        this.name = funName;
    }

    public SumType() {
        this.numberOfParameters = -1;
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 4 || n == 5;
    }

    public Object evaluate(Node node, EvaluatorI pv) throws ParseException {
        int numParams = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(numParams)) {
            throw new ParseException(this.name + ": called with invalid number of parameters: " + numParams + " it should be either 4 or 5.");
        }
        Node varNode = node.jjtGetChild(1);
        Variable var = null;
        if (!(varNode instanceof ASTVarNode)) {
            throw new ParseException(this.name + ": second argument should be a variable");
        }
        var = ((ASTVarNode)varNode).getVar();
        Object minObj = pv.eval(node.jjtGetChild(2));
        if (!(minObj instanceof Number)) {
            throw new ParseException(this.name + ": third argument (min) should evaluate to a number it is " + minObj.toString());
        }
        double min = ((Number)minObj).doubleValue();
        Object maxObj = pv.eval(node.jjtGetChild(3));
        if (!(maxObj instanceof Number)) {
            throw new ParseException(this.name + ": forth argument (max) should evaluate to a number it is " + minObj.toString());
        }
        double max = ((Number)maxObj).doubleValue();
        if (min > max) {
            throw new ParseException(this.name + ": min value should be smaller than max value they are " + min + " and " + max + ".");
        }
        if (numParams == 5) {
            Object incObj = pv.eval(node.jjtGetChild(4));
            if (!(incObj instanceof Number)) {
                throw new ParseException(this.name + ": fifth argument (steps) should evaluate to a number it is " + minObj.toString());
            }
            double inc = ((Number)incObj).doubleValue();
            return this.evaluate(node.jjtGetChild(0), var, min, max, inc, pv);
        }
        return this.evaluate(node.jjtGetChild(0), var, min, max, 1.0, pv);
    }

    public Object evaluate(Node node, Variable var, double min, double max, double inc, EvaluatorI pv) throws ParseException {
        int i = 0;
        Object[] res = new Object[(int)((max - min) / inc) + 1];
        i = 0;
        double val = min;
        while (val <= max) {
            var.setValue(new Double(val));
            res[i] = pv.eval(node);
            val = min + (double)(++i) * inc;
        }
        Object ret = this.evaluate(res);
        return ret;
    }

    public abstract Object evaluate(Object[] var1) throws ParseException;

    public void run(Stack s) throws ParseException {
        throw new ParseException(this.name + ": run method called should not normally happen.");
    }
}

