/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.PartialDerivative;
import org.lsmp.djep.xjep.PrintVisitor;
import org.lsmp.djep.xjep.XVariable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DVariable
extends XVariable {
    protected Hashtable derivatives = new Hashtable();

    protected PartialDerivative createDerivative(String[] derivnames, Node eqn) {
        return new PartialDerivative(this, derivnames, eqn);
    }

    protected DVariable(String name) {
        super(name);
    }

    protected DVariable(String name, Object value) {
        super(name, value);
    }

    public void setEquation(Node eqn) {
        super.setEquation(eqn);
        this.derivatives.clear();
    }

    public void invalidateAll() {
        if (this.isConstant()) {
            return;
        }
        this.setValidValue(false);
        Enumeration e = this.derivatives.elements();
        while (e.hasMoreElements()) {
            PartialDerivative deriv = (PartialDerivative)e.nextElement();
            deriv.setValidValue(false);
        }
    }

    public static String makeDerivString(String rootname, String[] dnames) {
        StringBuffer sb = new StringBuffer();
        sb.append('d');
        if (dnames.length != 1) {
            sb.append("^" + dnames.length);
        }
        sb.append(rootname);
        sb.append('/');
        for (int i = 0; i < dnames.length; ++i) {
            sb.append('d');
            sb.append(dnames[i]);
        }
        return sb.toString();
    }

    private String[] sortedNames(String[] names) {
        Object[] newnames = new String[names.length];
        System.arraycopy(names, 0, newnames, 0, names.length);
        Arrays.sort(newnames);
        return newnames;
    }

    void setDerivative(String[] derivnames, PartialDerivative eqn) {
        String[] newnames = this.sortedNames(derivnames);
        this.derivatives.put(DVariable.makeDerivString(this.name, newnames), eqn);
    }

    void setDerivativeSorted(String[] derivnames, PartialDerivative eqn) {
        this.derivatives.put(DVariable.makeDerivString(this.name, derivnames), eqn);
    }

    PartialDerivative getDerivative(String[] derivnames) {
        String[] newnames = this.sortedNames(derivnames);
        return (PartialDerivative)this.derivatives.get(DVariable.makeDerivString(this.name, newnames));
    }

    PartialDerivative getDerivativeSorted(String[] derivnames) {
        return (PartialDerivative)this.derivatives.get(DVariable.makeDerivString(this.name, derivnames));
    }

    PartialDerivative findDerivativeSorted(String[] derivnames, DJep jep) throws ParseException {
        Node lowereqn;
        if (this.getEquation() == null) {
            return null;
        }
        if (derivnames == null) {
            throw new ParseException("findDerivativeSorted: Null array of names");
        }
        PartialDerivative res = this.getDerivativeSorted(derivnames);
        if (res != null) {
            return res;
        }
        int origlen = derivnames.length;
        if (origlen < 1) {
            throw new ParseException("findDerivativeSorted: Empty Array of names");
        }
        if (origlen == 1) {
            lowereqn = this.getEquation();
        } else {
            String[] newnames = new String[origlen - 1];
            for (int i = 0; i < origlen - 1; ++i) {
                newnames[i] = derivnames[i];
            }
            lowereqn = this.findDerivativeSorted(newnames, jep).getEquation();
        }
        if (lowereqn == null) {
            return null;
        }
        Node deriv = jep.differentiate(lowereqn, derivnames[origlen - 1]);
        Node simp = jep.simplify(deriv);
        res = this.createDerivative(derivnames, simp);
        this.setDerivative(derivnames, res);
        return res;
    }

    PartialDerivative findDerivative(String[] derivnames, DJep jep) throws ParseException {
        String[] newnames = this.sortedNames(derivnames);
        return this.findDerivativeSorted(newnames, jep);
    }

    PartialDerivative findDerivative(String derivname, DJep jep) throws ParseException {
        String[] newnames = new String[]{derivname};
        return this.findDerivativeSorted(newnames, jep);
    }

    PartialDerivative findDerivative(PartialDerivative deriv, String dname, DJep jep) throws ParseException {
        int len = deriv.getDnames().length;
        String[] newnames = new String[len + 1];
        System.arraycopy(deriv.getDnames(), 0, newnames, 0, len);
        newnames[len] = dname;
        return this.findDerivative(newnames, jep);
    }

    public String toString(PrintVisitor bpv) {
        boolean mode = bpv.getMode(32);
        bpv.setMode(32, false);
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(":\t");
        if (this.hasValidValue()) {
            sb.append(this.getValue());
        } else {
            sb.append("NA");
        }
        sb.append("\t");
        if (this.isConstant()) {
            sb.append("constant");
        } else if (this.getEquation() != null) {
            sb.append("eqn " + bpv.toString(this.getEquation()));
        } else {
            sb.append("no equation");
        }
        Enumeration e = this.derivatives.elements();
        while (e.hasMoreElements()) {
            sb.append("\n");
            PartialDerivative var = (PartialDerivative)e.nextElement();
            sb.append("\t" + var.toString() + ": ");
            if (var.hasValidValue()) {
                sb.append(var.getValue());
            } else {
                sb.append("NA");
            }
            sb.append("\t");
            sb.append(bpv.toString(var.getEquation()));
        }
        bpv.setMode(32, mode);
        return sb.toString();
    }

    public Enumeration allDerivatives() {
        return this.derivatives.elements();
    }
}

