/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.zoompanel;

import com.jimrolf.datagrapher2d.DataGrapher2D;
import com.jimrolf.functionfield.DoubleField;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ZoomPanelVertical
extends JPanel {
    private JLabel commaLabel;
    private JLabel leftParenthesisLabel;
    private JLabel rightParenthesisLabel;
    private DoubleField xCenterField;
    private DoubleField yCenterField;
    private JRadioButton zoomBothButton;
    private JRadioButton zoomCenterBoxButton;
    private JRadioButton zoomCenterCursorButton;
    private ButtonGroup zoomCenterGroup;
    private JPanel zoomCenterPanel;
    private ButtonGroup zoomDirectionGroup;
    private JPanel zoomDirectionPanel;
    private JRadioButton zoomInButton;
    private ButtonGroup zoomInOutGroup;
    private JPanel zoomInOutPanel;
    private JRadioButton zoomOutButton;
    private JRadioButton zoomXButton;
    private JRadioButton zoomYButton;

    public ZoomPanelVertical() {
        this.initComponents();
        this.setSize(404, 84);
    }

    public void zoom(MouseEvent evt, DataGrapher2D grapher1, double[] domainRange, DoubleField xMinField, DoubleField xMaxField, DoubleField yMinField, DoubleField yMaxField) {
        boolean noProblems = true;
        double xCenter = 0.0;
        double yCenter = 0.0;
        double xWidth = 0.0;
        double yHeight = 0.0;
        if (this.zoomCenterCursorButton.isSelected()) {
            xCenter = grapher1.getXVal(evt.getX());
            yCenter = grapher1.getYVal(evt.getY());
            this.xCenterField.setDoubleText(xCenter);
            this.yCenterField.setDoubleText(yCenter);
        } else {
            if (this.xCenterField.hasError()) {
                noProblems = false;
            } else {
                xCenter = this.xCenterField.getDoubleVal();
            }
            if (this.yCenterField.hasError()) {
                noProblems = false;
            } else {
                yCenter = this.yCenterField.getDoubleVal();
            }
        }
        if (noProblems) {
            xWidth = domainRange[1] - domainRange[0];
            yHeight = domainRange[3] - domainRange[2];
            if (this.zoomInButton.isSelected()) {
                if (this.zoomBothButton.isSelected()) {
                    domainRange[0] = xCenter - xWidth / 4.0;
                    domainRange[1] = xCenter + xWidth / 4.0;
                    domainRange[2] = yCenter - yHeight / 4.0;
                    domainRange[3] = yCenter + yHeight / 4.0;
                }
                if (this.zoomXButton.isSelected()) {
                    domainRange[0] = xCenter - xWidth / 4.0;
                    domainRange[1] = xCenter + xWidth / 4.0;
                }
                if (this.zoomYButton.isSelected()) {
                    domainRange[2] = yCenter - yHeight / 4.0;
                    domainRange[3] = yCenter + yHeight / 4.0;
                }
            } else {
                if (this.zoomBothButton.isSelected()) {
                    domainRange[0] = xCenter - xWidth * 1.5;
                    domainRange[1] = xCenter + xWidth * 1.5;
                    domainRange[2] = yCenter - yHeight * 1.5;
                    domainRange[3] = yCenter + yHeight * 1.5;
                }
                if (this.zoomXButton.isSelected()) {
                    domainRange[0] = xCenter - xWidth * 1.5;
                    domainRange[1] = xCenter + xWidth * 1.5;
                }
                if (this.zoomYButton.isSelected()) {
                    domainRange[2] = yCenter - yHeight * 1.5;
                    domainRange[3] = yCenter + yHeight * 1.5;
                }
            }
        }
        xMinField.setDoubleText(domainRange[0]);
        xMinField.setDoubleVal(domainRange[0]);
        grapher1.setXMin(domainRange[0]);
        xMaxField.setText("" + domainRange[1]);
        xMaxField.setDoubleVal(domainRange[1]);
        grapher1.setXMax(domainRange[1]);
        yMinField.setText("" + domainRange[2]);
        yMinField.setDoubleVal(domainRange[2]);
        grapher1.setYMin(domainRange[2]);
        yMaxField.setText("" + domainRange[3]);
        yMaxField.setDoubleVal(domainRange[3]);
        grapher1.setYMax(domainRange[3]);
    }

    private void initComponents() {
        this.zoomInOutGroup = new ButtonGroup();
        this.zoomDirectionGroup = new ButtonGroup();
        this.zoomCenterGroup = new ButtonGroup();
        this.zoomInOutPanel = new JPanel();
        this.zoomInButton = new JRadioButton();
        this.zoomOutButton = new JRadioButton();
        this.zoomDirectionPanel = new JPanel();
        this.zoomXButton = new JRadioButton();
        this.zoomYButton = new JRadioButton();
        this.zoomBothButton = new JRadioButton();
        this.zoomCenterPanel = new JPanel();
        this.zoomCenterCursorButton = new JRadioButton();
        this.zoomCenterBoxButton = new JRadioButton();
        this.leftParenthesisLabel = new JLabel();
        this.commaLabel = new JLabel();
        this.rightParenthesisLabel = new JLabel();
        this.xCenterField = new DoubleField();
        this.yCenterField = new DoubleField();
        this.setLayout(null);
        this.setBackground(Color.white);
        this.zoomInOutPanel.setLayout(null);
        this.zoomInOutPanel.setBackground(new Color(255, 255, 255));
        this.zoomInOutPanel.setBorder(BorderFactory.createEtchedBorder());
        this.zoomInButton.setBackground(new Color(255, 255, 255));
        this.zoomInOutGroup.add(this.zoomInButton);
        this.zoomInButton.setFont(new Font("LucidaSans", 1, 10));
        this.zoomInButton.setSelected(true);
        this.zoomInButton.setText("Zoom In");
        this.zoomInOutPanel.add(this.zoomInButton);
        this.zoomInButton.setBounds(1, 1, 66, 15);
        this.zoomOutButton.setBackground(new Color(255, 255, 255));
        this.zoomInOutGroup.add(this.zoomOutButton);
        this.zoomOutButton.setFont(new Font("LucidaSans", 1, 10));
        this.zoomOutButton.setText("Zoom Out");
        this.zoomInOutPanel.add(this.zoomOutButton);
        this.zoomOutButton.setBounds(66, 1, 75, 15);
        this.add(this.zoomInOutPanel);
        this.zoomInOutPanel.setBounds(0, 0, 322, 18);
        this.zoomDirectionPanel.setLayout(null);
        this.zoomDirectionPanel.setBackground(new Color(255, 255, 255));
        this.zoomDirectionPanel.setBorder(BorderFactory.createEtchedBorder());
        this.zoomXButton.setBackground(new Color(255, 255, 255));
        this.zoomDirectionGroup.add(this.zoomXButton);
        this.zoomXButton.setFont(new Font("LucidaSans", 1, 10));
        this.zoomXButton.setText("Zoom x direction only");
        this.zoomDirectionPanel.add(this.zoomXButton);
        this.zoomXButton.setBounds(1, 16, 136, 15);
        this.zoomYButton.setBackground(new Color(255, 255, 255));
        this.zoomDirectionGroup.add(this.zoomYButton);
        this.zoomYButton.setFont(new Font("LucidaSans", 1, 10));
        this.zoomYButton.setText("Zoom y direction only");
        this.zoomDirectionPanel.add(this.zoomYButton);
        this.zoomYButton.setBounds(137, 16, 136, 15);
        this.zoomBothButton.setBackground(new Color(255, 255, 255));
        this.zoomDirectionGroup.add(this.zoomBothButton);
        this.zoomBothButton.setFont(new Font("LucidaSans", 1, 10));
        this.zoomBothButton.setSelected(true);
        this.zoomBothButton.setText("Zoom both directions");
        this.zoomDirectionPanel.add(this.zoomBothButton);
        this.zoomBothButton.setBounds(1, 1, 135, 15);
        this.add(this.zoomDirectionPanel);
        this.zoomDirectionPanel.setBounds(0, 18, 322, 33);
        this.zoomCenterPanel.setLayout(null);
        this.zoomCenterPanel.setBackground(new Color(255, 255, 255));
        this.zoomCenterPanel.setBorder(BorderFactory.createEtchedBorder());
        this.zoomCenterCursorButton.setBackground(new Color(255, 255, 255));
        this.zoomCenterGroup.add(this.zoomCenterCursorButton);
        this.zoomCenterCursorButton.setFont(new Font("LucidaSans", 1, 10));
        this.zoomCenterCursorButton.setSelected(true);
        this.zoomCenterCursorButton.setText("Center zoom at cursor");
        this.zoomCenterPanel.add(this.zoomCenterCursorButton);
        this.zoomCenterCursorButton.setBounds(145, 1, 141, 15);
        this.zoomCenterBoxButton.setBackground(new Color(255, 255, 255));
        this.zoomCenterGroup.add(this.zoomCenterBoxButton);
        this.zoomCenterBoxButton.setFont(new Font("LucidaSans", 1, 10));
        this.zoomCenterBoxButton.setText("Center zoom at default");
        this.zoomCenterPanel.add(this.zoomCenterBoxButton);
        this.zoomCenterBoxButton.setBounds(1, 1, 144, 15);
        this.leftParenthesisLabel.setHorizontalAlignment(0);
        this.leftParenthesisLabel.setText("(");
        this.zoomCenterPanel.add(this.leftParenthesisLabel);
        this.leftParenthesisLabel.setBounds(69, 15, 4, 15);
        this.commaLabel.setHorizontalAlignment(0);
        this.commaLabel.setText(",");
        this.zoomCenterPanel.add(this.commaLabel);
        this.commaLabel.setBounds(137, 15, 3, 15);
        this.rightParenthesisLabel.setHorizontalAlignment(0);
        this.rightParenthesisLabel.setText(")");
        this.zoomCenterPanel.add(this.rightParenthesisLabel);
        this.rightParenthesisLabel.setBounds(203, 15, 4, 15);
        this.xCenterField.setBackground(new Color(242, 242, 251));
        this.xCenterField.setFont(new Font("LucidaSans", 0, 10));
        this.zoomCenterPanel.add(this.xCenterField);
        this.xCenterField.setBounds(75, 17, 60, 15);
        this.yCenterField.setBackground(new Color(242, 242, 251));
        this.yCenterField.setFont(new Font("LucidaSans", 0, 10));
        this.zoomCenterPanel.add(this.yCenterField);
        this.yCenterField.setBounds(141, 17, 60, 15);
        this.add(this.zoomCenterPanel);
        this.zoomCenterPanel.setBounds(0, 51, 322, 34);
    }
}

