/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.zoompanel;

import com.jimrolf.convert.Convert;
import com.jimrolf.functionfield.DoubleField;
import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.slider.Slider;
import com.jimrolf.zoompanel.ZoomPanelInterface;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ZoomPanelMethods
implements ZoomPanelInterface {
    private boolean componentIsFocused = false;
    private double xWidth = 0.0;
    private double yHeight = 0.0;
    private int wheelRotation = 0;
    private double newSliderDoubleVal = 0.0;
    private boolean isOkToDragAndSlide = true;
    protected JRadioButton zoomCenterDefaultButton = null;
    protected JRadioButton zoomCenterCursorButton = null;
    protected DoubleField yCenterField = null;
    protected DoubleField xCenterField = null;
    protected Slider zoomSlider = null;
    private Grapher2D grapher = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private double sliderDoubleVal = 0.0;
    private Color fieldColor = new Color(242, 242, 251);
    private JTextField focusField = null;
    protected JRadioButton zoomBothButton = null;
    protected JRadioButton zoomXButton = null;
    protected JRadioButton zoomYButton = null;

    public void xCenterFieldFocusGained(FocusEvent evt) {
        this.setFocusField((JTextField)evt.getSource());
    }

    public void yCenterFieldFocusGained(FocusEvent evt) {
        this.setFocusField((JTextField)evt.getSource());
    }

    public void clearAll() {
        this.clearLabels();
        this.xCenterField.setDoubleText(0.0);
        this.yCenterField.setDoubleText(0.0);
        this.zoomSlider.setDoubleVal(0.0);
    }

    public void zoomByMouseWheel(MouseWheelEvent evt) {
        boolean noProblems = true;
        double xCenter = 0.0;
        double yCenter = 0.0;
        this.clearLabels();
        if (this.zoomCenterCursorButton.isSelected()) {
            xCenter = this.grapher.getXVal(evt.getX());
            yCenter = this.grapher.getYVal(evt.getY());
        } else {
            if (this.xCenterField.hasError()) {
                noProblems = false;
            } else {
                xCenter = this.xCenterField.getDoubleVal();
            }
            if (this.yCenterField.hasError()) {
                noProblems = false;
            } else {
                yCenter = this.yCenterField.getDoubleVal();
            }
        }
        if (noProblems) {
            this.grapher.setZoomCenterX(xCenter);
            this.grapher.setZoomCenterY(yCenter);
            this.wheelRotation = evt.getWheelRotation();
            if (this.wheelRotation > 0) {
                this.grapher.setZoomMagnitude(Convert.toDouble(this.wheelRotation));
                this.zoomOut();
            } else if (this.wheelRotation < 0) {
                this.grapher.setZoomMagnitude(Convert.toDouble(-this.wheelRotation));
                this.zoomIn();
            }
        }
    }

    private void zoomOut() {
        if (this.zoomXButton != null && this.zoomXButton.isSelected()) {
            this.grapher.zoomOut(0);
        } else if (this.zoomYButton != null && this.zoomYButton.isSelected()) {
            this.grapher.zoomOut(1);
        } else {
            this.grapher.zoomOut(2);
        }
    }

    private void zoomIn() {
        if (this.zoomXButton != null && this.zoomXButton.isSelected()) {
            this.grapher.zoomIn(0);
        } else if (this.zoomYButton != null && this.zoomYButton.isSelected()) {
            this.grapher.zoomIn(1);
        } else {
            this.grapher.zoomIn(2);
        }
    }

    public void clearLabels() {
        this.xCenterField.setBackground(this.fieldColor);
        this.yCenterField.setBackground(this.fieldColor);
    }

    public void zoomSliderMouseEntered(MouseEvent evt) {
        this.componentIsFocused = this.zoomSlider.requestFocusInWindow();
        this.isOkToDragAndSlide = true;
        this.clearLabels();
        if (this.xCenterField.hasError()) {
            this.isOkToDragAndSlide = false;
        } else {
            this.grapher.setZoomCenterX(this.xCenterField.getDoubleVal());
        }
        if (this.yCenterField.hasError()) {
            this.isOkToDragAndSlide = false;
        } else {
            this.grapher.setZoomCenterY(this.yCenterField.getDoubleVal());
        }
    }

    public void zoomSliderMouseDragged(MouseEvent evt) {
        if (this.isOkToDragAndSlide) {
            this.newSliderDoubleVal = this.zoomSlider.getDoubleVal(evt);
            if (this.newSliderDoubleVal > this.sliderDoubleVal) {
                this.zoomIn();
                this.focusField = null;
            } else if (this.newSliderDoubleVal < this.sliderDoubleVal) {
                this.zoomOut();
                this.focusField = null;
            }
            this.sliderDoubleVal = this.newSliderDoubleVal;
            this.propertyChangeSupport.firePropertyChange("zoomSliderHasMoved", null, null);
        }
    }

    public void zoomSliderMouseExited(MouseEvent evt) {
        this.componentIsFocused = false;
    }

    public void zoomSliderMouseReleased(MouseEvent evt) {
        this.zoomSlider.setDoubleVal(0.0);
        this.sliderDoubleVal = 0.0;
    }

    public void zoomSliderKeyPressed(KeyEvent evt) {
        if (this.isOkToDragAndSlide) {
            if (this.sliderDoubleVal >= this.zoomSlider.getDoubleMax() || this.sliderDoubleVal <= this.zoomSlider.getDoubleMin()) {
                this.zoomSlider.setDoubleVal(0.0);
            }
            if (evt.getKeyCode() == 37 || evt.getKeyCode() == 226 || evt.getKeyCode() == 40 || evt.getKeyCode() == 225) {
                this.zoomOut();
                this.focusField = null;
                this.sliderDoubleVal -= 1.0;
            }
            if (evt.getKeyCode() == 39 || evt.getKeyCode() == 227 || evt.getKeyCode() == 38 || evt.getKeyCode() == 224) {
                this.zoomIn();
                this.focusField = null;
                this.sliderDoubleVal += 1.0;
            }
            this.propertyChangeSupport.firePropertyChange("zoomSliderHasMoved", null, null);
        }
    }

    public JRadioButton getZoomCenterDefaultButton() {
        return this.zoomCenterDefaultButton;
    }

    public void setZoomCenterDefaultButton(JRadioButton zoomCenterDefaultButton) {
        this.zoomCenterDefaultButton = zoomCenterDefaultButton;
    }

    public JRadioButton getZoomCenterCursorButton() {
        return this.zoomCenterCursorButton;
    }

    public void setZoomCenterCursorButton(JRadioButton zoomCenterCursorButton) {
        this.zoomCenterCursorButton = zoomCenterCursorButton;
    }

    public DoubleField getYCenterField() {
        return this.yCenterField;
    }

    public void setYCenterField(DoubleField yCenterField) {
        this.yCenterField = yCenterField;
    }

    public DoubleField getXCenterField() {
        return this.xCenterField;
    }

    public void setXCenterField(DoubleField xCenterField) {
        this.xCenterField = xCenterField;
    }

    public Slider getZoomSlider() {
        return this.zoomSlider;
    }

    public void setZoomSlider(Slider zoomSlider) {
        this.zoomSlider = zoomSlider;
    }

    public void zoomByClicking(MouseEvent evt) {
        boolean noProblems = true;
        double xCenter = 0.0;
        double yCenter = 0.0;
        if (this.zoomCenterCursorButton.isSelected()) {
            xCenter = this.grapher.getXVal(evt.getX());
            yCenter = this.grapher.getYVal(evt.getY());
        } else {
            if (this.xCenterField.hasError()) {
                noProblems = false;
            } else {
                xCenter = this.xCenterField.getDoubleVal();
            }
            if (this.yCenterField.hasError()) {
                noProblems = false;
            } else {
                yCenter = this.yCenterField.getDoubleVal();
            }
        }
        if (noProblems) {
            this.grapher.setZoomCenterX(xCenter);
            this.grapher.setZoomCenterY(yCenter);
            if (evt.getButton() == 1) {
                this.zoomIn();
            } else if (evt.getButton() == 3) {
                this.zoomOut();
            } else {
                this.zoomIn();
            }
        }
    }

    public Grapher2D getGrapher() {
        return this.grapher;
    }

    public void setGrapher(Grapher2D grapher) {
        this.grapher = grapher;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public Color getFieldColor() {
        return this.fieldColor;
    }

    public void setFieldColor(Color fieldColor) {
        this.fieldColor = fieldColor;
        this.xCenterField.setBackground(fieldColor);
        this.yCenterField.setBackground(fieldColor);
    }

    public JTextField getFocusField() {
        return this.focusField;
    }

    public void setFocusField(JTextField focusField) {
        JTextField oldFocusField = this.focusField;
        this.focusField = focusField;
        this.propertyChangeSupport.firePropertyChange("focusField", oldFocusField, focusField);
    }

    public void register(Grapher2D grapher) {
        this.grapher = grapher;
    }

    public JRadioButton getZoomBothButton() {
        return this.zoomBothButton;
    }

    public void setZoomBothButton(JRadioButton zoomBothButton) {
        this.zoomBothButton = zoomBothButton;
    }

    public JRadioButton getZoomXButton() {
        return this.zoomXButton;
    }

    public void setZoomXButton(JRadioButton zoomXButton) {
        this.zoomXButton = zoomXButton;
    }

    public JRadioButton getZoomYButton() {
        return this.zoomYButton;
    }

    public void setZoomYButton(JRadioButton zoomYButton) {
        this.zoomYButton = zoomYButton;
    }
}

