/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.taggedintpropertyeditor;

import java.beans.PropertyEditorSupport;

public class TaggedIntPropertyEditor
extends PropertyEditorSupport {
    protected TaggedInt[] m_Tags;

    public TaggedIntPropertyEditor() {
    }

    public TaggedIntPropertyEditor(TaggedInt[] tags) {
        this.m_Tags = tags;
    }

    public String[] getTags() {
        String[] tags = new String[this.m_Tags.length];
        for (int i = 0; i < this.m_Tags.length; ++i) {
            tags[i] = this.m_Tags[i].getTag();
        }
        return tags;
    }

    public String getAsText() {
        return this.getValueAsString(true);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        for (int i = 0; i < this.m_Tags.length; ++i) {
            TaggedInt currTag = this.m_Tags[i];
            if (!currTag.getTag().equals(text)) continue;
            this.setValueAsInteger(new Integer(currTag.getValue()));
            return;
        }
        super.setAsText(text);
    }

    protected void setValueAsInteger(Integer newValue) {
        this.setValue(newValue);
    }

    public String getJavaInitializationString() {
        return this.getValueAsString(false);
    }

    protected Integer getValueAsInteger() {
        return (Integer)this.getValue();
    }

    protected String getValueAsString(boolean tag) {
        Integer value = this.getValueAsInteger();
        if (value != null) {
            int intValue = value;
            for (int i = 0; i < this.m_Tags.length; ++i) {
                TaggedInt currTag = this.m_Tags[i];
                if (currTag.getValue() != intValue) continue;
                return tag ? currTag.getTag() : currTag.getInitializationString();
            }
        }
        return "";
    }

    public static class TaggedInt {
        protected String m_Tag;
        protected int m_Value;
        protected String m_InitializationString;

        public TaggedInt(String tag, int value, String initializationString) {
            this.m_Tag = tag;
            this.m_Value = value;
            this.m_InitializationString = initializationString;
        }

        public String getTag() {
            return this.m_Tag;
        }

        public int getValue() {
            return this.m_Value;
        }

        public String getInitializationString() {
            return this.m_InitializationString;
        }
    }
}

