/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.slider;

import com.jimrolf.convert.Convert;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;

public class Slider
extends JSlider {
    private int intMax = 300;
    private int intMin = 0;
    private double doubleMax = 1.0;
    private double doubleMin = 0.0;
    private double doubleVal = 0.5;

    public void setMaximum(int intMax) {
        this.intMax = intMax;
        super.setMaximum(intMax);
    }

    public void setMinimum(int intMin) {
        this.intMin = intMin;
        super.setMinimum(intMin);
    }

    public double getDoubleVal(ChangeEvent evt) {
        this.doubleVal = this.doubleMin + (Convert.toDouble(this.getValue()) - (double)this.intMin) * (this.doubleMax - this.doubleMin) / (double)(this.intMax - this.intMin);
        return this.doubleVal;
    }

    public double getDoubleVal(MouseEvent evt) {
        this.doubleVal = this.doubleMin + (Convert.toDouble(this.getValue()) - (double)this.intMin) * (this.doubleMax - this.doubleMin) / (double)(this.intMax - this.intMin);
        return this.doubleVal;
    }

    public double getDoubleVal(KeyEvent evt) {
        this.doubleVal = this.doubleMin + (Convert.toDouble(this.getValue()) - (double)this.intMin) * (this.doubleMax - this.doubleMin) / (double)(this.intMax - this.intMin);
        return this.doubleVal;
    }

    public Slider() {
        this.setMaximum(300);
        this.setMinimum(0);
        this.setValue(150);
        this.setPreferredSize(new Dimension(100, 20));
        this.setBackground(Color.white);
        this.setFont(new Font("Lucida Sans", 0, 11));
    }

    public double getDoubleMax() {
        return this.doubleMax;
    }

    public void setDoubleMax(double doubleMax) {
        this.doubleMax = doubleMax;
    }

    public double getDoubleMin() {
        return this.doubleMin;
    }

    public void setDoubleMin(double doubleMin) {
        this.doubleMin = doubleMin;
    }

    public double getDoubleVal() {
        return this.doubleVal;
    }

    public void setDoubleVal(double doubleVal) {
        this.doubleVal = doubleVal;
        this.setValue(Convert.toRoundedInt((doubleVal - this.doubleMin) / (this.doubleMax - this.doubleMin) * (double)(this.intMax - this.intMin) + (double)this.intMin));
    }
}

