/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.polytool;

import com.jimrolf.complex.Complex;
import com.jimrolf.datagrapher2d.DataGrapher2D;
import com.jimrolf.domainchoicebox.ComplexDomainChoiceBox;
import com.jimrolf.functionfield.DoubleField;
import com.jimrolf.functionfield.IntField;
import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.numberlabel.NumberLabel;
import com.jimrolf.plotstuff2d.PlotStuff;
import com.jimrolf.plotstuff2d.PlotStuff2D;
import com.jimrolf.plotstuff2d.PolarGrid;
import com.jimrolf.polytool.ArcVertexInfo;
import com.jimrolf.polytool.ArcVertexPanel;
import com.jimrolf.zoompanel.ZoomPanel325x80;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class PolyTool
extends JApplet {
    public static final int SKETCH = 0;
    public static final int CIRC = 1;
    public static final int RECT = 2;
    public static final int ARC = 3;
    public static final int VERTEX = 4;
    private int numInteriorCircles = 0;
    private int defaultNumInteriorCircles = 9;
    private int numRays = 0;
    private double radiusMax = 0.999;
    private double eps = MachineEpsilon.getEpsilon();
    private double cursorX = 0.0;
    private double cursorY = 0.0;
    private boolean polygonHasBeenGraphed = false;
    private boolean componentIsFocused = false;
    private boolean dragging = false;
    private Complex zVal = new Complex();
    private Complex zRange = new Complex();
    private Color backgroundColor = new Color(235, 235, 235);
    private JTextComponent focusField = null;
    private double[] domainDomainRange = new double[]{-1.0, 1.0, -1.0, 1.0};
    private double[] rangeDomainRange = new double[]{-1.0, 1.0, -1.0, 1.0};
    private double[] arcBegin = null;
    private Complex[] vertex = null;
    private int numArcVertexPanels = 0;
    private int numArcs = 0;
    private int numVertices = 0;
    private int currentVertex = 0;
    private PlotStuff2D[] arcPoints = null;
    private double[][] arcPointsDataX = null;
    private double[][] arcPointsDataY = null;
    private int maxNumArcsVertices = 9;
    private PlotStuff[] domainAllData = null;
    private PlotStuff[] rangeAllData = null;
    private int[] rangeOrderTraces = null;
    private Color arcPointPlotColor = Color.BLUE;
    private Color vertexPlotColor = Color.BLUE;
    private PlotStuff2D[] vertexPoints = null;
    private double[][] vertexPointsDataX = null;
    private double[][] vertexPointsDataY = null;
    private ArcVertexPanel[] arcVertexPanels = null;
    private int currentHighlightedPanel = -1;
    private double machEps = MachineEpsilon.getEpsilon();
    private double piInverse = 0.3183098861837907;
    private Complex funcNumerator = new Complex();
    private Complex funcDenom = new Complex();
    private Complex funcPart1 = new Complex();
    private Complex funcPart2 = new Complex();
    private Complex one = new Complex(1.0, 0.0);
    private Complex exponent = new Complex();
    private boolean foundDomainPoint = false;
    private int domainPoint = 0;
    private boolean foundRangePoint = false;
    private int rangePoint = 0;
    private double theta = 0.0;
    private double lastTheta = 0.0;
    private double domainPointTolerance = Math.sqrt((this.domainDomainRange[3] - this.domainDomainRange[2]) * (this.domainDomainRange[3] - this.domainDomainRange[2]) + (this.domainDomainRange[1] - this.domainDomainRange[0]) * (this.domainDomainRange[1] - this.domainDomainRange[0])) / 20.0;
    private double rangePointTolerance = Math.sqrt((this.rangeDomainRange[3] - this.rangeDomainRange[2]) * (this.rangeDomainRange[3] - this.rangeDomainRange[2]) + (this.rangeDomainRange[1] - this.rangeDomainRange[0]) * (this.rangeDomainRange[1] - this.rangeDomainRange[0])) / 20.0;
    private Grapher2D currentGrapher = null;
    private double[] currentDomainRange = null;
    private ArcVertexInfo[] arcVertexInfo = null;
    private Vector arcVertexInfoVector = new Vector();
    private double domainBegin = 0.0;
    private JButton addButton;
    private JButton clearAllButton;
    private JLabel clickOnLabel;
    private JRadioButton domainBoxedAxesButton;
    private ButtonGroup domainButtonGroup;
    private JRadioButton domainCrossedAxesButton;
    private JLabel domainCursorLabel;
    private NumberLabel domainCursorLocateLabel;
    private JButton domainDefaultDomainButton;
    private ComplexDomainChoiceBox domainDomainChoiceBox;
    private DataGrapher2D domainGrapher;
    private JPanel domainGrapherPanel;
    private PolarGrid domainPGrid;
    private DoubleField domainXMaxField;
    private DoubleField domainXMinField;
    private DoubleField domainYMaxField;
    private DoubleField domainYMinField;
    private JLabel errorLabel;
    private JButton graphButton;
    private JPanel gridPanel;
    private JLabel mapToLabel;
    private IntField numInteriorCirclesField;
    private JLabel numInteriorCirclesLabel;
    private IntField numRaysField;
    private JLabel numRaysLabel;
    private JPanel polarGridPanel;
    private JPanel polyToolPanel;
    private JPanel polygonPanel;
    private JRadioButton rangeBoxedAxesButton;
    private ButtonGroup rangeButtonGroup;
    private JRadioButton rangeCrossedAxesButton;
    private JLabel rangeCursorLabel;
    private NumberLabel rangeCursorLocateLabel;
    private JButton rangeDefaultDomainButton;
    private ComplexDomainChoiceBox rangeDomainChoiceBox;
    private DataGrapher2D rangeGrapher;
    private JPanel rangeGrapherPanel;
    private PolarGrid rangePGrid;
    private DoubleField rangeXMaxField;
    private DoubleField rangeXMinField;
    private DoubleField rangeYMaxField;
    private DoubleField rangeYMinField;
    private JButton removeButton;
    private JCheckBox sketchBox;
    private PlotStuff2D sketchData;
    private JLabel startAtLabel;
    private JPanel zoomErrorMessagePanel;
    private JPanel zoomInfoPanel;
    private JLabel zoomMessageLabel;
    private JCheckBox zoomOnOffBox;
    private ZoomPanel325x80 zoomPanel;

    public void init() {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    PolyTool.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initStuff();
    }

    private void grapherMouseClicked(MouseEvent evt) {
        this.zoomPanel.zoomByClicking(evt);
        this.currentGrapher.plotData();
    }

    private void mouseWheelMoved(MouseWheelEvent evt) {
        this.zoomPanel.zoomByMouseWheel(evt);
        this.currentGrapher.plotData();
    }

    private void initComponents() {
        this.sketchData = new PlotStuff2D();
        this.domainPGrid = new PolarGrid();
        this.rangePGrid = new PolarGrid();
        this.domainButtonGroup = new ButtonGroup();
        this.rangeButtonGroup = new ButtonGroup();
        this.polyToolPanel = new JPanel();
        this.domainGrapherPanel = new JPanel();
        this.domainGrapher = new DataGrapher2D();
        this.domainYMaxField = new DoubleField();
        this.domainYMinField = new DoubleField();
        this.domainXMinField = new DoubleField();
        this.domainXMaxField = new DoubleField();
        this.domainDomainChoiceBox = new ComplexDomainChoiceBox();
        this.domainCursorLabel = new JLabel();
        this.domainCursorLocateLabel = new NumberLabel();
        this.domainCrossedAxesButton = new JRadioButton();
        this.domainBoxedAxesButton = new JRadioButton();
        this.domainDefaultDomainButton = new JButton();
        this.rangeGrapherPanel = new JPanel();
        this.rangeGrapher = new DataGrapher2D();
        this.rangeYMaxField = new DoubleField();
        this.rangeYMinField = new DoubleField();
        this.rangeXMinField = new DoubleField();
        this.rangeXMaxField = new DoubleField();
        this.rangeDomainChoiceBox = new ComplexDomainChoiceBox();
        this.rangeCursorLabel = new JLabel();
        this.rangeCursorLocateLabel = new NumberLabel();
        this.rangeCrossedAxesButton = new JRadioButton();
        this.rangeBoxedAxesButton = new JRadioButton();
        this.rangeDefaultDomainButton = new JButton();
        this.polygonPanel = new JPanel();
        this.graphButton = new JButton();
        this.clearAllButton = new JButton();
        this.zoomInfoPanel = new JPanel();
        this.gridPanel = new JPanel();
        this.polarGridPanel = new JPanel();
        this.numInteriorCirclesLabel = new JLabel();
        this.numInteriorCirclesField = new IntField();
        this.numRaysField = new IntField();
        this.numRaysLabel = new JLabel();
        this.sketchBox = new JCheckBox();
        this.zoomOnOffBox = new JCheckBox();
        this.errorLabel = new JLabel();
        this.zoomErrorMessagePanel = new JPanel();
        this.zoomMessageLabel = new JLabel();
        this.zoomPanel = new ZoomPanel325x80();
        this.addButton = new JButton();
        this.startAtLabel = new JLabel();
        this.clickOnLabel = new JLabel();
        this.mapToLabel = new JLabel();
        this.removeButton = new JButton();
        this.sketchData.setPlotColor(Color.blue);
        this.domainPGrid.setCircleColor(new Color(204, 0, 0));
        this.domainPGrid.setNumCirclePoints(150);
        this.domainPGrid.setNumCircles(1);
        this.domainPGrid.setNumRayPoints(50);
        this.domainPGrid.setNumRays(0);
        this.domainPGrid.setRadiusMax(1.0);
        this.domainPGrid.setRayColor(new Color(0, 102, 51));
        this.rangePGrid.setCircleColor(new Color(204, 0, 0));
        this.rangePGrid.setNumCirclePoints(150);
        this.rangePGrid.setNumCircles(10);
        this.rangePGrid.setNumRayPoints(50);
        this.rangePGrid.setNumRays(16);
        this.rangePGrid.setRadiusMax(1.0);
        this.rangePGrid.setRayColor(new Color(0, 102, 51));
        this.getContentPane().setLayout(null);
        this.polyToolPanel.setBackground(SystemColor.controlLtHighlight);
        this.polyToolPanel.setLayout(null);
        this.domainGrapherPanel.setBackground(new Color(204, 204, 204));
        this.domainGrapherPanel.setBorder(BorderFactory.createEtchedBorder());
        this.domainGrapherPanel.setLayout(null);
        this.domainGrapher.setBorder(BorderFactory.createEtchedBorder());
        this.domainGrapher.setXAxisTitle("Re");
        this.domainGrapher.setXMax(1.0);
        this.domainGrapher.setXMin(-1.0);
        this.domainGrapher.setYAxisTitle("Im");
        this.domainGrapher.setYMax(1.0);
        this.domainGrapher.setYMin(-1.0);
        this.domainGrapher.setNumTraces(1);
        this.domainGrapher.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.domainGrapherMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                PolyTool.this.domainGrapherMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                PolyTool.this.domainGrapherMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                PolyTool.this.domainGrapherMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                PolyTool.this.domainGrapherMouseReleased(evt);
            }
        });
        this.domainGrapher.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                PolyTool.this.domainGrapherMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                PolyTool.this.domainGrapherMouseMoved(evt);
            }
        });
        this.domainGrapher.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                PolyTool.this.domainGrapherMouseWheelMoved(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainGrapher);
        this.domainGrapher.setBounds(45, 35, 300, 300);
        this.domainYMaxField.setText("1");
        this.domainYMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.domainYMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.domainYMaxFieldFocusGained(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainYMaxField);
        this.domainYMaxField.setBounds(2, 19, 40, 15);
        this.domainYMinField.setText("-1");
        this.domainYMinField.setFont(new Font("LucidaSans", 0, 10));
        this.domainYMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.domainYMinFieldFocusGained(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainYMinField);
        this.domainYMinField.setBounds(2, 320, 40, 15);
        this.domainXMinField.setText("-1");
        this.domainXMinField.setFont(new Font("LucidaSans", 0, 10));
        this.domainXMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.domainXMinFieldFocusGained(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainXMinField);
        this.domainXMinField.setBounds(45, 335, 40, 15);
        this.domainXMaxField.setText("1");
        this.domainXMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.domainXMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.domainXMaxFieldFocusGained(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainXMaxField);
        this.domainXMaxField.setBounds(305, 335, 40, 15);
        this.domainDomainChoiceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTool.this.domainDomainChoiceBoxActionPerformed(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainDomainChoiceBox);
        this.domainDomainChoiceBox.setBounds(45, 19, 205, 15);
        this.domainCursorLabel.setBackground(new Color(255, 255, 255));
        this.domainCursorLabel.setFont(new Font("LucidaSans", 1, 10));
        this.domainCursorLabel.setText("Cursor:");
        this.domainGrapherPanel.add(this.domainCursorLabel);
        this.domainCursorLabel.setBounds(100, 335, 38, 15);
        this.domainCursorLocateLabel.setText("invisible");
        this.domainGrapherPanel.add(this.domainCursorLocateLabel);
        this.domainCursorLocateLabel.setBounds(140, 335, 160, 15);
        this.domainCrossedAxesButton.setBackground(Color.white);
        this.domainButtonGroup.add(this.domainCrossedAxesButton);
        this.domainCrossedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.domainCrossedAxesButton.setSelected(true);
        this.domainCrossedAxesButton.setText("Crossed");
        this.domainCrossedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.domainCrossedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.domainCrossedAxesButton.setOpaque(false);
        this.domainCrossedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTool.this.domainCrossedAxesButtonActionPerformed(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainCrossedAxesButton);
        this.domainCrossedAxesButton.setBounds(210, 3, 56, 15);
        this.domainBoxedAxesButton.setBackground(Color.white);
        this.domainButtonGroup.add(this.domainBoxedAxesButton);
        this.domainBoxedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.domainBoxedAxesButton.setText("Boxed axes");
        this.domainBoxedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.domainBoxedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.domainBoxedAxesButton.setOpaque(false);
        this.domainBoxedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTool.this.domainBoxedAxesButtonActionPerformed(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainBoxedAxesButton);
        this.domainBoxedAxesButton.setBounds(270, 3, 82, 15);
        this.domainDefaultDomainButton.setFont(new Font("Dialog", 1, 10));
        this.domainDefaultDomainButton.setText("Default Domain");
        this.domainDefaultDomainButton.setMargin(new Insets(2, 2, 2, 2));
        this.domainDefaultDomainButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.domainDefaultDomainButtonMouseClicked(evt);
            }
        });
        this.domainGrapherPanel.add(this.domainDefaultDomainButton);
        this.domainDefaultDomainButton.setBounds(253, 19, 91, 15);
        this.polyToolPanel.add(this.domainGrapherPanel);
        this.domainGrapherPanel.setBounds(2, 0, 350, 355);
        this.rangeGrapherPanel.setBackground(new Color(204, 204, 204));
        this.rangeGrapherPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rangeGrapherPanel.setLayout(null);
        this.rangeGrapher.setBorder(BorderFactory.createEtchedBorder());
        this.rangeGrapher.setXAxisTitle("Re");
        this.rangeGrapher.setXMax(1.0);
        this.rangeGrapher.setXMin(-1.0);
        this.rangeGrapher.setYAxisTitle("Im");
        this.rangeGrapher.setYMax(1.0);
        this.rangeGrapher.setYMin(-1.0);
        this.rangeGrapher.setNumTraces(1);
        this.rangeGrapher.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.rangeGrapherMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                PolyTool.this.rangeGrapherMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                PolyTool.this.rangeGrapherMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                PolyTool.this.rangeGrapherMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                PolyTool.this.rangeGrapherMouseReleased(evt);
            }
        });
        this.rangeGrapher.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                PolyTool.this.rangeGrapherMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                PolyTool.this.rangeGrapherMouseMoved(evt);
            }
        });
        this.rangeGrapher.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                PolyTool.this.rangeGrapherMouseWheelMoved(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeGrapher);
        this.rangeGrapher.setBounds(45, 35, 300, 300);
        this.rangeYMaxField.setText("1");
        this.rangeYMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeYMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.rangeYMaxFieldFocusGained(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeYMaxField);
        this.rangeYMaxField.setBounds(2, 19, 40, 15);
        this.rangeYMinField.setText("-1");
        this.rangeYMinField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeYMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.rangeYMinFieldFocusGained(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeYMinField);
        this.rangeYMinField.setBounds(2, 320, 40, 15);
        this.rangeXMinField.setText("-1");
        this.rangeXMinField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeXMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.rangeXMinFieldFocusGained(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeXMinField);
        this.rangeXMinField.setBounds(45, 335, 40, 15);
        this.rangeXMaxField.setText("1");
        this.rangeXMaxField.setFont(new Font("LucidaSans", 0, 10));
        this.rangeXMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PolyTool.this.rangeXMaxFieldFocusGained(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeXMaxField);
        this.rangeXMaxField.setBounds(305, 335, 40, 15);
        this.rangeDomainChoiceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTool.this.rangeDomainChoiceBoxActionPerformed(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeDomainChoiceBox);
        this.rangeDomainChoiceBox.setBounds(45, 19, 205, 15);
        this.rangeCursorLabel.setBackground(new Color(255, 255, 255));
        this.rangeCursorLabel.setFont(new Font("LucidaSans", 1, 10));
        this.rangeCursorLabel.setText("Cursor:");
        this.rangeGrapherPanel.add(this.rangeCursorLabel);
        this.rangeCursorLabel.setBounds(100, 335, 38, 15);
        this.rangeCursorLocateLabel.setText("invisible");
        this.rangeGrapherPanel.add(this.rangeCursorLocateLabel);
        this.rangeCursorLocateLabel.setBounds(140, 335, 160, 15);
        this.rangeCrossedAxesButton.setBackground(Color.white);
        this.rangeButtonGroup.add(this.rangeCrossedAxesButton);
        this.rangeCrossedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.rangeCrossedAxesButton.setSelected(true);
        this.rangeCrossedAxesButton.setText("Crossed");
        this.rangeCrossedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rangeCrossedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.rangeCrossedAxesButton.setOpaque(false);
        this.rangeCrossedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTool.this.rangeCrossedAxesButtonActionPerformed(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeCrossedAxesButton);
        this.rangeCrossedAxesButton.setBounds(210, 3, 56, 15);
        this.rangeBoxedAxesButton.setBackground(Color.white);
        this.rangeButtonGroup.add(this.rangeBoxedAxesButton);
        this.rangeBoxedAxesButton.setFont(new Font("LucidaSans", 0, 10));
        this.rangeBoxedAxesButton.setText("Boxed axes");
        this.rangeBoxedAxesButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rangeBoxedAxesButton.setMargin(new Insets(0, 0, 0, 0));
        this.rangeBoxedAxesButton.setOpaque(false);
        this.rangeBoxedAxesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTool.this.rangeBoxedAxesButtonActionPerformed(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeBoxedAxesButton);
        this.rangeBoxedAxesButton.setBounds(270, 3, 82, 15);
        this.rangeDefaultDomainButton.setFont(new Font("Dialog", 1, 10));
        this.rangeDefaultDomainButton.setText("Default Domain");
        this.rangeDefaultDomainButton.setMargin(new Insets(2, 2, 2, 2));
        this.rangeDefaultDomainButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.rangeDefaultDomainButtonMouseClicked(evt);
            }
        });
        this.rangeGrapherPanel.add(this.rangeDefaultDomainButton);
        this.rangeDefaultDomainButton.setBounds(253, 19, 91, 15);
        this.polyToolPanel.add(this.rangeGrapherPanel);
        this.rangeGrapherPanel.setBounds(677, 0, 350, 355);
        this.polygonPanel.setBackground(new Color(204, 204, 204));
        this.polygonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.polygonPanel.setLayout(null);
        this.graphButton.setFont(new Font("LucidaSans", 1, 10));
        this.graphButton.setText("Graph");
        this.graphButton.setMargin(new Insets(2, 2, 2, 2));
        this.graphButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.graphButtonMouseClicked(evt);
            }
        });
        this.polygonPanel.add(this.graphButton);
        this.graphButton.setBounds(166, 18, 70, 16);
        this.clearAllButton.setFont(new Font("LucidaSans", 1, 10));
        this.clearAllButton.setText("Clear All");
        this.clearAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.clearAllButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.clearAllButtonMouseClicked(evt);
            }
        });
        this.polygonPanel.add(this.clearAllButton);
        this.clearAllButton.setBounds(241, 18, 70, 16);
        this.zoomInfoPanel.setBackground(new Color(204, 204, 204));
        this.zoomInfoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.zoomInfoPanel.setLayout(null);
        this.gridPanel.setBackground(new Color(204, 204, 204));
        this.gridPanel.setBorder(BorderFactory.createEtchedBorder());
        this.gridPanel.setLayout(null);
        this.polarGridPanel.setBackground(Color.white);
        this.polarGridPanel.setOpaque(false);
        this.polarGridPanel.setLayout(null);
        this.numInteriorCirclesLabel.setFont(new Font("LucidaSans", 0, 10));
        this.numInteriorCirclesLabel.setText("Interior circles:");
        this.polarGridPanel.add(this.numInteriorCirclesLabel);
        this.numInteriorCirclesLabel.setBounds(15, 0, 73, 15);
        this.numInteriorCirclesField.setText("9");
        this.numInteriorCirclesField.setFont(new Font("LucidaSans", 0, 10));
        this.polarGridPanel.add(this.numInteriorCirclesField);
        this.numInteriorCirclesField.setBounds(88, 0, 40, 15);
        this.numRaysField.setText("16");
        this.numRaysField.setFont(new Font("LucidaSans", 0, 10));
        this.polarGridPanel.add(this.numRaysField);
        this.numRaysField.setBounds(190, 0, 40, 15);
        this.numRaysLabel.setFont(new Font("LucidaSans", 0, 10));
        this.numRaysLabel.setHorizontalAlignment(4);
        this.numRaysLabel.setText("Rays:");
        this.polarGridPanel.add(this.numRaysLabel);
        this.numRaysLabel.setBounds(165, 0, 25, 15);
        this.gridPanel.add(this.polarGridPanel);
        this.polarGridPanel.setBounds(90, 2, 230, 15);
        this.sketchBox.setBackground(Color.white);
        this.sketchBox.setFont(new Font("LucidaSans", 0, 10));
        this.sketchBox.setText("Sketch");
        this.sketchBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sketchBox.setMargin(new Insets(0, 0, 0, 0));
        this.sketchBox.setOpaque(false);
        this.sketchBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PolyTool.this.sketchBoxItemStateChanged(evt);
            }
        });
        this.gridPanel.add(this.sketchBox);
        this.sketchBox.setBounds(2, 2, 49, 15);
        this.zoomOnOffBox.setBackground(new Color(255, 255, 255));
        this.zoomOnOffBox.setFont(new Font("LucidaSans", 0, 10));
        this.zoomOnOffBox.setText("Zoom on/off");
        this.zoomOnOffBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.zoomOnOffBox.setMargin(new Insets(0, 0, 0, 0));
        this.zoomOnOffBox.setOpaque(false);
        this.zoomOnOffBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTool.this.zoomOnOffBoxActionPerformed(evt);
            }
        });
        this.gridPanel.add(this.zoomOnOffBox);
        this.zoomOnOffBox.setBounds(2, 20, 81, 15);
        this.errorLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.errorLabel.setForeground(new Color(204, 0, 0));
        this.errorLabel.setText("Difference greater than 2*pi");
        this.gridPanel.add(this.errorLabel);
        this.errorLabel.setBounds(110, 20, 210, 15);
        this.zoomInfoPanel.add(this.gridPanel);
        this.gridPanel.setBounds(0, 0, 325, 40);
        this.zoomErrorMessagePanel.setOpaque(false);
        this.zoomErrorMessagePanel.setLayout(null);
        this.zoomMessageLabel.setFont(new Font("Lucida Sans", 1, 12));
        this.zoomMessageLabel.setHorizontalAlignment(0);
        this.zoomMessageLabel.setText("Zoom capabilities not available when sketching.");
        this.zoomErrorMessagePanel.add(this.zoomMessageLabel);
        this.zoomMessageLabel.setBounds(0, 0, 326, 20);
        this.zoomInfoPanel.add(this.zoomErrorMessagePanel);
        this.zoomErrorMessagePanel.setBounds(0, 65, 325, 20);
        this.zoomPanel.setBackground(new Color(204, 204, 204));
        this.zoomPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PolyTool.this.zoomPanelPropertyChange(evt);
            }
        });
        this.zoomInfoPanel.add(this.zoomPanel);
        this.zoomPanel.setBounds(0, 40, 325, 80);
        this.polygonPanel.add(this.zoomInfoPanel);
        this.zoomInfoPanel.setBounds(0, 235, 327, 120);
        this.addButton.setFont(new Font("LucidaSans", 1, 10));
        this.addButton.setText("Add ");
        this.addButton.setMargin(new Insets(2, 2, 2, 2));
        this.addButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.addButtonMouseClicked(evt);
            }
        });
        this.polygonPanel.add(this.addButton);
        this.addButton.setBounds(16, 18, 70, 16);
        this.startAtLabel.setFont(new Font("LucidaSans", 1, 10));
        this.startAtLabel.setText("Start at theta:");
        this.polygonPanel.add(this.startAtLabel);
        this.startAtLabel.setBounds(39, 35, 71, 16);
        this.clickOnLabel.setFont(new Font("LucidaSans", 1, 10));
        this.clickOnLabel.setHorizontalAlignment(0);
        this.clickOnLabel.setText("Click on graphs or \"Add\" button to add arc/vertex info.");
        this.polygonPanel.add(this.clickOnLabel);
        this.clickOnLabel.setBounds(1, 3, 325, 15);
        this.mapToLabel.setFont(new Font("LucidaSans", 1, 10));
        this.mapToLabel.setText("Map to:");
        this.polygonPanel.add(this.mapToLabel);
        this.mapToLabel.setBounds(158, 35, 80, 16);
        this.removeButton.setFont(new Font("Lucida Sans", 1, 10));
        this.removeButton.setText("Remove");
        this.removeButton.setMargin(new Insets(2, 2, 2, 2));
        this.removeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PolyTool.this.removeButtonMouseClicked(evt);
            }
        });
        this.polygonPanel.add(this.removeButton);
        this.removeButton.setBounds(91, 18, 70, 16);
        this.polyToolPanel.add(this.polygonPanel);
        this.polygonPanel.setBounds(350, 0, 327, 355);
        this.getContentPane().add(this.polyToolPanel);
        this.polyToolPanel.setBounds(0, 0, 1027, 355);
    }

    private void reorderArcVertexInfo() {
        int i;
        int currentPosition = 0;
        boolean positionNotFound = true;
        double tempArcBegin = 0.0;
        for (i = 0; i <= this.numArcVertexPanels - 1; ++i) {
            this.arcVertexInfo[i].setArcBeginVal(this.arcBegin[i]);
            this.arcVertexInfo[i].setArcBeginString(this.arcVertexPanels[i].getArcBeginField().getText());
            this.arcVertexInfo[i].setVertexReVal(this.vertex[i].re());
            this.arcVertexInfo[i].setVertexReString(this.arcVertexPanels[i].getVertexReField().getText());
            this.arcVertexInfo[i].setVertexImVal(this.vertex[i].im());
            this.arcVertexInfo[i].setVertexImString(this.arcVertexPanels[i].getVertexImField().getText());
            this.arcVertexInfo[i].setArcPointsDataX(this.arcPointsDataX[i][0]);
            this.arcVertexInfo[i].setArcPointsDataY(this.arcPointsDataY[i][0]);
        }
        this.arcVertexInfoVector.clear();
        this.arcVertexInfoVector.add(this.arcVertexInfo[0]);
        for (i = 1; i <= this.numArcVertexPanels - 1; ++i) {
            positionNotFound = true;
            tempArcBegin = this.arcVertexInfo[i].getArcBeginVal();
            if (Math.abs(tempArcBegin - ((ArcVertexInfo)this.arcVertexInfoVector.get(currentPosition)).getArcBeginVal()) < this.eps) {
                if (tempArcBegin < ((ArcVertexInfo)this.arcVertexInfoVector.get(currentPosition)).getArcBeginVal()) {
                    this.arcVertexInfoVector.add(currentPosition, this.arcVertexInfo[i]);
                    continue;
                }
                this.arcVertexInfoVector.add(currentPosition + 1, this.arcVertexInfo[i]);
                continue;
            }
            if (tempArcBegin > ((ArcVertexInfo)this.arcVertexInfoVector.get(currentPosition)).getArcBeginVal()) {
                while (currentPosition < this.arcVertexInfoVector.size() - 1 && positionNotFound) {
                    if (!(tempArcBegin <= ((ArcVertexInfo)this.arcVertexInfoVector.get(++currentPosition)).getArcBeginVal())) continue;
                    positionNotFound = false;
                }
                if (positionNotFound) {
                    this.arcVertexInfoVector.add(this.arcVertexInfoVector.size(), this.arcVertexInfo[i]);
                    continue;
                }
                this.arcVertexInfoVector.add(currentPosition, this.arcVertexInfo[i]);
                continue;
            }
            while (currentPosition > 1 && positionNotFound) {
                if (!(tempArcBegin >= ((ArcVertexInfo)this.arcVertexInfoVector.get(--currentPosition)).getArcBeginVal())) continue;
                positionNotFound = false;
            }
            if (positionNotFound) {
                this.arcVertexInfoVector.add(0, this.arcVertexInfo[i]);
                continue;
            }
            this.arcVertexInfoVector.add(currentPosition, this.arcVertexInfo[i]);
        }
        for (i = 0; i <= this.numArcVertexPanels - 1; ++i) {
            this.arcVertexPanels[i].getArcBeginField().setText(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getArcBeginString());
            this.arcVertexPanels[i].getArcBeginField().setDoubleVal(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getArcBeginVal());
            this.arcBegin[i] = ((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getArcBeginVal();
            this.arcVertexPanels[i].getVertexReField().setText(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getVertexReString());
            this.arcVertexPanels[i].getVertexReField().setDoubleVal(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getVertexReVal());
            this.vertex[i].setRe(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getVertexReVal());
            this.arcVertexPanels[i].getVertexImField().setText(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getVertexImString());
            this.arcVertexPanels[i].getVertexImField().setDoubleVal(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getVertexImVal());
            this.vertex[i].setIm(((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getVertexImVal());
            this.arcPointsDataX[i][0] = ((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getArcPointsDataX();
            this.arcPointsDataY[i][0] = ((ArcVertexInfo)this.arcVertexInfoVector.get(i)).getArcPointsDataY();
            this.vertexPointsDataX[i][0] = this.vertex[i].re();
            this.vertexPointsDataY[i][0] = this.vertex[i].im();
        }
    }

    private void zoomOnOffBoxActionPerformed(ActionEvent evt) {
        if (!this.sketchBox.isSelected()) {
            if (this.zoomOnOffBox.isSelected()) {
                this.zoomPanel.setVisible(true);
            } else {
                this.zoomPanel.setVisible(false);
            }
        }
    }

    private void sketchBoxItemStateChanged(ItemEvent evt) {
        if (this.sketchBox.isSelected()) {
            this.zoomOnOffBox.setVisible(false);
            this.zoomOnOffBox.setSelected(false);
            this.zoomPanel.setVisible(false);
            this.zoomErrorMessagePanel.setVisible(true);
        } else {
            this.zoomOnOffBox.setSelected(false);
            this.zoomOnOffBox.setVisible(true);
            this.zoomErrorMessagePanel.setVisible(false);
        }
        this.domainGrapher.plotData();
        this.rangeGrapher.plotData();
    }

    private void zoomPanelPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("zoomSliderHasMoved")) {
            this.currentGrapher.plotData();
        } else {
            this.focusField = this.zoomPanel.getFocusField();
        }
    }

    private void rangeDefaultDomainButtonMouseClicked(MouseEvent evt) {
        this.rangeDomainChoiceBox.putDomainRangeVals();
        this.rangeGrapher.plotData();
    }

    private void domainDefaultDomainButtonMouseClicked(MouseEvent evt) {
        this.domainDomainChoiceBox.putDomainRangeVals();
        this.domainGrapher.plotData();
    }

    private void domainGrapherMouseWheelMoved(MouseWheelEvent evt) {
        this.mouseWheelMoved(evt);
    }

    private void addButtonMouseClicked(MouseEvent evt) {
        if (this.numArcVertexPanels < this.maxNumArcsVertices) {
            if (this.currentHighlightedPanel == -1 || this.arcVertexPanels[this.currentHighlightedPanel].isVertexHighlighted()) {
                this.insertArcVertexPanel(this.numArcVertexPanels);
                this.requestFocus(3, this.arcVertexPanels[this.numArcVertexPanels - 1]);
            } else {
                this.insertArcVertexPanel(this.currentHighlightedPanel + 1);
                this.requestFocus(3, this.arcVertexPanels[this.currentHighlightedPanel + 1]);
            }
            if (this.currentHighlightedPanel > 0) {
                // empty if block
            }
            this.polygonHasBeenGraphed = false;
        }
    }

    private void rangeGrapherMouseReleased(MouseEvent evt) {
        this.foundRangePoint = false;
        this.rangePoint = 0;
    }

    private void domainGrapherMouseClicked(MouseEvent evt) {
        if (this.zoomOnOffBox.isSelected()) {
            this.clearLabels();
            this.grapherMouseClicked(evt);
        } else {
            this.placeDomainPoint(evt);
        }
    }

    private void rangeGrapherMouseWheelMoved(MouseWheelEvent evt) {
        this.mouseWheelMoved(evt);
    }

    private void rangeGrapherMouseClicked(MouseEvent evt) {
        this.clearLabels();
        if (this.zoomOnOffBox.isSelected()) {
            if (this.sketchBox.isSelected()) {
                this.zoomErrorMessagePanel.setVisible(true);
                this.zoomPanel.setVisible(false);
            } else {
                this.grapherMouseClicked(evt);
            }
        } else {
            this.placeRangePoint(evt);
        }
    }

    private void domainBoxedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.domainCrossedAxesButton.isSelected()) {
            this.domainGrapher.setAxesStyle(1);
        } else {
            this.domainGrapher.setAxesStyle(2);
        }
        this.domainGrapher.plotData();
    }

    private void domainCrossedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.domainCrossedAxesButton.isSelected()) {
            this.domainGrapher.setAxesStyle(1);
        } else {
            this.domainGrapher.setAxesStyle(2);
        }
        this.domainGrapher.plotData();
    }

    private void rangeBoxedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.rangeCrossedAxesButton.isSelected()) {
            this.rangeGrapher.setAxesStyle(1);
        } else {
            this.rangeGrapher.setAxesStyle(2);
        }
        this.rangeGrapher.plotData();
    }

    private void rangeCrossedAxesButtonActionPerformed(ActionEvent evt) {
        if (this.rangeCrossedAxesButton.isSelected()) {
            this.rangeGrapher.setAxesStyle(1);
        } else {
            this.rangeGrapher.setAxesStyle(2);
        }
        this.rangeGrapher.plotData();
    }

    private void rangeDomainChoiceBoxActionPerformed(ActionEvent evt) {
        this.rangeDomainChoiceBox.itemClicked();
        this.rangeGrapher.plotData();
    }

    private void domainDomainChoiceBoxActionPerformed(ActionEvent evt) {
        this.domainDomainChoiceBox.itemClicked();
        this.domainGrapher.plotData();
    }

    private void domainGrapherMouseReleased(MouseEvent evt) {
        this.foundDomainPoint = false;
        this.domainPoint = 0;
    }

    private void clearAllButtonMouseClicked(MouseEvent evt) {
        this.clearLabels();
        this.domainBegin = 0.0;
        this.sketchBox.setSelected(false);
        this.rangeGrapher.setNumTraces(0);
        this.rangeGrapher.plotData();
        this.numRaysField.setText("0");
        this.numRays = 0;
        this.domainPGrid.setNumCircles(1);
        this.domainPGrid.setNumRays(this.numRays);
        this.rangePGrid.setNumCircles(this.numInteriorCircles + 1);
        this.rangePGrid.setNumRays(this.numRays);
        for (int i = 0; i <= this.numArcVertexPanels - 1; ++i) {
            this.arcVertexPanels[i].clearHighlight();
            this.arcVertexPanels[i].getArcBeginField().setText("");
            this.arcVertexPanels[i].getVertexReField().setText("");
            this.arcVertexPanels[i].getVertexImField().setText("");
            this.arcVertexPanels[i].setVisible(false);
        }
        this.numArcs = 0;
        this.numVertices = 0;
        this.numArcVertexPanels = 0;
        this.currentHighlightedPanel = -1;
        this.polygonHasBeenGraphed = false;
        this.sketchBox.setSelected(false);
        this.zoomOnOffBox.setSelected(false);
        this.zoomPanel.setVisible(false);
        this.startAtLabel.setVisible(false);
        this.mapToLabel.setVisible(false);
        this.domainPGrid.createData();
        this.domainGrapher.setNumTraces(1);
        this.domainGrapher.plotData();
    }

    private void graphButtonMouseClicked(MouseEvent evt) {
        boolean noProblems = true;
        this.clearLabels();
        if (this.isXYInputsGood() && this.isInputInfoGood()) {
            int i;
            for (i = 0; i <= this.numArcVertexPanels - 1; ++i) {
                if (!this.arcVertexPanels[i].isArcInfoGood()) {
                    noProblems = false;
                    continue;
                }
                this.arcBegin[i] = this.arcVertexPanels[i].getArcBegin();
                this.arcPointsDataX[i][0] = this.radiusMax * Math.cos(this.arcBegin[i]);
                this.arcPointsDataY[i][0] = this.radiusMax * Math.sin(this.arcBegin[i]);
                this.vertexPointsDataX[i][0] = this.arcVertexPanels[i].getVertexRe();
                this.vertex[i].setRe(this.vertexPointsDataX[i][0]);
                this.vertexPointsDataY[i][0] = this.arcVertexPanels[i].getVertexIm();
                this.vertex[i].setIm(this.vertexPointsDataY[i][0]);
            }
            this.reorderArcVertexInfo();
            if (this.arcBegin[this.numArcVertexPanels - 1] - this.arcBegin[0] > Math.PI * 2) {
                noProblems = false;
                this.arcVertexPanels[this.numArcVertexPanels - 1].getArcBeginField().setBackground(this.arcVertexPanels[this.numArcVertexPanels - 1].getArcBeginField().getErrorColor());
                this.arcVertexPanels[0].getArcBeginField().setBackground(this.arcVertexPanels[0].getArcBeginField().getErrorColor());
                this.errorLabel.setVisible(true);
            }
            this.domainBegin = this.arcBegin[0] < 0.0 ? this.arcBegin[0] : 0.0;
            if (noProblems) {
                this.numArcs = this.numArcVertexPanels;
                this.numVertices = this.numArcVertexPanels;
                this.domainPGrid.createData();
                this.rangePGrid.createData();
                this.domainGrapher.setNumTraces(this.numArcVertexPanels + 1);
                this.domainGrapher.plotData(this.domainAllData);
                this.transformData();
                for (i = 0; i <= this.numVertices - 1; ++i) {
                    this.rangeOrderTraces[i] = i;
                }
                this.rangeGrapher.setNumTraces(this.numArcVertexPanels + 1);
                this.rangeOrderTraces[this.numArcVertexPanels] = this.maxNumArcsVertices;
                this.rangeGrapher.plotData(this.rangeOrderTraces, this.rangeAllData);
                this.polygonHasBeenGraphed = true;
            }
        }
    }

    private void rangeXMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeXMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeYMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeYMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainXMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainXMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainYMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void domainYMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void rangeGrapherMousePressed(MouseEvent evt) {
        this.clearLabels();
        this.cursorX = this.rangeGrapher.getXVal(evt.getX());
        this.cursorY = this.rangeGrapher.getYVal(evt.getY());
        this.foundRangePoint = false;
        this.rangePoint = 0;
        while (!this.foundRangePoint && this.rangePoint <= this.numVertices - 1) {
            if (Math.sqrt((this.cursorX - this.vertexPointsDataX[this.rangeOrderTraces[this.rangePoint]][0]) * (this.cursorX - this.vertexPointsDataX[this.rangeOrderTraces[this.rangePoint]][0]) + (this.cursorY - this.vertexPointsDataY[this.rangeOrderTraces[this.rangePoint]][0]) * (this.cursorY - this.vertexPointsDataY[this.rangeOrderTraces[this.rangePoint]][0])) <= this.rangePointTolerance) {
                this.foundRangePoint = true;
                continue;
            }
            ++this.rangePoint;
        }
    }

    private void rangeGrapherMouseExited(MouseEvent evt) {
        this.componentIsFocused = false;
        this.rangeCursorLocateLabel.setVisible(false);
    }

    private void rangeGrapherMouseEntered(MouseEvent evt) {
        this.zoomPanel.register(this.rangeGrapher);
        this.currentGrapher = this.rangeGrapher;
        this.currentDomainRange = this.rangeDomainRange;
        this.componentIsFocused = this.rangeGrapher.requestFocusInWindow();
        this.rangeCursorLocateLabel.setCursorLocation(this.rangeGrapher.getXVal(evt.getX()), this.rangeGrapher.getYVal(evt.getY()));
        this.rangeCursorLocateLabel.setVisible(true);
    }

    private void rangeGrapherMouseMoved(MouseEvent evt) {
        this.rangeCursorLocateLabel.setCursorLocation(this.rangeGrapher.getXVal(evt.getX()), this.rangeGrapher.getYVal(evt.getY()));
    }

    private void rangeGrapherMouseDragged(MouseEvent evt) {
        this.cursorX = this.rangeGrapher.getXVal(evt.getX());
        this.cursorY = this.rangeGrapher.getYVal(evt.getY());
        if (this.foundRangePoint) {
            this.rangeCursorLocateLabel.setCursorLocation(this.rangeGrapher.getXVal(evt.getX()), this.rangeGrapher.getYVal(evt.getY()));
            this.arcVertexPanels[this.rangeOrderTraces[this.rangePoint]].setVertexRe(this.cursorX);
            this.arcVertexPanels[this.rangeOrderTraces[this.rangePoint]].setVertexIm(this.cursorY);
            this.vertex[this.rangeOrderTraces[this.rangePoint]].setRe(this.cursorX);
            this.vertex[this.rangeOrderTraces[this.rangePoint]].setIm(this.cursorY);
            this.vertexPointsDataX[this.rangeOrderTraces[this.rangePoint]][0] = this.cursorX;
            this.vertexPointsDataY[this.rangeOrderTraces[this.rangePoint]][0] = this.cursorY;
            if (this.polygonHasBeenGraphed) {
                this.transformData();
            }
            this.rangeGrapher.plotData();
            this.domainGrapher.plotData();
        }
    }

    private void domainGrapherMouseDragged(MouseEvent evt) {
        double currentArcEnd = 0.0;
        double previousArcBegin = 0.0;
        double tempVertexRe = 0.0;
        double tempVertexIm = 0.0;
        String tempVertexReText = "";
        String tempVertexImText = "";
        this.cursorX = this.domainGrapher.getXVal(evt.getX());
        this.cursorY = this.domainGrapher.getYVal(evt.getY());
        this.domainCursorLocateLabel.setCursorLocation(this.cursorX, this.cursorY);
        if (this.sketchBox.isSelected()) {
            this.zVal.setRe(this.cursorX);
            this.zVal.setIm(this.cursorY);
            this.zRange = this.func(this.zVal);
            this.domainGrapher.sketchData(this.cursorX, this.cursorY);
            this.rangeGrapher.sketchData(this.zRange.re(), this.zRange.im());
        } else if (this.foundDomainPoint) {
            this.lastTheta = this.theta;
            this.theta = this.getTheta(this.cursorX, this.cursorY);
            currentArcEnd = this.domainPoint == this.numArcVertexPanels - 1 ? this.arcBegin[0] + Math.PI * 2 : this.arcBegin[this.domainPoint + 1];
            previousArcBegin = this.domainPoint == 0 ? this.domainBegin : this.arcBegin[this.domainPoint - 1];
            if (this.theta - this.lastTheta < -Math.PI) {
                tempVertexRe = this.vertex[this.numArcVertexPanels - 1].re();
                tempVertexReText = this.arcVertexPanels[this.numArcVertexPanels - 1].getVertexReField().getText();
                tempVertexIm = this.vertex[this.numArcVertexPanels - 1].im();
                tempVertexImText = this.arcVertexPanels[this.numArcVertexPanels - 1].getVertexImField().getText();
                for (int i = this.numArcVertexPanels - 1; i >= 1; --i) {
                    this.arcBegin[i] = this.arcBegin[i - 1];
                    this.arcVertexPanels[i].getArcBeginField().setText(this.arcVertexPanels[i - 1].getArcBeginField().getText());
                    this.vertex[i].setRe(this.vertex[i - 1].re());
                    this.arcVertexPanels[i].getVertexReField().setText(this.arcVertexPanels[i - 1].getVertexReField().getText());
                    this.vertex[i].setIm(this.vertex[i - 1].im());
                    this.arcVertexPanels[i].getVertexImField().setText(this.arcVertexPanels[i - 1].getVertexImField().getText());
                    this.vertexPointsDataX[i][0] = this.vertex[i].re();
                    this.vertexPointsDataY[i][0] = this.vertex[i].im();
                    this.arcPointsDataX[i][0] = this.arcPointsDataX[i - 1][0];
                    this.arcPointsDataY[i][0] = this.arcPointsDataY[i - 1][0];
                }
                this.arcBegin[0] = this.theta;
                this.arcVertexPanels[0].setArcBegin(this.theta);
                this.vertex[0].setRe(tempVertexRe);
                this.arcVertexPanels[0].getVertexReField().setText(tempVertexReText);
                this.vertex[0].setIm(tempVertexIm);
                this.arcVertexPanels[0].getVertexImField().setText(tempVertexImText);
                this.arcPointsDataX[0][0] = this.radiusMax * Math.cos(this.theta);
                this.arcPointsDataY[0][0] = this.radiusMax * Math.sin(this.theta);
                this.vertexPointsDataX[0][0] = this.vertex[0].re();
                this.vertexPointsDataY[0][0] = this.vertex[0].im();
                this.domainPoint = 0;
            } else if (this.theta - this.lastTheta > Math.PI) {
                tempVertexRe = this.vertex[0].re();
                tempVertexReText = this.arcVertexPanels[0].getVertexReField().getText();
                tempVertexIm = this.vertex[0].im();
                tempVertexImText = this.arcVertexPanels[0].getVertexImField().getText();
                for (int i = 0; i <= this.numArcVertexPanels - 2; ++i) {
                    this.arcBegin[i] = this.arcBegin[i + 1];
                    this.vertex[i].setRe(this.vertex[i + 1].re());
                    this.vertex[i].setIm(this.vertex[i + 1].im());
                    this.vertexPointsDataX[i][0] = this.vertex[i].re();
                    this.vertexPointsDataY[i][0] = this.vertex[i].im();
                    this.arcVertexPanels[i].getArcBeginField().setText(this.arcVertexPanels[i + 1].getArcBeginField().getText());
                    this.arcVertexPanels[i].getVertexReField().setText(this.arcVertexPanels[i + 1].getVertexReField().getText());
                    this.arcVertexPanels[i].getVertexImField().setText(this.arcVertexPanels[i + 1].getVertexImField().getText());
                    this.arcPointsDataX[i][0] = this.arcPointsDataX[i + 1][0];
                    this.arcPointsDataY[i][0] = this.arcPointsDataY[i + 1][0];
                }
                this.arcBegin[this.numArcVertexPanels - 1] = this.theta;
                this.arcVertexPanels[this.numArcVertexPanels - 1].setArcBegin(this.theta);
                this.vertex[this.numArcVertexPanels - 1].setRe(tempVertexRe);
                this.arcVertexPanels[this.numArcVertexPanels - 1].getVertexReField().setText(tempVertexReText);
                this.vertex[this.numArcVertexPanels - 1].setIm(tempVertexIm);
                this.arcVertexPanels[this.numArcVertexPanels - 1].getVertexImField().setText(tempVertexImText);
                this.arcPointsDataX[this.numArcVertexPanels - 1][0] = this.radiusMax * Math.cos(this.theta);
                this.arcPointsDataY[this.numArcVertexPanels - 1][0] = this.radiusMax * Math.sin(this.theta);
                this.vertexPointsDataX[this.numArcVertexPanels - 1][0] = this.vertex[this.numArcVertexPanels - 1].re();
                this.vertexPointsDataY[this.numArcVertexPanels - 1][0] = this.vertex[this.numArcVertexPanels - 1].im();
                this.domainPoint = this.numArcVertexPanels - 1;
            } else if (this.theta > currentArcEnd) {
                tempVertexRe = this.vertex[this.domainPoint].re();
                tempVertexReText = this.arcVertexPanels[this.domainPoint].getVertexReField().getText();
                tempVertexIm = this.vertex[this.domainPoint].im();
                tempVertexImText = this.arcVertexPanels[this.domainPoint].getVertexImField().getText();
                this.arcBegin[this.domainPoint] = this.arcBegin[this.domainPoint + 1];
                this.arcVertexPanels[this.domainPoint].getArcBeginField().setText(this.arcVertexPanels[this.domainPoint + 1].getArcBeginField().getText());
                this.vertex[this.domainPoint].setRe(this.vertex[this.domainPoint + 1].re());
                this.arcVertexPanels[this.domainPoint].getVertexReField().setText(this.arcVertexPanels[this.domainPoint + 1].getVertexReField().getText());
                this.vertex[this.domainPoint].setIm(this.vertex[this.domainPoint + 1].im());
                this.arcVertexPanels[this.domainPoint].getVertexImField().setText(this.arcVertexPanels[this.domainPoint + 1].getVertexImField().getText());
                this.arcPointsDataX[this.domainPoint][0] = this.arcPointsDataX[this.domainPoint + 1][0];
                this.arcPointsDataY[this.domainPoint][0] = this.arcPointsDataY[this.domainPoint + 1][0];
                this.arcBegin[this.domainPoint + 1] = this.theta;
                this.arcVertexPanels[this.domainPoint + 1].setArcBegin(this.theta);
                this.vertex[this.domainPoint + 1].setRe(tempVertexRe);
                this.arcVertexPanels[this.domainPoint + 1].getVertexReField().setText(tempVertexReText);
                this.vertex[this.domainPoint + 1].setIm(tempVertexIm);
                this.arcVertexPanels[this.domainPoint + 1].getVertexImField().setText(tempVertexImText);
                this.arcPointsDataX[this.domainPoint + 1][0] = this.radiusMax * Math.cos(this.theta);
                this.arcPointsDataY[this.domainPoint + 1][0] = this.radiusMax * Math.sin(this.theta);
                this.vertexPointsDataX[this.domainPoint][0] = this.vertex[this.domainPoint].re();
                this.vertexPointsDataY[this.domainPoint][0] = this.vertex[this.domainPoint].im();
                this.vertexPointsDataX[this.domainPoint + 1][0] = this.vertex[this.domainPoint + 1].re();
                this.vertexPointsDataY[this.domainPoint + 1][0] = this.vertex[this.domainPoint + 1].im();
                ++this.domainPoint;
            } else if (this.theta < previousArcBegin) {
                tempVertexRe = this.vertex[this.domainPoint].re();
                tempVertexReText = this.arcVertexPanels[this.domainPoint].getVertexReField().getText();
                tempVertexIm = this.vertex[this.domainPoint].im();
                tempVertexImText = this.arcVertexPanels[this.domainPoint].getVertexImField().getText();
                this.arcBegin[this.domainPoint] = this.arcBegin[this.domainPoint - 1];
                this.arcVertexPanels[this.domainPoint].getArcBeginField().setText(this.arcVertexPanels[this.domainPoint - 1].getArcBeginField().getText());
                this.vertex[this.domainPoint].setRe(this.vertex[this.domainPoint - 1].re());
                this.arcVertexPanels[this.domainPoint].getVertexReField().setText(this.arcVertexPanels[this.domainPoint - 1].getVertexReField().getText());
                this.vertex[this.domainPoint].setIm(this.vertex[this.domainPoint - 1].im());
                this.arcVertexPanels[this.domainPoint].getVertexImField().setText(this.arcVertexPanels[this.domainPoint - 1].getVertexImField().getText());
                this.arcPointsDataX[this.domainPoint][0] = this.arcPointsDataX[this.domainPoint - 1][0];
                this.arcPointsDataY[this.domainPoint][0] = this.arcPointsDataY[this.domainPoint - 1][0];
                this.arcBegin[this.domainPoint - 1] = this.theta;
                this.arcVertexPanels[this.domainPoint - 1].setArcBegin(this.theta);
                this.vertex[this.domainPoint - 1].setRe(tempVertexRe);
                this.arcVertexPanels[this.domainPoint - 1].getVertexReField().setText(tempVertexReText);
                this.vertex[this.domainPoint - 1].setIm(tempVertexIm);
                this.arcVertexPanels[this.domainPoint - 1].getVertexImField().setText(tempVertexImText);
                this.arcPointsDataX[this.domainPoint - 1][0] = this.radiusMax * Math.cos(this.theta);
                this.arcPointsDataY[this.domainPoint - 1][0] = this.radiusMax * Math.sin(this.theta);
                this.vertexPointsDataX[this.domainPoint][0] = this.vertex[this.domainPoint].re();
                this.vertexPointsDataY[this.domainPoint][0] = this.vertex[this.domainPoint].im();
                this.vertexPointsDataX[this.domainPoint - 1][0] = this.vertex[this.domainPoint - 1].re();
                this.vertexPointsDataY[this.domainPoint - 1][0] = this.vertex[this.domainPoint - 1].im();
                --this.domainPoint;
            } else {
                this.arcBegin[this.domainPoint] = this.theta;
                this.arcVertexPanels[this.domainPoint].setArcBegin(this.theta);
                this.arcPointsDataX[this.domainPoint][0] = this.radiusMax * Math.cos(this.theta);
                this.arcPointsDataY[this.domainPoint][0] = this.radiusMax * Math.sin(this.theta);
            }
            if (this.polygonHasBeenGraphed) {
                this.transformData();
            }
            this.domainGrapher.plotData();
            this.rangeGrapher.plotData();
        }
    }

    private void domainGrapherMousePressed(MouseEvent evt) {
        this.clearLabels();
        this.cursorX = this.domainGrapher.getXVal(evt.getX());
        this.cursorY = this.domainGrapher.getYVal(evt.getY());
        if (this.sketchBox.isSelected()) {
            this.domainGrapher.setLastX(this.cursorX);
            this.domainGrapher.setLastY(this.cursorY);
            this.zVal.setRe(this.cursorX);
            this.zVal.setIm(this.cursorY);
            this.zRange = this.func(this.zVal);
            this.rangeGrapher.setLastX(this.zRange.re());
            this.rangeGrapher.setLastY(this.zRange.im());
        } else {
            this.foundDomainPoint = false;
            this.domainPoint = 0;
            while (!this.foundDomainPoint && this.domainPoint <= this.numArcVertexPanels - 1) {
                if (Math.sqrt((this.cursorX - this.radiusMax * Math.cos(this.arcBegin[this.domainPoint])) * (this.cursorX - this.radiusMax * Math.cos(this.arcBegin[this.domainPoint])) + (this.cursorY - this.radiusMax * Math.sin(this.arcBegin[this.domainPoint])) * (this.cursorY - this.radiusMax * Math.sin(this.arcBegin[this.domainPoint]))) <= this.domainPointTolerance) {
                    this.foundDomainPoint = true;
                    this.lastTheta = this.theta = this.arcBegin[this.domainPoint];
                    continue;
                }
                ++this.domainPoint;
            }
        }
    }

    private void domainGrapherMouseMoved(MouseEvent evt) {
        this.cursorX = this.domainGrapher.getXVal(evt.getX());
        this.cursorY = this.domainGrapher.getYVal(evt.getY());
        this.domainCursorLocateLabel.setCursorLocation(this.cursorX, this.cursorY);
    }

    private void domainGrapherMouseExited(MouseEvent evt) {
        this.componentIsFocused = false;
        this.domainCursorLocateLabel.setVisible(false);
    }

    private void domainGrapherMouseEntered(MouseEvent evt) {
        this.zoomPanel.register(this.domainGrapher);
        this.currentGrapher = this.domainGrapher;
        this.currentDomainRange = this.domainDomainRange;
        this.componentIsFocused = this.domainGrapher.requestFocusInWindow();
        this.domainCursorLocateLabel.setCursorLocation(this.domainGrapher.getXVal(evt.getX()), this.domainGrapher.getYVal(evt.getY()));
        this.domainCursorLocateLabel.setVisible(true);
    }

    private void removeButtonMouseClicked(MouseEvent evt) {
        int whichPanel = -1;
        int whichVertex = 0;
        boolean vertexFound = false;
        if (this.numArcVertexPanels >= 1) {
            if (this.numArcVertexPanels == 1) {
                this.removeArcVertexPanel();
                this.numArcs = 0;
                this.numVertices = 0;
                this.numArcVertexPanels = 0;
                this.arcVertexPanels[0].clearHighlight();
                this.currentHighlightedPanel = -1;
                this.domainGrapher.setNumTraces(1);
                this.rangeGrapher.setNumTraces(0);
                this.domainGrapher.plotData();
                this.rangeGrapher.plotData();
            } else {
                int i;
                whichPanel = this.currentHighlightedPanel == -1 ? this.numArcVertexPanels - 1 : this.currentHighlightedPanel;
                while (!vertexFound && whichVertex <= this.numVertices - 1) {
                    if (this.rangeOrderTraces[whichVertex] == whichPanel) {
                        vertexFound = true;
                        continue;
                    }
                    ++whichVertex;
                }
                if (vertexFound) {
                    --this.numVertices;
                    for (i = whichVertex; i <= this.numVertices - 1; ++i) {
                        this.rangeOrderTraces[i] = this.rangeOrderTraces[i + 1];
                    }
                }
                for (i = whichPanel; i <= this.numArcs - 2; ++i) {
                    for (int j = 0; j <= this.numVertices - 1; ++j) {
                        if (this.rangeOrderTraces[j] != i + 1) continue;
                        this.rangeOrderTraces[j] = i;
                    }
                    this.arcBegin[i] = this.arcBegin[i + 1];
                    this.arcVertexPanels[i].getArcBeginField().setText(this.arcVertexPanels[i + 1].getArcBeginField().getText());
                    this.arcPointsDataX[i][0] = this.arcPointsDataX[i + 1][0];
                    this.arcPointsDataY[i][0] = this.arcPointsDataY[i + 1][0];
                    this.vertex[i].setRe(this.vertex[i + 1].re());
                    this.arcVertexPanels[i].getVertexReField().setText(this.arcVertexPanels[i + 1].getVertexReField().getText());
                    this.vertex[i].setIm(this.vertex[i + 1].im());
                    this.arcVertexPanels[i].getVertexImField().setText(this.arcVertexPanels[i + 1].getVertexImField().getText());
                    this.vertexPointsDataX[i][0] = this.vertexPointsDataX[i + 1][0];
                    this.vertexPointsDataY[i][0] = this.vertexPointsDataY[i + 1][0];
                }
                this.domainBegin = this.arcBegin[0] < 0.0 ? this.arcBegin[0] : 0.0;
                if (whichPanel <= this.numArcs - 1) {
                    --this.numArcs;
                }
                this.removeArcVertexPanel();
                if (this.currentHighlightedPanel >= 0) {
                    this.arcVertexPanels[this.currentHighlightedPanel].clearHighlight();
                }
                this.currentHighlightedPanel = -1;
                if (this.polygonHasBeenGraphed && this.numArcVertexPanels > 0) {
                    this.rangeOrderTraces[this.numVertices] = this.maxNumArcsVertices;
                    this.transformData();
                    this.rangeGrapher.setNumTraces(this.numVertices + 1);
                } else {
                    this.rangeGrapher.setNumTraces(this.numVertices);
                }
                this.domainGrapher.setNumTraces(this.numArcs + 1);
                this.domainGrapher.plotData();
                this.rangeGrapher.plotData(this.rangeOrderTraces, this.rangeAllData);
            }
        }
    }

    private boolean isXYInputsGood() {
        boolean noProblems = true;
        if (this.domainXMinField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[0] = this.domainXMinField.getDoubleVal();
            this.domainGrapher.setXMin(this.domainDomainRange[0]);
        }
        if (this.domainXMaxField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[1] = this.domainXMaxField.getDoubleVal();
            this.domainGrapher.setXMax(this.domainDomainRange[1]);
        }
        if (this.domainYMinField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[2] = this.domainYMinField.getDoubleVal();
            this.domainGrapher.setYMin(this.domainDomainRange[2]);
        }
        if (this.domainYMaxField.hasError()) {
            noProblems = false;
        } else {
            this.domainDomainRange[3] = this.domainYMaxField.getDoubleVal();
            this.domainGrapher.setYMax(this.domainDomainRange[3]);
        }
        if (this.rangeXMinField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[0] = this.rangeXMinField.getDoubleVal();
            this.rangeGrapher.setXMin(this.rangeDomainRange[0]);
        }
        if (this.rangeXMaxField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[1] = this.rangeXMaxField.getDoubleVal();
            this.rangeGrapher.setXMax(this.rangeDomainRange[1]);
        }
        if (this.rangeYMinField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[2] = this.rangeYMinField.getDoubleVal();
            this.rangeGrapher.setYMin(this.rangeDomainRange[2]);
        }
        if (this.rangeYMaxField.hasError()) {
            noProblems = false;
        } else {
            this.rangeDomainRange[3] = this.rangeYMaxField.getDoubleVal();
            this.rangeGrapher.setYMax(this.rangeDomainRange[3]);
        }
        this.domainPointTolerance = Math.sqrt((this.domainDomainRange[3] - this.domainDomainRange[2]) * (this.domainDomainRange[3] - this.domainDomainRange[2]) + (this.domainDomainRange[1] - this.domainDomainRange[0]) * (this.domainDomainRange[1] - this.domainDomainRange[0])) / 20.0;
        this.rangePointTolerance = Math.sqrt((this.rangeDomainRange[3] - this.rangeDomainRange[2]) * (this.rangeDomainRange[3] - this.rangeDomainRange[2]) + (this.rangeDomainRange[1] - this.rangeDomainRange[0]) * (this.rangeDomainRange[1] - this.rangeDomainRange[0])) / 20.0;
        return noProblems;
    }

    private void transformData() {
        int j;
        int i;
        for (i = 0; i <= this.domainPGrid.getNumCircles() - 1; ++i) {
            for (j = 0; j <= this.domainPGrid.getNumCirclePoints() - 1; ++j) {
                this.zVal.setRe(this.domainPGrid.getCircles(i).getDataX(j));
                this.zVal.setIm(this.domainPGrid.getCircles(i).getDataY(j));
                this.zRange = this.func(this.zVal);
                this.rangePGrid.getCircles(i).setDataX(j, this.zRange.re());
                this.rangePGrid.getCircles(i).setDataY(j, this.zRange.im());
            }
        }
        for (i = 0; i <= this.domainPGrid.getNumTotalRays() - 1; ++i) {
            for (j = 0; j <= this.domainPGrid.getNumRayPoints() - 1; ++j) {
                this.zVal.setRe(this.domainPGrid.getRays(i).getDataX(j));
                this.zVal.setIm(this.domainPGrid.getRays(i).getDataY(j));
                this.zRange = this.func(this.zVal);
                this.rangePGrid.getRays(i).setDataX(j, this.zRange.re());
                this.rangePGrid.getRays(i).setDataY(j, this.zRange.im());
            }
        }
    }

    private void clearLabels() {
        this.errorLabel.setVisible(false);
        this.domainXMinField.setBackground(this.backgroundColor);
        this.domainXMaxField.setBackground(this.backgroundColor);
        this.domainYMinField.setBackground(this.backgroundColor);
        this.domainYMaxField.setBackground(this.backgroundColor);
        this.rangeXMinField.setBackground(this.backgroundColor);
        this.rangeXMaxField.setBackground(this.backgroundColor);
        this.rangeYMinField.setBackground(this.backgroundColor);
        this.rangeYMaxField.setBackground(this.backgroundColor);
        this.numRaysField.setBackground(this.backgroundColor);
        this.numInteriorCirclesField.setBackground(this.backgroundColor);
        for (int i = 0; i <= this.numArcVertexPanels - 1; ++i) {
            this.arcVertexPanels[i].clearLabels();
        }
    }

    private boolean isInputInfoGood() {
        boolean noProblems = true;
        if (this.numRaysField.hasError()) {
            noProblems = false;
        } else {
            this.numRays = this.numRaysField.getIntVal();
            this.domainPGrid.setNumRays(this.numRays);
            this.rangePGrid.setNumRays(this.numRays);
        }
        if (this.numInteriorCirclesField.hasError()) {
            noProblems = false;
        } else {
            this.numInteriorCircles = this.numInteriorCirclesField.getIntVal();
            this.domainPGrid.setNumCircles(this.numInteriorCircles + 1);
            this.rangePGrid.setNumCircles(this.numInteriorCircles + 1);
        }
        for (int i = 0; i <= this.numArcVertexPanels - 1; ++i) {
            if (this.arcVertexPanels[i].isInputInfoGood()) continue;
            noProblems = false;
        }
        return noProblems;
    }

    private Complex func(Complex z) {
        Complex sum = new Complex();
        for (int i = 0; i <= this.numArcVertexPanels - 2; ++i) {
            this.funcPart1 = this.vertex[i].mul((this.arcBegin[i + 1] - this.arcBegin[i]) / (Math.PI * 2));
            this.exponent.setRe(Math.cos(-this.arcBegin[i + 1]));
            this.exponent.setIm(Math.sin(-this.arcBegin[i + 1]));
            this.funcNumerator = this.one.sub(z.mul(this.exponent));
            this.exponent.setRe(Math.cos(-this.arcBegin[i]));
            this.exponent.setIm(Math.sin(-this.arcBegin[i]));
            this.funcDenom = this.one.sub(z.mul(this.exponent));
            this.funcPart2 = this.vertex[i].mul(this.funcNumerator.div(this.funcDenom).arg()).mul(this.piInverse);
            sum = sum.add(this.funcPart1).add(this.funcPart2);
        }
        this.funcPart1 = this.vertex[this.numArcVertexPanels - 1].mul((this.arcBegin[0] + Math.PI * 2 - this.arcBegin[this.numArcVertexPanels - 1]) / (Math.PI * 2));
        this.exponent.setRe(Math.cos(-this.arcBegin[0] - Math.PI * 2));
        this.exponent.setIm(Math.sin(-this.arcBegin[0] - Math.PI * 2));
        this.funcNumerator = this.one.sub(z.mul(this.exponent));
        this.exponent.setRe(Math.cos(-this.arcBegin[this.numArcVertexPanels - 1]));
        this.exponent.setIm(Math.sin(-this.arcBegin[this.numArcVertexPanels - 1]));
        this.funcDenom = this.one.sub(z.mul(this.exponent));
        this.funcPart2 = this.vertex[this.numArcVertexPanels - 1].mul(this.funcNumerator.div(this.funcDenom).arg()).mul(this.piInverse);
        sum = sum.add(this.funcPart1).add(this.funcPart2);
        return sum;
    }

    private void initStuff() {
        this.errorLabel.setVisible(false);
        this.rangeDomainChoiceBox.registerObjects(this.rangeGrapher, this.rangeDomainRange, this.rangeXMinField, this.rangeXMaxField, this.rangeYMinField, this.rangeYMaxField);
        this.domainDomainChoiceBox.registerObjects(this.domainGrapher, this.domainDomainRange, this.domainXMinField, this.domainXMaxField, this.domainYMinField, this.domainYMaxField);
        this.domainGrapher.registerObjects(this.domainDomainRange, this.domainXMinField, this.domainXMaxField, this.domainYMinField, this.domainYMaxField);
        this.rangeGrapher.registerObjects(this.rangeDomainRange, this.rangeXMinField, this.rangeXMaxField, this.rangeYMinField, this.rangeYMaxField);
        this.zoomPanel.register(this.domainGrapher);
        this.currentGrapher = this.domainGrapher;
        this.currentDomainRange = this.domainDomainRange;
        this.domainPGrid.setRadiusMax(this.radiusMax);
        this.rangePGrid.setRadiusMax(this.radiusMax);
        this.rangeGrapher.init();
        this.startAtLabel.setVisible(false);
        this.mapToLabel.setVisible(false);
        this.arcVertexPanels = new ArcVertexPanel[this.maxNumArcsVertices];
        this.domainAllData = new PlotStuff[1 + this.maxNumArcsVertices];
        this.rangeAllData = new PlotStuff[1 + this.maxNumArcsVertices];
        this.rangeOrderTraces = new int[1 + this.maxNumArcsVertices];
        this.arcBegin = new double[this.maxNumArcsVertices];
        this.vertex = new Complex[this.maxNumArcsVertices];
        this.arcPoints = new PlotStuff2D[this.maxNumArcsVertices];
        this.arcPointsDataX = new double[this.maxNumArcsVertices][1];
        this.arcPointsDataY = new double[this.maxNumArcsVertices][1];
        this.vertexPoints = new PlotStuff2D[this.maxNumArcsVertices];
        this.vertexPointsDataX = new double[this.maxNumArcsVertices][1];
        this.vertexPointsDataY = new double[this.maxNumArcsVertices][1];
        this.arcVertexInfo = new ArcVertexInfo[this.maxNumArcsVertices];
        this.domainAllData[0] = this.domainPGrid;
        this.rangeAllData[this.maxNumArcsVertices] = this.rangePGrid;
        for (int i = 0; i <= this.maxNumArcsVertices - 1; ++i) {
            this.arcVertexInfo[i] = new ArcVertexInfo();
            this.arcPoints[i] = new PlotStuff2D();
            this.arcPoints[i].setPlotStyle(1);
            this.arcPoints[i].setNumPoints(1);
            this.arcPoints[i].setPlotSize(3);
            this.arcPoints[i].setPlotColor(this.arcPointPlotColor);
            this.arcPoints[i].setDataX(this.arcPointsDataX[i]);
            this.arcPoints[i].setDataY(this.arcPointsDataY[i]);
            this.domainAllData[i + 1] = this.arcPoints[i];
            this.vertexPoints[i] = new PlotStuff2D();
            this.vertexPoints[i].setPlotStyle(1);
            this.vertexPoints[i].setNumPoints(1);
            this.vertexPoints[i].setPlotSize(3);
            this.vertexPoints[i].setPlotColor(this.arcPointPlotColor);
            this.vertexPoints[i].setDataX(this.vertexPointsDataX[i]);
            this.vertexPoints[i].setDataY(this.vertexPointsDataY[i]);
            this.rangeAllData[i] = this.vertexPoints[i];
            this.arcVertexPanels[i] = new ArcVertexPanel();
            this.polygonPanel.add(this.arcVertexPanels[i]);
            this.arcVertexPanels[i].setBounds(1, 51 + i * 20, 320, 18);
            this.arcVertexPanels[i].setArcNum(i + 1);
            this.arcVertexPanels[i].setVisible(false);
            this.arcVertexPanels[i].addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    PolyTool.this.arcVertexPanelsPropertyChange(evt);
                }
            });
            this.vertex[i] = new Complex();
        }
        this.zoomPanel.setVisible(false);
        this.zoomErrorMessagePanel.setVisible(false);
        this.domainGrapher.setSketchTrace(this.sketchData);
        this.rangeGrapher.setSketchTrace(this.sketchData);
        this.rangeCursorLocateLabel.setVisible(false);
        this.domainCursorLocateLabel.setVisible(false);
        this.domainPGrid.createData();
        this.domainGrapher.plotData(this.domainPGrid);
    }

    private void insertDomainPoint(int currentArcPoint, double theta, String vertexReText, String vertexImText) {
        this.arcBegin[currentArcPoint] = theta;
        this.arcVertexPanels[currentArcPoint].setArcBegin(theta);
        this.arcPointsDataX[currentArcPoint][0] = this.radiusMax * Math.cos(theta);
        this.arcPointsDataY[currentArcPoint][0] = this.radiusMax * Math.sin(theta);
        this.arcVertexPanels[currentArcPoint].getVertexReField().setText(vertexReText);
        this.arcVertexPanels[currentArcPoint].getVertexImField().setText(vertexImText);
    }

    private boolean areArcFieldsGood(int skipArc) {
        boolean noProblems = true;
        if (skipArc == -1 || skipArc > this.numArcs) {
            for (int i = 0; i <= this.numArcs - 1; ++i) {
                if (this.arcVertexPanels[i].isArcInfoGood()) continue;
                noProblems = false;
            }
        } else {
            int i;
            for (i = 0; i <= skipArc - 1; ++i) {
                if (this.arcVertexPanels[i].isArcInfoGood()) continue;
                noProblems = false;
            }
            for (i = skipArc + 1; i <= this.numArcs - 1; ++i) {
                if (this.arcVertexPanels[i].isArcInfoGood()) continue;
                noProblems = false;
            }
        }
        return noProblems;
    }

    private void placeDomainPoint(MouseEvent evt) {
        String tempVertexReText = null;
        String tempVertexImText = null;
        double tol = (this.domainDomainRange[3] - this.domainDomainRange[2]) / 18.0;
        double radius = 0.0;
        double localTheta = 0.0;
        double thetaAhead = 0.0;
        double thetaBehind = 0.0;
        boolean noProblems = true;
        if (this.numArcs < this.maxNumArcsVertices) {
            this.cursorX = this.domainGrapher.getXVal(evt.getX());
            this.cursorY = this.domainGrapher.getYVal(evt.getY());
            radius = Math.sqrt(this.cursorX * this.cursorX + this.cursorY * this.cursorY);
            if (Math.abs(this.radiusMax - radius) <= tol && this.cursorX != 0.0 && this.cursorY != 0.0) {
                int currentArc;
                localTheta = this.getTheta(this.cursorX, this.cursorY);
                if (!(this.numArcVertexPanels >= this.maxNumArcsVertices || this.currentHighlightedPanel != -1 && this.arcVertexPanels[this.currentHighlightedPanel].isArcHighlighted())) {
                    noProblems = this.areArcFieldsGood(-1);
                    if (noProblems) {
                        for (currentArc = 0; currentArc < this.numArcs && localTheta > this.arcBegin[currentArc]; ++currentArc) {
                        }
                        for (int i = this.numArcVertexPanels - 1; i >= currentArc; --i) {
                            for (int j = 0; j <= this.numVertices - 1; ++j) {
                                if (this.rangeOrderTraces[j] != i) continue;
                                this.rangeOrderTraces[j] = i + 1;
                            }
                            this.arcBegin[i + 1] = this.arcBegin[i];
                            this.arcVertexPanels[i + 1].getArcBeginField().setText(this.arcVertexPanels[i].getArcBeginField().getText());
                            this.arcPointsDataX[i + 1][0] = this.arcPointsDataX[i][0];
                            this.arcPointsDataY[i + 1][0] = this.arcPointsDataY[i][0];
                            this.vertexPointsDataX[i + 1][0] = this.vertexPointsDataX[i][0];
                            this.arcVertexPanels[i + 1].getVertexReField().setText(this.arcVertexPanels[i].getVertexReField().getText());
                            this.vertexPointsDataY[i + 1][0] = this.vertexPointsDataY[i][0];
                            this.arcVertexPanels[i + 1].getVertexImField().setText(this.arcVertexPanels[i].getVertexImField().getText());
                        }
                        tempVertexReText = "";
                        tempVertexImText = "";
                        this.addArcVertexPanel();
                        ++this.numArcs;
                        this.insertDomainPoint(currentArc, localTheta, tempVertexReText, tempVertexImText);
                    }
                } else if (this.arcVertexPanels[this.currentHighlightedPanel].isArcHighlighted() && (noProblems = this.areArcFieldsGood(this.currentHighlightedPanel))) {
                    tempVertexReText = this.arcVertexPanels[this.currentHighlightedPanel].getVertexReField().getText();
                    tempVertexImText = this.arcVertexPanels[this.currentHighlightedPanel].getVertexImField().getText();
                    if (this.currentHighlightedPanel >= this.numArcs) {
                        while (currentArc < this.numArcs && localTheta > this.arcBegin[currentArc]) {
                            ++currentArc;
                        }
                        for (int i = this.currentHighlightedPanel - 1; i >= currentArc; --i) {
                            this.arcBegin[i + 1] = this.arcBegin[i];
                            this.arcPointsDataX[i + 1][0] = this.arcPointsDataX[i][0];
                            this.arcPointsDataY[i + 1][0] = this.arcPointsDataY[i][0];
                            this.arcVertexPanels[i + 1].getArcBeginField().setText(this.arcVertexPanels[i].getArcBeginField().getText());
                            this.arcVertexPanels[i + 1].getVertexReField().setText(this.arcVertexPanels[i].getVertexReField().getText());
                            this.arcVertexPanels[i + 1].getVertexImField().setText(this.arcVertexPanels[i].getVertexImField().getText());
                        }
                        ++this.numArcs;
                    } else {
                        if (this.currentHighlightedPanel == 0) {
                            thetaAhead = this.arcBegin[1];
                            thetaBehind = 0.0;
                        } else if (this.currentHighlightedPanel == this.numArcs - 1) {
                            thetaAhead = Math.PI * 2;
                            thetaBehind = this.arcBegin[this.numArcs - 2];
                        } else {
                            thetaAhead = this.arcBegin[this.currentHighlightedPanel + 1];
                            thetaBehind = this.arcBegin[this.currentHighlightedPanel - 1];
                        }
                        if (localTheta >= thetaBehind && localTheta <= thetaAhead) {
                            currentArc = this.currentHighlightedPanel;
                        } else if (localTheta > thetaAhead) {
                            tempVertexReText = this.arcVertexPanels[this.currentHighlightedPanel].getVertexReField().getText();
                            tempVertexImText = this.arcVertexPanels[this.currentHighlightedPanel].getVertexImField().getText();
                            for (currentArc = this.currentHighlightedPanel + 1; currentArc < this.numArcs - 1 && localTheta > this.arcBegin[currentArc - 1]; ++currentArc) {
                            }
                            for (int i = this.currentHighlightedPanel; i < currentArc; ++i) {
                                this.arcBegin[i] = this.arcBegin[i + 1];
                                this.arcPointsDataX[i][0] = this.arcPointsDataX[i + 1][0];
                                this.arcPointsDataY[i][0] = this.arcPointsDataY[i + 1][0];
                                this.arcVertexPanels[i].getArcBeginField().setText(this.arcVertexPanels[i + 1].getArcBeginField().getText());
                                this.arcVertexPanels[i].getVertexReField().setText(this.arcVertexPanels[i + 1].getVertexReField().getText());
                                this.arcVertexPanels[i].getVertexImField().setText(this.arcVertexPanels[i + 1].getVertexImField().getText());
                            }
                        } else {
                            tempVertexReText = this.arcVertexPanels[this.currentHighlightedPanel].getVertexReField().getText();
                            tempVertexImText = this.arcVertexPanels[this.currentHighlightedPanel].getVertexImField().getText();
                            for (currentArc = this.currentHighlightedPanel - 1; currentArc > 0 && localTheta < this.arcBegin[currentArc]; --currentArc) {
                            }
                            for (int i = this.currentHighlightedPanel - 1; i >= currentArc; --i) {
                                this.arcBegin[i + 1] = this.arcBegin[i];
                                this.arcPointsDataX[i + 1][0] = this.arcPointsDataX[i][0];
                                this.arcPointsDataY[i + 1][0] = this.arcPointsDataY[i][0];
                                this.arcVertexPanels[i + 1].getArcBeginField().setText(this.arcVertexPanels[i].getArcBeginField().getText());
                                this.arcVertexPanels[i + 1].getVertexReField().setText(this.arcVertexPanels[i].getVertexReField().getText());
                                this.arcVertexPanels[i + 1].getVertexImField().setText(this.arcVertexPanels[i].getVertexImField().getText());
                            }
                        }
                    }
                    this.insertDomainPoint(currentArc, localTheta, tempVertexReText, tempVertexImText);
                    this.currentHighlightedPanel = -1;
                }
            }
        }
        if (noProblems) {
            if (!this.findFirstArcSlot()) {
                this.findFirstVertexSlot();
            }
            this.numRays = 4 * this.numArcs;
            this.numRaysField.setText("" + this.numRays);
            this.domainPGrid.setNumRays(this.numRays);
            this.rangePGrid.setNumRays(this.numRays);
            this.domainGrapher.setNumTraces(1 + this.numArcs);
            this.domainGrapher.plotData(this.domainAllData);
        }
    }

    private void placeRangePoint(MouseEvent evt) {
        int currentRangeOrderTrace = -1;
        if (this.numVertices < this.maxNumArcsVertices) {
            this.cursorX = this.rangeGrapher.getXVal(evt.getX());
            this.cursorY = this.rangeGrapher.getYVal(evt.getY());
            if (this.currentHighlightedPanel == -1 || !this.arcVertexPanels[this.currentHighlightedPanel].isVertexHighlighted()) {
                this.vertexPointsDataX[this.numArcVertexPanels][0] = this.cursorX;
                this.vertexPointsDataY[this.numArcVertexPanels][0] = this.cursorY;
                this.arcVertexPanels[this.numArcVertexPanels].setVertexRe(this.cursorX);
                this.arcVertexPanels[this.numArcVertexPanels].setVertexIm(this.cursorY);
                this.rangeOrderTraces[this.numVertices] = this.numArcVertexPanels;
                if (this.polygonHasBeenGraphed) {
                    this.rangeOrderTraces[this.numVertices + 1] = this.maxNumArcsVertices;
                }
                this.addArcVertexPanel();
                this.arcVertexPanels[this.numArcVertexPanels - 1].getArcBeginField().setText("");
                this.arcVertexPanels[this.numArcVertexPanels - 1].getArcBeginField().requestFocus();
                ++this.numVertices;
            } else {
                for (int i = 0; i <= this.numVertices - 1; ++i) {
                    if (this.arcVertexPanels[this.rangeOrderTraces[i]].getArcNum() - 1 != this.currentHighlightedPanel) continue;
                    currentRangeOrderTrace = i;
                }
                this.vertexPointsDataX[this.currentHighlightedPanel][0] = this.cursorX;
                this.arcVertexPanels[this.currentHighlightedPanel].setVertexRe(this.cursorX);
                this.vertexPointsDataY[this.currentHighlightedPanel][0] = this.cursorY;
                this.arcVertexPanels[this.currentHighlightedPanel].setVertexIm(this.cursorY);
                if (currentRangeOrderTrace == -1) {
                    this.rangeOrderTraces[this.numVertices] = this.currentHighlightedPanel;
                    if (this.polygonHasBeenGraphed) {
                        this.rangeOrderTraces[this.numVertices + 1] = this.maxNumArcsVertices;
                    }
                    ++this.numVertices;
                }
                this.findNextVertexSlot();
            }
            if (this.polygonHasBeenGraphed) {
                this.rangeGrapher.setNumTraces(this.numVertices + 1);
            } else {
                this.rangeGrapher.setNumTraces(this.numVertices);
            }
            this.rangeGrapher.plotData(this.rangeOrderTraces, this.rangeAllData);
        }
    }

    private double getTheta(double cursorX, double cursorY) {
        double localTheta = 0.0;
        double asin = 0.0;
        double acos = 0.0;
        double radius = Math.sqrt(cursorX * cursorX + cursorY * cursorY);
        acos = Math.acos(cursorX / radius);
        asin = Math.asin(cursorY / radius);
        if (asin >= 0.0) {
            localTheta = acos;
        } else {
            localTheta = acos > 1.5707963267948966 ? Math.PI - asin : Math.PI * 2 + asin;
            if (localTheta - Math.PI * 2 > this.domainBegin) {
                localTheta -= Math.PI * 2;
            }
        }
        return localTheta;
    }

    private void findNextArcSlot() {
        int currentArc = 0;
        for (currentArc = this.currentHighlightedPanel + 1; currentArc <= this.numArcVertexPanels - 1 && !this.arcVertexPanels[currentArc].getArcBeginField().getText().equals(""); ++currentArc) {
        }
        if (currentArc <= this.numArcVertexPanels - 1) {
            this.arcVertexPanels[currentArc].getArcBeginField().requestFocus();
        } else {
            for (currentArc = 0; currentArc < this.currentHighlightedPanel && !this.arcVertexPanels[currentArc].getArcBeginField().getText().equals(""); ++currentArc) {
            }
            if (currentArc < this.currentHighlightedPanel) {
                this.arcVertexPanels[currentArc].getArcBeginField().requestFocus();
            } else {
                this.arcVertexPanels[this.currentHighlightedPanel].clearHighlight();
                this.currentHighlightedPanel = -1;
            }
        }
    }

    private void findNextVertexSlot() {
        this.currentVertex = this.currentHighlightedPanel + 1;
        while (this.currentVertex <= this.numArcVertexPanels - 1 && !this.arcVertexPanels[this.currentVertex].getVertexReField().getText().equals("") && !this.arcVertexPanels[this.currentVertex].getVertexImField().getText().equals("")) {
            ++this.currentVertex;
        }
        if (this.currentVertex <= this.numArcVertexPanels - 1) {
            this.arcVertexPanels[this.currentVertex].getVertexReField().requestFocus();
        } else {
            this.currentVertex = 0;
            while (this.currentVertex < this.currentHighlightedPanel && !this.arcVertexPanels[this.currentVertex].getVertexReField().getText().equals("") && !this.arcVertexPanels[this.currentVertex].getVertexImField().getText().equals("")) {
                ++this.currentVertex;
            }
            if (this.currentVertex < this.currentHighlightedPanel) {
                this.arcVertexPanels[this.currentVertex].getVertexReField().requestFocus();
            } else {
                this.arcVertexPanels[this.currentHighlightedPanel].clearHighlight();
                this.currentHighlightedPanel = -1;
            }
        }
    }

    private void removeArcVertexPanel() {
        if (this.numArcVertexPanels == 1) {
            this.startAtLabel.setVisible(false);
            this.mapToLabel.setVisible(false);
        }
        this.arcVertexPanels[this.numArcVertexPanels - 1].setVisible(false);
        --this.numArcVertexPanels;
    }

    private void insertArcVertexPanel(int insertSlot) {
        int i;
        if (this.numArcVertexPanels == 0) {
            this.graphButton.setVisible(true);
            this.clearAllButton.setVisible(true);
            this.removeButton.setVisible(true);
            this.startAtLabel.setVisible(true);
            this.mapToLabel.setVisible(true);
        }
        this.arcVertexPanels[this.numArcVertexPanels].setVisible(true);
        ++this.numArcVertexPanels;
        for (i = this.numArcVertexPanels - 1; i > insertSlot; --i) {
            this.arcBegin[i] = this.arcBegin[i - 1];
            this.arcVertexPanels[i].setArcBegin(this.arcVertexPanels[i - 1].getArcBegin());
            this.arcVertexPanels[i].getArcBeginField().setText(this.arcVertexPanels[i - 1].getArcBeginField().getText());
            this.arcVertexPanels[i].setVertexRe(this.arcVertexPanels[i - 1].getVertexRe());
            this.arcVertexPanels[i].getVertexReField().setText(this.arcVertexPanels[i - 1].getVertexReField().getText());
            this.arcVertexPanels[i].setVertexIm(this.arcVertexPanels[i - 1].getVertexIm());
            this.arcVertexPanels[i].getVertexImField().setText(this.arcVertexPanels[i - 1].getVertexImField().getText());
        }
        for (i = 0; i <= this.numVertices - 1; ++i) {
            if (this.rangeOrderTraces[i] < insertSlot) continue;
            this.rangeOrderTraces[i] = this.rangeOrderTraces[i] + 1;
        }
        if (this.polygonHasBeenGraphed) {
            this.rangeOrderTraces[this.numVertices] = this.maxNumArcsVertices;
        }
        this.arcVertexPanels[insertSlot].getArcBeginField().setText("");
        this.arcVertexPanels[insertSlot].getVertexReField().setText("");
        this.arcVertexPanels[insertSlot].getVertexImField().setText("");
    }

    private void addArcVertexPanel() {
        if (this.numArcVertexPanels == 0) {
            this.graphButton.setVisible(true);
            this.clearAllButton.setVisible(true);
            this.removeButton.setVisible(true);
            this.startAtLabel.setVisible(true);
            this.mapToLabel.setVisible(true);
        }
        this.arcVertexPanels[this.numArcVertexPanels].setVisible(true);
        ++this.numArcVertexPanels;
    }

    public void arcVertexPanelsPropertyChange(PropertyChangeEvent evt) {
        if (this.currentHighlightedPanel != -1) {
            this.arcVertexPanels[this.currentHighlightedPanel].clearHighlight();
        }
        this.currentHighlightedPanel = ((ArcVertexPanel)evt.getSource()).getArcNum() - 1;
        this.focusField = ((ArcVertexPanel)evt.getSource()).getFocusField();
    }

    private boolean findFirstArcSlot() {
        int currentArc;
        boolean foundArcSlot = false;
        for (currentArc = 0; currentArc <= this.numArcVertexPanels - 1 && !this.arcVertexPanels[currentArc].getArcBeginField().getText().equals(""); ++currentArc) {
        }
        if (currentArc <= this.numArcVertexPanels - 1) {
            this.requestFocus(3, this.arcVertexPanels[currentArc]);
            foundArcSlot = true;
        } else {
            if (this.currentHighlightedPanel != -1) {
                this.arcVertexPanels[this.currentHighlightedPanel].clearHighlight();
            }
            this.currentHighlightedPanel = -1;
            foundArcSlot = false;
        }
        return foundArcSlot;
    }

    private void findFirstVertexSlot() {
        int localCurrentVertex;
        for (localCurrentVertex = 0; localCurrentVertex <= this.numArcVertexPanels - 1 && !this.arcVertexPanels[localCurrentVertex].getVertexReField().getText().equals("") && !this.arcVertexPanels[localCurrentVertex].getVertexImField().getText().equals(""); ++localCurrentVertex) {
        }
        if (localCurrentVertex <= this.numArcVertexPanels - 1) {
            this.requestFocus(4, this.arcVertexPanels[localCurrentVertex]);
        } else {
            if (this.currentHighlightedPanel != -1) {
                this.arcVertexPanels[this.currentHighlightedPanel].clearHighlight();
            }
            this.currentHighlightedPanel = -1;
        }
    }

    private void requestFocus(int arcVertex, ArcVertexPanel panel) {
        for (int i = 0; i <= this.numArcVertexPanels - 1; ++i) {
            this.arcVertexPanels[i].clearHighlight();
        }
        if (arcVertex == 3) {
            panel.getArcBeginField().requestFocus();
            panel.highlightArcFields();
        } else {
            panel.getVertexReField().requestFocus();
            panel.highlightVertexFields();
        }
        this.currentHighlightedPanel = panel.getArcNum() - 1;
    }
}

