/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.polytool;

import com.jimrolf.functionfield.DoubleField;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ArcVertexPanel
extends JPanel {
    private float[] hueSatBright = new float[3];
    private Color fieldHighlightBackgroundColor = null;
    private Color fieldBackgroundColor = null;
    private DoubleField arcBeginField;
    private JLabel arcNumLabel;
    private JLabel iLabel;
    private JLabel mapsToLabel;
    private JLabel plusLabel;
    private DoubleField vertexImField;
    private DoubleField vertexReField;
    private Color highlightColor = new Color(255, 214, 159);
    private double arcBegin = 0.0;
    private double vertexRe = 0.0;
    private double vertexIm = 0.0;
    private int arcNum = 0;
    private Color panelColor = Color.white;
    private JTextField focusField;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean arcHighlighted = false;
    private boolean vertexHighlighted = false;

    public void highlightArcFields() {
        this.arcBeginField.setBackground(this.fieldHighlightBackgroundColor);
        this.arcHighlighted = true;
    }

    public void highlightVertexFields() {
        this.vertexReField.setBackground(this.fieldHighlightBackgroundColor);
        this.vertexImField.setBackground(this.fieldHighlightBackgroundColor);
        this.vertexHighlighted = true;
    }

    public void highlightPanel() {
        this.setBackground(this.highlightColor);
        this.highlightArcFields();
        this.highlightVertexFields();
    }

    public void clearHighlight() {
        this.setBackground(this.panelColor);
        this.clearArcHighlight();
        this.clearVertexHighlight();
    }

    public void clearVertexHighlight() {
        this.vertexReField.setBackground(this.fieldBackgroundColor);
        this.vertexImField.setBackground(this.fieldBackgroundColor);
        this.vertexHighlighted = false;
    }

    public void clearArcHighlight() {
        this.arcBeginField.setBackground(this.fieldBackgroundColor);
        this.arcHighlighted = false;
    }

    public void clearLabels() {
        this.arcBeginField.setBackground(this.fieldBackgroundColor);
        this.vertexReField.setBackground(this.fieldBackgroundColor);
        this.vertexImField.setBackground(this.fieldBackgroundColor);
    }

    public boolean isArcInfoGood() {
        boolean noProblems = true;
        if (this.arcBeginField.hasError()) {
            noProblems = false;
        } else {
            this.arcBegin = this.arcBeginField.getDoubleVal();
        }
        return noProblems;
    }

    public boolean isInputInfoGood() {
        boolean noProblems = true;
        if (!this.isArcInfoGood()) {
            noProblems = false;
        }
        if (this.vertexReField.hasError()) {
            noProblems = false;
        } else {
            this.vertexRe = this.vertexReField.getDoubleVal();
        }
        if (this.vertexImField.hasError()) {
            noProblems = false;
        } else {
            this.vertexIm = this.vertexImField.getDoubleVal();
        }
        return noProblems;
    }

    public ArcVertexPanel() {
        this.initComponents();
        this.hueSatBright = Color.RGBtoHSB(this.highlightColor.getRed(), this.highlightColor.getGreen(), this.highlightColor.getBlue(), this.hueSatBright);
        this.fieldHighlightBackgroundColor = Color.getHSBColor(this.hueSatBright[0], this.hueSatBright[1], 0.9f * this.hueSatBright[2]);
        this.hueSatBright = Color.RGBtoHSB(this.panelColor.getRed(), this.panelColor.getGreen(), this.panelColor.getBlue(), this.hueSatBright);
        this.fieldBackgroundColor = Color.getHSBColor(this.hueSatBright[0], this.hueSatBright[1], 0.95f * this.hueSatBright[2]);
    }

    private void initComponents() {
        this.arcBeginField = new DoubleField();
        this.vertexReField = new DoubleField();
        this.vertexImField = new DoubleField();
        this.arcNumLabel = new JLabel();
        this.iLabel = new JLabel();
        this.plusLabel = new JLabel();
        this.mapsToLabel = new JLabel();
        this.setBackground(new Color(204, 204, 204));
        this.setOpaque(false);
        this.setLayout(null);
        this.arcBeginField.setText("");
        this.arcBeginField.setFont(new Font("LucidaSans", 0, 10));
        this.arcBeginField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ArcVertexPanel.this.arcBeginFieldFocusGained(evt);
            }
        });
        this.add(this.arcBeginField);
        this.arcBeginField.setBounds(37, 1, 75, 16);
        this.vertexReField.setText("");
        this.vertexReField.setFont(new Font("LucidaSans", 0, 10));
        this.vertexReField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ArcVertexPanel.this.vertexReFieldFocusGained(evt);
            }
        });
        this.add(this.vertexReField);
        this.vertexReField.setBounds(156, 1, 75, 16);
        this.vertexImField.setText("");
        this.vertexImField.setFont(new Font("LucidaSans", 0, 10));
        this.vertexImField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ArcVertexPanel.this.vertexImFieldFocusGained(evt);
            }
        });
        this.add(this.vertexImField);
        this.vertexImField.setBounds(238, 1, 75, 16);
        this.arcNumLabel.setBackground(new Color(255, 255, 255));
        this.arcNumLabel.setFont(new Font("LucidaSans", 0, 10));
        this.arcNumLabel.setText("Arc 20:");
        this.add(this.arcNumLabel);
        this.arcNumLabel.setBounds(1, 1, 34, 16);
        this.iLabel.setFont(new Font("LucidaSans", 1, 10));
        this.iLabel.setText("i");
        this.add(this.iLabel);
        this.iLabel.setBounds(315, 1, 3, 16);
        this.plusLabel.setFont(new Font("LucidaSans", 1, 10));
        this.plusLabel.setText("+");
        this.add(this.plusLabel);
        this.plusLabel.setBounds(231, 1, 8, 16);
        this.mapsToLabel.setFont(new Font("LucidaSans", 0, 10));
        this.mapsToLabel.setText("maps to");
        this.add(this.mapsToLabel);
        this.mapsToLabel.setBounds(115, 1, 39, 16);
    }

    private void arcBeginFieldFocusGained(FocusEvent evt) {
        this.setFocusField((JTextField)evt.getSource());
        this.propertyChangeSupport.firePropertyChange("focusFieldHasChanged", null, null);
        this.highlightArcFields();
    }

    private void vertexImFieldFocusGained(FocusEvent evt) {
        this.setFocusField((JTextField)evt.getSource());
        this.propertyChangeSupport.firePropertyChange("focusFieldHasChanged", null, null);
        this.highlightVertexFields();
    }

    private void vertexReFieldFocusGained(FocusEvent evt) {
        this.setFocusField((JTextField)evt.getSource());
        this.propertyChangeSupport.firePropertyChange("focusFieldHasChanged", null, null);
        this.highlightVertexFields();
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
        this.hueSatBright = Color.RGBtoHSB(highlightColor.getRed(), highlightColor.getGreen(), highlightColor.getBlue(), this.hueSatBright);
        this.fieldHighlightBackgroundColor = Color.getHSBColor(this.hueSatBright[0], this.hueSatBright[1], 0.95f * this.hueSatBright[2]);
    }

    public double getArcBegin() {
        return this.arcBegin;
    }

    public void setArcBegin(double arcBegin) {
        this.arcBegin = arcBegin;
        this.arcBeginField.setDoubleText(arcBegin);
    }

    public double getVertexRe() {
        return this.vertexRe;
    }

    public void setVertexRe(double vertexRe) {
        this.vertexRe = vertexRe;
        this.vertexReField.setDoubleText(vertexRe);
    }

    public double getVertexIm() {
        return this.vertexIm;
    }

    public void setVertexIm(double vertexIm) {
        this.vertexIm = vertexIm;
        this.vertexImField.setDoubleText(vertexIm);
    }

    public int getArcNum() {
        return this.arcNum;
    }

    public void setArcNum(int arcNum) {
        this.arcNum = arcNum;
        this.arcNumLabel.setText("Arc " + arcNum + ":");
        this.arcBeginField.setName("" + arcNum);
        this.vertexReField.setName("" + arcNum);
        this.vertexImField.setName("" + arcNum);
    }

    public Color getPanelColor() {
        return this.panelColor;
    }

    public void setPanelColor(Color panelColor) {
        this.panelColor = panelColor;
        this.hueSatBright = Color.RGBtoHSB(panelColor.getRed(), panelColor.getGreen(), panelColor.getBlue(), this.hueSatBright);
        this.fieldBackgroundColor = Color.getHSBColor(this.hueSatBright[0], this.hueSatBright[1], 0.95f * this.hueSatBright[2]);
    }

    public DoubleField getArcBeginField() {
        return this.arcBeginField;
    }

    public DoubleField getVertexReField() {
        return this.vertexReField;
    }

    public DoubleField getVertexImField() {
        return this.vertexImField;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public JTextField getFocusField() {
        return this.focusField;
    }

    public void setFocusField(JTextField focusField) {
        this.focusField = focusField;
    }

    public boolean isArcHighlighted() {
        return this.arcHighlighted;
    }

    public void setArcHighlighted(boolean arcHighlighted) {
        this.arcHighlighted = arcHighlighted;
    }

    public boolean isVertexHighlighted() {
        return this.vertexHighlighted;
    }

    public void setVertexHighlighted(boolean vertexHighlighted) {
        this.vertexHighlighted = vertexHighlighted;
    }
}

