/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.polargrapher2d;

import com.jimrolf.convert.Convert;
import com.jimrolf.datagrapher2d.DataGrapher2D;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;

public class PolarGrapher2D
extends DataGrapher2D {
    protected double radialGridSpacing = 0.5;
    protected double r = 0.0;
    protected double theta = 0.0;
    protected boolean polar = true;

    public double getRadialGridSpacing() {
        return this.radialGridSpacing;
    }

    public void setRadialGridSpacing(double radialGridSpacing) {
        this.radialGridSpacing = radialGridSpacing;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public boolean isPolar() {
        return this.polar;
    }

    public void setPolar(boolean polar) {
        this.polar = polar;
    }

    public void computeRandTheta(int xPixel, int yPixel) {
        double asin = 0.0;
        double acos = 0.0;
        double x = (double)(xPixel - this.originX) * (this.xMax - this.xMin) / (double)this.xAxisLength;
        double y = (double)(this.originY - yPixel) * (this.yMax - this.yMin) / (double)this.yAxisLength;
        this.r = Math.sqrt(x * x + y * y);
        double absRe = Math.abs(x);
        double absIm = Math.abs(y);
        if (absRe == 0.0 && absIm == 0.0) {
            this.r = 0.0;
        } else if (absRe > absIm) {
            double temp = absIm / absRe;
            this.r = absRe * Math.sqrt(1.0 + temp * temp);
        } else {
            double temp = absRe / absIm;
            this.r = absIm * Math.sqrt(1.0 + temp * temp);
        }
        this.theta = Math.atan2(y, x);
    }

    public void grapherMouseMoved(MouseEvent evt) {
        if (this.numberLabel != null) {
            if (this.polar) {
                this.computeRandTheta(evt.getX(), evt.getY());
                this.numberLabel.setCursorLocation(this.r, this.theta);
            } else {
                this.numberLabel.setCursorLocation(this.getXVal(evt.getX()), this.getYVal(evt.getY()));
            }
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.usingMouseDragForZoom) {
            this.plotZoomRectangle = true;
            this.findCornersofZoomRect(evt);
        } else {
            this.setOriginX(this.oldOriginX + (evt.getX() - this.mousePressedXPixel));
            this.setOriginY(this.oldOriginY + (evt.getY() - this.mousePressedYPixel));
            this.updateRegisteredObjects();
            this.locateAxes();
            if (this.numberLabel != null) {
                if (this.polar) {
                    this.computeRandTheta(evt.getX(), evt.getY());
                    this.numberLabel.setCursorLocation(this.r, this.theta);
                } else {
                    this.numberLabel.setCursorLocation(this.getXVal(evt.getX()), this.getYVal(evt.getY()));
                }
            }
        }
    }

    public int getXPixel() {
        return Convert.toRoundedInt((double)this.originX + this.r * Math.cos(this.theta) / (this.xMax - this.xMin) * (double)this.xAxisLength);
    }

    public int getYPixel() {
        return Convert.toRoundedInt((double)this.originY - this.r * Math.sin(this.theta) / (this.yMax - this.yMin) * (double)this.yAxisLength);
    }

    public void plotLine(int localNumPoints, int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        int startI;
        int graphX1 = 0;
        int graphY1 = 0;
        int graphX2 = 0;
        int graphY2 = 0;
        g2d.setStroke(new BasicStroke(size, 1, 2));
        for (startI = 0; startI <= localNumPoints - 1 && (Double.isNaN(dataX[startI]) || Double.isNaN(dataY[startI])); ++startI) {
        }
        if (this.polar) {
            if (startI <= localNumPoints - 1) {
                this.r = dataX[startI];
                this.theta = dataY[startI];
                graphX1 = this.getXPixel();
                graphY1 = this.getYPixel();
            }
            for (int i = startI + 1; i <= localNumPoints - 1; ++i) {
                if (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i])) {
                    graphX2 = graphX1;
                    graphY2 = graphY1;
                    g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
                    while (i <= localNumPoints - 1 && (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i]))) {
                        ++i;
                    }
                    if (i > localNumPoints - 1) continue;
                    this.r = dataX[i];
                    this.theta = dataY[i];
                    graphX1 = this.getXPixel();
                    graphY1 = this.getYPixel();
                    continue;
                }
                this.r = dataX[i];
                this.theta = dataY[i];
                graphX2 = this.getXPixel();
                graphY2 = this.getYPixel();
                g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
                graphX1 = graphX2;
                graphY1 = graphY2;
            }
        } else {
            if (startI <= localNumPoints - 1) {
                graphX1 = this.getXPixel(dataX[startI]);
                graphY1 = this.getYPixel(dataY[startI]);
            }
            for (int i = startI + 1; i <= localNumPoints - 1; ++i) {
                if (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i])) {
                    graphX2 = graphX1;
                    graphY2 = graphY1;
                    g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
                    while (i <= localNumPoints - 1 && (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i]))) {
                        ++i;
                    }
                    if (i > localNumPoints - 1) continue;
                    graphX1 = this.getXPixel(dataX[i]);
                    graphY1 = this.getYPixel(dataY[i]);
                    continue;
                }
                graphX2 = this.getXPixel(dataX[i]);
                graphY2 = this.getYPixel(dataY[i]);
                g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
                graphX1 = graphX2;
                graphY1 = graphY2;
            }
        }
    }

    public void plotPoints(int localNumPoints, int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        if (this.polar) {
            for (int i = 0; i <= localNumPoints - 1; ++i) {
                this.r = dataX[i];
                this.theta = dataY[i];
                g2d.fillOval(this.getXPixel() - size, this.getYPixel() - size, 2 * size + 1, 2 * size + 1);
            }
        } else {
            for (int i = 0; i <= localNumPoints - 1; ++i) {
                g2d.fillOval(this.getXPixel(dataX[i]) - size, this.getYPixel(dataY[i]) - size, 2 * size + 1, 2 * size + 1);
            }
        }
    }

    protected void drawGrid() {
        boolean temp = false;
        double gridRadius = 0.0;
        double currentRadius = 0.0;
        double gridDeltaRadius = 0.0;
        int numThetaPoints = 75;
        int numRays = 16;
        double deltaTheta = Math.PI * 2 / (double)numRays;
        int endX = 0;
        int endY = 0;
        int startX = 0;
        int startY = 0;
        if (this.polar) {
            int i;
            if (this.yMax > this.xMax) {
                gridRadius = (double)Convert.toRoundedInt(this.yMax / this.radialGridSpacing) * this.radialGridSpacing;
                if (gridRadius > this.yMax && Math.abs(gridRadius - this.yMax) > this.eps) {
                    gridRadius -= this.radialGridSpacing;
                }
            } else {
                gridRadius = (double)Convert.toRoundedInt(this.xMax / this.radialGridSpacing) * this.radialGridSpacing;
                if (gridRadius > this.xMax && Math.abs(gridRadius - this.xMax) > this.eps) {
                    gridRadius -= this.radialGridSpacing;
                }
            }
            for (i = 0; i <= numRays; ++i) {
                endX = this.getXPixel(gridRadius * Math.cos((double)i * deltaTheta));
                endY = this.getYPixel(gridRadius * Math.sin((double)i * deltaTheta));
                this.gBI.drawLine(this.originX, this.originY, endX, endY);
            }
            deltaTheta = Math.PI * 2 / (double)(numThetaPoints - 1);
            for (i = 1; i <= Convert.toRoundedInt(2.0 * gridRadius); ++i) {
                currentRadius = (double)i * this.radialGridSpacing;
                startX = this.getXPixel(currentRadius);
                startY = this.getYPixel(0.0);
                for (int j = 1; j <= numThetaPoints - 2; ++j) {
                    endX = this.getXPixel(currentRadius * Math.cos((double)j * deltaTheta));
                    endY = this.getYPixel(currentRadius * Math.sin((double)j * deltaTheta));
                    this.gBI.drawLine(startX, startY, endX, endY);
                    startX = endX;
                    startY = endY;
                }
                endX = this.getXPixel(currentRadius);
                endY = this.getYPixel(0.0);
                this.gBI.drawLine(startX, startY, endX, endY);
            }
        } else {
            super.drawGrid();
        }
    }
}

