/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.plotstuff2d;

import com.jimrolf.datagrapher2d.DataGrapher2D;
import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.plotstuff2d.PlotStuff;
import com.jimrolf.plotstuff2d.PlotStuff2D;
import java.awt.Color;
import java.awt.Graphics2D;

public class PolarGrid
extends PlotStuff {
    private double theta = 0.0;
    private double deltaTheta = 0.0;
    private double deltaRadius = 0.0;
    private double deltaThetaRay = 0.0;
    private double deltaRadiusTheta = 0.0;
    private boolean needToUpdateRayData = true;
    private boolean needToUpdateCircleData = true;
    private double radius = 0.0;
    private double[][] raysDataX = null;
    private double[][] raysDataY = null;
    private double[][] circlesDataX = null;
    private double[][] circlesDataY = null;
    private double epsilon = 0.0;
    protected boolean needToAllocateCircleData = true;
    protected boolean needToAllocateRayData = true;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double thetaMin;
    private double thetaMax = Math.PI * 2;
    private int numRays = 6;
    private int numCircles = 3;
    private int numCirclePoints = 100;
    private int numRayPoints = 2;
    private double radiusMax = 3.0;
    private int numTotalRays = 3;
    private PlotStuff[] rays;
    private PlotStuff[] circles;
    private Color rayColor = new Color(0, 102, 0);
    private Color circleColor = Color.RED;

    public PolarGrid() {
        this.epsilon = MachineEpsilon.getEpsilon();
        this.plotSize = 1;
        this.plotStyle = 10;
    }

    public boolean isNeedToAllocateCircleData() {
        return this.needToAllocateCircleData;
    }

    public void setNeedToAllocateCircleData(boolean needToAllocateCircleData) {
        this.needToAllocateCircleData = needToAllocateCircleData;
    }

    public boolean isNeedToAllocateRayData() {
        return this.needToAllocateRayData;
    }

    public void setNeedToAllocateRayData(boolean needToAllocateRayData) {
        this.needToAllocateRayData = needToAllocateRayData;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
        this.needToUpdateCircleData = true;
        this.needToUpdateRayData = true;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
        this.needToUpdateCircleData = true;
        this.needToUpdateRayData = true;
    }

    public double getThetaMin() {
        this.thetaMin = 0.0;
        return 0.0;
    }

    public void setThetaMin(double thetaMin) {
        this.thetaMin = thetaMin;
        this.needToUpdateCircleData = true;
        this.needToUpdateRayData = true;
    }

    public double getThetaMax() {
        return this.thetaMax;
    }

    public void setThetaMax(double thetaMax) {
        this.thetaMax = thetaMax;
        this.needToUpdateCircleData = true;
        this.needToUpdateRayData = true;
    }

    public int getNumRays() {
        return this.numRays;
    }

    public void setNumRays(int numRays) {
        this.numRays = numRays;
        this.needToAllocateRayData = true;
    }

    public int getNumCircles() {
        return this.numCircles;
    }

    public void setNumCircles(int numCircles) {
        this.numCircles = numCircles;
        this.needToAllocateCircleData = true;
    }

    public int getNumCirclePoints() {
        return this.numCirclePoints;
    }

    public void setNumCirclePoints(int numCirclePoints) {
        this.numCirclePoints = numCirclePoints;
        this.needToAllocateCircleData = true;
    }

    public int getNumRayPoints() {
        return this.numRayPoints;
    }

    public void setNumRayPoints(int numRayPoints) {
        this.numRayPoints = numRayPoints;
        this.needToAllocateRayData = true;
    }

    public double getRadiusMax() {
        return this.radiusMax;
    }

    public void setRadiusMax(double radiusMax) {
        this.radiusMax = radiusMax;
        this.needToUpdateCircleData = true;
        this.needToUpdateRayData = true;
    }

    public void createData() {
        int tempNumTotalRays = 0;
        tempNumTotalRays = Math.abs(this.thetaMax - this.thetaMin - Math.PI * 2) <= 2.0 * this.epsilon ? this.numRays : this.numRays + 2;
        if (tempNumTotalRays != this.numTotalRays) {
            this.needToAllocateRayData = true;
        }
        this.numTotalRays = tempNumTotalRays;
        if (this.needToAllocateRayData) {
            this.allocateRayData();
        }
        if (this.needToAllocateCircleData) {
            this.allocateCircleData();
        }
        if (this.needToUpdateRayData || this.needToUpdateCircleData) {
            this.updateData();
        }
    }

    public int getNumTotalRays() {
        return this.numTotalRays;
    }

    public PlotStuff getRays(int index) {
        return this.rays[index];
    }

    public PlotStuff[] getRays() {
        return this.rays;
    }

    public void setRays(int index, PlotStuff rays) {
        this.rays[index] = rays;
    }

    public void setRays(PlotStuff[] rays) {
        this.rays = rays;
    }

    public PlotStuff getCircles(int index) {
        return this.circles[index];
    }

    public PlotStuff[] getCircles() {
        return this.circles;
    }

    public void setCircles(int index, PlotStuff circles) {
        this.circles[index] = circles;
    }

    public void setCircles(PlotStuff[] circles) {
        this.circles = circles;
    }

    public void setCirclesDataX(int numCircle, int numPoint, double dataVal) {
        this.circles[numCircle].setDataX(numPoint, dataVal);
    }

    public void setCirclesDataY(int numCircle, int numPoint, double dataVal) {
        this.circles[numCircle].setDataY(numPoint, dataVal);
    }

    public void setRaysDataX(int numRay, int numPoint, double dataVal) {
        this.circles[numRay].setDataX(numPoint, dataVal);
    }

    public void setRaysDataY(int numRay, int numPoint, double dataVal) {
        this.circles[numRay].setDataY(numPoint, dataVal);
    }

    public Color getRayColor() {
        return this.rayColor;
    }

    public void setRayColor(Color rayColor) {
        this.rayColor = rayColor;
        if (this.rays != null) {
            for (int i = 0; i <= this.rays.length - 1; ++i) {
                this.rays[i].setPlotColor(rayColor);
            }
        }
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
        if (this.circles != null) {
            for (int i = 0; i <= this.circles.length - 1; ++i) {
                this.circles[i].setPlotColor(circleColor);
            }
        }
    }

    public void updateCircleData() {
        this.deltaRadiusTheta = this.radiusMax / (double)this.numCircles;
        this.deltaTheta = (this.thetaMax - this.thetaMin) / (double)this.numCirclePoints;
        for (int i = 0; i <= this.numCircles - 1; ++i) {
            this.radius = (double)(i + 1) * this.deltaRadiusTheta;
            this.circlesDataX[i][0] = this.centerX + this.radius * Math.cos(this.thetaMin);
            this.circlesDataY[i][0] = this.centerY + this.radius * Math.sin(this.thetaMin);
            for (int j = 1; j <= this.numCirclePoints - 2; ++j) {
                this.theta = this.thetaMin + (double)j * this.deltaTheta;
                this.circlesDataX[i][j] = this.centerX + this.radius * Math.cos(this.theta);
                this.circlesDataY[i][j] = this.centerY + this.radius * Math.sin(this.theta);
            }
            this.circlesDataX[i][this.numCirclePoints - 1] = this.centerX + this.radius * Math.cos(this.thetaMax);
            this.circlesDataY[i][this.numCirclePoints - 1] = this.centerY + this.radius * Math.sin(this.thetaMax);
        }
    }

    public void updateData() {
        this.updateRayData();
        this.updateCircleData();
    }

    public void updateRayData() {
        this.deltaRadius = this.radiusMax / (double)(this.numRayPoints - 1);
        this.deltaThetaRay = this.numTotalRays == this.numRays ? (this.thetaMax - this.thetaMin) / (double)this.numTotalRays : (this.thetaMax - this.thetaMin) / (double)(this.numTotalRays - 1);
        for (int i = 0; i <= this.numTotalRays - 1; ++i) {
            this.theta = this.thetaMin + (double)i * this.deltaThetaRay;
            this.raysDataX[i][0] = this.centerX;
            this.raysDataY[i][0] = this.centerY;
            for (int j = 1; j <= this.numRayPoints - 2; ++j) {
                this.radius = (double)j * this.deltaRadius;
                this.raysDataX[i][j] = this.centerX + this.radius * Math.cos(this.theta);
                this.raysDataY[i][j] = this.centerY + this.radius * Math.sin(this.theta);
            }
            this.raysDataX[i][this.numRayPoints - 1] = this.centerX + this.radiusMax * Math.cos(this.theta);
            this.raysDataY[i][this.numRayPoints - 1] = this.centerY + this.radiusMax * Math.sin(this.theta);
        }
    }

    public void plotData(Grapher2D grapher, Graphics2D g2d) {
        int j;
        if (this.numRays > 0) {
            for (j = 0; j <= this.numTotalRays - 1; ++j) {
                g2d.setColor(this.rays[j].getPlotColor());
                ((DataGrapher2D)grapher).plotLine(this.getNumRayPoints(), this.getPlotSize(), this.getRays(j).getDataX(), this.getRays(j).getDataY(), g2d);
            }
        }
        for (j = 0; j <= this.numCircles - 1; ++j) {
            g2d.setColor(this.circles[j].getPlotColor());
            ((DataGrapher2D)grapher).plotLine(this.getNumCirclePoints(), this.getPlotSize(), this.getCircles(j).getDataX(), this.getCircles(j).getDataY(), g2d);
        }
    }

    public void allocateCircleData() {
        this.circles = new PlotStuff[this.numCircles];
        this.circlesDataX = new double[this.numCircles][this.numCirclePoints];
        this.circlesDataY = new double[this.numCircles][this.numCirclePoints];
        for (int i = 0; i <= this.numCircles - 1; ++i) {
            this.circles[i] = new PlotStuff2D();
            this.circles[i].setDataX(this.circlesDataX[i]);
            this.circles[i].setDataY(this.circlesDataY[i]);
            this.circles[i].setPlotColor(this.circleColor);
            this.circles[i].setPlotStyle(this.plotStyle);
        }
        this.needToAllocateCircleData = false;
    }

    public void allocateRayData() {
        this.raysDataX = new double[this.numTotalRays][this.numRayPoints];
        this.raysDataY = new double[this.numTotalRays][this.numRayPoints];
        this.rays = new PlotStuff[this.numTotalRays];
        for (int i = 0; i <= this.numTotalRays - 1; ++i) {
            this.rays[i] = new PlotStuff2D();
            this.rays[i].setDataX(this.raysDataX[i]);
            this.rays[i].setDataY(this.raysDataY[i]);
            this.rays[i].setPlotColor(this.rayColor);
            this.rays[i].setPlotStyle(this.plotStyle);
        }
        this.needToAllocateRayData = false;
    }
}

