/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.plotstuff2d;

import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.plotstuff2d.PlotStuff2D;
import java.awt.BasicStroke;
import java.awt.Graphics2D;

public class ContourPlot2D
extends PlotStuff2D {
    protected boolean usingCellCrossings = true;

    public boolean isUsingCellCrossings() {
        return this.usingCellCrossings;
    }

    public void setUsingCellCrossings(boolean usingCellCrossings) {
        this.usingCellCrossings = usingCellCrossings;
    }

    public ContourPlot2D() {
        this.plotStyle = 14;
    }

    public void plotData(Grapher2D grapher, Graphics2D g2d) {
        int graphX1 = 0;
        int graphY1 = 0;
        int graphX2 = 0;
        int graphY2 = 0;
        g2d.setStroke(new BasicStroke(this.plotSize, 1, 2));
        if (this.usingCellCrossings) {
            for (int i = 0; i <= this.numPoints / 2 - 1; ++i) {
                if (Double.isNaN(this.dataX[2 * i]) || Double.isNaN(this.dataY[2 * i]) || Double.isNaN(this.dataX[2 * i + 1]) || Double.isNaN(this.dataY[2 * i + 1])) continue;
                graphX1 = grapher.getXPixel(this.dataX[2 * i]);
                graphY1 = grapher.getYPixel(this.dataY[2 * i]);
                graphX2 = grapher.getXPixel(this.dataX[2 * i + 1]);
                graphY2 = grapher.getYPixel(this.dataY[2 * i + 1]);
                g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
            }
        } else {
            for (int i = 0; i <= this.numPoints - 1; ++i) {
                graphX1 = grapher.getXPixel(this.dataX[i]);
                graphY1 = grapher.getYPixel(this.dataY[i]);
                graphX2 = graphX1;
                graphY2 = graphY1;
                g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
            }
        }
    }
}

