/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.matrix;

public class Matrix {
    private int numRows = 0;
    private int numCols = 0;
    private double[][] A = null;
    private double[][] augA = null;
    private double[][] transposeA = null;

    public Matrix() {
    }

    public Matrix(int numRows, int numCols) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.A = new double[numRows][numCols];
    }

    public Matrix(double[][] A) {
        this.numRows = A.length;
        this.numCols = A[0].length;
        this.A = new double[this.numRows][this.numCols];
        for (int i = 0; i <= this.numRows - 1; ++i) {
            for (int j = 0; j <= this.numCols - 1; ++j) {
                this.A[i][j] = A[i][j];
            }
        }
    }

    public Matrix(double[][] A, double[] b) {
        int j;
        int i;
        this.numRows = A.length;
        this.numCols = A[0].length;
        this.A = new double[this.numRows][this.numCols];
        for (i = 0; i <= this.numRows - 1; ++i) {
            for (j = 0; j <= this.numCols - 1; ++j) {
                this.A[i][j] = A[i][j];
            }
        }
        this.augA = new double[this.numRows][this.numCols + 1];
        for (i = 0; i <= this.numRows - 1; ++i) {
            for (j = 0; j <= this.numCols - 1; ++j) {
                this.augA[i][j] = A[i][j];
            }
        }
        for (int k = 0; k <= this.numRows - 1; ++k) {
            this.augA[k][this.numCols] = b[k];
        }
    }

    public void setEntry(double x, int row, int col) {
        this.A[row][col] = x;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void setNumCols(int numCols) {
        this.numCols = numCols;
    }

    public void setAMatrix(double[][] A) {
        this.numRows = A.length;
        this.numCols = A[0].length;
        this.A = new double[this.numRows][this.numCols];
        for (int i = 0; i <= this.numRows - 1; ++i) {
            for (int j = 0; j <= this.numCols - 1; ++j) {
                this.A[i][j] = A[i][j];
            }
        }
    }

    public double[][] getAMatrix() {
        return this.A;
    }

    public double[][] getAugAMatrix() {
        return this.augA;
    }

    public double[][] getTransposeA() {
        return this.transposeA;
    }

    public double getEntry(int row, int col) {
        return this.A[row][col];
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void augmentA(double[] b) {
        if (this.augA == null) {
            this.augA = new double[this.numRows][this.numCols + 1];
        }
        for (int i = 0; i <= this.numCols - 1; ++i) {
            for (int j = 0; j <= this.numRows - 1; ++j) {
                this.augA[i][j] = this.A[i][j];
            }
        }
        for (int k = 0; k <= this.numRows - 1; ++k) {
            this.augA[k][this.numCols] = b[k];
        }
    }

    public void swapARows(int firstRow, int secondRow) {
        double tempRowSlot = 0.0;
        for (int i = 0; i <= this.numCols - 1; ++i) {
            tempRowSlot = this.A[firstRow][i];
            this.A[firstRow][i] = this.A[secondRow][i];
            this.A[secondRow][i] = tempRowSlot;
        }
    }

    public void swapAugARows(int firstRow, int secondRow) {
        double tempRowSlot = 0.0;
        for (int i = 0; i <= this.numCols; ++i) {
            tempRowSlot = this.augA[firstRow][i];
            this.augA[firstRow][i] = this.augA[secondRow][i];
            this.augA[secondRow][i] = tempRowSlot;
        }
    }

    public void swapACols(int firstCol, int secondCol) {
        double tempColSlot = 0.0;
        for (int i = 0; i <= this.numRows - 1; ++i) {
            tempColSlot = this.A[i][firstCol];
            this.A[i][firstCol] = this.A[i][secondCol];
            this.A[i][secondCol] = tempColSlot;
        }
    }

    public void transposeA() {
        this.transposeA = new double[this.numCols][this.numRows];
        for (int row = 0; row <= this.numCols - 1; ++row) {
            for (int col = 0; col <= this.numRows - 1; ++col) {
                this.transposeA[row][col] = this.A[col][row];
            }
        }
    }

    public double[][] times(Matrix B) {
        double[][] tempMat = new double[this.numRows][B.getNumCols()];
        double sum = 0.0;
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i <= this.numRows - 1; ++i) {
            for (j = 0; j <= B.getNumCols() - 1; ++j) {
                sum = 0.0;
                for (k = 0; k <= this.numCols - 1; ++k) {
                    sum += this.A[i][k] * B.getEntry(k, j);
                }
                tempMat[i][j] = sum;
            }
        }
        return tempMat;
    }

    public double[][] times(double[][] B) {
        double[][] tempMat = new double[this.numRows][B[0].length];
        double sum = 0.0;
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i <= this.numRows - 1; ++i) {
            for (j = 0; j <= B[0].length - 1; ++j) {
                sum = 0.0;
                for (k = 0; k <= this.numCols - 1; ++k) {
                    sum += this.A[i][k] * B[k][j];
                }
                tempMat[i][j] = sum;
            }
        }
        return tempMat;
    }

    public double[] times(double[] b) {
        double[] tempVec = new double[this.numRows];
        double sum = 0.0;
        int i = 0;
        int j = 0;
        for (i = 0; i <= this.numRows - 1; ++i) {
            sum = 0.0;
            for (j = 0; j <= b.length - 1; ++j) {
                sum += this.A[i][j] * b[j];
            }
            tempVec[i] = sum;
        }
        return tempVec;
    }

    public double[][] transposeTimes(Matrix B) {
        if (this.transposeA == null) {
            this.transposeA = new double[this.numCols][this.numRows];
            for (int row = 0; row <= this.numCols - 1; ++row) {
                for (int col = 0; col <= this.numRows - 1; ++col) {
                    this.transposeA[row][col] = this.A[col][row];
                }
            }
        }
        double[][] tempMat = new double[this.numCols][B.getNumCols()];
        double sum = 0.0;
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i <= this.numCols - 1; ++i) {
            for (j = 0; j <= B.getNumCols() - 1; ++j) {
                sum = 0.0;
                for (k = 0; k <= this.numRows - 1; ++k) {
                    sum += this.transposeA[i][k] * B.getEntry(k, j);
                }
                tempMat[i][j] = sum;
            }
        }
        return tempMat;
    }

    public double[][] transposeTimes(double[][] B) {
        if (this.transposeA == null) {
            this.transposeA = new double[this.numCols][this.numRows];
            for (int row = 0; row <= this.numCols - 1; ++row) {
                for (int col = 0; col <= this.numRows - 1; ++col) {
                    this.transposeA[row][col] = this.A[col][row];
                }
            }
        }
        double[][] tempMat = new double[this.numCols][B[0].length];
        double sum = 0.0;
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i <= this.numCols - 1; ++i) {
            for (j = 0; j <= B[0].length - 1; ++j) {
                sum = 0.0;
                for (k = 0; k <= this.numRows - 1; ++k) {
                    sum += this.transposeA[i][k] * B[k][j];
                }
                tempMat[i][j] = sum;
            }
        }
        return tempMat;
    }

    public double[] transposeTimes(double[] b) {
        if (this.transposeA == null) {
            this.transposeA = new double[this.numCols][this.numRows];
            for (int row = 0; row <= this.numCols - 1; ++row) {
                for (int col = 0; col <= this.numRows - 1; ++col) {
                    this.transposeA[row][col] = this.A[col][row];
                }
            }
        }
        double[] tempVec = new double[this.numCols];
        double sum = 0.0;
        int i = 0;
        int j = 0;
        for (i = 0; i <= this.numCols - 1; ++i) {
            sum = 0.0;
            for (j = 0; j <= this.numRows - 1; ++j) {
                sum += this.transposeA[i][j] * b[j];
            }
            tempVec[i] = sum;
        }
        return tempVec;
    }

    public double[] backSub() {
        double[] x = new double[this.numRows];
        int i = 0;
        int k = 0;
        double sum = 0.0;
        for (k = this.numRows - 1; k >= 0; --k) {
            sum = 0.0;
            for (i = k + 1; i <= this.numCols - 1; ++i) {
                sum += this.augA[k][i] * x[i];
            }
            x[k] = (this.augA[k][this.numCols] - sum) / this.augA[k][k];
        }
        return x;
    }

    public void gaussElim() {
        int i = 0;
        int j = 0;
        int k = 0;
        double multiplier = 0.0;
        for (i = 0; i <= this.numCols - 1; ++i) {
            for (j = i + 1; j <= this.numRows - 1; ++j) {
                multiplier = this.augA[j][i] / this.augA[i][i];
                for (k = i + 1; k <= this.numCols; ++k) {
                    this.augA[j][k] = this.augA[j][k] - multiplier * this.augA[i][k];
                }
            }
        }
    }

    public void gaussElimPivot() {
        int i = 0;
        int j = 0;
        int k = 0;
        int maxRow = 0;
        double multiplier = 0.0;
        double maxPivot = 0.0;
        for (i = 0; i <= this.numCols - 1; ++i) {
            maxRow = i;
            maxPivot = Math.abs(this.augA[i][i]);
            for (k = i + 1; k <= this.numRows - 1; ++k) {
                if (!(Math.abs(this.augA[k][i]) > maxPivot)) continue;
                maxRow = k;
                maxPivot = Math.abs(this.augA[k][i]);
            }
            if (maxRow != i) {
                this.swapAugARows(maxRow, i);
            }
            for (j = i + 1; j <= this.numRows - 1; ++j) {
                multiplier = this.augA[j][i] / this.augA[i][i];
                for (k = i + 1; k <= this.numCols; ++k) {
                    this.augA[j][k] = this.augA[j][k] - multiplier * this.augA[i][k];
                }
            }
        }
    }

    public void gaussElimScaledPivot() {
        int i = 0;
        int j = 0;
        int k = 0;
        int maxRow = 0;
        double multiplier = 0.0;
        double maxPivot = 0.0;
        double[] s = new double[this.numRows];
        for (i = 0; i <= this.numCols - 1; ++i) {
            for (k = i; k <= this.numRows - 1; ++k) {
                s[k] = Math.abs(this.augA[k][i]);
                for (j = i + 1; j <= this.numCols - 1; ++j) {
                    if (!(Math.abs(this.augA[k][j]) >= s[k])) continue;
                    s[k] = Math.abs(this.augA[k][j]);
                }
            }
            maxRow = i;
            maxPivot = Math.abs(this.augA[i][i]) / s[i];
            for (k = i + 1; k <= this.numRows - 1; ++k) {
                if (!(Math.abs(this.augA[k][i]) / s[k] > maxPivot)) continue;
                maxRow = k;
                maxPivot = Math.abs(this.augA[k][i]);
            }
            if (maxRow != i) {
                this.swapAugARows(maxRow, i);
            }
            for (j = i + 1; j <= this.numRows - 1; ++j) {
                multiplier = this.augA[j][i] / this.augA[i][i];
                for (k = i + 1; k <= this.numCols; ++k) {
                    this.augA[j][k] = this.augA[j][k] - multiplier * this.augA[i][k];
                }
            }
        }
    }

    public double[] triDiagBackSub() {
        int i = 0;
        double[] x = new double[this.numRows];
        x[this.numRows - 1] = this.augA[this.numRows - 1][3] / this.augA[this.numRows - 1][1];
        for (i = this.numRows - 2; i >= 0; --i) {
            x[i] = (this.augA[i][3] - this.augA[i][2] * x[i + 1]) / this.augA[i][1];
        }
        return x;
    }

    public void triDiagGaussElim() {
        double m = 0.0;
        int i = 0;
        for (i = 1; i <= this.numRows - 1; ++i) {
            m = -this.augA[i][0] / this.augA[i - 1][1];
            double[] dArray = this.augA[i];
            dArray[1] = dArray[1] + this.augA[i - 1][2] * m;
            double[] dArray2 = this.augA[i];
            dArray2[3] = dArray2[3] + m * this.augA[i - 1][3];
        }
    }
}

