/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.functionparser;

import com.jimrolf.complex.Complex;
import org.lsmp.djep.djep.DJep;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Factorial;

public class FunctionParser {
    protected boolean implicitMultiplication = true;
    protected DJep funcParser = null;
    protected DJep derivParser = null;
    protected String funcInput = null;
    protected String variable = null;
    protected String[] variables = null;
    protected boolean multiDimensional = false;
    protected boolean useAllVariables = false;
    protected double variableValue = 0.0;
    protected String derivInput = null;
    protected boolean funcHasError = false;
    protected boolean derivHasError = false;
    protected String funcErrorInfo = null;
    protected String derivErrorInfo = null;
    protected String[] partialDerivInput = null;
    protected int whichDeriv = 0;
    protected String[] partialDerivErrorInfo = null;
    protected boolean[] partialDerivHasError = null;
    protected DJep[] partialDerivParser = null;
    protected int[] whichPartialDeriv = null;
    protected int dimension = 0;
    protected boolean complex;

    public String[] getPartialDerivInput() {
        return this.partialDerivInput;
    }

    public String getPartialDerivInput(int index) {
        return this.partialDerivInput[index];
    }

    public String[] getPartialDerivErrorInfo() {
        return this.partialDerivErrorInfo;
    }

    public void setPartialDerivErrorInfo(String[] partialDerivErrorInfo) {
        this.partialDerivErrorInfo = partialDerivErrorInfo;
    }

    public String getPartialDerivErrorInfo(int index) {
        return this.partialDerivErrorInfo[index];
    }

    public void setPartialDerivErrorInfo(int index, String newPartialDerivErrorInfo) {
        this.partialDerivErrorInfo[index] = newPartialDerivErrorInfo;
    }

    public boolean[] partialDerivHasError() {
        return this.partialDerivHasError;
    }

    public void setPartialDerivHasError(boolean[] partialDerivHasError) {
        this.partialDerivHasError = partialDerivHasError;
    }

    public boolean partialDerivHasError(int index) {
        return this.partialDerivHasError[index];
    }

    public void setPartialDerivHasError(int index, boolean newPartialDerivHasError) {
        this.partialDerivHasError[index] = newPartialDerivHasError;
    }

    public DJep[] getPartialDerivParser() {
        return this.partialDerivParser;
    }

    public void setPartialDerivParser(DJep[] partialDerivParser) {
        this.partialDerivParser = partialDerivParser;
    }

    public DJep getPartialDerivParser(int index) {
        return this.partialDerivParser[index];
    }

    public void setPartialDerivParser(int index, DJep newPartialDerivParser) {
        this.partialDerivParser[index] = newPartialDerivParser;
    }

    public int[] getWhichPartialDeriv() {
        return this.whichPartialDeriv;
    }

    public void setWhichPartialDeriv(int[] whichPartialDeriv) {
        this.whichPartialDeriv = whichPartialDeriv;
    }

    public int getWhichPartialDeriv(int index) {
        return this.whichPartialDeriv[index];
    }

    public void setWhichPartialDeriv(int index, int newWhichPartialDeriv) {
        this.whichPartialDeriv[index] = newWhichPartialDeriv;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.setUpMultiDimensionalStuff();
    }

    public int getDimension() {
        return this.dimension;
    }

    public FunctionParser() {
        this.funcParser = new DJep();
        this.funcParser.addStandardFunctions();
        this.funcParser.addStandardConstants();
        this.funcParser.setAllowUndeclared(true);
        this.funcParser.setAllowAssignment(true);
        this.funcParser.setImplicitMul(true);
        this.funcParser.addStandardDiffRules();
        this.funcParser.addFunction("fact", new Factorial());
        this.derivParser = new DJep();
        this.derivParser.addStandardFunctions();
        this.derivParser.addStandardConstants();
        this.derivParser.setAllowUndeclared(true);
        this.derivParser.setAllowAssignment(true);
        this.derivParser.setImplicitMul(true);
        this.derivParser.addStandardDiffRules();
        this.derivParser.addFunction("fact", new Factorial());
        this.variable = "x";
    }

    public FunctionParser(String funcInput, String variable) {
        this.funcInput = funcInput;
        this.variable = variable;
        this.funcParser = new DJep();
        this.funcParser.addStandardFunctions();
        this.funcParser.addStandardConstants();
        this.funcParser.setAllowUndeclared(true);
        this.funcParser.setAllowAssignment(true);
        this.funcParser.setImplicitMul(true);
        this.funcParser.addStandardDiffRules();
        this.funcParser.addFunction("fact", new Factorial());
        this.derivParser = new DJep();
        this.derivParser.addStandardFunctions();
        this.derivParser.addStandardConstants();
        this.derivParser.setAllowUndeclared(true);
        this.derivParser.setAllowAssignment(true);
        this.derivParser.setImplicitMul(true);
        this.derivParser.addStandardDiffRules();
        this.derivParser.addFunction("fact", new Factorial());
        this.parseExpression(funcInput);
    }

    public FunctionParser(String funcInput, String[] variables) {
        this.funcInput = funcInput;
        this.variables = variables;
        this.multiDimensional = true;
        this.funcParser = new DJep();
        this.funcParser.addStandardFunctions();
        this.funcParser.addStandardConstants();
        this.funcParser.setAllowUndeclared(true);
        this.funcParser.setAllowAssignment(true);
        this.funcParser.setImplicitMul(true);
        this.funcParser.addStandardDiffRules();
        this.funcParser.addFunction("fact", new Factorial());
        this.derivParser = new DJep();
        this.derivParser.addStandardFunctions();
        this.derivParser.addStandardConstants();
        this.derivParser.setAllowUndeclared(true);
        this.derivParser.setAllowAssignment(true);
        this.derivParser.setImplicitMul(true);
        this.derivParser.addStandardDiffRules();
        this.derivParser.addFunction("fact", new Factorial());
        this.parseExpression(funcInput);
    }

    private void setUpMultiDimensionalStuff() {
        this.multiDimensional = true;
        this.whichPartialDeriv = new int[this.dimension];
        this.partialDerivInput = new String[this.dimension];
        this.partialDerivParser = new DJep[this.dimension];
        this.partialDerivHasError = new boolean[this.dimension];
        this.partialDerivErrorInfo = new String[this.dimension];
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.funcParser.addVariable(this.variables[i], 0.0);
            this.partialDerivParser[i] = new DJep();
            this.partialDerivParser[i].addStandardFunctions();
            this.partialDerivParser[i].addStandardConstants();
            this.partialDerivParser[i].setAllowUndeclared(true);
            this.partialDerivParser[i].setAllowAssignment(true);
            this.partialDerivParser[i].setImplicitMul(true);
            this.partialDerivParser[i].addStandardDiffRules();
            this.partialDerivParser[i].addFunction("fact", new Factorial());
            this.partialDerivHasError[i] = false;
            this.partialDerivErrorInfo[i] = null;
        }
    }

    public void simplifyFunc() {
        try {
            this.funcInput = this.funcParser.toString(this.funcParser.simplify(this.funcParser.parse(this.funcInput)));
        }
        catch (ParseException e) {
            this.funcHasError = true;
        }
        this.funcParser.addVariable(this.variable, 0.0);
        this.funcParser.parseExpression(this.funcInput);
    }

    public void parseExpression() {
        this.funcHasError = false;
        this.funcErrorInfo = null;
        if (this.multiDimensional || this.useAllVariables) {
            int i;
            if (this.useAllVariables) {
                this.derivInput = this.funcInput;
                this.funcParser.addVariable(this.variable, 0.0);
                this.derivParser.addVariable(this.variable, 0.0);
            }
            for (i = 0; i <= this.dimension - 1; ++i) {
                this.partialDerivInput[i] = this.funcInput;
                this.funcParser.addVariable(this.variables[i], 0.0);
                this.derivParser.addVariable(this.variables[i], 0.0);
                for (int j = 0; j <= this.dimension - 1; ++j) {
                    this.partialDerivParser[i].addVariable(this.variables[j], 0.0);
                }
            }
            this.funcParser.parseExpression(this.funcInput);
            if (this.funcParser.getErrorInfo() != null) {
                this.funcHasError = true;
                this.funcErrorInfo = this.funcParser.getErrorInfo();
            }
            if (this.useAllVariables) {
                this.derivParser.parseExpression(this.derivInput);
                if (this.derivParser.getErrorInfo() != null) {
                    this.derivHasError = true;
                    this.derivErrorInfo = this.derivParser.getErrorInfo();
                }
            }
            for (i = 0; i <= this.dimension - 1; ++i) {
                this.partialDerivParser[i].parseExpression(this.partialDerivInput[i]);
                if (this.partialDerivParser[i].getErrorInfo() != null) {
                    this.partialDerivHasError[i] = true;
                    this.partialDerivErrorInfo[i] = this.partialDerivParser[i].getErrorInfo();
                    continue;
                }
                this.partialDerivHasError[i] = false;
            }
        } else {
            this.derivInput = this.funcInput;
            this.derivHasError = false;
            this.derivErrorInfo = null;
            this.funcParser.addVariable(this.variable, 0.0);
            this.derivParser.addVariable(this.variable, 0.0);
            this.funcParser.parseExpression(this.funcInput);
            if (this.funcParser.getErrorInfo() != null) {
                this.funcHasError = true;
                this.funcErrorInfo = this.funcParser.getErrorInfo();
            }
            this.derivParser.parseExpression(this.derivInput);
            if (this.derivParser.getErrorInfo() != null) {
                this.derivHasError = true;
                this.derivErrorInfo = this.derivParser.getErrorInfo();
            }
        }
    }

    public void parseExpression(String funcInput) {
        this.funcInput = funcInput;
        this.parseExpression();
    }

    public double evalFunc(double x) {
        this.funcParser.addVariable(this.variable, x);
        return this.funcParser.getValue();
    }

    public double evalFunc(double x, double y) {
        this.funcParser.addVariable(this.variables[0], x);
        this.funcParser.addVariable(this.variables[1], y);
        return this.funcParser.getValue();
    }

    public double evalFunc(double x, double y, double z) {
        this.funcParser.addVariable(this.variables[0], x);
        this.funcParser.addVariable(this.variables[1], y);
        this.funcParser.addVariable(this.variables[2], z);
        return this.funcParser.getValue();
    }

    public Complex evalFunc(Complex z) {
        this.funcParser.addVariable(this.variable, z);
        return this.funcParser.getComplexValue();
    }

    public double evalFunc(int x) {
        this.funcParser.addVariable(this.variable, x);
        return this.funcParser.getValue();
    }

    public double evalFunc(double[] variableVals) {
        for (int i = 0; i <= variableVals.length - 1; ++i) {
            this.funcParser.addVariable(this.variables[i], variableVals[i]);
        }
        return this.funcParser.getValue();
    }

    public double evalFunc(double t, double[] variableVals) {
        this.funcParser.addVariable(this.variable, t);
        for (int i = 0; i <= variableVals.length - 1; ++i) {
            this.funcParser.addVariable(this.variables[i], variableVals[i]);
        }
        return this.funcParser.getValue();
    }

    public void setImplicitMultiplication(boolean value) {
        this.funcParser.setImplicitMul(value);
        this.implicitMultiplication = value;
    }

    public boolean getImplicitMultiplication() {
        return this.implicitMultiplication;
    }

    public void setVariable(String variable) {
        this.funcParser.removeVariable(this.variable);
        this.variable = variable;
        this.funcParser.addVariable(variable, 0.0);
        this.multiDimensional = false;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariables(String[] variables) {
        int i;
        if (this.variables != null) {
            for (i = 0; i <= this.dimension - 1; ++i) {
                this.funcParser.removeVariable(this.variables[i]);
            }
        }
        this.variables = variables;
        this.dimension = variables.length;
        this.multiDimensional = true;
        this.setUpMultiDimensionalStuff();
        for (i = 0; i <= this.dimension - 1; ++i) {
            this.funcParser.addVariable(variables[i], 0.0);
        }
    }

    public void setVariables(String variable, String[] variables) {
        int i;
        this.funcParser.removeVariable(this.variable);
        if (this.variables != null) {
            for (i = 0; i <= variables.length - 1; ++i) {
                this.funcParser.removeVariable(this.variables[i]);
            }
        }
        this.variable = variable;
        this.variables = variables;
        this.multiDimensional = false;
        this.useAllVariables = true;
        this.dimension = variables.length;
        this.setUpMultiDimensionalStuff();
        this.funcParser.addVariable(variable, 0.0);
        for (i = 0; i <= this.dimension - 1; ++i) {
            this.funcParser.addVariable(variables[i], 0.0);
        }
    }

    public void removeVariable(String variable) {
        this.funcParser.removeVariable(variable);
    }

    public void removeVariables(String[] variables) {
        for (int i = 0; i <= variables.length - 1; ++i) {
            this.funcParser.removeVariable(variables[i]);
        }
    }

    public void removeVariables(String variable, String[] variables) {
        this.funcParser.removeVariable(variable);
        for (int i = 0; i <= variables.length - 1; ++i) {
            this.funcParser.removeVariable(variables[i]);
        }
    }

    public String[] getVariables() {
        return this.variables;
    }

    public void setVariableValue(double variableValue) {
        this.variableValue = variableValue;
    }

    public double getVariableValue() {
        return this.variableValue;
    }

    public boolean funcHasError() {
        return this.funcParser.hasError();
    }

    public String getFuncErrorInfo() {
        return this.funcParser.getErrorInfo();
    }

    public boolean derivHasError() {
        return this.derivHasError;
    }

    public String getDerivErrorInfo() {
        return this.derivParser.getErrorInfo();
    }

    public int getWhichDeriv() {
        return this.whichDeriv;
    }

    public void computeDeriv(int var) {
        this.computeDeriv(var, var);
    }

    public void computeDeriv(int variable1, int variable2) {
        try {
            this.partialDerivInput[variable1] = this.funcParser.toString(this.funcParser.simplify(this.funcParser.differentiate(this.funcParser.parse(this.partialDerivInput[variable1]), this.variables[variable2])));
        }
        catch (ParseException e) {
            this.partialDerivHasError[variable1] = true;
        }
        if (!this.partialDerivHasError[variable1]) {
            if (this.useAllVariables) {
                this.partialDerivParser[variable1].addVariable(this.variable, 0.0);
            }
            for (int i = 0; i <= this.dimension - 1; ++i) {
                this.partialDerivParser[variable1].addVariable(this.variables[i], 0.0);
            }
            this.partialDerivParser[variable1].parseExpression(this.partialDerivInput[variable1]);
            int n = variable1;
            this.whichPartialDeriv[n] = this.whichPartialDeriv[n] + 1;
        }
    }

    public void computeDeriv() {
        try {
            this.derivInput = this.funcParser.toString(this.funcParser.simplify(this.funcParser.differentiate(this.funcParser.parse(this.derivInput), this.variable)));
        }
        catch (ParseException e) {
            this.derivHasError = true;
        }
        if (!this.derivHasError) {
            this.derivParser.addVariable(this.variable, 0.0);
            this.derivParser.parseExpression(this.derivInput);
            ++this.whichDeriv;
        }
    }

    public String getDeriv() {
        return this.derivInput;
    }

    public double evalDeriv(double x) {
        this.derivParser.addVariable(this.variable, x);
        return this.derivParser.getValue();
    }

    public double evalDeriv(int i, double x, double y) {
        this.partialDerivParser[i].addVariable(this.variables[0], x);
        this.partialDerivParser[i].addVariable(this.variables[1], y);
        return this.partialDerivParser[i].getValue();
    }

    public double evalDeriv(int i, double x, double y, double z) {
        this.partialDerivParser[i].addVariable(this.variables[0], x);
        this.partialDerivParser[i].addVariable(this.variables[1], y);
        this.partialDerivParser[i].addVariable(this.variables[2], z);
        return this.partialDerivParser[i].getValue();
    }

    public double evalDeriv(int i, double[] variableVals) {
        for (int j = 0; j <= this.dimension - 1; ++j) {
            this.partialDerivParser[i].addVariable(this.variables[j], variableVals[j]);
        }
        return this.partialDerivParser[i].getValue();
    }

    public Complex evalDeriv(Complex z) {
        this.derivParser.addVariable(this.variable, z);
        return this.derivParser.getComplexValue();
    }

    public double evalDeriv(int x) {
        this.derivParser.addVariable(this.variable, x);
        return this.derivParser.getValue();
    }

    public boolean funcHasVariable(String testVariable) {
        boolean val = false;
        this.funcParser.removeVariable(testVariable);
        this.funcParser.parseExpression(this.funcInput);
        if (this.funcParser.getVar(testVariable) != null) {
            val = true;
            this.funcParser.addVariable(testVariable, 0.0);
        }
        return val;
    }

    public void setUseAllVariables(boolean useAllVariables) {
        this.useAllVariables = useAllVariables;
    }

    public boolean getUseAllVariables() {
        return this.useAllVariables;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public void setComplex(boolean complex) {
        this.complex = complex;
        if (complex) {
            this.funcParser.addComplex();
            this.derivParser.addComplex();
        }
    }

    public void setFuncInput(String funcInput) {
        this.funcInput = funcInput;
    }

    public String getFuncInput() {
        return this.funcInput;
    }

    public void setDerivInput(String derivInput) {
        this.derivInput = derivInput;
    }

    public String getDerivInput() {
        return this.derivInput;
    }
}

