/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.functionfield;

import com.jimrolf.functionparser.FunctionParser;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FunctionField
extends JTextField {
    private String errorInfo;
    private Color errorColor = Color.yellow;
    public FunctionParser parser = new FunctionParser();
    private boolean complexFunc = false;

    public FunctionField() {
        this.setBackground(new Color(235, 235, 235));
        this.setFont(new Font("Lucida Sans", 0, 11));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setText("");
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public void highlightError() {
        this.setBackground(this.errorColor);
    }

    public boolean hasError() {
        boolean hasProblems = false;
        this.parser.parseExpression(this.getText());
        if (this.parser.funcHasError()) {
            hasProblems = true;
            this.errorInfo = "Error with function(s).";
            this.setBackground(this.errorColor);
        }
        return hasProblems;
    }

    public boolean hasError(JLabel errorLabel) {
        boolean hasProblems = false;
        this.parser.parseExpression(this.getText());
        if (this.parser.funcHasError()) {
            hasProblems = true;
            this.errorInfo = "Error with function(s).";
            errorLabel.setText(this.errorInfo);
            this.setBackground(this.errorColor);
        }
        return hasProblems;
    }

    public boolean derivHasError() {
        boolean hasProblems = false;
        if (this.parser.derivHasError()) {
            hasProblems = true;
            this.errorInfo = "Error in derivative";
            this.setBackground(this.errorColor);
        }
        return hasProblems;
    }

    public boolean derivHasError(JLabel errorLabel) {
        boolean hasProblems = false;
        if (this.parser.derivHasError()) {
            hasProblems = true;
            this.errorInfo = "Error in derivative";
            errorLabel.setText(this.errorInfo);
            this.setBackground(this.errorColor);
        }
        return hasProblems;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public FunctionParser getParser() {
        return this.parser;
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
    }

    public void setParser(FunctionParser parser) {
        this.parser = parser;
    }

    public boolean isComplexFunc() {
        return this.complexFunc;
    }

    public void setComplexFunc(boolean complexFunc) {
        this.complexFunc = complexFunc;
        if (complexFunc) {
            this.parser.setComplex(true);
            this.parser.removeVariable(this.parser.getVariable());
            this.parser.setVariable("z");
        } else {
            this.parser.setComplex(false);
            this.parser.removeVariable("z");
            this.parser.setVariable("x");
        }
    }
}

