/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.domainchoicebox;

import com.jimrolf.functionfield.DoubleField;
import com.jimrolf.grapher2d.Grapher2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class DomainChoiceBox
extends JComboBox {
    protected double[] domainRange = null;
    protected DecimalFormat numberFormat;
    protected String numberFormatPattern = "0.000000000000000";
    protected int numberFormatDecimalPlaces = 8;
    protected Grapher2D grapher = null;
    protected DoubleField xMinField = null;
    protected DoubleField xMaxField = null;
    protected DoubleField yMinField = null;
    protected DoubleField yMaxField = null;
    protected String capturedLabel = "Capture view";
    protected String removeLabel = "Remove last captured view";
    protected int numFixedSlots = 0;
    protected int numCapturedSlots = 0;
    protected int maxNumCapturedSlots = 10;
    protected double[] capturedXMin = new double[this.maxNumCapturedSlots];
    protected double[] capturedXMax = new double[this.maxNumCapturedSlots];
    protected double[] capturedYMin = new double[this.maxNumCapturedSlots];
    protected double[] capturedYMax = new double[this.maxNumCapturedSlots];
    protected String[] capturedXMinString = new String[this.maxNumCapturedSlots];
    protected String[] capturedXMaxString = new String[this.maxNumCapturedSlots];
    protected String[] capturedYMinString = new String[this.maxNumCapturedSlots];
    protected String[] capturedYMaxString = new String[this.maxNumCapturedSlots];

    public DomainChoiceBox() {
        this.numberFormat = new DecimalFormat();
        this.numberFormat.applyPattern(this.numberFormatPattern);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(1);
        this.numberFormat.setMaximumFractionDigits(this.numberFormatDecimalPlaces);
        this.setBackground(Color.WHITE);
        this.domainRange = new double[4];
        this.domainRange[0] = -3.0;
        this.domainRange[1] = 3.0;
        this.domainRange[2] = -3.0;
        this.domainRange[3] = 3.0;
        this.setFont(new Font("Lucida Sans", 1, 10));
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                DomainChoiceBox.this.domainChoiceBoxPopupMenuWillBecomeVisible(evt);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public void domainChoiceBoxPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        JComboBox box = (JComboBox)evt.getSource();
        Accessible comp = box.getUI().getAccessibleChild(box, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        JComponent scrollPane = (JComponent)((JPopupMenu)comp).getComponent(0);
        Dimension size = new Dimension();
        size.width = box.getPreferredSize().width > box.getSize().width ? box.getPreferredSize().width : box.getSize().width;
        size.height = scrollPane.getPreferredSize().height;
        scrollPane.setPreferredSize(size);
        scrollPane.setMaximumSize(size);
    }

    public abstract void putDomainRangeVals();

    public void registerObjects(Grapher2D grapher, double[] domainRange, DoubleField xMinField, DoubleField xMaxField, DoubleField yMinField, DoubleField yMaxField) {
        this.grapher = grapher;
        this.domainRange = domainRange;
        this.xMinField = xMinField;
        this.xMaxField = xMaxField;
        this.yMinField = yMinField;
        this.yMaxField = yMaxField;
    }

    public void updateRegisteredObjects(double xMin, double xMax, double yMin, double yMax, String xMinString, String xMaxString, String yMinString, String yMaxString) {
        if (this.grapher != null) {
            this.grapher.setXMin(xMin);
            this.grapher.setXMax(xMax);
            this.grapher.setYMin(yMin);
            this.grapher.setYMax(yMax);
        }
        if (this.domainRange != null) {
            this.domainRange[0] = xMin;
            this.domainRange[1] = xMax;
            this.domainRange[2] = yMin;
            this.domainRange[3] = yMax;
        }
        if (this.xMinField != null) {
            this.xMinField.setText(xMinString);
            this.xMinField.setDoubleVal(xMin);
        }
        if (this.xMaxField != null) {
            this.xMaxField.setText(xMaxString);
            this.xMaxField.setDoubleVal(xMax);
        }
        if (this.yMinField != null) {
            this.yMinField.setText(yMinString);
            this.yMinField.setDoubleVal(yMin);
        }
        if (this.yMaxField != null) {
            this.yMaxField.setText(yMaxString);
            this.yMaxField.setDoubleVal(yMax);
        }
    }

    public double getDomainRange(int index) {
        return this.domainRange[index];
    }

    public double[] getDomainRange() {
        return this.domainRange;
    }

    public void setDomainRange(int index, double domainRange) {
        this.domainRange[index] = domainRange;
    }

    public void setDomainRange(double[] domainRange) {
        this.domainRange = domainRange;
    }

    public DecimalFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(DecimalFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getNumberFormatPattern() {
        return this.numberFormatPattern;
    }

    public void setNumberFormatPattern(String numberFormatPattern) {
        this.numberFormatPattern = numberFormatPattern;
    }

    public int getNumberFormatDecimalPlaces() {
        return this.numberFormatDecimalPlaces;
    }

    public void setNumberFormatDecimalPlaces(int numberFormatDecimalPlaces) {
        this.numberFormatDecimalPlaces = numberFormatDecimalPlaces;
    }

    public Grapher2D getGrapher() {
        return this.grapher;
    }

    public void setGrapher(Grapher2D grapher) {
        this.grapher = grapher;
    }

    public DoubleField getXMinField() {
        return this.xMinField;
    }

    public void setXMinField(DoubleField xMinField) {
        this.xMinField = xMinField;
    }

    public DoubleField getXMaxField() {
        return this.xMaxField;
    }

    public void setXMaxField(DoubleField xMaxField) {
        this.xMaxField = xMaxField;
    }

    public DoubleField getYMinField() {
        return this.yMinField;
    }

    public void setYMinField(DoubleField yMinField) {
        this.yMinField = yMinField;
    }

    public DoubleField getYMaxField() {
        return this.yMaxField;
    }

    public void setYMaxField(DoubleField yMaxField) {
        this.yMaxField = yMaxField;
    }

    public String getCapturedLabel() {
        return this.capturedLabel;
    }

    public void setCapturedLabel(String captureLabel) {
        this.capturedLabel = captureLabel;
    }

    public String getRemoveLabel() {
        return this.removeLabel;
    }

    public void setRemoveLabel(String removeLabel) {
        this.removeLabel = removeLabel;
    }

    public int getNumFixedSlots() {
        return this.numFixedSlots;
    }

    public void setNumFixedSlots(int numFixedSlots) {
        this.numFixedSlots = numFixedSlots;
    }

    public int getNumCapturedSlots() {
        return this.numCapturedSlots;
    }

    public void setNumCapturedSlots(int numCapturedSlots) {
        this.numCapturedSlots = numCapturedSlots;
    }

    public int getMaxNumCapturedSlots() {
        return this.maxNumCapturedSlots;
    }

    public void setMaxNumCapturedSlots(int maxNumCapturedSlots) {
        this.maxNumCapturedSlots = maxNumCapturedSlots;
    }

    public double[] getCapturedXMin() {
        return this.capturedXMin;
    }

    public void setCapturedXMin(double[] capturedXMin) {
        this.capturedXMin = capturedXMin;
    }

    public double getCapturedXMin(int index) {
        return this.capturedXMin[index];
    }

    public void setCapturedXMin(int index, double newCapturedXMin) {
        this.capturedXMin[index] = newCapturedXMin;
    }

    public double[] getCapturedXMax() {
        return this.capturedXMax;
    }

    public void setCapturedXMax(double[] capturedXMax) {
        this.capturedXMax = capturedXMax;
    }

    public double getCapturedXMax(int index) {
        return this.capturedXMax[index];
    }

    public void setCapturedXMax(int index, double newCapturedXMax) {
        this.capturedXMax[index] = newCapturedXMax;
    }

    public double[] getCapturedYMin() {
        return this.capturedYMin;
    }

    public void setCapturedYMin(double[] capturedYMin) {
        this.capturedYMin = capturedYMin;
    }

    public double getCapturedYMin(int index) {
        return this.capturedYMin[index];
    }

    public void setCapturedYMin(int index, double newCapturedYMin) {
        this.capturedYMin[index] = newCapturedYMin;
    }

    public double[] getCapturedYMax() {
        return this.capturedYMax;
    }

    public void setCapturedYMax(double[] capturedYMax) {
        this.capturedYMax = capturedYMax;
    }

    public double getCapturedYMax(int index) {
        return this.capturedYMax[index];
    }

    public void setCapturedYMax(int index, double newCapturedYMax) {
        this.capturedYMax[index] = newCapturedYMax;
    }

    public String[] getCapturedXMinString() {
        return this.capturedXMinString;
    }

    public void setCapturedXMinString(String[] capturedXMinString) {
        this.capturedXMinString = capturedXMinString;
    }

    public String getCapturedXMinString(int index) {
        return this.capturedXMinString[index];
    }

    public void setCapturedXMinString(int index, String newCapturedXMinString) {
        this.capturedXMinString[index] = newCapturedXMinString;
    }

    public String[] getCapturedXMaxString() {
        return this.capturedXMaxString;
    }

    public void setCapturedXMaxString(String[] capturedXMaxString) {
        this.capturedXMaxString = capturedXMaxString;
    }

    public String getCapturedXMaxString(int index) {
        return this.capturedXMaxString[index];
    }

    public void setCapturedXMaxString(int index, String newCapturedXMaxString) {
        this.capturedXMaxString[index] = newCapturedXMaxString;
    }

    public String[] getCapturedYMinString() {
        return this.capturedYMinString;
    }

    public void setCapturedYMinString(String[] capturedYMinString) {
        this.capturedYMinString = capturedYMinString;
    }

    public String getCapturedYMinString(int index) {
        return this.capturedYMinString[index];
    }

    public void setCapturedYMinString(int index, String newCapturedYMinString) {
        this.capturedYMinString[index] = newCapturedYMinString;
    }

    public String[] getCapturedYMaxString() {
        return this.capturedYMaxString;
    }

    public void setCapturedYMaxString(String[] capturedYMaxString) {
        this.capturedYMaxString = capturedYMaxString;
    }

    public String getCapturedYMaxString(int index) {
        return this.capturedYMaxString[index];
    }

    public void setCapturedYMaxString(int index, String newCapturedYMaxString) {
        this.capturedYMaxString[index] = newCapturedYMaxString;
    }

    public void itemClicked() {
        boolean noProblems = true;
        if (this.getItemCount() > this.numFixedSlots + this.numCapturedSlots + 2) {
            this.removeItemAt(this.numFixedSlots + this.numCapturedSlots + 2);
        }
        if (this.xMinField != null) {
            this.xMinField.setBackground(this.xMinField.getBackgroundColor());
        }
        if (this.xMaxField != null) {
            this.xMaxField.setBackground(this.xMaxField.getBackgroundColor());
        }
        if (this.yMinField != null) {
            this.yMinField.setBackground(this.yMinField.getBackgroundColor());
        }
        if (this.yMaxField != null) {
            this.yMaxField.setBackground(this.yMaxField.getBackgroundColor());
        }
        if (this.getSelectedIndex() == this.numFixedSlots + this.numCapturedSlots && this.numCapturedSlots < this.maxNumCapturedSlots) {
            if (this.xMinField != null && !this.xMinField.hasError()) {
                this.capturedXMin[this.numCapturedSlots] = this.xMinField.getDoubleVal();
                this.capturedXMinString[this.numCapturedSlots] = this.xMinField.getText();
            } else {
                noProblems = false;
            }
            if (this.xMaxField != null && !this.xMaxField.hasError()) {
                this.capturedXMax[this.numCapturedSlots] = this.xMaxField.getDoubleVal();
                this.capturedXMaxString[this.numCapturedSlots] = this.xMaxField.getText();
            } else {
                noProblems = false;
            }
            if (this.yMinField != null && !this.yMinField.hasError()) {
                this.capturedYMin[this.numCapturedSlots] = this.yMinField.getDoubleVal();
                this.capturedYMinString[this.numCapturedSlots] = this.yMinField.getText();
            } else {
                noProblems = false;
            }
            if (this.yMaxField != null && !this.yMaxField.hasError()) {
                this.capturedYMax[this.numCapturedSlots] = this.yMaxField.getDoubleVal();
                this.capturedYMaxString[this.numCapturedSlots] = this.yMaxField.getText();
            } else {
                noProblems = false;
            }
            if (this.xMinField != null || this.xMaxField != null || this.yMinField != null || this.yMaxField != null) {
                if (noProblems) {
                    ++this.numCapturedSlots;
                    this.insertItemAt("[" + this.capturedXMinString[this.numCapturedSlots - 1] + "," + this.capturedXMaxString[this.numCapturedSlots - 1] + "] x [" + this.capturedYMinString[this.numCapturedSlots - 1] + "," + this.capturedYMaxString[this.numCapturedSlots - 1] + "]", this.getSelectedIndex());
                    this.setSelectedIndex(this.numFixedSlots + this.numCapturedSlots - 1);
                    this.putDomainRangeVals();
                } else {
                    this.addItem("Error in domain/range");
                    this.setSelectedIndex(this.numFixedSlots + this.numCapturedSlots + 2);
                }
            }
        } else if (this.getSelectedIndex() == this.numFixedSlots + this.numCapturedSlots + 1) {
            if (this.numCapturedSlots == 0) {
                this.setSelectedIndex(1);
                this.putDomainRangeVals();
            } else {
                this.removeItemAt(this.numFixedSlots + this.numCapturedSlots - 1);
                --this.numCapturedSlots;
                this.setSelectedIndex(this.numFixedSlots + this.numCapturedSlots - 1);
                this.putDomainRangeVals();
            }
        } else if (this.getSelectedIndex() < this.numFixedSlots + this.numCapturedSlots) {
            this.putDomainRangeVals();
        }
    }
}

