/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import com.jimrolf.complex.Complex;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommand;

public class Mobius
extends PostfixMathCommand
implements CallbackEvaluationI {
    public Mobius() {
        this.numberOfParameters = -1;
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 2;
    }

    public Object evaluate(Node node, EvaluatorI pv) throws ParseException {
        double val;
        int num = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(num)) {
            throw new ParseException("If operator must have 2 arguments.");
        }
        Object condVal = pv.eval(node.jjtGetChild(0));
        if (!(condVal instanceof Complex)) {
            throw new ParseException("First parameter must be complex");
        }
        if (condVal instanceof Boolean) {
            if (((Boolean)condVal).booleanValue()) {
                return pv.eval(node.jjtGetChild(1));
            }
            return pv.eval(node.jjtGetChild(2));
        }
        if (condVal instanceof Complex) {
            val = ((Complex)condVal).re();
        } else if (condVal instanceof Number) {
            val = ((Number)condVal).doubleValue();
        } else {
            throw new ParseException("Condition in if operator must be double or complex");
        }
        if (val > 0.0) {
            return pv.eval(node.jjtGetChild(1));
        }
        if (num == 3 || val < 0.0) {
            return pv.eval(node.jjtGetChild(2));
        }
        return pv.eval(node.jjtGetChild(3));
    }
}

