/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.lsmp.djep.xjep.CommandVisitor;
import org.lsmp.djep.xjep.DeepCopyVisitor;
import org.lsmp.djep.xjep.Eval;
import org.lsmp.djep.xjep.MacroFunction;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.PrintVisitor;
import org.lsmp.djep.xjep.SimplificationVisitor;
import org.lsmp.djep.xjep.SubstitutionVisitor;
import org.lsmp.djep.xjep.TreeUtils;
import org.lsmp.djep.xjep.XEvaluatorVisitor;
import org.lsmp.djep.xjep.XOperatorSet;
import org.lsmp.djep.xjep.XSymbolTable;
import org.lsmp.djep.xjep.XVariable;
import org.lsmp.djep.xjep.XVariableFactory;
import org.lsmp.djep.xjep.function.Define;
import org.lsmp.djep.xjep.function.FromBase;
import org.lsmp.djep.xjep.function.Max;
import org.lsmp.djep.xjep.function.MaxArg;
import org.lsmp.djep.xjep.function.Min;
import org.lsmp.djep.xjep.function.MinArg;
import org.lsmp.djep.xjep.function.Product;
import org.lsmp.djep.xjep.function.Simpson;
import org.lsmp.djep.xjep.function.Sum;
import org.lsmp.djep.xjep.function.ToBase;
import org.lsmp.djep.xjep.function.Trapezium;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;
import org.nfunk.jep.function.Exp;
import org.nfunk.jep.function.PostfixMathCommandI;

public class XJep
extends JEP {
    protected NodeFactory nf = null;
    protected TreeUtils tu = null;
    protected DeepCopyVisitor copier = null;
    protected SubstitutionVisitor subv = null;
    protected SimplificationVisitor simpv = null;
    protected CommandVisitor commandv = null;
    protected PrintVisitor pv = null;
    private VariableFactory vf = new XVariableFactory();
    private JEP ingrediant = null;

    public XJep() {
        this.symTab = new XSymbolTable(this.vf);
        this.nf = new NodeFactory(this);
        this.opSet = new XOperatorSet();
        this.tu = new TreeUtils();
        this.copier = new DeepCopyVisitor();
        this.subv = new SubstitutionVisitor();
        this.ev = new XEvaluatorVisitor();
        this.simpv = new SimplificationVisitor();
        this.commandv = new CommandVisitor();
        this.pv = new PrintVisitor();
        this.pv.addSpecialRule(this.opSet.getElement(), new PrintVisitor.PrintRulesI(){

            public void append(Node node, PrintVisitor pv) throws ParseException {
                node.jjtGetChild(0).jjtAccept(pv, null);
                node.jjtGetChild(1).jjtAccept(pv, null);
            }
        });
    }

    protected XJep(XJep j) {
        super(j);
        this.commandv = j.commandv;
        this.copier = j.copier;
        this.ev = j.ev;
        this.nf = j.nf;
        this.opSet = j.opSet;
        this.pv = j.pv;
        this.simpv = j.simpv;
        this.subv = j.subv;
        this.tu = j.tu;
    }

    public XJep(JEP j) {
        this.ingrediant = j;
        this.nf = new NodeFactory(this);
        this.symTab = new XSymbolTable(this.vf);
        this.funTab = j.getFunctionTable();
        this.opSet = new XOperatorSet(j.getOperatorSet());
        this.tu = new TreeUtils();
        this.copier = new DeepCopyVisitor();
        this.subv = new SubstitutionVisitor();
        this.ev = new XEvaluatorVisitor();
        this.simpv = new SimplificationVisitor();
        this.commandv = new CommandVisitor();
        this.pv = new PrintVisitor();
    }

    public XJep newInstance() {
        XJep newJep = new XJep(this);
        return newJep;
    }

    public XJep newInstance(SymbolTable st) {
        XJep newJep = new XJep(this);
        newJep.symTab = st;
        return newJep;
    }

    public void addStandardFunctions() {
        if (this.ingrediant != null) {
            this.ingrediant.addStandardFunctions();
        } else {
            super.addStandardFunctions();
        }
        this.addFunction("eval", new Eval());
        this.addFunction("Sum", new Sum(this));
        this.addFunction("Product", new Product());
        this.addFunction("Min", new Min());
        this.addFunction("Max", new Max());
        this.addFunction("MinArg", new MinArg());
        this.addFunction("MaxArg", new MaxArg());
        this.addFunction("Simpson", new Simpson());
        this.addFunction("Trapezium", new Trapezium());
        this.addFunction("toBase", new ToBase());
        this.addFunction("toHex", new ToBase(16, "0x"));
        this.addFunction("fromBase", new FromBase());
        this.addFunction("fromHex", new FromBase(16, "0x"));
        this.addFunction("exp", new Exp());
        this.addFunction("Define", new Define(this));
        try {
            MacroFunction sec = new MacroFunction("sec", 1, "1/cos(x)", this);
            this.addFunction("sec", sec);
            MacroFunction cosec = new MacroFunction("cosec", 1, "1/sin(x)", this);
            this.addFunction("cosec", cosec);
            MacroFunction cot = new MacroFunction("cot", 1, "1/tan(x)", this);
            this.addFunction("cot", cot);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
    }

    public void addStandardConstants() {
        if (this.ingrediant != null) {
            this.ingrediant.addStandardConstants();
            Enumeration en = this.ingrediant.getSymbolTable().elements();
            while (en.hasMoreElements()) {
                Variable var = (Variable)en.nextElement();
                if (!var.isConstant()) continue;
                this.symTab.addConstant(var.getName(), var.getValue());
            }
        } else {
            super.addStandardConstants();
        }
    }

    public void addComplex() {
        if (this.ingrediant != null) {
            this.ingrediant.addComplex();
        } else {
            super.addComplex();
        }
        try {
            MacroFunction complex = new MacroFunction("macrocomplex", 2, "x+i*y", this);
            this.addFunction("macrocomplex", complex);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
    }

    public Node deepCopy(Node node) throws ParseException {
        return this.copier.deepCopy(node, this);
    }

    public Node simplify(Node node) throws ParseException {
        return this.simpv.simplify(node, this);
    }

    public Node preprocess(Node node) throws ParseException {
        return this.commandv.process(node, this);
    }

    public Node substitute(Node orig, String name, Node replacement) throws ParseException {
        return this.subv.substitute(orig, name, replacement, this);
    }

    public Node substitute(Node orig, String[] names, Node[] replacements) throws ParseException {
        return this.subv.substitute(orig, names, replacements, this);
    }

    public void print(Node node) {
        this.pv.print(node);
    }

    public void print(Node node, PrintStream out) {
        this.pv.print(node, out);
    }

    public void println(Node node) {
        this.pv.println(node);
    }

    public void println(Node node, PrintStream out) {
        this.pv.println(node, out);
    }

    public String toString(Node node) {
        return this.pv.toString(node);
    }

    public NodeFactory getNodeFactory() {
        return this.nf;
    }

    public TreeUtils getTreeUtils() {
        return this.tu;
    }

    public PrintVisitor getPrintVisitor() {
        return this.pv;
    }

    public Object calcVarValue(String name) throws Exception {
        XVariable xvar = (XVariable)this.getVar(name);
        return xvar.calcValue(this);
    }

    public Node continueParsing() throws ParseException {
        return this.parser.continueParse();
    }

    public void restartParser(String str) {
        this.parser.restart(new StringReader(str), this);
    }

    public void restartParser(Reader reader) {
        this.parser.restart(reader, this);
    }

    public Vector getVarsInEquation(Node n, Vector v) {
        if (n instanceof ASTVarNode) {
            Variable var = ((ASTVarNode)n).getVar();
            if (!v.contains(var)) {
                v.add(var);
            }
        } else if (n instanceof ASTFunNode) {
            for (int i = 0; i < n.jjtGetNumChildren(); ++i) {
                this.getVarsInEquation(n.jjtGetChild(i), v);
            }
        }
        return v;
    }

    public Vector recursiveGetVarsInEquation(Node n, Vector v) throws ParseException {
        if (n instanceof ASTVarNode) {
            XVariable var = (XVariable)((ASTVarNode)n).getVar();
            if (!v.contains(var)) {
                if (var.hasEquation()) {
                    this.recursiveGetVarsInEquation(var.getEquation(), v);
                }
                if (v.contains(var)) {
                    throw new ParseException("Recursive definition for " + var.getName());
                }
                v.add(var);
            }
        } else if (n instanceof ASTFunNode) {
            for (int i = 0; i < n.jjtGetNumChildren(); ++i) {
                this.recursiveGetVarsInEquation(n.jjtGetChild(i), v);
            }
        }
        return v;
    }

    public Object evaluate(PostfixMathCommandI pfmc, Node node) throws ParseException {
        return super.evaluate(node);
    }
}

