/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep.diffRules;

import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DiffRulesI;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;

public class PassThroughDiffRule
implements DiffRulesI {
    private String name;
    private PostfixMathCommandI pfmc;

    private PassThroughDiffRule() {
    }

    public PassThroughDiffRule(DJep djep, String inName) {
        this.name = inName;
        this.pfmc = djep.getFunctionTable().get(this.name);
    }

    public PassThroughDiffRule(String inName, PostfixMathCommandI inPfmc) {
        this.name = inName;
        this.pfmc = inPfmc;
    }

    public String toString() {
        if (this.pfmc == null) {
            return "" + this.name + "\t\tPassthrough but no math command!";
        }
        switch (this.pfmc.getNumberOfParameters()) {
            case 0: {
                return this.name + "  \t\tdiff(" + this.name + ",x) -> " + this.name;
            }
            case 1: {
                return this.name + "  \tdiff(" + this.name + "(a),x) -> " + this.name + "(da/dx)";
            }
            case 2: {
                return this.name + "  \tdiff(" + this.name + "(a,b),x) -> " + this.name + "(da/dx,db/dx)";
            }
        }
        return this.name + "  \tdiff(" + this.name + "(a,b,...),x) -> " + this.name + "(da/dx,db/dx,...)";
    }

    public String getName() {
        return this.name;
    }

    public Node differentiate(ASTFunNode node, String var, Node[] children, Node[] dchildren, DJep djep) throws ParseException {
        return djep.getNodeFactory().buildFunctionNode(node, dchildren);
    }
}

