/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.plotstuff2d;

import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.plotstuff2d.PlotStuff2D;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class Vectors2D
extends PlotStuff2D {
    private int[] triangleX = new int[3];
    private int[] triangleY = new int[3];
    private Polygon trianglePlot = new Polygon(this.triangleX, this.triangleY, 3);
    private double epsilon = MachineEpsilon.getEpsilon();
    protected double scalingFactor = 1.0;
    protected int numVectors = 0;
    protected double[][] basePoint = null;
    protected double[][] direction = null;
    protected boolean automaticHeadSize = true;
    protected double headHeight = 0.0;
    protected double headWidth = 0.0;

    public Vectors2D() {
        this.plotStyle = 15;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public int getNumVectors() {
        return this.numVectors;
    }

    public void setNumVectors(int numVectors) {
        this.numVectors = numVectors;
    }

    public double[][] getBasePoint() {
        return this.basePoint;
    }

    public void setBasePoint(double[][] basePoint) {
        this.basePoint = basePoint;
    }

    public double[] getBasePoint(int index) {
        return this.basePoint[index];
    }

    public void setBasePoint(int index, double[] newBasePoint) {
        this.basePoint[index] = newBasePoint;
    }

    public double[][] getDirection() {
        return this.direction;
    }

    public void setDirection(double[][] direction) {
        this.direction = direction;
    }

    public double[] getDirection(int index) {
        return this.direction[index];
    }

    public void setDirection(int index, double[] newDirection) {
        this.direction[index] = newDirection;
    }

    public boolean isAutomaticHeadSize() {
        return this.automaticHeadSize;
    }

    public void setAutomaticHeadSize(boolean automaticHeadSize) {
        this.automaticHeadSize = automaticHeadSize;
    }

    public double getHeadHeight() {
        return this.headHeight;
    }

    public void setHeadHeight(double headHeight) {
        this.headHeight = headHeight;
    }

    public double getHeadWidth() {
        return this.headWidth;
    }

    public void vecField(double headWidth) {
        this.headWidth = headWidth;
    }

    public void plotData(Grapher2D grapher, Graphics2D g2d) {
        int graphX1 = 0;
        int graphY1 = 0;
        int graphX2 = 0;
        int graphY2 = 0;
        double xa = 0.0;
        double ya = 0.0;
        double m = 0.0;
        double yMax = grapher.getYMax();
        double yMin = grapher.getYMin();
        int yAxisLength = grapher.getYAxisLength();
        double directionX = 0.0;
        double directionY = 0.0;
        double arrowHeadDeltaX = 0.0;
        double headWidthRatio = 1.5;
        if (this.automaticHeadSize) {
            this.headHeight = ((double)this.plotSize + 4.0) * (yMax - yMin) / (double)yAxisLength;
            this.headWidth = this.headHeight / headWidthRatio;
        }
        g2d.setStroke(new BasicStroke(this.plotSize, 0, 0));
        for (int i = 0; i <= this.numVectors - 1; ++i) {
            if (this.isSingularity(this.basePoint[i][0]) || this.isSingularity(this.basePoint[i][1]) || this.isSingularity(this.direction[i][0]) || this.isSingularity(this.direction[i][1])) continue;
            graphX1 = grapher.getXPixel(this.basePoint[i][0]);
            graphY1 = grapher.getYPixel(this.basePoint[i][1]);
            directionX = this.scalingFactor * this.direction[i][0];
            directionY = this.scalingFactor * this.direction[i][1];
            if (Math.abs(this.direction[i][0]) <= this.epsilon) {
                arrowHeadDeltaX = this.headWidth;
                ya = directionY > 0.0 ? directionY - this.headHeight : directionY + this.headHeight;
                this.trianglePlot.xpoints[0] = grapher.getXPixel(this.basePoint[i][0] - arrowHeadDeltaX);
                this.trianglePlot.ypoints[0] = grapher.getYPixel(this.basePoint[i][1] + ya);
                this.trianglePlot.xpoints[1] = grapher.getXPixel(this.basePoint[i][0] + arrowHeadDeltaX);
                this.trianglePlot.ypoints[1] = this.trianglePlot.ypoints[0];
                this.trianglePlot.xpoints[2] = grapher.getXPixel(this.basePoint[i][0]);
                this.trianglePlot.ypoints[2] = grapher.getYPixel(this.basePoint[i][1] + directionY);
                graphX2 = this.trianglePlot.xpoints[2];
                graphY2 = this.trianglePlot.ypoints[0];
            } else {
                m = directionY / directionX;
                if (m > 0.0) {
                    arrowHeadDeltaX = this.headWidth * Math.abs(m) / Math.sqrt(1.0 + m * m);
                    xa = this.direction[i][1] > 0.0 ? this.basePoint[i][0] + directionX - this.headHeight / Math.sqrt(1.0 + m * m) : this.basePoint[i][0] + directionX + this.headHeight / Math.sqrt(1.0 + m * m);
                    ya = m * (xa - directionX - this.basePoint[i][0]) + directionY + this.basePoint[i][1];
                    this.trianglePlot.xpoints[0] = grapher.getXPixel(xa + arrowHeadDeltaX);
                    this.trianglePlot.ypoints[0] = grapher.getYPixel(-arrowHeadDeltaX / m + ya);
                    this.trianglePlot.xpoints[1] = grapher.getXPixel(xa - arrowHeadDeltaX);
                    this.trianglePlot.ypoints[1] = grapher.getYPixel(arrowHeadDeltaX / m + ya);
                    this.trianglePlot.xpoints[2] = grapher.getXPixel(this.basePoint[i][0] + directionX);
                    this.trianglePlot.ypoints[2] = grapher.getYPixel(this.basePoint[i][1] + directionY);
                    graphX2 = grapher.getXPixel(xa);
                    graphY2 = grapher.getYPixel(ya);
                } else if (m < 0.0) {
                    arrowHeadDeltaX = this.headWidth * Math.abs(m) / Math.sqrt(1.0 + m * m);
                    xa = this.direction[i][1] < 0.0 ? this.basePoint[i][0] + directionX - this.headHeight / Math.sqrt(1.0 + m * m) : this.basePoint[i][0] + directionX + this.headHeight / Math.sqrt(1.0 + m * m);
                    ya = m * (xa - directionX - this.basePoint[i][0]) + directionY + this.basePoint[i][1];
                    this.trianglePlot.xpoints[0] = grapher.getXPixel(xa - arrowHeadDeltaX);
                    this.trianglePlot.ypoints[0] = grapher.getYPixel(arrowHeadDeltaX / m + ya);
                    this.trianglePlot.xpoints[1] = grapher.getXPixel(xa + arrowHeadDeltaX);
                    this.trianglePlot.ypoints[1] = grapher.getYPixel(-arrowHeadDeltaX / m + ya);
                    this.trianglePlot.xpoints[2] = grapher.getXPixel(this.basePoint[i][0] + directionX);
                    this.trianglePlot.ypoints[2] = grapher.getYPixel(this.basePoint[i][1] + directionY);
                    graphX2 = grapher.getXPixel(xa);
                    graphY2 = grapher.getYPixel(ya);
                } else {
                    arrowHeadDeltaX = this.headWidth;
                    xa = directionX > 0.0 ? this.basePoint[i][0] + directionX - arrowHeadDeltaX : this.basePoint[i][0] + directionX + arrowHeadDeltaX;
                    this.trianglePlot.xpoints[0] = grapher.getXPixel(xa);
                    this.trianglePlot.ypoints[0] = grapher.getYPixel(this.basePoint[i][1] + directionY - arrowHeadDeltaX);
                    this.trianglePlot.xpoints[1] = grapher.getXPixel(xa);
                    this.trianglePlot.ypoints[1] = grapher.getYPixel(this.basePoint[i][1] + directionY + arrowHeadDeltaX);
                    this.trianglePlot.xpoints[2] = grapher.getXPixel(this.basePoint[i][0] + directionX);
                    this.trianglePlot.ypoints[2] = grapher.getYPixel(this.basePoint[i][1] + directionY);
                    graphX2 = this.trianglePlot.xpoints[0];
                    graphY2 = this.trianglePlot.ypoints[2];
                }
            }
            g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
            g2d.fillPolygon(this.trianglePlot);
        }
    }
}

