/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.plotstuff2d;

import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.plotstuff2d.PlotStuff;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class Arrows2D
extends PlotStuff {
    private int[] triangleX = new int[3];
    private int[] triangleY = new int[3];
    private Polygon trianglePlot = new Polygon(this.triangleX, this.triangleY, 3);
    private double epsilon = MachineEpsilon.getEpsilon();
    protected boolean automaticHeadSize = true;
    protected int numArrows = 0;
    protected double[] basePoint = null;
    protected double[] directionVector = null;
    protected double headHeight = 0.0;
    protected double headWidth = 0.0;

    public Arrows2D() {
        this.plotStyle = 2;
    }

    public boolean isAutomaticHeadSize() {
        return this.automaticHeadSize;
    }

    public void setAutomaticHeadSize(boolean automaticHeadSize) {
        this.automaticHeadSize = automaticHeadSize;
    }

    public int getNumArrows() {
        return this.numArrows;
    }

    public void setNumArrows(int numArrows) {
        this.numArrows = numArrows;
    }

    public double[] getBasePoint() {
        return this.basePoint;
    }

    public void setBasePoint(double[] basePoint) {
        this.basePoint = basePoint;
    }

    public double getBasePoint(int index) {
        return this.basePoint[index];
    }

    public void setBasePoint(int index, double newBasePoint) {
        this.basePoint[index] = newBasePoint;
    }

    public double[] getDirectionVector() {
        return this.directionVector;
    }

    public void setDirectionVector(double[] directionVector) {
        this.directionVector = directionVector;
    }

    public double getDirectionVector(int index) {
        return this.directionVector[index];
    }

    public void setDirectionVector(int index, double newDirectionVector) {
        this.directionVector[index] = newDirectionVector;
    }

    public double getHeadHeight() {
        return this.headHeight;
    }

    public void setHeadHeight(double headHeight) {
        this.headHeight = headHeight;
    }

    public double getHeadWidth() {
        return this.headWidth;
    }

    public void setHeadWidth(double headWidth) {
        this.headWidth = headWidth;
    }

    public void plotData(Grapher2D grapher, Graphics2D g2d) {
        int graphX1 = 0;
        int graphY1 = 0;
        int graphX2 = 0;
        int graphY2 = 0;
        double xa = 0.0;
        double ya = 0.0;
        double m = 0.0;
        double yMax = grapher.getYMax();
        double yMin = grapher.getYMin();
        int yAxisLength = grapher.getYAxisLength();
        double arrowHeadDeltaX = 0.0;
        double headWidthRatio = 1.5;
        if (this.automaticHeadSize) {
            this.headHeight = ((double)this.plotSize + 4.0) * (yMax - yMin) / (double)yAxisLength;
        }
        g2d.setStroke(new BasicStroke(this.plotSize, 0, 0));
        graphX1 = grapher.getXPixel(this.basePoint[0]);
        graphY1 = grapher.getYPixel(this.basePoint[1]);
        if (Math.abs(this.directionVector[0] - this.basePoint[0]) <= this.epsilon) {
            arrowHeadDeltaX = this.headHeight / headWidthRatio;
            ya = this.directionVector[1] > this.basePoint[1] ? this.directionVector[1] - this.headHeight : this.directionVector[1] + this.headHeight;
            this.trianglePlot.xpoints[0] = grapher.getXPixel(this.directionVector[0] - arrowHeadDeltaX);
            this.trianglePlot.ypoints[0] = grapher.getYPixel(ya);
            this.trianglePlot.xpoints[1] = grapher.getXPixel(this.directionVector[0] + arrowHeadDeltaX);
            this.trianglePlot.ypoints[1] = this.trianglePlot.ypoints[0];
            this.trianglePlot.xpoints[2] = grapher.getXPixel(this.directionVector[0]);
            this.trianglePlot.ypoints[2] = grapher.getYPixel(this.directionVector[1]);
            graphX2 = this.trianglePlot.xpoints[2];
            graphY2 = this.trianglePlot.ypoints[0];
        } else {
            m = (this.directionVector[1] - this.basePoint[1]) / (this.directionVector[0] - this.basePoint[0]);
            if (m > 0.0) {
                arrowHeadDeltaX = this.headHeight / headWidthRatio * Math.abs(m) / Math.sqrt(1.0 + m * m);
                xa = this.directionVector[0] > this.basePoint[0] ? this.directionVector[0] - this.headHeight / Math.sqrt(1.0 + m * m) : this.directionVector[0] + this.headHeight / Math.sqrt(1.0 + m * m);
                ya = m * (xa - this.directionVector[0]) + this.directionVector[1];
                this.trianglePlot.xpoints[0] = grapher.getXPixel(xa + arrowHeadDeltaX);
                this.trianglePlot.ypoints[0] = grapher.getYPixel(-arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[1] = grapher.getXPixel(xa - arrowHeadDeltaX);
                this.trianglePlot.ypoints[1] = grapher.getYPixel(arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[2] = grapher.getXPixel(this.directionVector[0]);
                this.trianglePlot.ypoints[2] = grapher.getYPixel(this.directionVector[1]);
                graphX2 = grapher.getXPixel(xa);
                graphY2 = grapher.getYPixel(ya);
            } else if (m < 0.0) {
                arrowHeadDeltaX = this.headHeight / headWidthRatio * Math.abs(m) / Math.sqrt(1.0 + m * m);
                xa = this.directionVector[0] > this.basePoint[0] ? this.directionVector[0] - this.headHeight / Math.sqrt(1.0 + m * m) : this.directionVector[0] + this.headHeight / Math.sqrt(1.0 + m * m);
                ya = m * (xa - this.directionVector[0]) + this.directionVector[1];
                this.trianglePlot.xpoints[0] = grapher.getXPixel(xa - arrowHeadDeltaX);
                this.trianglePlot.ypoints[0] = grapher.getYPixel(arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[1] = grapher.getXPixel(xa + arrowHeadDeltaX);
                this.trianglePlot.ypoints[1] = grapher.getYPixel(-arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[2] = grapher.getXPixel(this.directionVector[0]);
                this.trianglePlot.ypoints[2] = grapher.getYPixel(this.directionVector[1]);
                graphX2 = grapher.getXPixel(xa);
                graphY2 = grapher.getYPixel(ya);
            } else {
                arrowHeadDeltaX = this.headHeight / headWidthRatio;
                xa = this.directionVector[0] > this.basePoint[0] ? this.directionVector[0] - arrowHeadDeltaX : this.directionVector[0] + arrowHeadDeltaX;
                this.trianglePlot.xpoints[0] = grapher.getXPixel(xa);
                this.trianglePlot.ypoints[0] = grapher.getYPixel(this.directionVector[1] - arrowHeadDeltaX);
                this.trianglePlot.xpoints[1] = grapher.getXPixel(xa);
                this.trianglePlot.ypoints[1] = grapher.getYPixel(this.directionVector[1] + arrowHeadDeltaX);
                this.trianglePlot.xpoints[2] = grapher.getXPixel(this.directionVector[0]);
                this.trianglePlot.ypoints[2] = grapher.getYPixel(this.directionVector[1]);
                graphX2 = this.trianglePlot.xpoints[0];
                graphY2 = this.trianglePlot.ypoints[2];
            }
        }
        g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
        g2d.fillPolygon(this.trianglePlot);
    }
}

