/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.multiodesolver;

import com.jimrolf.multiodesolver.MultiDerivFunc;
import com.jimrolf.multiodesolver.MultiODESolver;

public class RungeKutta5
extends MultiODESolver {
    private double[] k1 = null;
    private double[] k2 = null;
    private double[] k3 = null;
    private double[] k4 = null;
    private double[] k5 = null;
    private double[] k6 = null;

    public RungeKutta5() {
    }

    public RungeKutta5(int dimension, MultiDerivFunc func) {
        this.dimension = dimension;
        this.func = func;
    }

    public RungeKutta5(int dimension, double initialT, double[] initialY, MultiDerivFunc func) {
        this.dimension = dimension;
        this.initialT = initialT;
        this.initialY = initialY;
        this.func = func;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.k1 = new double[dimension];
        this.k2 = new double[dimension];
        this.k3 = new double[dimension];
        this.k4 = new double[dimension];
        this.k5 = new double[dimension];
        this.k6 = new double[dimension];
    }

    private void takeNextStep(int nextStepNum, double[] localTempY) {
        int j;
        this.k1 = this.func.f(this.t[nextStepNum - 1], localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k1[n] = this.k1[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + this.k1[j] / 4.0;
        }
        this.k2 = this.func.f(this.t[nextStepNum - 1] + this.h / 4.0, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k2[n] = this.k2[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + (this.k1[j] + this.k2[j]) / 8.0;
        }
        this.k3 = this.func.f(this.t[nextStepNum - 1] + this.h / 4.0, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k3[n] = this.k3[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] - this.k2[j] / 2.0 + this.k3[j];
        }
        this.k4 = this.func.f(this.t[nextStepNum - 1] + this.h / 2.0, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k4[n] = this.k4[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + (3.0 * this.k1[j] + 9.0 * this.k4[j]) / 16.0;
        }
        this.k5 = this.func.f(this.t[nextStepNum - 1] + this.h * 0.75, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k5[n] = this.k5[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + (-3.0 * this.k1[j] + 2.0 * this.k2[j] + 12.0 * this.k3[j] - 12.0 * this.k4[j] + 8.0 * this.k5[j]) / 7.0;
        }
        this.k6 = this.func.f(this.t[nextStepNum - 1] + this.h, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k6[n] = this.k6[n] * this.h;
            this.y[j][nextStepNum] = this.y[j][nextStepNum - 1] + (7.0 * this.k1[j] + 32.0 * this.k3[j] + 12.0 * this.k4[j] + 32.0 * this.k5[j] + 7.0 * this.k6[j]) / 90.0;
        }
        this.t[nextStepNum] = this.initialT + (double)nextStepNum * this.h;
    }

    public void solveODE() {
        this.solveODE(this.numPoints);
    }

    public void solveODEWithErrorChecking() {
        this.solveODEWithErrorChecking(this.numPoints);
    }

    public void solveODE(int localNumPoints) {
        int i;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.numPoints];
            this.y = new double[this.dimension][this.numPoints];
        }
        this.t[0] = this.initialT;
        for (i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        for (i = 1; i <= localNumPoints - 1; ++i) {
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][i - 1];
            }
            this.takeNextStep(i, this.tempY);
        }
    }

    public void solveODEWithErrorChecking(int localNumPoints) {
        int stepNum = 1;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.numPoints];
            this.y = new double[this.dimension][this.numPoints];
        }
        this.error = false;
        this.errorStepNum = 0;
        this.t[0] = this.initialT;
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        while (!this.error && stepNum <= localNumPoints - 1) {
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][stepNum - 1];
            }
            this.takeNextStep(stepNum, this.tempY);
            for (int k = 0; k <= this.dimension - 1; ++k) {
                if (!Double.isInfinite(this.y[k][stepNum]) && !Double.isNaN(this.y[k][stepNum])) continue;
                this.error = true;
                this.errorStepNum = stepNum;
            }
            ++stepNum;
        }
    }

    public void solveODEUntil() {
        int numSteps = 0;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.currentCapacity];
            this.y = new double[this.dimension][this.currentCapacity];
        }
        this.t[0] = this.initialT;
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        this.tempY = this.initialY;
        while (!this.constraints.isTimeToStop(numSteps, this.t[numSteps], this.tempY)) {
            if (numSteps >= this.currentCapacity - 1) {
                this.addCapacityToArrays(numSteps + 1);
            }
            this.takeNextStep(++numSteps, this.tempY);
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][numSteps];
            }
        }
        this.numPoints = numSteps + 1;
    }

    public void solveODEUntilWithErrorChecking() {
        int numSteps = 0;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.currentCapacity];
            this.y = new double[this.dimension][this.currentCapacity];
        }
        this.error = false;
        this.errorStepNum = 0;
        this.t[0] = this.initialT;
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        this.tempY = this.initialY;
        while (!this.constraints.isTimeToStop(numSteps, this.t[numSteps], this.tempY) && !this.error) {
            if (numSteps >= this.currentCapacity - 1) {
                this.addCapacityToArrays(numSteps + 1);
            }
            this.takeNextStep(++numSteps, this.tempY);
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][numSteps];
                if (!Double.isInfinite(this.y[j][numSteps]) && !Double.isNaN(this.y[j][numSteps])) continue;
                this.error = true;
                this.errorStepNum = numSteps;
            }
        }
        this.numPoints = numSteps + 1;
    }
}

