/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.multiodesolver;

import com.jimrolf.multiodesolver.MultiODESolver;

public class RKFehlberg45
extends MultiODESolver {
    private double[] k1 = null;
    private double[] k2 = null;
    private double[] k3 = null;
    private double[] k4 = null;
    private double[] k5 = null;
    private double[] k6 = null;
    private double[] k3Coeffs = new double[]{0.375, 0.09375, 0.28125};
    private double[] k4Coeffs = new double[]{0.9230769230769231, 0.8793809740555303, -3.277196176604461, 3.3208921256258535};
    private double[] k5Coeffs = new double[]{1.0, 2.0324074074074074, -8.0, 7.173489278752436, -0.20589668615984405};
    private double[] k6Coeffs = new double[]{0.5, -0.2962962962962963, 2.0, -1.3816764132553607, 0.4529727095516569, -0.275};
    private double[] nextStepYCoeffs = new double[]{0.11574074074074074, 0.5489278752436647, 0.5353313840155945, -0.2};
    private double[] nextStepZCoeffs = new double[]{0.11851851851851852, 0.5189863547758284, 0.5061314903420167, -0.18, 0.03636363636363636};
    private double errorTolerance = 1.0E-9;
    private double s = 0.0;
    private double norm = 0.0;
    private double[] z = null;
    private double hMax = Double.POSITIVE_INFINITY;
    private double hMin = 0.0;

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.k1 = new double[dimension];
        this.k2 = new double[dimension];
        this.k3 = new double[dimension];
        this.k4 = new double[dimension];
        this.k5 = new double[dimension];
        this.k6 = new double[dimension];
        this.z = new double[dimension];
    }

    private void takeNextStep(int nextStepNum, double[] localTempY) {
        int j;
        for (j = 0; j <= this.dimension - 1; ++j) {
            localTempY[j] = this.y[j][nextStepNum - 1];
        }
        this.k1 = this.func.f(this.t[nextStepNum - 1], localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k1[n] = this.k1[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + this.k1[j] / 4.0;
        }
        this.k2 = this.func.f(this.t[nextStepNum - 1] + this.h / 4.0, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k2[n] = this.k2[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + this.k3Coeffs[1] * this.k1[j] + this.k3Coeffs[2] * this.k2[j];
        }
        this.k3 = this.func.f(this.t[nextStepNum - 1] + this.k3Coeffs[0] * this.h, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k3[n] = this.k3[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + this.k4Coeffs[1] * this.k1[j] + this.k4Coeffs[2] * this.k2[j] + this.k4Coeffs[3] * this.k3[j];
        }
        this.k4 = this.func.f(this.t[nextStepNum - 1] + this.k4Coeffs[0] * this.h, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k4[n] = this.k4[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + this.k5Coeffs[1] * this.k1[j] + this.k5Coeffs[2] * this.k2[j] + this.k5Coeffs[3] * this.k3[j] + this.k5Coeffs[4] * this.k4[j];
        }
        this.k5 = this.func.f(this.t[nextStepNum - 1] + this.h, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k5[n] = this.k5[n] * this.h;
            localTempY[j] = this.y[j][nextStepNum - 1] + this.k6Coeffs[1] * this.k1[j] + this.k6Coeffs[2] * this.k2[j] + this.k6Coeffs[3] * this.k3[j] + this.k6Coeffs[4] * this.k4[j] + this.k6Coeffs[5] * this.k5[j];
        }
        this.k6 = this.func.f(this.t[nextStepNum - 1] + this.k6Coeffs[0] * this.h, localTempY);
        for (j = 0; j <= this.dimension - 1; ++j) {
            int n = j;
            this.k6[n] = this.k6[n] * this.h;
            this.y[j][nextStepNum] = this.y[j][nextStepNum - 1] + this.nextStepYCoeffs[0] * this.k1[j] + this.nextStepYCoeffs[1] * this.k3[j] + this.nextStepYCoeffs[2] * this.k4[j] + this.nextStepYCoeffs[3] * this.k5[j];
            this.z[j] = this.y[j][nextStepNum - 1] + this.nextStepZCoeffs[0] * this.k1[j] + this.nextStepZCoeffs[1] * this.k3[j] + this.nextStepZCoeffs[2] * this.k4[j] + this.nextStepZCoeffs[3] * this.k5[j] + this.nextStepZCoeffs[4] * this.k6[j];
        }
        this.norm = 0.0;
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.norm += (this.z[i] - this.y[i][nextStepNum]) * (this.z[i] - this.y[i][nextStepNum]);
        }
        this.t[nextStepNum] = this.t[nextStepNum - 1] + this.h;
        this.norm = Math.sqrt(this.norm);
        if (this.h < 0.0) {
            this.s = Math.pow(-this.errorTolerance * this.h / (2.0 * this.norm), 0.025);
            this.h *= this.s;
            if (-this.h > this.hMax) {
                this.h = -this.hMax;
            }
            if (-this.h < this.hMin) {
                this.h = -this.hMin;
            }
        } else {
            this.s = Math.pow(this.errorTolerance * this.h / (2.0 * this.norm), 0.025);
            this.h *= this.s;
            if (this.h > this.hMax) {
                this.h = this.hMax;
            }
            if (this.h < this.hMin) {
                this.h = this.hMin;
            }
        }
    }

    public void solveODE() {
        this.solveODE(this.numPoints);
    }

    public void solveODEWithErrorChecking() {
        this.solveODEWithErrorChecking(this.numPoints);
    }

    public void solveODE(int localNumPoints) {
        int i;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.numPoints];
            this.y = new double[this.dimension][this.numPoints];
        }
        this.t[0] = this.initialT;
        for (i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        for (i = 1; i <= localNumPoints - 1; ++i) {
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][i - 1];
            }
            this.takeNextStep(i, this.tempY);
        }
    }

    public void solveODEWithErrorChecking(int localNumPoints) {
        int stepNum = 1;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.numPoints];
            this.y = new double[this.dimension][this.numPoints];
        }
        this.error = false;
        this.errorStepNum = 0;
        this.t[0] = this.initialT;
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        while (!this.error && stepNum <= localNumPoints - 1) {
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][stepNum - 1];
            }
            this.takeNextStep(stepNum, this.tempY);
            for (int k = 0; k <= this.dimension - 1; ++k) {
                if (!Double.isInfinite(this.y[k][stepNum]) && !Double.isNaN(this.y[k][stepNum])) continue;
                this.error = true;
                this.errorStepNum = stepNum;
            }
        }
    }

    public void solveODEUntil() {
        int numSteps = 0;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.currentCapacity];
            this.y = new double[this.dimension][this.currentCapacity];
        }
        this.t[0] = this.initialT;
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        this.tempY = this.initialY;
        while (!this.constraints.isTimeToStop(numSteps, this.t[numSteps], this.tempY)) {
            if (numSteps >= this.currentCapacity - 1) {
                this.addCapacityToArrays(numSteps + 1);
            }
            this.takeNextStep(++numSteps, this.tempY);
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][numSteps];
            }
        }
        this.numPoints = numSteps + 1;
    }

    public void solveODEUntilWithErrorChecking() {
        int numSteps = 0;
        if (!this.capacityCreated) {
            this.tempY = new double[this.dimension];
            this.t = new double[this.currentCapacity];
            this.y = new double[this.dimension][this.currentCapacity];
        }
        this.error = false;
        this.errorStepNum = 0;
        this.t[0] = this.initialT;
        for (int i = 0; i <= this.dimension - 1; ++i) {
            this.y[i][0] = this.initialY[i];
        }
        this.tempY = this.initialY;
        while (!this.constraints.isTimeToStop(numSteps, this.t[numSteps], this.tempY) && !this.error) {
            if (numSteps >= this.currentCapacity - 1) {
                this.addCapacityToArrays(numSteps + 1);
            }
            this.takeNextStep(++numSteps, this.tempY);
            for (int j = 0; j <= this.dimension - 1; ++j) {
                this.tempY[j] = this.y[j][numSteps];
                if (!Double.isInfinite(this.y[j][numSteps]) && !Double.isNaN(this.y[j][numSteps])) continue;
                this.error = true;
                this.errorStepNum = numSteps;
            }
        }
        this.numPoints = numSteps + 1;
    }

    public double getHMax() {
        return this.hMax;
    }

    public void setHMax(double hMax) {
        this.hMax = hMax;
    }

    public double getHMin() {
        return this.hMin;
    }

    public void setHMin(double hMin) {
        this.hMin = hMin;
    }
}

