/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.multiodesolver;

import com.jimrolf.convert.Convert;
import com.jimrolf.multiodesolver.MultiDerivFuncAbstractClass;
import com.jimrolf.multiodesolver.MultiTimeToStopAbstractClass;

public abstract class MultiODESolver {
    protected boolean capacityIncremented = false;
    protected boolean capacityCreated = false;
    protected double[] tempY = null;
    protected int numPoints = 0;
    protected int dimension = 0;
    protected double[] t = null;
    protected double[][] y = null;
    protected double initialT = 0.0;
    protected double finalT = 0.0;
    protected double[] initialY = null;
    protected double h = 0.0;
    protected MultiDerivFuncAbstractClass func = null;
    protected MultiTimeToStopAbstractClass constraints = null;
    protected int currentCapacity = 100;
    protected int incrementCapacity = 100;
    protected boolean error = false;
    protected int errorStepNum = 0;

    public boolean hasError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public int getErrorStepNum() {
        return this.errorStepNum;
    }

    public void setErrorStepNum(int errorStepNum) {
        this.errorStepNum = errorStepNum;
    }

    public MultiTimeToStopAbstractClass getConstraints() {
        return this.constraints;
    }

    public int getCurrentCapacity() {
        return this.currentCapacity;
    }

    public int getDimension() {
        return this.dimension;
    }

    public double getFinalT() {
        return this.finalT;
    }

    public MultiDerivFuncAbstractClass getFunc() {
        return this.func;
    }

    public int getIncrementCapacity() {
        return this.incrementCapacity;
    }

    public double getInitialT() {
        return this.initialT;
    }

    public double[] getInitialY() {
        return this.initialY;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public double getH() {
        return this.h;
    }

    public double[] getTVals() {
        return this.t;
    }

    public double[][] getYVals() {
        return this.y;
    }

    public double[] getYVals(int i) {
        return this.y[i];
    }

    public double getYVals(int i, int j) {
        return this.y[i][j];
    }

    public boolean isCapacityCreated() {
        return this.capacityCreated;
    }

    public boolean isCapacityIncremented() {
        return this.capacityIncremented;
    }

    public void setConstraints(MultiTimeToStopAbstractClass constraints) {
        this.constraints = constraints;
    }

    public void setCurrentCapacity(int currentCapacity) {
        this.currentCapacity = currentCapacity;
    }

    public void createCapacity(int currentCapacity) {
        this.currentCapacity = currentCapacity;
        this.capacityCreated = true;
        this.tempY = new double[this.dimension];
        this.t = new double[currentCapacity];
        this.y = new double[this.dimension][currentCapacity];
    }

    public void setCapacityCreated(boolean capacityCreated) {
        this.capacityCreated = capacityCreated;
    }

    public void setCapacityIncremented(boolean capacityIncremented) {
        this.capacityIncremented = capacityIncremented;
    }

    public abstract void setDimension(int var1);

    public void setFinalT(double finalT) {
        this.finalT = finalT;
    }

    public void setFunc(MultiDerivFuncAbstractClass func) {
        this.func = func;
    }

    public void setIncrementCapacity(int incrementCapacity) {
        this.incrementCapacity = incrementCapacity;
    }

    public void setInitialT(double initialT) {
        this.initialT = initialT;
    }

    public void setInitialY(double[] initialY) {
        this.initialY = initialY;
    }

    public void setNumPoints(int numPoints) {
        this.numPoints = numPoints;
    }

    public void setH(double h) {
        this.h = h;
    }

    protected void addCapacityToArrays(int localNumPoints) {
        int j;
        int i;
        double[] tempT = null;
        double[][] localTempY = null;
        localTempY = new double[this.dimension][localNumPoints];
        tempT = new double[localNumPoints];
        for (i = 0; i <= localNumPoints - 1; ++i) {
            tempT[i] = this.t[i];
            for (j = 0; j <= this.dimension - 1; ++j) {
                localTempY[j][i] = this.y[j][i];
            }
        }
        this.currentCapacity += this.incrementCapacity;
        this.t = new double[this.currentCapacity];
        this.y = new double[this.dimension][this.currentCapacity];
        for (i = 0; i <= localNumPoints - 1; ++i) {
            this.t[i] = tempT[i];
            for (j = 0; j <= this.dimension - 1; ++j) {
                this.y[j][i] = localTempY[j][i];
            }
        }
    }

    public abstract void solveODE();

    public abstract void solveODEWithErrorChecking();

    public abstract void solveODE(int var1);

    public abstract void solveODEWithErrorChecking(int var1);

    public abstract void solveODEUntil();

    public abstract void solveODEUntilWithErrorChecking();

    public void solveODE(double[] initialY) {
        this.initialY = initialY;
        this.solveODE();
    }

    public void solveODEWithErrorChecking(double[] initialY) {
        this.initialY = initialY;
        this.solveODEWithErrorChecking();
    }

    public void solveODE(double finalT, double h) {
        this.finalT = finalT;
        this.h = h;
        this.numPoints = Convert.toRoundedInt(Math.abs((finalT - this.initialT) / h)) + 1;
        this.solveODE();
    }

    public void solveODEUntil(double[] initialY) {
        this.initialY = initialY;
        this.solveODEUntil();
    }

    public void solveODE(double initialT, double[] initialY, double finalT, double h) {
        this.initialT = initialT;
        this.initialY = initialY;
        this.solveODE(finalT, h);
    }
}

