/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.multiodesolver;

import com.jimrolf.functionfield.FunctionField;
import com.jimrolf.functionparser.FunctionParser;
import com.jimrolf.multiodesolver.MultiDerivFuncAbstractClass;

public class MultiDerivFunc
extends MultiDerivFuncAbstractClass {
    private int dimension = 0;
    private FunctionParser[] funcParsers = null;

    public MultiDerivFunc() {
    }

    public MultiDerivFunc(int dimension) {
        this.dimension = dimension;
        this.funcParsers = new FunctionParser[dimension];
    }

    public MultiDerivFunc(int dimension, FunctionParser[] funcParsers) {
        this.dimension = dimension;
        this.funcParsers = funcParsers;
    }

    public double[] f(double t, double[] y) {
        double[] answer = new double[this.dimension];
        for (int i = 0; i <= this.dimension - 1; ++i) {
            answer[i] = this.funcParsers[i].evalFunc(t, y);
        }
        return answer;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.funcParsers = new FunctionParser[dimension];
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setFuncs(FunctionParser[] funcParsers) {
        this.funcParsers = funcParsers;
    }

    public FunctionParser[] getFuncs() {
        return this.funcParsers;
    }

    public void setFunc(int funcNumber, FunctionParser funcParser) {
        this.funcParsers[funcNumber] = funcParser;
    }

    public void setFunc(int funcNumber, FunctionField funcField) {
        this.funcParsers[funcNumber] = funcField.getParser();
    }

    public FunctionParser getFunc(int funcNumber) {
        return this.funcParsers[funcNumber];
    }
}

