/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.integrator;

import com.jimrolf.convert.Convert;
import com.jimrolf.integrator.Integrator;
import com.jimrolf.integrator.IntegratorFunc;

public class Trapezoid
extends Integrator {
    public Trapezoid() {
    }

    public Trapezoid(IntegratorFunc func, int numPoints) {
        super(func, numPoints);
    }

    public double integrate() {
        return this.integrate(this.a, this.b);
    }

    public void integrateGenerateDataSet() {
        int i;
        this.dataX = new double[this.numPoints];
        this.dataY = new double[this.numPoints];
        double deltaX = (this.b - this.a) / Convert.toDouble(this.numPoints - 1);
        double deltaXOver2 = deltaX / 2.0;
        double yval1 = 0.0;
        double yval2 = 0.0;
        this.dataX[0] = this.a;
        this.dataY[0] = 0.0;
        yval1 = this.func.f(this.a);
        for (i = 1; i <= this.numPoints - 2; ++i) {
            this.dataX[i] = this.a + (double)i * deltaX;
            yval2 = this.func.f(this.dataX[i]);
            this.dataY[i] = this.dataY[i - 1] + (yval1 + yval2);
            yval1 = yval2;
        }
        this.dataX[this.numPoints - 1] = this.b;
        yval2 = this.func.f(this.b);
        this.dataY[this.numPoints - 1] = this.dataY[this.numPoints - 2] + yval1 + yval2;
        for (i = 1; i <= this.numPoints - 1; ++i) {
            this.dataY[i] = this.dataY[i] * deltaXOver2;
        }
    }

    public void integrateBackwardsGenerateDataSet() {
        int i;
        double deltaX = (this.b - this.a) / Convert.toDouble(this.numPoints - 1);
        double deltaXOver2 = deltaX / 2.0;
        double yval1 = 0.0;
        double yval2 = 0.0;
        this.dataX[0] = this.b;
        this.dataY[0] = 0.0;
        yval1 = this.func.f(this.b);
        for (i = 1; i <= this.numPoints - 2; ++i) {
            this.dataX[i] = this.b - (double)i * deltaX;
            yval2 = this.func.f(this.dataX[i]);
            this.dataY[i] = this.dataY[i - 1] + (yval1 + yval2);
            yval1 = yval2;
        }
        this.dataX[this.numPoints - 1] = this.a;
        yval2 = this.func.f(this.a);
        this.dataY[this.numPoints - 1] = this.dataY[this.numPoints - 2] + yval1 + yval2;
        for (i = 1; i <= this.numPoints - 1; ++i) {
            this.dataY[i] = -this.dataY[i] * deltaXOver2;
        }
    }

    public double integrateWithNumPoints() {
        double deltaX = (this.b - this.a) / Convert.toDouble(this.numPoints - 1);
        double val = 0.0;
        for (int i = 1; i <= this.numPoints - 1; ++i) {
            val += this.integrate(this.a + (double)(i - 1) * deltaX, this.a + (double)i * deltaX);
        }
        return val;
    }

    protected double integrate(double a, double b) {
        double deltaX = (b - a) / Convert.toDouble(this.numPoints - 1);
        double val = this.func.f(a) / 2.0;
        for (int i = 0; i < this.numPoints - 1; ++i) {
            val += this.func.f(a + (double)i * deltaX);
        }
        val += this.func.f(b) / 2.0;
        return val *= deltaX;
    }

    public double integrateBackwards() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

