/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.integrator;

import com.jimrolf.functionfield.FunctionField;
import com.jimrolf.functionparser.FunctionParser;
import com.jimrolf.integrator.IntegratorFuncAbstractClass;

public class IntegratorFunc
extends IntegratorFuncAbstractClass {
    private FunctionParser funcParser;
    private String funcInput;
    private String funcVariable;
    private boolean funcHasError = false;
    private String errorInfo;

    public double f(double x) {
        return this.funcParser.evalFunc(x);
    }

    public IntegratorFunc() {
    }

    public IntegratorFunc(String funcInput, String funcVariable) {
        this.funcParser = new FunctionParser();
        this.funcVariable = funcVariable;
        this.funcParser.setVariable(funcVariable);
        this.funcInput = funcInput;
        this.funcParser.parseExpression(funcInput);
        if (this.funcParser.funcHasError()) {
            this.funcHasError = true;
            this.errorInfo = this.funcParser.getFuncErrorInfo();
        }
    }

    public IntegratorFunc(FunctionParser funcParser, String funcInput, String funcVariable) {
        this.funcParser = funcParser;
        this.funcVariable = funcVariable;
        funcParser.setVariable(funcVariable);
        this.funcInput = funcInput;
        funcParser.parseExpression(funcInput);
        if (funcParser.funcHasError()) {
            this.funcHasError = true;
            this.errorInfo = funcParser.getFuncErrorInfo();
        }
    }

    public IntegratorFunc(FunctionField funcField) {
        if (funcField.hasError()) {
            this.funcHasError = true;
            this.errorInfo = funcField.getErrorInfo();
        }
        this.funcParser = funcField.getParser();
    }

    public FunctionParser getFuncParser() {
        return this.funcParser;
    }

    public void setFuncParser(FunctionParser funcParser) {
        this.funcParser = funcParser;
    }

    public String getFuncInput() {
        return this.funcInput;
    }

    public void setFuncInput(String funcInput) {
        this.funcInput = funcInput;
        this.funcParser.parseExpression(funcInput);
        if (this.funcParser.funcHasError()) {
            this.funcHasError = true;
            this.errorInfo = this.funcParser.getFuncErrorInfo();
        }
    }

    public String getFuncVariable() {
        return this.funcVariable;
    }

    public void setFuncVariable(String funcVariable) {
        this.funcVariable = funcVariable;
        this.funcParser.setVariable(funcVariable);
    }

    public boolean isFuncHasError() {
        return this.funcHasError;
    }

    public void setFuncHasError(boolean funcHasError) {
        this.funcHasError = funcHasError;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }
}

