/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.integrator;

import com.jimrolf.integrator.IntegratorFuncAbstractClass;

public abstract class Integrator {
    protected double a;
    protected double b;
    protected int numPoints;
    protected double[] dataX;
    protected double[] dataY;
    protected IntegratorFuncAbstractClass func;
    protected boolean error = false;
    protected String errorInfo = null;

    public Integrator() {
    }

    public Integrator(IntegratorFuncAbstractClass func, int numPoints) {
        this.func = func;
        this.numPoints = numPoints;
        this.dataX = new double[numPoints];
        this.dataY = new double[numPoints];
    }

    protected abstract double integrate(double var1, double var3);

    public abstract double integrate();

    public abstract double integrateBackwards();

    public abstract void integrateGenerateDataSet();

    public abstract void integrateBackwardsGenerateDataSet();

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double[] getDataX() {
        return this.dataX;
    }

    public double getDataX(int index) {
        return this.dataX[index];
    }

    public double[] getDataY() {
        return this.dataY;
    }

    public double getDataY(int index) {
        return this.dataY[index];
    }

    public IntegratorFuncAbstractClass getFunc() {
        return this.func;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public void setA(double a) {
        this.a = a;
    }

    public void setB(double b) {
        this.b = b;
    }

    public void setAB(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public void setDataX(double[] dataX) {
        this.dataX = dataX;
    }

    public void setDataX(int index, double dataX) {
        this.dataX[index] = dataX;
    }

    public void setDataY(double[] dataY) {
        this.dataY = dataY;
    }

    public void setDataY(int index, double dataY) {
        this.dataY[index] = dataY;
    }

    public void setFunc(IntegratorFuncAbstractClass func) {
        this.func = func;
    }

    public void setNumPoints(int numPoints) {
        this.numPoints = numPoints;
    }

    public boolean hasError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }
}

