/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.integrator;

import com.jimrolf.convert.Convert;
import com.jimrolf.integrator.Integrator;
import com.jimrolf.integrator.IntegratorFunc;

public class GaussLegendreQuadrature
extends Integrator {
    private int numNodes;
    private double[] nodes;
    private double[] weights;

    public GaussLegendreQuadrature() {
    }

    public GaussLegendreQuadrature(IntegratorFunc func, int numPoints) {
        super(func, numPoints);
    }

    public void integrateGenerateDataSet() {
        this.dataX = new double[this.numPoints];
        this.dataY = new double[this.numPoints];
        double deltaX = (this.b - this.a) / Convert.toDouble(this.numPoints - 1);
        this.dataX[0] = this.a;
        this.dataY[0] = 0.0;
        for (int i = 1; i <= this.numPoints - 1; ++i) {
            this.dataX[i] = this.a + (double)i * deltaX;
            this.findNodesandWeights(this.dataX[i - 1], this.dataX[i]);
            this.dataY[i] = this.dataY[i - 1] + this.integrate(this.dataX[i - 1], this.dataX[i]);
        }
    }

    public void integrateBackwardsGenerateDataSet() {
        this.dataX = new double[this.numPoints];
        this.dataY = new double[this.numPoints];
        double deltaX = (this.b - this.a) / Convert.toDouble(this.numPoints - 1);
        this.dataX[0] = this.b;
        this.dataY[0] = 0.0;
        for (int i = 1; i <= this.numPoints - 1; ++i) {
            this.dataX[i] = this.b - (double)i * deltaX;
            this.findNodesandWeights(this.dataX[i - 1], this.dataX[i]);
            this.dataY[i] = this.dataY[i - 1] + this.integrate(this.dataX[i], this.dataX[i - 1]);
        }
    }

    public double integrate() {
        return this.integrate(this.a, this.b);
    }

    public double integrateWithNumPoints() {
        double deltaX = (this.b - this.a) / Convert.toDouble(this.numPoints - 1);
        double val = 0.0;
        for (int i = 1; i <= this.numPoints - 1; ++i) {
            this.findNodesandWeights(this.a + (double)(i - 1) * deltaX, this.a + (double)i * deltaX);
            val += this.integrate();
        }
        return val;
    }

    protected double integrate(double a, double b) {
        double val = 0.0;
        for (int i = 0; i <= this.numNodes - 1; ++i) {
            val += this.weights[i] * this.func.f(this.nodes[i]);
        }
        return val;
    }

    public double integrateBackwards() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void findNodesAndWeights() {
        this.findNodesandWeights(this.a, this.b);
    }

    private void findNodesandWeights(double a, double b) {
        double eps = 3.0E-14;
        int m = (this.numNodes + 1) / 2;
        double xAvg = 0.5 * (a + b);
        double xHalf = 0.5 * (b - a);
        double z = 0.0;
        double z1 = 0.0;
        double p1 = 0.0;
        double p2 = 0.0;
        double p3 = 0.0;
        double pp = 0.0;
        for (int i = 1; i <= m; ++i) {
            z = Math.cos(Math.PI * ((double)i - 0.25) / ((double)this.numNodes + 0.5));
            do {
                p1 = 1.0;
                p2 = 0.0;
                for (int j = 1; j <= this.numNodes; ++j) {
                    p3 = p2;
                    p2 = p1;
                    p1 = ((2.0 * (double)j - 1.0) * z * p2 - ((double)j - 1.0) * p3) / (double)j;
                }
            } while (Math.abs((z = (z1 = z) - p1 / (pp = (double)this.numNodes * (z * p1 - p2) / (z * z - 1.0))) - z1) > eps);
            this.nodes[i - 1] = xAvg - xHalf * z;
            this.nodes[this.numNodes - i] = xAvg + xHalf * z;
            this.weights[i - 1] = 2.0 * xHalf / ((1.0 - z * z) * pp * pp);
            this.weights[this.numNodes - i] = this.weights[i - 1];
        }
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
        this.nodes = new double[numNodes];
        this.weights = new double[numNodes];
    }

    public double getNodes(int index) {
        return this.nodes[index];
    }

    public double[] getNodes() {
        return this.nodes;
    }

    public void setNodes(int index, double nodes) {
        this.nodes[index] = nodes;
    }

    public void setNodes(double[] nodes) {
        this.nodes = nodes;
    }

    public double getWeights(int index) {
        return this.weights[index];
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(int index, double weights) {
        this.weights[index] = weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }
}

