/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.integrator;

import com.jimrolf.integrator.Integrator;
import com.jimrolf.integrator.IntegratorFunc;

public class AdaptiveSimpson
extends Integrator {
    private double locationAError = 0.0;
    private double locationBError = 0.0;
    private double locationCError = 0.0;
    private double tempLocationBError = 0.0;
    protected double errorLocation = 0.0;
    private double epsilon = 1.0E-12;
    private int maxIter = 50;
    private int numIter = 0;
    private double integralValue = 0.0;

    public double getErrorLocation() {
        return this.errorLocation;
    }

    public void setErrorLocation(double errorLocation) {
        this.errorLocation = errorLocation;
    }

    public AdaptiveSimpson() {
    }

    public AdaptiveSimpson(IntegratorFunc func, int numPoints) {
        super(func, numPoints);
    }

    protected double integrate(double a, double b) {
        double h = (b - a) / 2.0;
        double c = (a + b) / 2.0;
        double fa = this.func.f(a);
        double fb = this.func.f(b);
        double fc = this.func.f(c);
        double simpSum = (fa + 4.0 * fc + fb) * h / 3.0;
        this.locationAError = a;
        this.locationBError = b;
        this.locationCError = c;
        this.integralValue = 0.0;
        this.numIter = 0;
        if (this.integrateOverTwoSubIntervals(a, h, fa, fc, fb, simpSum, a, b)) {
            simpSum = this.integralValue;
        } else {
            this.error = true;
            simpSum = 0.0;
        }
        return simpSum;
    }

    private boolean integrateOverTwoSubIntervals(double a, double h, double fa, double fc, double fb, double simpSum, double originalA, double originalB) {
        boolean noProblems = true;
        double y = 0.0;
        double z = 0.0;
        double simpSum1 = 0.0;
        double simpSum2 = 0.0;
        if (Double.isInfinite(fa) || Double.isNaN(fa)) {
            noProblems = false;
            this.error = true;
            this.errorInfo = "Singularity likely encountered";
            this.errorLocation = this.locationAError;
        } else if (Double.isInfinite(fb) || Double.isNaN(fb)) {
            noProblems = false;
            this.error = true;
            this.errorInfo = "Singularity likely encountered";
            this.errorLocation = this.locationBError;
        } else if (Double.isInfinite(fc) || Double.isNaN(fc)) {
            noProblems = false;
            this.error = true;
            this.errorInfo = "Singularity likely encountered";
            this.errorLocation = this.locationCError;
        } else if (this.numIter <= this.maxIter - 1 && this.numIter >= 0) {
            y = this.func.f(a + (h /= 2.0));
            if (Math.abs((simpSum1 = (fa + 4.0 * y + fc) * h / 3.0) + (simpSum2 = (fc + 4.0 * (z = this.func.f(a + 3.0 * h)) + fb) * h / 3.0) - simpSum) < 30.0 * this.epsilon * h / (originalB - originalA)) {
                this.integralValue += simpSum1 + simpSum2 + (simpSum1 + simpSum2 - simpSum) / 15.0;
                --this.numIter;
            } else {
                ++this.numIter;
                this.locationAError = a;
                this.locationBError = this.locationCError;
                this.locationCError = a + h;
                if (this.integrateOverTwoSubIntervals(a, h, fa, y, fc, simpSum1, originalA, originalB)) {
                    this.locationAError = a * 2.0 * h;
                    this.locationBError = this.tempLocationBError;
                    this.locationCError = a + 3.0 * h;
                    if (!this.integrateOverTwoSubIntervals(a + 2.0 * h, h, fc, z, fb, simpSum2, originalA, originalB)) {
                        noProblems = false;
                    }
                } else {
                    noProblems = false;
                }
            }
        } else if (this.numIter > this.maxIter) {
            this.errorInfo = "Exceeded maxIter";
            noProblems = false;
        }
        return noProblems;
    }

    public double integrate() {
        return this.integrate(this.a, this.b);
    }

    public void integrateGenerateDataSet() {
        this.dataX = new double[this.numPoints];
        this.dataY = new double[this.numPoints];
        double deltaX = (this.b - this.a) / (double)(this.numPoints - 1);
        double h = deltaX / 2.0;
        double c = 0.0;
        double fa = 0.0;
        double fb = 0.0;
        double fc = 0.0;
        double simpSum = (fa + 4.0 * fc + fb) * h / 3.0;
        this.dataX[0] = this.a;
        this.dataY[0] = 0.0;
        fb = this.func.f(this.dataX[0]);
        for (int i = 1; i <= this.numPoints - 1; ++i) {
            this.integralValue = 0.0;
            this.numIter = 0;
            this.dataX[i] = this.a + (double)i * deltaX;
            fa = fb;
            fb = this.func.f(this.dataX[i]);
            fc = this.func.f(this.dataX[i - 1] + h);
            if (this.integrateOverTwoSubIntervals(this.dataX[i - 1], h, fa, fc, fb, simpSum = (fa + 4.0 * fc + fb) * h / 3.0, this.dataX[i - 1], this.dataX[i])) {
                this.dataY[i] = this.dataY[i - 1] + this.integralValue;
                continue;
            }
            this.error = true;
            this.dataY[i] = 0.0;
        }
    }

    public void integrateBackwardsGenerateDataSet() {
        this.dataX = new double[this.numPoints];
        this.dataY = new double[this.numPoints];
    }

    public double integrateWithNumPoints() {
        return 0.0;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    public int getNumIter() {
        return this.numIter;
    }

    public void setNumIter(int numIter) {
        this.numIter = numIter;
    }

    public double getIntegralValue() {
        return this.integralValue;
    }

    public void setIntegralValue(double integralValue) {
        this.integralValue = integralValue;
    }

    public double integrateBackwards() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

