/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.functionfield;

import com.jimrolf.functionparser.FunctionParser;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DoubleField
extends JTextField {
    private DecimalFormat outNumber = new DecimalFormat();
    private String pattern = "0.000000000000000";
    private FunctionParser inputParser;
    private Color errorColor;
    private String errorInfo;
    private double doubleVal;
    private int numDecimalPlaces = 8;
    protected Color backgroundColor = new Color(235, 235, 235);

    public DoubleField() {
        this.inputParser = new FunctionParser();
        this.errorColor = Color.yellow;
        this.setBackground(this.backgroundColor);
        this.setFont(new Font("Lucida Sans", 0, 11));
        this.setBorder(BorderFactory.createBevelBorder(1));
        super.setText("0.0");
        this.outNumber.applyPattern(this.pattern);
        this.outNumber.setMinimumIntegerDigits(1);
        this.outNumber.setMinimumFractionDigits(1);
        this.outNumber.setMaximumFractionDigits(this.numDecimalPlaces);
    }

    public FunctionParser getInputParser() {
        return this.inputParser;
    }

    public void setInputParser(FunctionParser inputParser) {
        this.inputParser = inputParser;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void highlightError() {
        this.setBackground(this.errorColor);
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public boolean hasError() {
        boolean hasProblems = false;
        this.inputParser.parseExpression(this.getText());
        if (this.inputParser.funcHasError() || Double.isNaN(this.inputParser.evalFunc(0.0)) || Double.isInfinite(this.inputParser.evalFunc(0.0))) {
            this.setBackground(this.errorColor);
            this.errorInfo = "Error with constant.";
            hasProblems = true;
        } else {
            this.doubleVal = this.inputParser.evalFunc(0.0);
        }
        return hasProblems;
    }

    public boolean hasError(JLabel errorLabel) {
        boolean hasProblems = false;
        this.inputParser.parseExpression(this.getText());
        if (this.inputParser.funcHasError() || Double.isNaN(this.inputParser.evalFunc(0.0)) || Double.isInfinite(this.inputParser.evalFunc(0.0))) {
            this.setBackground(this.errorColor);
            this.errorInfo = "Error with constant.";
            errorLabel.setText(this.errorInfo);
            hasProblems = true;
        } else {
            this.doubleVal = this.inputParser.evalFunc(0.0);
        }
        return hasProblems;
    }

    public double getDoubleVal() {
        return this.doubleVal;
    }

    public void setDoubleVal(double doubleVal) {
        this.doubleVal = doubleVal;
    }

    public void setText(String input) {
        super.setText(input);
        this.moveCaretPosition(0);
    }

    public void setDoubleText(double x) {
        super.setText("" + this.outNumber.format(x));
        this.moveCaretPosition(0);
        this.doubleVal = x;
    }

    public int getNumDecimalPlaces() {
        return this.numDecimalPlaces;
    }

    public void setNumDecimalPlaces(int numDecimalPlaces) {
        this.numDecimalPlaces = numDecimalPlaces;
        this.outNumber.setMaximumFractionDigits(numDecimalPlaces);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setBackground(backgroundColor);
    }
}

