/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.datagrapher2d;

import com.jimrolf.convert.Convert;
import com.jimrolf.grapher2d.Grapher2D;
import com.jimrolf.myclasses.MachineEpsilon;
import com.jimrolf.plotstuff2d.Crosses2D;
import com.jimrolf.plotstuff2d.PlotStuff;
import com.jimrolf.plotstuff2d.PlotStuff2D;
import com.jimrolf.plotstuff2d.PolarGrid;
import com.jimrolf.plotstuff2d.RectGrid;
import com.jimrolf.plotstuff2d.SlopeField2D;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class DataGrapher2D
extends Grapher2D {
    private double epsilon = MachineEpsilon.getEpsilon();
    private int[] triangleX = new int[3];
    private int[] triangleY = new int[3];
    private Polygon trianglePlot = new Polygon(this.triangleX, this.triangleY, 3);
    private int[] areaX = new int[4];
    private int[] areaY = new int[4];
    private Polygon areaPlot = new Polygon(this.areaX, this.areaY, 4);
    private double directLength = 0.0;
    private double directScaleFactor = 0.75;
    private double slope = 0.0;
    private double directDeltaX = 0.0;
    private double directXVal = 0.0;
    private double directYVal = 0.0;
    private int newX1 = 0;
    private int newX2 = 0;
    private int newY1 = 0;
    private int newY2 = 0;

    protected void createBackgroundImage() {
    }

    protected void plotLine(int localNumPoints, int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        int startI;
        int graphX1 = 0;
        int graphY1 = 0;
        int graphX2 = 0;
        int graphY2 = 0;
        g2d.setStroke(new BasicStroke(size, 1, 2));
        for (startI = 0; startI <= localNumPoints - 1 && (Double.isNaN(dataX[startI]) || Double.isNaN(dataY[startI])); ++startI) {
        }
        if (startI <= localNumPoints - 1) {
            graphX1 = this.getXPixel(dataX[startI]);
            graphY1 = this.getYPixel(dataY[startI]);
        }
        for (int i = startI + 1; i <= localNumPoints - 1; ++i) {
            if (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i])) {
                graphX2 = graphX1;
                graphY2 = graphY1;
                g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
                while (i <= localNumPoints - 1 && (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i]))) {
                    ++i;
                }
                if (i > localNumPoints - 1) continue;
                graphX1 = this.getXPixel(dataX[i]);
                graphY1 = this.getYPixel(dataY[i]);
                continue;
            }
            graphX2 = this.getXPixel(dataX[i]);
            graphY2 = this.getYPixel(dataY[i]);
            g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
            graphX1 = graphX2;
            graphY1 = graphY2;
        }
    }

    protected void plotData(PlotStuff trace, Graphics2D g2d) {
        switch (trace.getPlotStyle()) {
            case 0: {
                this.plotLine(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 1: {
                this.plotPoints(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 2: {
                this.plotArrows(trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 3: {
                this.plotLine(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                this.plotPoints(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 5: {
                this.plotRectangle(trace.getNumPoints(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 6: {
                this.plotRectangle(trace.getNumPoints(), trace.getDataX(), trace.getDataY(), g2d);
                this.plotLine(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 7: {
                this.plotRectNoShade(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 8: {
                this.plotTrap(trace.getNumPoints(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 9: {
                this.plotTrapNoShade(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 4: {
                this.plotSlopes(((SlopeField2D)trace).getNumXGridPoints(), ((SlopeField2D)trace).getNumYGridPoints(), ((SlopeField2D)trace).getPlotSize(), (SlopeField2D)trace, g2d);
                break;
            }
            case 10: {
                this.plotPolarGridData((PolarGrid)trace, g2d);
                break;
            }
            case 11: {
                this.plotRectGridData((RectGrid)trace, g2d);
                break;
            }
            case 12: {
                this.plotCrosses(trace.getNumPoints(), trace.getPlotSize(), ((Crosses2D)trace).getCrossSize(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 13: {
                this.plotHashMarks(trace.getNumPoints(), ((PlotStuff2D)trace).getHashMarkWidth(), ((PlotStuff2D)trace).getHashMarkHeight(), trace.getDataX(), trace.getDataY(), g2d);
                break;
            }
            case 15: {
                trace.plotData(this, g2d);
            }
        }
    }

    protected void plotSlopes(int localNumXGridPoints, int localNumYGridPoints, int size, SlopeField2D trace, Graphics2D g2d) {
        g2d.setStroke(new BasicStroke(trace.getPlotSize()));
        this.directLength = 1.0 * (double)this.xAxisLength / (double)localNumXGridPoints < 1.0 * (double)this.yAxisLength / (double)localNumYGridPoints ? 1.0 * this.directScaleFactor * (double)this.xAxisLength / (double)localNumXGridPoints : 1.0 * this.directScaleFactor * (double)this.yAxisLength / (double)localNumYGridPoints;
        for (int i = 0; i <= localNumXGridPoints - 1; ++i) {
            for (int j = 0; j <= localNumYGridPoints - 1; ++j) {
                this.slope = 1.0 * (double)(this.getYPixel(trace.getSlopeY(i, j) / trace.getSlopeX(i, j)) - this.getYPixel(0.0)) / (double)(this.getXPixel(1.0) - this.getXPixel(0.0));
                this.directDeltaX = Math.sqrt(this.directLength * this.directLength / (4.0 + 4.0 * this.slope * this.slope));
                if (Double.isNaN(this.slope) || Double.isInfinite(this.slope) || this.directDeltaX < 0.5) {
                    this.directXVal = this.getXPixel(trace.getDataX(i));
                    this.directYVal = this.getYPixel(trace.getDataY(j));
                    this.newX1 = Convert.toRoundedInt(this.directXVal);
                    this.newY1 = Convert.toRoundedInt(this.directYVal + this.directLength / 2.0);
                    this.newX2 = Convert.toRoundedInt(this.directXVal);
                    this.newY2 = Convert.toRoundedInt(this.directYVal - this.directLength / 2.0);
                    g2d.drawLine(this.newX1, this.newY1, this.newX2, this.newY2);
                    continue;
                }
                this.directDeltaX = Math.sqrt(this.directLength * this.directLength / (4.0 + 4.0 * this.slope * this.slope));
                this.directXVal = this.getXPixel(trace.getDataX(i));
                this.directYVal = this.getYPixel(trace.getDataY(j));
                this.newX2 = Convert.toRoundedInt(this.directXVal + this.directDeltaX);
                this.newY2 = Convert.toRoundedInt(this.directYVal + this.slope * ((double)this.newX2 - this.directXVal));
                this.newX1 = Convert.toRoundedInt(this.directXVal - this.directDeltaX);
                this.newY1 = Convert.toRoundedInt(this.directYVal + this.slope * ((double)this.newX1 - this.directXVal));
                g2d.drawLine(this.newX1, this.newY1, this.newX2, this.newY2);
            }
        }
    }

    protected void plotArrows(int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        int graphX1 = 0;
        int graphY1 = 0;
        int graphX2 = 0;
        int graphY2 = 0;
        double xa = 0.0;
        double ya = 0.0;
        double m = 0.0;
        double arrowHeadDeltaX = 0.0;
        double headWidthRatio = 1.5;
        double headHeight = ((double)size + 4.0) * (this.yMax - this.yMin) / (double)this.yAxisLength;
        g2d.setStroke(new BasicStroke(size, 0, 0));
        graphX1 = this.getXPixel(dataX[0]);
        graphY1 = this.getYPixel(dataY[0]);
        if (Math.abs(dataX[1] - dataX[0]) <= this.epsilon) {
            arrowHeadDeltaX = headHeight / headWidthRatio;
            ya = dataY[1] > dataY[0] ? dataY[1] - headHeight : dataY[1] + headHeight;
            this.trianglePlot.xpoints[0] = this.getXPixel(dataX[1] - arrowHeadDeltaX);
            this.trianglePlot.ypoints[0] = this.getYPixel(ya);
            this.trianglePlot.xpoints[1] = this.getXPixel(dataX[1] + arrowHeadDeltaX);
            this.trianglePlot.ypoints[1] = this.trianglePlot.ypoints[0];
            this.trianglePlot.xpoints[2] = this.getXPixel(dataX[1]);
            this.trianglePlot.ypoints[2] = this.getYPixel(dataY[1]);
            graphX2 = this.trianglePlot.xpoints[2];
            graphY2 = this.trianglePlot.ypoints[0];
        } else {
            m = (dataY[1] - dataY[0]) / (dataX[1] - dataX[0]);
            if (m > 0.0) {
                arrowHeadDeltaX = headHeight / headWidthRatio * Math.abs(m) / Math.sqrt(1.0 + m * m);
                xa = dataX[1] > dataX[0] ? dataX[1] - headHeight / Math.sqrt(1.0 + m * m) : dataX[1] + headHeight / Math.sqrt(1.0 + m * m);
                ya = m * (xa - dataX[1]) + dataY[1];
                this.trianglePlot.xpoints[0] = this.getXPixel(xa + arrowHeadDeltaX);
                this.trianglePlot.ypoints[0] = this.getYPixel(-arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[1] = this.getXPixel(xa - arrowHeadDeltaX);
                this.trianglePlot.ypoints[1] = this.getYPixel(arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[2] = this.getXPixel(dataX[1]);
                this.trianglePlot.ypoints[2] = this.getYPixel(dataY[1]);
                graphX2 = this.getXPixel(xa);
                graphY2 = this.getYPixel(ya);
            } else if (m < 0.0) {
                arrowHeadDeltaX = headHeight / headWidthRatio * Math.abs(m) / Math.sqrt(1.0 + m * m);
                xa = dataX[1] > dataX[0] ? dataX[1] - headHeight / Math.sqrt(1.0 + m * m) : dataX[1] + headHeight / Math.sqrt(1.0 + m * m);
                ya = m * (xa - dataX[1]) + dataY[1];
                this.trianglePlot.xpoints[0] = this.getXPixel(xa - arrowHeadDeltaX);
                this.trianglePlot.ypoints[0] = this.getYPixel(arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[1] = this.getXPixel(xa + arrowHeadDeltaX);
                this.trianglePlot.ypoints[1] = this.getYPixel(-arrowHeadDeltaX / m + ya);
                this.trianglePlot.xpoints[2] = this.getXPixel(dataX[1]);
                this.trianglePlot.ypoints[2] = this.getYPixel(dataY[1]);
                graphX2 = this.getXPixel(xa);
                graphY2 = this.getYPixel(ya);
            } else {
                arrowHeadDeltaX = headHeight / headWidthRatio;
                xa = dataX[1] > dataX[0] ? dataX[1] - arrowHeadDeltaX : dataX[1] + arrowHeadDeltaX;
                this.trianglePlot.xpoints[0] = this.getXPixel(xa);
                this.trianglePlot.ypoints[0] = this.getYPixel(dataY[1] - arrowHeadDeltaX);
                this.trianglePlot.xpoints[1] = this.getXPixel(xa);
                this.trianglePlot.ypoints[1] = this.getYPixel(dataY[1] + arrowHeadDeltaX);
                this.trianglePlot.xpoints[2] = this.getXPixel(dataX[1]);
                this.trianglePlot.ypoints[2] = this.getYPixel(dataY[1]);
                graphX2 = this.trianglePlot.xpoints[0];
                graphY2 = this.trianglePlot.ypoints[2];
            }
        }
        g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
        g2d.fillPolygon(this.trianglePlot);
    }

    protected void plotRectangle(int localNumPoints, double[] dataX, double[] dataY, Graphics2D g2d) {
        boolean gotTwoGoodPoints = false;
        for (int startI = 0; startI <= localNumPoints - 1 && (Double.isNaN(dataX[startI]) || Double.isNaN(dataY[startI])); ++startI) {
        }
        for (int i = startI + 1; i <= localNumPoints - 1; ++i) {
            if (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i])) {
                while (i <= localNumPoints - 1 && (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i]))) {
                    ++i;
                }
                gotTwoGoodPoints = false;
                continue;
            }
            this.areaPlot.xpoints[0] = this.getXPixel(dataX[i - 1]);
            this.areaPlot.ypoints[0] = this.getYPixel(dataY[i - 1]);
            this.areaPlot.xpoints[1] = this.getXPixel(dataX[i]);
            this.areaPlot.ypoints[1] = this.areaPlot.ypoints[0];
            this.areaPlot.xpoints[2] = this.areaPlot.xpoints[1];
            this.areaPlot.ypoints[2] = this.originY;
            this.areaPlot.xpoints[3] = this.areaPlot.xpoints[0];
            this.areaPlot.ypoints[3] = this.originY;
            g2d.fillPolygon(this.areaPlot);
        }
    }

    protected void plotRectNoShade(int localNumPoints, int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        boolean gotTwoGoodPoints = false;
        g2d.setStroke(new BasicStroke(size));
        for (int startI = 0; startI <= localNumPoints - 1 && (Double.isNaN(dataX[startI]) || Double.isNaN(dataY[startI])); ++startI) {
        }
        for (int i = startI + 1; i <= localNumPoints - 1; ++i) {
            if (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i])) {
                while (i <= localNumPoints - 1 && (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i]))) {
                    ++i;
                }
                gotTwoGoodPoints = false;
                continue;
            }
            this.areaPlot.xpoints[0] = this.getXPixel(dataX[i - 1]);
            this.areaPlot.ypoints[0] = this.getYPixel(dataY[i - 1]);
            this.areaPlot.xpoints[1] = this.getXPixel(dataX[i]);
            this.areaPlot.ypoints[1] = this.areaPlot.ypoints[0];
            this.areaPlot.xpoints[2] = this.areaPlot.xpoints[1];
            this.areaPlot.ypoints[2] = this.originY;
            this.areaPlot.xpoints[3] = this.areaPlot.xpoints[0];
            this.areaPlot.ypoints[3] = this.originY;
            g2d.drawPolygon(this.areaPlot);
        }
    }

    protected void plotTrap(int localNumPoints, double[] dataX, double[] dataY, Graphics2D g2d) {
        boolean gotTwoGoodPoints = false;
        for (int startI = 0; startI <= localNumPoints - 1 && (Double.isNaN(dataX[startI]) || Double.isNaN(dataY[startI])); ++startI) {
        }
        for (int i = startI + 1; i <= localNumPoints - 1; ++i) {
            if (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i])) {
                while (i <= localNumPoints - 1 && (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i]))) {
                    ++i;
                }
                gotTwoGoodPoints = false;
                continue;
            }
            this.areaPlot.xpoints[0] = this.getXPixel(dataX[i - 1]);
            this.areaPlot.ypoints[0] = this.getYPixel(dataY[i - 1]);
            this.areaPlot.xpoints[1] = this.getXPixel(dataX[i]);
            this.areaPlot.ypoints[1] = this.getYPixel(dataY[i]);
            this.areaPlot.xpoints[2] = this.areaPlot.xpoints[1];
            this.areaPlot.ypoints[2] = this.originY;
            this.areaPlot.xpoints[3] = this.areaPlot.xpoints[0];
            this.areaPlot.ypoints[3] = this.originY;
            g2d.fillPolygon(this.areaPlot);
        }
    }

    protected void plotTrapNoShade(int localNumPoints, int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        boolean gotTwoGoodPoints = false;
        g2d.setStroke(new BasicStroke(size));
        for (int startI = 0; startI <= localNumPoints - 1 && (Double.isNaN(dataX[startI]) || Double.isNaN(dataY[startI])); ++startI) {
        }
        for (int i = startI + 1; i <= localNumPoints - 1; ++i) {
            if (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i])) {
                while (i <= localNumPoints - 1 && (Double.isNaN(dataX[i]) || Double.isNaN(dataY[i]))) {
                    ++i;
                }
                gotTwoGoodPoints = false;
                continue;
            }
            this.areaPlot.xpoints[0] = this.getXPixel(dataX[i - 1]);
            this.areaPlot.ypoints[0] = this.getYPixel(dataY[i - 1]);
            this.areaPlot.xpoints[1] = this.getXPixel(dataX[i]);
            this.areaPlot.ypoints[1] = this.getYPixel(dataY[i]);
            this.areaPlot.xpoints[2] = this.areaPlot.xpoints[1];
            this.areaPlot.ypoints[2] = this.originY;
            this.areaPlot.xpoints[3] = this.areaPlot.xpoints[0];
            this.areaPlot.ypoints[3] = this.originY;
            g2d.drawPolygon(this.areaPlot);
        }
    }

    protected void plotPolarGridData(PolarGrid trace, Graphics2D g2d) {
        int j;
        int localNumCircles = trace.getNumCircles();
        int localNumTotalRays = trace.getNumTotalRays();
        for (j = 0; j <= localNumTotalRays - 1; ++j) {
            g2d.setColor(trace.getRays(j).getPlotColor());
            this.plotLine(trace.getNumRayPoints(), trace.getPlotSize(), trace.getRays(j).getDataX(), trace.getRays(j).getDataY(), g2d);
        }
        for (j = 0; j <= localNumCircles - 1; ++j) {
            g2d.setColor(trace.getCircles(j).getPlotColor());
            this.plotLine(trace.getNumCirclePoints(), trace.getPlotSize(), trace.getCircles(j).getDataX(), trace.getCircles(j).getDataY(), g2d);
        }
    }

    protected void plotPoints(int localNumPoints, int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        for (int i = 0; i <= localNumPoints - 1; ++i) {
            g2d.fillOval(this.getXPixel(dataX[i]) - size, this.getYPixel(dataY[i]) - size, 2 * size + 1, 2 * size + 1);
        }
    }

    protected void plotCrosses(int localNumPoints, int lineWidth, int crossSize, double[] dataX, double[] dataY, Graphics2D g2d) {
        g2d.setStroke(new BasicStroke(lineWidth, 1, 2));
        for (int i = 0; i <= localNumPoints - 1; ++i) {
            g2d.drawLine(this.getXPixel(dataX[i]) - crossSize, this.getYPixel(dataY[i]), this.getXPixel(dataX[i]) + crossSize, this.getYPixel(dataY[i]));
            g2d.drawLine(this.getXPixel(dataX[i]), this.getYPixel(dataY[i]) - crossSize, this.getXPixel(dataX[i]), this.getYPixel(dataY[i]) + crossSize);
        }
    }

    protected void plotRectGridData(RectGrid trace, Graphics2D g2d) {
        int i;
        int localNumVertHatches = trace.getNumVertHatches();
        int localNumHorizHatches = trace.getNumHorizHatches();
        for (i = 0; i <= localNumVertHatches - 1; ++i) {
            g2d.setColor(trace.getVertHatches(i).getPlotColor());
            this.plotLine(trace.getNumVertPoints(), trace.getPlotSize(), trace.getVertHatches(i).getDataX(), trace.getVertHatches(i).getDataY(), g2d);
        }
        this.plotLine(trace.getNumVertPoints(), trace.getPlotSize(), trace.getLeftSide().getDataX(), trace.getLeftSide().getDataY(), g2d);
        this.plotLine(trace.getNumVertPoints(), trace.getPlotSize(), trace.getRightSide().getDataX(), trace.getRightSide().getDataY(), g2d);
        for (i = 0; i <= localNumHorizHatches - 1; ++i) {
            g2d.setColor(trace.getHorizHatches(i).getPlotColor());
            this.plotLine(trace.getNumHorizPoints(), trace.getPlotSize(), trace.getHorizHatches(i).getDataX(), trace.getHorizHatches(i).getDataY(), g2d);
        }
        this.plotLine(trace.getNumHorizPoints(), trace.getPlotSize(), trace.getTopSide().getDataX(), trace.getTopSide().getDataY(), g2d);
        this.plotLine(trace.getNumHorizPoints(), trace.getPlotSize(), trace.getBottomSide().getDataX(), trace.getBottomSide().getDataY(), g2d);
    }

    protected void plotHashMarks(int localNumPoints, int width, int height, double[] dataX, double[] dataY, Graphics g2d) {
        if (width == 0) {
            for (int i = 0; i <= localNumPoints - 1; ++i) {
                g2d.drawLine(this.getXPixel(dataX[i]), this.getYPixel(dataY[i]) + height, this.getXPixel(dataX[i]), this.getYPixel(dataY[i]) - height);
            }
        } else if (height == 0) {
            for (int i = 0; i <= localNumPoints - 1; ++i) {
                g2d.drawLine(this.getXPixel(dataX[i]) - width, this.getYPixel(dataY[i]), this.getXPixel(dataX[i]) + width, this.getYPixel(dataY[i]));
            }
        } else {
            for (int i = 0; i <= localNumPoints - 1; ++i) {
                g2d.fillRect(this.getXPixel(dataX[i]) - width, this.getYPixel(dataY[i]) - height, 2 * width + 1, 2 * height + 1);
            }
        }
    }
}

