/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.contourgrapher2d;

import com.jimrolf.contours2d.ContourFuncInterface;
import com.jimrolf.datagrapher2d.DataGrapher2D;
import com.jimrolf.numberlabel.NumberLabel;
import com.jimrolf.plotstuff2d.PlotStuff;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ContourGrapher2D
extends DataGrapher2D {
    protected double contourTol = 0.0;
    protected ContourFuncInterface func = null;
    protected NumberLabel contourLabel = new NumberLabel();
    protected int numConstants = 0;
    protected double[] constants = null;

    public double getContourTol() {
        return this.contourTol;
    }

    public void setContourTol(double contourTol) {
        this.contourTol = contourTol;
    }

    public void setFuncMinMax(double min, double max) {
        this.contourTol = (max - min) / (3.0 * Math.sqrt((this.domainRange[1] - this.domainRange[0]) * (this.domainRange[1] - this.domainRange[0]) + (this.domainRange[3] - this.domainRange[2]) * (this.domainRange[3] - this.domainRange[2])));
    }

    public ContourFuncInterface getFunc() {
        return this.func;
    }

    public void setFunc(ContourFuncInterface func) {
        this.func = func;
    }

    public NumberLabel getContourLabel() {
        return this.contourLabel;
    }

    public void setContourLabel(NumberLabel contourLabel) {
        this.contourLabel = contourLabel;
    }

    public int getNumConstants() {
        return this.numConstants;
    }

    public void setNumConstants(int numConstants) {
        this.numConstants = numConstants;
    }

    public double[] getConstants() {
        return this.constants;
    }

    public void setConstants(double[] constants) {
        this.constants = constants;
    }

    public double getConstants(int index) {
        return this.constants[index];
    }

    public void setConstants(int index, double newConstants) {
        this.constants[index] = newConstants;
    }

    public ContourGrapher2D() {
        this.contourLabel.setOpaque(false);
        this.contourLabel.setVisible(false);
        this.contourLabel.setMaximumFractionDigits(8);
        this.contourLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.add(this.contourLabel);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                ContourGrapher2D.this.grapherMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                ContourGrapher2D.this.grapherMouseExited(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                ContourGrapher2D.this.grapherMouseMoved(evt);
            }
        });
    }

    protected void plotData(PlotStuff trace, Graphics2D g2d) {
        if (trace.getPlotStyle() == 14) {
            this.plotContours(trace.getNumPoints(), trace.getPlotSize(), trace.getDataX(), trace.getDataY(), g2d);
        } else {
            super.plotData(trace, g2d);
        }
    }

    protected void plotContours(int localNumPoints, int size, double[] dataX, double[] dataY, Graphics2D g2d) {
        int graphX1 = 0;
        int graphY1 = 0;
        int graphX2 = 0;
        int graphY2 = 0;
        g2d.setStroke(new BasicStroke(size, 1, 2));
        for (int i = 0; i <= localNumPoints / 2 - 1; ++i) {
            if (Double.isNaN(dataX[2 * i]) || Double.isNaN(dataY[2 * i]) || Double.isNaN(dataX[2 * i + 1]) || Double.isNaN(dataY[2 * i + 1])) continue;
            graphX1 = this.getXPixel(dataX[2 * i]);
            graphY1 = this.getYPixel(dataY[2 * i]);
            graphX2 = this.getXPixel(dataX[2 * i + 1]);
            graphY2 = this.getYPixel(dataY[2 * i + 1]);
            g2d.drawLine(graphX1, graphY1, graphX2, graphY2);
        }
    }

    public void grapherMouseEntered(MouseEvent evt) {
        if (this.numConstants > 0 && this.constants != null) {
            this.contourLabel.setText("");
            this.contourLabel.setVisible(true);
        }
    }

    public void grapherMouseExited(MouseEvent evt) {
        this.contourLabel.setVisible(false);
    }

    public void grapherMouseMoved(MouseEvent evt) {
        boolean foundConstant = false;
        if (this.numConstants > 0 && this.constants != null && this.func != null) {
            int counter;
            for (counter = 0; !foundConstant && counter < this.numConstants; ++counter) {
                if (!(Math.abs(this.func.f(this.getXVal(evt.getX()), this.getYVal(evt.getY())) - this.constants[counter]) < this.contourTol)) continue;
                foundConstant = true;
            }
            if (foundConstant) {
                this.contourLabel.setDoubleText(this.constants[counter - 1]);
                this.contourLabel.setBounds(evt.getX() + 10, evt.getY() - 10, 75, 18);
            } else {
                this.contourLabel.setText("");
            }
        }
    }
}

