/*
 * Decompiled with CFR 0.152.
 */
package com.jimrolf.complexvectool;

import com.jimrolf.complexvectool.DefaultVecFieldFunc;
import com.jimrolf.complexvectool.FlowFunc;
import com.jimrolf.complexvectool.FluxFunc;
import com.jimrolf.complexvectool.PolyaFlowFunc;
import com.jimrolf.complexvectool.PolyaFluxFunc;
import com.jimrolf.complexvectool.PolyaVecFieldFunc;
import com.jimrolf.convert.Convert;
import com.jimrolf.datagrapher2d.DataGrapher2D;
import com.jimrolf.domainchoicebox.RealDomainChoiceBox;
import com.jimrolf.functionchoicebox.ComplexFunctionChoiceBox;
import com.jimrolf.functionfield.DoubleField;
import com.jimrolf.functionfield.FunctionField;
import com.jimrolf.functionfield.IntField;
import com.jimrolf.integrator.AdaptiveSimpson;
import com.jimrolf.multiodesolver.MultiDerivFuncAbstractClass;
import com.jimrolf.multiodesolver.RungeKutta4;
import com.jimrolf.numberlabel.NumberLabel;
import com.jimrolf.plotstuff2d.Crosses2D;
import com.jimrolf.plotstuff2d.PlotStuff;
import com.jimrolf.plotstuff2d.PlotStuff2D;
import com.jimrolf.plotstuff2d.Vectors2D;
import com.jimrolf.slider.Slider;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class ComplexVecTool
extends JApplet
implements Runnable {
    private MultiDerivFuncAbstractClass defaultVecFieldFunc = null;
    private MultiDerivFuncAbstractClass polyaVecFieldFunc = null;
    private JTextComponent focusField = null;
    private boolean componentIsFocused = false;
    private boolean vecFieldHasBeenGraphed = false;
    private boolean circleHasBeenGraphed = false;
    private float[] hueSatBright = new float[3];
    private double t = 0.0;
    private double tMin = 0.0;
    private double tMax = Math.PI * 2;
    private double gridDeltaX = 0.0;
    private double gridDeltaY = 0.0;
    private int numXGridPoints = 0;
    private int numYGridPoints = 0;
    private PlotStuff2D[] slopeSolutionData = null;
    private PlotStuff2D[] slopeSolutionBackData = null;
    private PlotStuff2D[] slopeSolutionInitialData = null;
    private int numCurrentSolutions = 0;
    private int maxNumSolutions = 45;
    private int solutionsIncrementCapacity = 45;
    private int maxNumTraces = 3;
    private double[] circleCenterDataX = new double[1];
    private double[] circleCenterDataY = new double[1];
    private double[] circleDataX = null;
    private double[] circleDataY = null;
    private int numCirclePoints = 100;
    private double deltaTheta = 0.0;
    private double radius = 0.0;
    private Color circleFoundColor = new Color(255, 153, 0);
    private Color circleColor = Color.BLACK;
    boolean creatingCircle = false;
    private PlotStuff[] allData = null;
    private int numTraces = 0;
    private double[] domainRange = new double[]{-3.0, 3.0, -3.0, 3.0};
    private Color backgroundColor = null;
    private Color panelColor = null;
    double[][] basePoint = new double[1][2];
    double[][] direction = new double[1][2];
    double[] initialCondition = new double[2];
    private RungeKutta4 odeForwardSolver = null;
    private RungeKutta4 odeBackSolver = null;
    private int initialCapacity = 100;
    private int numPoints = 301;
    private Color solutionBackColor = new Color(0, 102, 51);
    private Color solutionInitialColor = Color.BLUE;
    private FlowFunc flowFunc = null;
    private FluxFunc fluxFunc = null;
    private PolyaFlowFunc polyaFlowFunc = null;
    private PolyaFluxFunc polyaFluxFunc = null;
    private AdaptiveSimpson adaptiveIntegrator = null;
    private double radiusPercent = 0.1;
    private double centerPercent = 0.15;
    private double shrinkRadiusTolFactor = 6.0 * Math.sqrt(2.0) / this.radiusPercent;
    private double centerGrabTolFactor = 6.0 * Math.sqrt(2.0) / this.centerPercent;
    private double shrinkRadiusTol = 0.0;
    private double pressedX = 0.0;
    private double pressedY = 0.0;
    private double originalCenterX = 0.0;
    private double originalCenterY = 0.0;
    private double centerGrabTol = 0.0;
    private boolean readyToShrink = false;
    private boolean readyToMove = false;
    private double stepSize = 0.02;
    protected Thread animatorThread = null;
    private int pauseVal = 20;
    private boolean timeToStop = false;
    private double flow = 0.0;
    private double flux = 0.0;
    private double eps = 1.0E-8;
    private JPanel bottomLeftCornerPanel;
    private JLabel centerLabel;
    private DoubleField centerXField;
    private DoubleField centerYField;
    private PlotStuff2D circle;
    private Crosses2D circleCenter;
    private JPanel circlePanel;
    private JButton clearButton;
    private JLabel commaLabel;
    private JPanel complexVecToolPanel;
    private NumberLabel cursorLabel;
    private JRadioButton defaultVecFieldButton;
    private JButton defaultViewButton;
    private RealDomainChoiceBox domainChoiceBox;
    private JCheckBox fixedIntervalBox;
    private NumberLabel flowLabel;
    private JCheckBox flowLineSettingsBox;
    private JPanel flowLineSettingsPanel;
    private NumberLabel fluxLabel;
    private FunctionField funcField;
    private JLabel funcLabel;
    private JPanel funcPanel;
    private ComplexFunctionChoiceBox functionChoiceBox;
    private JButton graphButton;
    private DataGrapher2D grapher;
    private JPanel grapherPanel;
    private JCheckBox insertCircleBox;
    private JPanel leftPanel;
    private JLabel leftParenthesisLabel;
    private JPanel lowerPanel;
    private IntField pauseValField;
    private JLabel pauseValLabel;
    private JPanel pointPanel;
    private JRadioButton polyaVecFieldButton;
    private DoubleField radiusField;
    private JLabel radiusLabel;
    private JLabel rightParenthesisLabel;
    private JLabel scalingFactorLabel;
    private JPanel scalingFactorPanel;
    private Slider scalingFactorSlider;
    private DoubleField stepSizeField;
    private JLabel stepSizeLabel;
    private JButton stopButton;
    private JLabel tLabel;
    private DoubleField tMaxField;
    private DoubleField tMinField;
    private JButton updateButton;
    private JPanel upperLeftCornerPanel;
    private JPanel upperPanel;
    private Vectors2D vecField;
    private ButtonGroup vecFieldButtonGroup;
    private DoubleField xMaxField;
    private DoubleField xMinField;
    private DoubleField yMaxField;
    private DoubleField yMinField;

    public void init() {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            UIManager.put("swing.boldMetal", Boolean.FALSE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ComplexVecTool.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initStuff();
    }

    private void initComponents() {
        this.vecFieldButtonGroup = new ButtonGroup();
        this.vecField = new Vectors2D();
        this.circleCenter = new Crosses2D();
        this.circle = new PlotStuff2D();
        this.complexVecToolPanel = new JPanel();
        this.grapherPanel = new JPanel();
        this.upperPanel = new JPanel();
        this.domainChoiceBox = new RealDomainChoiceBox();
        this.defaultViewButton = new JButton();
        this.grapher = new DataGrapher2D();
        this.leftPanel = new JPanel();
        this.yMinField = new DoubleField();
        this.yMaxField = new DoubleField();
        this.bottomLeftCornerPanel = new JPanel();
        this.lowerPanel = new JPanel();
        this.xMinField = new DoubleField();
        this.xMaxField = new DoubleField();
        this.cursorLabel = new NumberLabel();
        this.upperLeftCornerPanel = new JPanel();
        this.funcPanel = new JPanel();
        this.funcLabel = new JLabel();
        this.funcField = new FunctionField();
        this.graphButton = new JButton();
        this.clearButton = new JButton();
        this.defaultVecFieldButton = new JRadioButton();
        this.polyaVecFieldButton = new JRadioButton();
        this.functionChoiceBox = new ComplexFunctionChoiceBox();
        this.scalingFactorPanel = new JPanel();
        this.scalingFactorLabel = new JLabel();
        this.scalingFactorSlider = new Slider();
        this.circlePanel = new JPanel();
        this.updateButton = new JButton();
        this.pointPanel = new JPanel();
        this.leftParenthesisLabel = new JLabel();
        this.commaLabel = new JLabel();
        this.centerYField = new DoubleField();
        this.centerXField = new DoubleField();
        this.rightParenthesisLabel = new JLabel();
        this.centerLabel = new JLabel();
        this.radiusLabel = new JLabel();
        this.radiusField = new DoubleField();
        this.flowLabel = new NumberLabel();
        this.fluxLabel = new NumberLabel();
        this.insertCircleBox = new JCheckBox();
        this.flowLineSettingsBox = new JCheckBox();
        this.flowLineSettingsPanel = new JPanel();
        this.tMaxField = new DoubleField();
        this.tMinField = new DoubleField();
        this.tLabel = new JLabel();
        this.fixedIntervalBox = new JCheckBox();
        this.stepSizeLabel = new JLabel();
        this.stepSizeField = new DoubleField();
        this.pauseValField = new IntField();
        this.pauseValLabel = new JLabel();
        this.stopButton = new JButton();
        this.vecField.setAutomaticHeadSize(false);
        this.vecField.setPlotColor(new Color(204, 0, 0));
        this.circleCenter.setPlotColor(new Color(0, 0, 0));
        this.circle.setPlotColor(new Color(0, 0, 0));
        this.getContentPane().setLayout(null);
        this.complexVecToolPanel.setLayout(null);
        this.grapherPanel.setBorder(BorderFactory.createEtchedBorder());
        this.grapherPanel.setLayout(null);
        this.upperPanel.setBorder(BorderFactory.createEtchedBorder());
        this.upperPanel.setLayout(null);
        this.domainChoiceBox.setOpaque(false);
        this.domainChoiceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComplexVecTool.this.domainChoiceBoxActionPerformed(evt);
            }
        });
        this.upperPanel.add(this.domainChoiceBox);
        this.domainChoiceBox.setBounds(1, 1, 265, 18);
        this.defaultViewButton.setFont(new Font("Lucida Sans", 1, 10));
        this.defaultViewButton.setText("Default View");
        this.defaultViewButton.setFocusPainted(false);
        this.defaultViewButton.setMargin(new Insets(2, 2, 2, 2));
        this.defaultViewButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComplexVecTool.this.defaultViewButtonMouseClicked(evt);
            }
        });
        this.upperPanel.add(this.defaultViewButton);
        this.defaultViewButton.setBounds(268, 1, 80, 18);
        this.grapherPanel.add(this.upperPanel);
        this.upperPanel.setBounds(55, 0, 350, 20);
        this.grapher.setXAxisTitle(" re");
        this.grapher.setYAxisTitle("im");
        this.grapher.setAxesColor(new Color(0, 0, 0));
        this.grapher.setAxesStyle(4);
        this.grapher.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ComplexVecTool.this.grapherMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                ComplexVecTool.this.grapherMouseReleased(evt);
            }

            public void mouseClicked(MouseEvent evt) {
                ComplexVecTool.this.grapherMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                ComplexVecTool.this.grapherMouseExited(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                ComplexVecTool.this.grapherMouseEntered(evt);
            }
        });
        this.grapher.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                ComplexVecTool.this.grapherMouseMoved(evt);
            }

            public void mouseDragged(MouseEvent evt) {
                ComplexVecTool.this.grapherMouseDragged(evt);
            }
        });
        GroupLayout grapherLayout = new GroupLayout(this.grapher);
        this.grapher.setLayout(grapherLayout);
        grapherLayout.setHorizontalGroup(grapherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        grapherLayout.setVerticalGroup(grapherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        this.grapherPanel.add(this.grapher);
        this.grapher.setBounds(55, 20, 350, 350);
        this.leftPanel.setBorder(BorderFactory.createEtchedBorder());
        this.leftPanel.setLayout(null);
        this.yMinField.setText("-3");
        this.yMinField.setFont(new Font("Lucida Sans", 0, 10));
        this.yMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.yMinFieldFocusGained(evt);
            }
        });
        this.leftPanel.add(this.yMinField);
        this.yMinField.setBounds(2, 330, 50, 18);
        this.yMaxField.setText("3");
        this.yMaxField.setFont(new Font("Lucida Sans", 0, 10));
        this.yMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.yMaxFieldFocusGained(evt);
            }
        });
        this.leftPanel.add(this.yMaxField);
        this.yMaxField.setBounds(2, 1, 50, 18);
        this.grapherPanel.add(this.leftPanel);
        this.leftPanel.setBounds(0, 20, 55, 350);
        this.bottomLeftCornerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomLeftCornerPanel.setLayout(null);
        this.grapherPanel.add(this.bottomLeftCornerPanel);
        this.bottomLeftCornerPanel.setBounds(0, 370, 55, 20);
        this.lowerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.lowerPanel.setLayout(null);
        this.xMinField.setText("-3");
        this.xMinField.setFont(new Font("Lucida Sans", 0, 10));
        this.xMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.xMinFieldFocusGained(evt);
            }
        });
        this.lowerPanel.add(this.xMinField);
        this.xMinField.setBounds(0, 0, 50, 18);
        this.xMaxField.setText("3");
        this.xMaxField.setFont(new Font("Lucida Sans", 0, 10));
        this.xMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.xMaxFieldFocusGained(evt);
            }
        });
        this.lowerPanel.add(this.xMaxField);
        this.xMaxField.setBounds(298, 0, 50, 18);
        this.cursorLabel.setHorizontalAlignment(0);
        this.cursorLabel.setText("invisible");
        this.lowerPanel.add(this.cursorLabel);
        this.cursorLabel.setBounds(75, 1, 200, 18);
        this.grapherPanel.add(this.lowerPanel);
        this.lowerPanel.setBounds(55, 370, 350, 20);
        this.upperLeftCornerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.upperLeftCornerPanel.setLayout(null);
        this.grapherPanel.add(this.upperLeftCornerPanel);
        this.upperLeftCornerPanel.setBounds(0, 0, 55, 20);
        this.complexVecToolPanel.add(this.grapherPanel);
        this.grapherPanel.setBounds(0, 0, 407, 390);
        this.funcPanel.setBorder(BorderFactory.createEtchedBorder());
        this.funcPanel.setLayout(null);
        this.funcLabel.setFont(new Font("Lucida Sans", 1, 10));
        this.funcLabel.setHorizontalAlignment(4);
        this.funcLabel.setText("f(z)=");
        this.funcPanel.add(this.funcLabel);
        this.funcLabel.setBounds(0, 40, 45, 18);
        this.funcField.setComplexFunc(true);
        this.funcField.setFont(new Font("Lucida Sans", 0, 10));
        this.funcField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.funcFieldFocusGained(evt);
            }
        });
        this.funcPanel.add(this.funcField);
        this.funcField.setBounds(50, 40, 260, 18);
        this.graphButton.setFont(new Font("Lucida Sans", 0, 11));
        this.graphButton.setText("Graph");
        this.graphButton.setFocusPainted(false);
        this.graphButton.setMargin(new Insets(0, 0, 0, 0));
        this.graphButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComplexVecTool.this.graphButtonMouseClicked(evt);
            }
        });
        this.funcPanel.add(this.graphButton);
        this.graphButton.setBounds(5, 105, 95, 18);
        this.clearButton.setFont(new Font("Lucida Sans", 0, 11));
        this.clearButton.setText("Clear All");
        this.clearButton.setFocusPainted(false);
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComplexVecTool.this.clearButtonMouseClicked(evt);
            }
        });
        this.funcPanel.add(this.clearButton);
        this.clearButton.setBounds(220, 105, 95, 18);
        this.vecFieldButtonGroup.add(this.defaultVecFieldButton);
        this.defaultVecFieldButton.setFont(new Font("Lucida Sans", 0, 10));
        this.defaultVecFieldButton.setSelected(true);
        this.defaultVecFieldButton.setText("Vector field: f(z)");
        this.defaultVecFieldButton.setFocusPainted(false);
        this.defaultVecFieldButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ComplexVecTool.this.defaultVecFieldButtonItemStateChanged(evt);
            }
        });
        this.funcPanel.add(this.defaultVecFieldButton);
        this.defaultVecFieldButton.setBounds(20, 20, 130, 18);
        this.vecFieldButtonGroup.add(this.polyaVecFieldButton);
        this.polyaVecFieldButton.setFont(new Font("Lucida Sans", 0, 10));
        this.polyaVecFieldButton.setText("Polya vector field: f(z)");
        this.polyaVecFieldButton.setFocusPainted(false);
        this.funcPanel.add(this.polyaVecFieldButton);
        this.polyaVecFieldButton.setBounds(160, 20, 131, 18);
        this.functionChoiceBox.setBackground(new Color(238, 238, 238));
        this.functionChoiceBox.setFont(new Font("Lucida Sans", 1, 10));
        this.functionChoiceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComplexVecTool.this.functionChoiceBoxActionPerformed(evt);
            }
        });
        this.funcPanel.add(this.functionChoiceBox);
        this.functionChoiceBox.setBounds(20, 0, 290, 18);
        this.scalingFactorPanel.setLayout(null);
        this.scalingFactorLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.scalingFactorLabel.setText("Vector scaling");
        this.scalingFactorPanel.add(this.scalingFactorLabel);
        this.scalingFactorLabel.setBounds(60, 20, 70, 13);
        this.scalingFactorSlider.setOpaque(false);
        this.scalingFactorSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                ComplexVecTool.this.scalingFactorSliderMouseDragged(evt);
            }
        });
        this.scalingFactorPanel.add(this.scalingFactorSlider);
        this.scalingFactorSlider.setBounds(0, 0, 190, 18);
        this.funcPanel.add(this.scalingFactorPanel);
        this.scalingFactorPanel.setBounds(65, 60, 190, 40);
        this.circlePanel.setLayout(null);
        this.updateButton.setFont(new Font("Lucida Sans", 0, 10));
        this.updateButton.setText("Update");
        this.updateButton.setFocusPainted(false);
        this.updateButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComplexVecTool.this.updateButtonMouseClicked(evt);
            }
        });
        this.circlePanel.add(this.updateButton);
        this.updateButton.setBounds(190, 0, 80, 18);
        this.pointPanel.setLayout(null);
        this.leftParenthesisLabel.setFont(new Font("Lucida Sans", 1, 12));
        this.leftParenthesisLabel.setHorizontalAlignment(4);
        this.leftParenthesisLabel.setText("(");
        this.pointPanel.add(this.leftParenthesisLabel);
        this.leftParenthesisLabel.setBounds(35, 0, 5, 18);
        this.commaLabel.setFont(new Font("Lucida Sans", 1, 12));
        this.commaLabel.setHorizontalAlignment(0);
        this.commaLabel.setText(",");
        this.pointPanel.add(this.commaLabel);
        this.commaLabel.setBounds(95, 0, 5, 18);
        this.centerYField.setText("0");
        this.centerYField.setFont(new Font("Lucida Sans", 0, 10));
        this.centerYField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.centerYFieldFocusGained(evt);
            }
        });
        this.pointPanel.add(this.centerYField);
        this.centerYField.setBounds(100, 0, 50, 18);
        this.centerXField.setText("0");
        this.centerXField.setFont(new Font("Lucida Sans", 0, 10));
        this.centerXField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.centerXFieldFocusGained(evt);
            }
        });
        this.pointPanel.add(this.centerXField);
        this.centerXField.setBounds(45, 0, 50, 18);
        this.rightParenthesisLabel.setFont(new Font("Lucida Sans", 1, 12));
        this.rightParenthesisLabel.setHorizontalAlignment(4);
        this.rightParenthesisLabel.setText(")");
        this.pointPanel.add(this.rightParenthesisLabel);
        this.rightParenthesisLabel.setBounds(150, 0, 5, 18);
        this.centerLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.centerLabel.setHorizontalAlignment(4);
        this.centerLabel.setText("center:");
        this.pointPanel.add(this.centerLabel);
        this.centerLabel.setBounds(0, 0, 35, 18);
        this.radiusLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.radiusLabel.setHorizontalAlignment(4);
        this.radiusLabel.setText("radius:");
        this.pointPanel.add(this.radiusLabel);
        this.radiusLabel.setBounds(0, 20, 35, 18);
        this.radiusField.setText("1");
        this.radiusField.setFont(new Font("Lucida Sans", 0, 10));
        this.radiusField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.radiusFieldFocusGained(evt);
            }
        });
        this.pointPanel.add(this.radiusField);
        this.radiusField.setBounds(45, 20, 50, 18);
        this.circlePanel.add(this.pointPanel);
        this.pointPanel.setBounds(0, 0, 200, 40);
        this.flowLabel.setHorizontalAlignment(2);
        this.flowLabel.setText("invisible");
        this.flowLabel.setPreText("Flow=");
        this.circlePanel.add(this.flowLabel);
        this.flowLabel.setBounds(0, 40, 200, 18);
        this.fluxLabel.setHorizontalAlignment(2);
        this.fluxLabel.setText("invisible");
        this.fluxLabel.setPreText("Flux=");
        this.circlePanel.add(this.fluxLabel);
        this.fluxLabel.setBounds(0, 60, 200, 18);
        this.funcPanel.add(this.circlePanel);
        this.circlePanel.setBounds(38, 160, 270, 80);
        this.insertCircleBox.setFont(new Font("Lucida Sans", 1, 10));
        this.insertCircleBox.setText("Insert/move circle");
        this.insertCircleBox.setBorder(null);
        this.insertCircleBox.setFocusPainted(false);
        this.insertCircleBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ComplexVecTool.this.insertCircleBoxItemStateChanged(evt);
            }
        });
        this.funcPanel.add(this.insertCircleBox);
        this.insertCircleBox.setBounds(20, 140, 160, 18);
        this.flowLineSettingsBox.setFont(new Font("Lucida Sans", 1, 10));
        this.flowLineSettingsBox.setText("Flow line settings");
        this.flowLineSettingsBox.setBorder(null);
        this.flowLineSettingsBox.setFocusPainted(false);
        this.flowLineSettingsBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ComplexVecTool.this.flowLineSettingsBoxItemStateChanged(evt);
            }
        });
        this.funcPanel.add(this.flowLineSettingsBox);
        this.flowLineSettingsBox.setBounds(20, 250, 160, 18);
        this.flowLineSettingsPanel.setLayout(null);
        this.tMaxField.setText("2*pi");
        this.tMaxField.setFont(new Font("Lucida Sans", 0, 10));
        this.tMaxField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.tMaxFieldFocusGained(evt);
            }
        });
        this.flowLineSettingsPanel.add(this.tMaxField);
        this.tMaxField.setBounds(90, 40, 50, 18);
        this.tMinField.setText("0");
        this.tMinField.setFont(new Font("Lucida Sans", 0, 10));
        this.tMinField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.tMinFieldFocusGained(evt);
            }
        });
        this.flowLineSettingsPanel.add(this.tMinField);
        this.tMinField.setBounds(0, 40, 50, 18);
        this.tLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.tLabel.setHorizontalAlignment(0);
        this.tLabel.setText("<=t<=");
        this.flowLineSettingsPanel.add(this.tLabel);
        this.tLabel.setBounds(50, 40, 40, 18);
        this.fixedIntervalBox.setFont(new Font("Lucida Sans", 0, 10));
        this.fixedIntervalBox.setText("Use fixed interval for ode solver");
        this.fixedIntervalBox.setBorder(null);
        this.fixedIntervalBox.setFocusPainted(false);
        this.fixedIntervalBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ComplexVecTool.this.fixedIntervalBoxItemStateChanged(evt);
            }
        });
        this.flowLineSettingsPanel.add(this.fixedIntervalBox);
        this.fixedIntervalBox.setBounds(0, 20, 190, 18);
        this.stepSizeLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.stepSizeLabel.setHorizontalAlignment(2);
        this.stepSizeLabel.setText("Step size:");
        this.flowLineSettingsPanel.add(this.stepSizeLabel);
        this.stepSizeLabel.setBounds(0, 0, 60, 18);
        this.stepSizeField.setText("0.02");
        this.stepSizeField.setFont(new Font("Lucida Sans", 0, 10));
        this.stepSizeField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ComplexVecTool.this.stepSizeFieldFocusGained(evt);
            }
        });
        this.flowLineSettingsPanel.add(this.stepSizeField);
        this.stepSizeField.setBounds(60, 0, 50, 18);
        this.pauseValField.setText("10");
        this.pauseValField.setFont(new Font("Lucida Sans", 0, 10));
        this.flowLineSettingsPanel.add(this.pauseValField);
        this.pauseValField.setBounds(180, 0, 50, 18);
        this.pauseValLabel.setFont(new Font("Lucida Sans", 0, 10));
        this.pauseValLabel.setHorizontalAlignment(2);
        this.pauseValLabel.setText("Step delay:");
        this.flowLineSettingsPanel.add(this.pauseValLabel);
        this.pauseValLabel.setBounds(120, 0, 60, 18);
        this.funcPanel.add(this.flowLineSettingsPanel);
        this.flowLineSettingsPanel.setBounds(38, 270, 270, 60);
        this.stopButton.setFont(new Font("Lucida Sans", 0, 10));
        this.stopButton.setText("Stop");
        this.stopButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComplexVecTool.this.stopButtonMouseClicked(evt);
            }
        });
        this.funcPanel.add(this.stopButton);
        this.stopButton.setBounds(112, 105, 95, 18);
        this.complexVecToolPanel.add(this.funcPanel);
        this.funcPanel.setBounds(407, 0, 320, 390);
        this.getContentPane().add(this.complexVecToolPanel);
        this.complexVecToolPanel.setBounds(0, 0, 727, 390);
    }

    private void domainChoiceBoxActionPerformed(ActionEvent evt) {
        this.clearLabels();
        this.domainChoiceBox.itemClicked();
        this.setDefaultDomain();
        if (this.vecFieldHasBeenGraphed) {
            this.createData(true);
        }
        this.grapher.plotData();
    }

    private void defaultViewButtonMouseClicked(MouseEvent evt) {
        this.domainChoiceBox.putDomainRangeVals();
        this.setDefaultDomain();
    }

    private void graphButtonMouseClicked(MouseEvent evt) {
        this.clearLabels();
        this.reGraph(true);
    }

    private void clearButtonMouseClicked(MouseEvent evt) {
        this.clearLabels();
        this.setDefaultDomain();
        this.vecFieldHasBeenGraphed = false;
        this.circleHasBeenGraphed = false;
        this.numCurrentSolutions = 0;
        this.numTraces = 0;
        this.grapher.setNumTraces(0);
        this.grapher.plotData();
    }

    private void functionChoiceBoxActionPerformed(ActionEvent evt) {
        this.functionChoiceBox.setFunctionString(this.focusField);
    }

    private void funcFieldFocusGained(FocusEvent evt) {
        this.focusField = (FunctionField)evt.getSource();
    }

    private void yMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void yMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void xMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void xMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void scalingFactorSliderMouseDragged(MouseEvent evt) {
        double scale = 0.0;
        if (this.vecFieldHasBeenGraphed && (scale = this.scalingFactorSlider.getDoubleVal(evt)) > 0.0) {
            this.vecField.setScalingFactor(scale);
            this.grapher.plotData();
        }
    }

    private void grapherMouseClicked(MouseEvent evt) {
        if (this.vecFieldHasBeenGraphed && !this.insertCircleBox.isSelected()) {
            double[] initialX = new double[1];
            double[] initialY = new double[1];
            initialX[0] = this.grapher.getXVal(evt.getX());
            initialY[0] = this.grapher.getYVal(evt.getY());
            this.initialCondition[0] = initialX[0];
            this.initialCondition[1] = initialY[0];
            this.odeForwardSolver.setInitialY(this.initialCondition);
            this.odeBackSolver.setInitialY(this.initialCondition);
            this.numCurrentSolutions += 3;
            this.checkSolutionMemory();
            this.slopeSolutionInitialData[this.numCurrentSolutions / 3 - 1].setDataX(initialX);
            this.slopeSolutionInitialData[this.numCurrentSolutions / 3 - 1].setDataY(initialY);
            this.allData[this.numTraces - 1 + this.numCurrentSolutions - 2] = this.slopeSolutionData[this.numCurrentSolutions / 3 - 1];
            this.allData[this.numTraces - 1 + this.numCurrentSolutions - 1] = this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1];
            this.allData[this.numTraces - 1 + this.numCurrentSolutions] = this.slopeSolutionInitialData[this.numCurrentSolutions / 3 - 1];
            this.grapher.setNumTraces(this.numTraces + this.numCurrentSolutions);
            if (this.fixedIntervalBox.isSelected()) {
                this.odeForwardSolver.setCapacityCreated(false);
                this.odeBackSolver.setCapacityCreated(false);
                this.odeForwardSolver.setInitialT(this.tMin);
                this.odeForwardSolver.setFinalT(this.tMax);
                this.odeForwardSolver.setNumPoints(Convert.toRoundedInt((this.tMax - this.tMin) / this.stepSize) + 1);
                this.odeForwardSolver.solveODE();
                this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setDataX(this.odeForwardSolver.getYVals(0));
                this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setDataY(this.odeForwardSolver.getYVals(1));
                this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setNumPoints(this.odeForwardSolver.getNumPoints());
                this.odeBackSolver.setInitialT(this.tMin);
                this.odeBackSolver.setFinalT(this.tMax);
                this.odeBackSolver.setNumPoints(Convert.toRoundedInt((this.tMax - this.tMin) / this.stepSize) + 1);
                this.odeBackSolver.solveODE();
                this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setDataX(this.odeBackSolver.getYVals(0));
                this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setDataY(this.odeBackSolver.getYVals(1));
                this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setNumPoints(this.odeBackSolver.getNumPoints());
                this.grapher.plotData(this.allData);
            } else {
                this.odeForwardSolver.createCapacity(this.initialCapacity);
                this.odeForwardSolver.setNumPoints(0);
                this.odeForwardSolver.setInitialT(0.0);
                this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setDataX(this.odeForwardSolver.getYVals(0));
                this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setDataY(this.odeForwardSolver.getYVals(1));
                this.odeBackSolver.createCapacity(this.initialCapacity);
                this.odeBackSolver.setNumPoints(0);
                this.odeBackSolver.setInitialT(0.0);
                this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setDataX(this.odeBackSolver.getYVals(0));
                this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setDataY(this.odeBackSolver.getYVals(1));
                if (this.animatorThread != null && this.animatorThread.isAlive()) {
                    this.animatorThread.interrupt();
                }
                this.timeToStop = false;
                this.animatorThread = new Thread(this);
                this.animatorThread.start();
            }
        }
    }

    private void defaultVecFieldButtonItemStateChanged(ItemEvent evt) {
        this.clearLabels();
        if (this.defaultVecFieldButton.isSelected()) {
            this.odeForwardSolver.setFunc(this.defaultVecFieldFunc);
            this.odeBackSolver.setFunc(this.defaultVecFieldFunc);
        } else {
            this.odeForwardSolver.setFunc(this.polyaVecFieldFunc);
            this.odeBackSolver.setFunc(this.polyaVecFieldFunc);
        }
        this.reGraph(false);
    }

    private void insertCircleBoxItemStateChanged(ItemEvent evt) {
        if (this.insertCircleBox.isSelected()) {
            this.flowLabel.setText("");
            this.fluxLabel.setText("");
            this.circlePanel.setVisible(true);
            this.stopButton.setVisible(false);
            this.timeToStop = true;
        } else {
            this.circlePanel.setVisible(false);
            this.stopButton.setVisible(true);
            this.circleHasBeenGraphed = false;
            this.updateNumTraces();
            this.grapher.plotData();
        }
    }

    private void centerYFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void centerXFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void radiusFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void grapherMouseMoved(MouseEvent evt) {
        double x = this.grapher.getXVal(evt.getX());
        double y = this.grapher.getYVal(evt.getY());
        double distance = Math.sqrt((x - this.circleCenterDataX[0]) * (x - this.circleCenterDataX[0]) + (y - this.circleCenterDataY[0]) * (y - this.circleCenterDataY[0]));
        this.grapher.grapherMouseMoved(evt);
        if (this.circleHasBeenGraphed) {
            if (distance > this.radius - this.shrinkRadiusTol && distance < this.radius + this.shrinkRadiusTol) {
                this.circle.setPlotColor(this.circleFoundColor);
                this.readyToShrink = true;
                this.grapher.plotData();
            } else if (distance < this.centerGrabTol) {
                this.circleCenter.setPlotColor(this.circleFoundColor);
                this.readyToMove = true;
                this.grapher.plotData();
            } else {
                this.circle.setPlotColor(this.circleColor);
                this.circleCenter.setPlotColor(this.circleColor);
                this.readyToShrink = false;
                this.readyToMove = false;
                this.grapher.plotData();
            }
        }
    }

    private void grapherMouseEntered(MouseEvent evt) {
        this.grapher.grapherMouseEntered(evt);
    }

    private void grapherMouseExited(MouseEvent evt) {
        this.grapher.grapherMouseExited(evt);
    }

    private void grapherMousePressed(MouseEvent evt) {
        if (this.vecFieldHasBeenGraphed && this.insertCircleBox.isSelected()) {
            if (this.circleHasBeenGraphed) {
                this.pressedX = this.grapher.getXVal(evt.getX());
                this.pressedY = this.grapher.getYVal(evt.getY());
                this.originalCenterX = this.circleCenterDataX[0];
                this.originalCenterY = this.circleCenterDataY[0];
            } else {
                this.circleCenterDataX[0] = this.grapher.getXVal(evt.getX());
                this.circleCenterDataY[0] = this.grapher.getYVal(evt.getY());
                this.radius = 0.0;
                this.centerXField.setDoubleText(this.circleCenterDataX[0]);
                this.centerYField.setDoubleText(this.circleCenterDataY[0]);
                this.radiusField.setDoubleText(this.radius);
                this.createCircleData();
                this.circleHasBeenGraphed = true;
                this.creatingCircle = true;
                this.updateNumTraces();
                this.grapher.plotData();
            }
        }
    }

    private void grapherMouseDragged(MouseEvent evt) {
        if (this.vecFieldHasBeenGraphed && this.insertCircleBox.isSelected()) {
            if (this.creatingCircle || this.readyToShrink) {
                this.radius = Math.sqrt((this.grapher.getXVal(evt.getX()) - this.circleCenterDataX[0]) * (this.grapher.getXVal(evt.getX()) - this.circleCenterDataX[0]) + (this.grapher.getYVal(evt.getY()) - this.circleCenterDataY[0]) * (this.grapher.getYVal(evt.getY()) - this.circleCenterDataY[0]));
                this.radiusField.setDoubleText(this.radius);
            } else if (this.readyToMove) {
                this.circleCenterDataX[0] = this.originalCenterX + (this.grapher.getXVal(evt.getX()) - this.pressedX);
                this.circleCenterDataY[0] = this.originalCenterY + (this.grapher.getYVal(evt.getY()) - this.pressedY);
                this.centerXField.setDoubleText(this.circleCenterDataX[0]);
                this.centerYField.setDoubleText(this.circleCenterDataY[0]);
            }
            this.createCircleData();
            this.grapher.plotData();
        }
    }

    private void grapherMouseReleased(MouseEvent evt) {
        if (this.vecFieldHasBeenGraphed && this.insertCircleBox.isSelected() && this.creatingCircle) {
            this.radius = Math.sqrt((this.grapher.getXVal(evt.getX()) - this.circleCenterDataX[0]) * (this.grapher.getXVal(evt.getX()) - this.circleCenterDataX[0]) + (this.grapher.getYVal(evt.getY()) - this.circleCenterDataY[0]) * (this.grapher.getYVal(evt.getY()) - this.circleCenterDataY[0]));
            this.radiusField.setDoubleText(this.radius);
            this.createCircleData();
            this.creatingCircle = false;
            this.grapher.plotData();
        }
    }

    private void updateButtonMouseClicked(MouseEvent evt) {
        if (this.isCircleInfoGood()) {
            this.circleHasBeenGraphed = true;
            this.createCircleData();
            this.updateNumTraces();
            this.grapher.plotData();
        }
    }

    private void flowLineSettingsBoxItemStateChanged(ItemEvent evt) {
        if (this.flowLineSettingsBox.isSelected()) {
            this.flowLineSettingsPanel.setVisible(true);
        } else {
            this.flowLineSettingsPanel.setVisible(false);
        }
    }

    private void tMaxFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void tMinFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void fixedIntervalBoxItemStateChanged(ItemEvent evt) {
        if (this.fixedIntervalBox.isSelected()) {
            this.tMinField.setVisible(true);
            this.tMaxField.setVisible(true);
            this.tLabel.setVisible(true);
            this.pauseValLabel.setVisible(false);
            this.pauseValField.setVisible(false);
            this.timeToStop = true;
        } else {
            this.tMinField.setVisible(false);
            this.tMaxField.setVisible(false);
            this.tLabel.setVisible(false);
            this.pauseValLabel.setVisible(true);
            this.pauseValField.setVisible(true);
        }
    }

    private void stepSizeFieldFocusGained(FocusEvent evt) {
        this.focusField = (DoubleField)evt.getSource();
    }

    private void stopButtonMouseClicked(MouseEvent evt) {
        this.timeToStop = true;
    }

    private void clearLabels() {
        this.funcField.setBackground(this.backgroundColor);
        this.xMinField.setBackground(this.backgroundColor);
        this.xMaxField.setBackground(this.backgroundColor);
        this.yMinField.setBackground(this.backgroundColor);
        this.yMaxField.setBackground(this.backgroundColor);
        this.centerXField.setBackground(this.backgroundColor);
        this.centerYField.setBackground(this.backgroundColor);
        this.radiusField.setBackground(this.backgroundColor);
        this.stepSizeField.setBackground(this.backgroundColor);
        this.pauseValField.setBackground(this.backgroundColor);
        this.tMinField.setBackground(this.backgroundColor);
        this.tMaxField.setBackground(this.backgroundColor);
    }

    private void setDefaultDomain() {
    }

    private void createData(boolean updateScalingFactor) {
        double maxLength = 0.0;
        double yVal = 0.0;
        double lengthVector = 0.0;
        this.gridDeltaX = (this.domainRange[1] - this.domainRange[0]) / (double)(this.numXGridPoints + 1);
        this.gridDeltaY = (this.domainRange[3] - this.domainRange[2]) / (double)(this.numYGridPoints + 1);
        if (this.defaultVecFieldButton.isSelected()) {
            for (int i = 0; i <= this.numYGridPoints - 1; ++i) {
                yVal = this.domainRange[2] + (double)(i + 1) * this.gridDeltaY;
                for (int j = 0; j <= this.numXGridPoints - 1; ++j) {
                    this.basePoint[j + i * this.numXGridPoints][0] = this.domainRange[0] + (double)(j + 1) * this.gridDeltaX;
                    this.basePoint[j + i * this.numXGridPoints][1] = yVal;
                    this.direction[j + i * this.numXGridPoints] = this.defaultVecFieldFunc.f(0.0, this.basePoint[j + i * this.numXGridPoints]);
                    lengthVector = this.direction[j + i * this.numXGridPoints][0] * this.direction[j + i * this.numXGridPoints][0] + this.direction[j + i * this.numXGridPoints][1] * this.direction[j + i * this.numXGridPoints][1];
                    if (!(lengthVector > maxLength)) continue;
                    maxLength = lengthVector;
                }
            }
        } else {
            for (int i = 0; i <= this.numYGridPoints - 1; ++i) {
                yVal = this.domainRange[2] + (double)(i + 1) * this.gridDeltaY;
                for (int j = 0; j <= this.numXGridPoints - 1; ++j) {
                    this.basePoint[j + i * this.numXGridPoints][0] = this.domainRange[0] + (double)(j + 1) * this.gridDeltaX;
                    this.basePoint[j + i * this.numXGridPoints][1] = yVal;
                    this.direction[j + i * this.numXGridPoints] = this.polyaVecFieldFunc.f(0.0, this.basePoint[j + i * this.numXGridPoints]);
                    lengthVector = this.direction[j + i * this.numXGridPoints][0] * this.direction[j + i * this.numXGridPoints][0] + this.direction[j + i * this.numXGridPoints][1] * this.direction[j + i * this.numXGridPoints][1];
                    if (!(lengthVector > maxLength)) continue;
                    maxLength = lengthVector;
                }
            }
        }
        if (updateScalingFactor) {
            lengthVector = Math.sqrt(lengthVector);
            this.vecField.setScalingFactor(0.75 / lengthVector);
            this.scalingFactorSlider.setDoubleMax(1.5 / lengthVector);
            this.scalingFactorSlider.setDoubleVal(0.75 / lengthVector);
        }
        if (this.insertCircleBox.isSelected()) {
            this.createCircleData();
        }
    }

    private void initStuff() {
        this.flowLineSettingsPanel.setVisible(false);
        this.tLabel.setVisible(false);
        this.tMinField.setVisible(false);
        this.tMaxField.setVisible(false);
        this.flowFunc = new FlowFunc();
        this.fluxFunc = new FluxFunc();
        this.polyaFlowFunc = new PolyaFlowFunc();
        this.polyaFluxFunc = new PolyaFluxFunc();
        this.adaptiveIntegrator = new AdaptiveSimpson();
        this.adaptiveIntegrator.setA(0.0);
        this.adaptiveIntegrator.setB(Math.PI * 2);
        this.adaptiveIntegrator.setEpsilon(this.eps);
        this.adaptiveIntegrator.setFunc(this.flowFunc);
        this.adaptiveIntegrator.setNumPoints(10);
        this.flowLabel.setText("");
        this.fluxLabel.setText("");
        this.circlePanel.setVisible(false);
        this.numXGridPoints = 15;
        this.numYGridPoints = 15;
        this.basePoint = new double[this.numXGridPoints * this.numYGridPoints][2];
        this.direction = new double[this.numXGridPoints * this.numYGridPoints][2];
        this.vecField.setBasePoint(this.basePoint);
        this.vecField.setDirection(this.direction);
        this.vecField.setNumVectors(this.numXGridPoints * this.numYGridPoints);
        this.vecField.setAutomaticHeadSize(false);
        this.vecField.setHeadHeight(0.1);
        this.vecField.vecField(0.0333);
        this.slopeSolutionData = new PlotStuff2D[this.maxNumSolutions];
        this.slopeSolutionBackData = new PlotStuff2D[this.maxNumSolutions];
        this.slopeSolutionInitialData = new PlotStuff2D[this.maxNumSolutions];
        for (int i = 0; i <= this.maxNumSolutions - 1; ++i) {
            this.slopeSolutionData[i] = new PlotStuff2D();
            this.slopeSolutionData[i].setNumPoints(this.numPoints);
            this.slopeSolutionData[i].setPlotColor(Color.blue);
            this.slopeSolutionData[i].setPlotSize(0);
            this.slopeSolutionData[i].setPlotStyle(0);
            this.slopeSolutionBackData[i] = new PlotStuff2D();
            this.slopeSolutionBackData[i].setPlotColor(this.solutionBackColor);
            this.slopeSolutionBackData[i].setPlotStyle(0);
            this.slopeSolutionBackData[i].setNumPoints(this.numPoints);
            this.slopeSolutionBackData[i].setPlotSize(0);
            this.slopeSolutionInitialData[i] = new PlotStuff2D();
            this.slopeSolutionInitialData[i].setPlotColor(this.solutionInitialColor);
            this.slopeSolutionInitialData[i].setPlotStyle(1);
            this.slopeSolutionInitialData[i].setNumPoints(1);
            this.slopeSolutionInitialData[i].setPlotSize(2);
        }
        this.circleDataX = new double[this.numCirclePoints];
        this.circleDataY = new double[this.numCirclePoints];
        this.circleCenter.setDataX(this.circleCenterDataX);
        this.circleCenter.setDataY(this.circleCenterDataY);
        this.circleCenter.setCrossSize(2);
        this.circleCenter.setNumPoints(1);
        this.circle.setDataX(this.circleDataX);
        this.circle.setDataY(this.circleDataY);
        this.circle.setNumPoints(this.numCirclePoints);
        this.deltaTheta = Math.PI * 2 / (double)(this.numCirclePoints - 1);
        this.circle.setNumPoints(this.numCirclePoints);
        this.allData = new PlotStuff2D[this.maxNumSolutions + this.maxNumTraces];
        this.allData[0] = this.vecField;
        this.defaultVecFieldFunc = new DefaultVecFieldFunc();
        this.polyaVecFieldFunc = new PolyaVecFieldFunc();
        this.odeForwardSolver = new RungeKutta4();
        this.odeForwardSolver.setFunc(this.defaultVecFieldFunc);
        this.odeForwardSolver.setDimension(2);
        this.odeBackSolver = new RungeKutta4();
        this.odeBackSolver.setFunc(this.defaultVecFieldFunc);
        this.odeBackSolver.setDimension(2);
        String polyaLabel = new String("Polya vector field: f\u0305(\u0305z\u0305)\u0305");
        this.polyaVecFieldButton.setText(polyaLabel);
        this.panelColor = this.grapherPanel.getBackground();
        this.hueSatBright = Color.RGBtoHSB(this.panelColor.getRed(), this.panelColor.getGreen(), this.panelColor.getBlue(), this.hueSatBright);
        this.backgroundColor = Color.getHSBColor(this.hueSatBright[0], this.hueSatBright[1], 0.95f * this.hueSatBright[2]);
        this.cursorLabel.setText("");
        this.domainChoiceBox.registerObjects(this.grapher, this.domainRange, this.xMinField, this.xMaxField, this.yMinField, this.yMaxField);
        this.grapher.setNumberLabel(this.cursorLabel);
        this.grapher.registerObjects(this.domainRange, this.xMinField, this.xMaxField, this.yMinField, this.yMaxField);
        this.grapher.init();
    }

    private boolean isCircleInfoGood() {
        boolean noProblems = true;
        if (this.insertCircleBox.isSelected()) {
            if (this.centerXField.hasError()) {
                noProblems = false;
            }
            if (this.centerYField.hasError()) {
                noProblems = false;
            }
            if (this.radiusField.hasError()) {
                noProblems = false;
            }
            if (noProblems) {
                this.circleCenterDataX[0] = this.centerXField.getDoubleVal();
                this.circleCenterDataY[0] = this.centerYField.getDoubleVal();
                this.radius = this.radiusField.getDoubleVal();
            }
        }
        return noProblems;
    }

    private boolean isInputInfoGood() {
        boolean noProblems = true;
        if (this.xMinField.hasError()) {
            noProblems = false;
        }
        if (this.xMaxField.hasError()) {
            noProblems = false;
        }
        if (this.yMinField.hasError()) {
            noProblems = false;
        }
        if (this.yMaxField.hasError()) {
            noProblems = false;
        }
        if (this.funcField.hasError()) {
            noProblems = false;
        }
        if (this.stepSizeField.hasError()) {
            noProblems = false;
        }
        if (this.fixedIntervalBox.isSelected()) {
            if (this.tMinField.hasError()) {
                noProblems = false;
            }
            if (this.tMaxField.hasError()) {
                noProblems = false;
            }
        } else if (this.pauseValField.hasError()) {
            noProblems = false;
        }
        if (noProblems) {
            this.domainRange[0] = this.xMinField.getDoubleVal();
            this.domainRange[1] = this.xMaxField.getDoubleVal();
            this.domainRange[2] = this.yMinField.getDoubleVal();
            this.domainRange[3] = this.yMaxField.getDoubleVal();
            this.centerGrabTol = Math.sqrt((this.domainRange[1] - this.domainRange[0]) * (this.domainRange[1] - this.domainRange[0]) + (this.domainRange[3] - this.domainRange[2]) * (this.domainRange[3] - this.domainRange[2])) / this.centerGrabTolFactor;
            this.shrinkRadiusTol = Math.sqrt((this.domainRange[1] - this.domainRange[0]) * (this.domainRange[1] - this.domainRange[0]) + (this.domainRange[3] - this.domainRange[2]) * (this.domainRange[3] - this.domainRange[2])) / this.shrinkRadiusTolFactor;
            ((DefaultVecFieldFunc)this.defaultVecFieldFunc).setFuncParser(this.funcField.getParser());
            ((PolyaVecFieldFunc)this.polyaVecFieldFunc).setFuncParser(this.funcField.getParser());
            this.flowFunc.setFuncParser(this.funcField.getParser());
            this.fluxFunc.setFuncParser(this.funcField.getParser());
            this.polyaFlowFunc.setFuncParser(this.funcField.getParser());
            this.polyaFluxFunc.setFuncParser(this.funcField.getParser());
            this.stepSize = this.stepSizeField.getDoubleVal();
            this.odeForwardSolver.setH(this.stepSize);
            this.odeBackSolver.setH(-this.stepSize);
            if (this.fixedIntervalBox.isSelected()) {
                this.tMin = this.tMinField.getDoubleVal();
                this.tMax = this.tMaxField.getDoubleVal();
            } else {
                this.pauseVal = this.pauseValField.getIntVal();
            }
            noProblems = this.isCircleInfoGood();
        }
        return noProblems;
    }

    private void updateNumTraces() {
        this.numTraces = 0;
        if (this.vecFieldHasBeenGraphed) {
            ++this.numTraces;
            this.allData[0] = this.vecField;
            if (this.insertCircleBox.isSelected() && this.circleHasBeenGraphed) {
                this.numTraces += 2;
                this.allData[1] = this.circleCenter;
                this.allData[2] = this.circle;
            }
            if (this.numCurrentSolutions > 0) {
                for (int i = 0; i <= this.numCurrentSolutions / 3 - 1; ++i) {
                    this.allData[this.numTraces + 3 * i] = this.slopeSolutionData[i];
                    this.allData[this.numTraces + 3 * i + 1] = this.slopeSolutionBackData[i];
                    this.allData[this.numTraces + 3 * i + 2] = this.slopeSolutionInitialData[i];
                }
            }
            this.grapher.setNumTraces(this.numTraces + this.numCurrentSolutions);
        }
    }

    public void checkSolutionMemory() {
        if (this.numCurrentSolutions > this.maxNumSolutions) {
            int i;
            PlotStuff[] tempAllData = new PlotStuff[this.maxNumSolutions + this.maxNumTraces];
            PlotStuff2D[] tempSlopeSolutionData = new PlotStuff2D[this.maxNumSolutions / 3];
            PlotStuff2D[] tempSlopeSolutionBackData = new PlotStuff2D[this.maxNumSolutions / 3];
            PlotStuff2D[] tempSlopeSolutionInitialData = new PlotStuff2D[this.maxNumSolutions / 3];
            for (i = 0; i <= this.maxNumTraces + this.maxNumSolutions - 1; ++i) {
                tempAllData[i] = this.allData[i];
            }
            for (i = 0; i <= this.maxNumSolutions / 3 - 1; ++i) {
                tempSlopeSolutionData[i] = this.slopeSolutionData[i];
                tempSlopeSolutionBackData[i] = this.slopeSolutionBackData[i];
                tempSlopeSolutionInitialData[i] = this.slopeSolutionInitialData[i];
            }
            this.maxNumSolutions += this.solutionsIncrementCapacity;
            this.allData = new PlotStuff[this.maxNumSolutions + this.maxNumTraces];
            this.grapher.setTraces(this.allData);
            this.slopeSolutionData = new PlotStuff2D[this.maxNumSolutions / 3];
            this.slopeSolutionBackData = new PlotStuff2D[this.maxNumSolutions / 3];
            this.slopeSolutionInitialData = new PlotStuff2D[this.maxNumSolutions / 3];
            for (i = 0; i <= this.maxNumTraces + this.maxNumSolutions - this.solutionsIncrementCapacity - 1; ++i) {
                this.allData[i] = tempAllData[i];
            }
            for (i = 0; i <= this.numCurrentSolutions / 3 - 2; ++i) {
                this.slopeSolutionData[i] = tempSlopeSolutionData[i];
                this.slopeSolutionBackData[i] = tempSlopeSolutionBackData[i];
                this.slopeSolutionInitialData[i] = tempSlopeSolutionInitialData[i];
            }
            for (i = this.numCurrentSolutions / 3 - 1; i <= this.maxNumSolutions / 3 - 1; ++i) {
                this.slopeSolutionData[i] = new PlotStuff2D();
                this.slopeSolutionData[i].setNumPoints(this.numPoints);
                this.slopeSolutionData[i].setPlotColor(Color.BLUE);
                this.slopeSolutionData[i].setPlotSize(0);
                this.slopeSolutionData[i].setPlotStyle(0);
                this.slopeSolutionBackData[i] = new PlotStuff2D();
                this.slopeSolutionBackData[i].setPlotColor(this.solutionBackColor);
                this.slopeSolutionBackData[i].setPlotSize(0);
                this.slopeSolutionBackData[i].setNumPoints(this.numPoints);
                this.slopeSolutionBackData[i].setPlotStyle(0);
                this.slopeSolutionInitialData[i] = new PlotStuff2D();
                this.slopeSolutionInitialData[i].setPlotColor(this.solutionInitialColor);
                this.slopeSolutionInitialData[i].setPlotSize(2);
                this.slopeSolutionInitialData[i].setNumPoints(1);
                this.slopeSolutionInitialData[i].setPlotStyle(1);
            }
        }
    }

    private void createCircleData() {
        this.circleDataX[0] = this.circleCenterDataX[0] + this.radius;
        this.circleDataY[0] = this.circleCenterDataY[0];
        this.circleDataX[this.numCirclePoints - 1] = this.circleCenterDataX[0] + this.radius;
        this.circleDataY[this.numCirclePoints - 1] = this.circleCenterDataY[0];
        for (int i = 1; i <= this.numCirclePoints - 2; ++i) {
            this.circleDataX[i] = this.circleCenterDataX[0] + this.radius * Math.cos((double)i * this.deltaTheta);
            this.circleDataY[i] = this.circleCenterDataY[0] + this.radius * Math.sin((double)i * this.deltaTheta);
        }
        if (this.defaultVecFieldButton.isSelected()) {
            this.flowFunc.setCenterX(this.circleCenterDataX[0]);
            this.flowFunc.setCenterY(this.circleCenterDataY[0]);
            this.flowFunc.setRadius(this.radius);
            this.fluxFunc.setCenterX(this.circleCenterDataX[0]);
            this.fluxFunc.setCenterY(this.circleCenterDataY[0]);
            this.fluxFunc.setRadius(this.radius);
            this.adaptiveIntegrator.setFunc(this.flowFunc);
            this.flow = this.adaptiveIntegrator.integrate();
            this.adaptiveIntegrator.setFunc(this.fluxFunc);
            this.flux = this.adaptiveIntegrator.integrate();
        } else {
            this.polyaFlowFunc.setCenterX(this.circleCenterDataX[0]);
            this.polyaFlowFunc.setCenterY(this.circleCenterDataY[0]);
            this.polyaFlowFunc.setRadius(this.radius);
            this.polyaFluxFunc.setCenterX(this.circleCenterDataX[0]);
            this.polyaFluxFunc.setCenterY(this.circleCenterDataY[0]);
            this.polyaFluxFunc.setRadius(this.radius);
            this.adaptiveIntegrator.setFunc(this.polyaFlowFunc);
            this.flow = this.adaptiveIntegrator.integrate();
            this.adaptiveIntegrator.setFunc(this.polyaFluxFunc);
            this.flux = this.adaptiveIntegrator.integrate();
        }
        this.outputFlowFlux(this.flow, this.flux);
    }

    private void reGraph(boolean updateScalingFactor) {
        this.vecFieldHasBeenGraphed = false;
        this.circleHasBeenGraphed = false;
        if (this.isInputInfoGood()) {
            this.createData(updateScalingFactor);
            this.numCurrentSolutions = 0;
            this.vecFieldHasBeenGraphed = true;
            if (this.insertCircleBox.isSelected()) {
                this.circleHasBeenGraphed = true;
            }
            this.updateNumTraces();
            this.grapher.plotData(this.allData);
        }
    }

    public void run() {
        while (!this.timeToStop && !Thread.interrupted()) {
            this.odeForwardSolver.solveODEOneStep();
            if (this.odeForwardSolver.isCapacityIncremented()) {
                this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setDataX(this.odeForwardSolver.getYVals(0));
                this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setDataY(this.odeForwardSolver.getYVals(1));
            }
            this.odeBackSolver.solveODEOneStep();
            if (this.odeBackSolver.isCapacityIncremented()) {
                this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setDataX(this.odeBackSolver.getYVals(0));
                this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setDataY(this.odeBackSolver.getYVals(1));
            }
            this.slopeSolutionData[this.numCurrentSolutions / 3 - 1].setNumPoints(this.odeForwardSolver.getNumPoints());
            this.slopeSolutionBackData[this.numCurrentSolutions / 3 - 1].setNumPoints(this.odeBackSolver.getNumPoints());
            this.grapher.plotData();
            try {
                Thread.sleep(this.pauseVal);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private void outputFlowFlux(double localFlow, double localFlux) {
        if (Math.abs(localFlow) < this.eps) {
            this.flowLabel.setDoubleText(Math.abs(localFlow));
        } else {
            this.flowLabel.setDoubleText(localFlow);
        }
        if (Math.abs(localFlux) < this.eps) {
            this.fluxLabel.setDoubleText(Math.abs(localFlux));
        } else {
            this.fluxLabel.setDoubleText(localFlux);
        }
    }
}

